
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "events",
    "metaData",
    "pager",
    "program",
    "programInstance"
})
@Generated("jsonschema2pojo")
public class Events implements Serializable
{

    @JsonProperty("events")
    private List<Event> events = null;
    /**
     * Undefined
     * 
     */
    @JsonProperty("metaData")
    private MetaData metaData;
    @JsonProperty("pager")
    private Pager pager;
    @JsonProperty("program")
    private String program;
    @JsonProperty("programInstance")
    private String programInstance;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 5043510627012758431L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Events() {
    }

    /**
     * 
     * @param source
     */
    public Events(Events source) {
        super();
        this.events = source.events;
        this.metaData = source.metaData;
        this.pager = source.pager;
        this.program = source.program;
        this.programInstance = source.programInstance;
    }

    /**
     * 
     * @param metaData
     * @param programInstance
     * @param pager
     * @param program
     * @param events
     */
    public Events(List<Event> events, MetaData metaData, Pager pager, String program, String programInstance) {
        super();
        this.events = events;
        this.metaData = metaData;
        this.pager = pager;
        this.program = program;
        this.programInstance = programInstance;
    }

    @JsonProperty("events")
    public Optional<List<Event>> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public Events withEvents(List<Event> events) {
        this.events = events;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("metaData")
    public Optional<MetaData> getMetaData() {
        return Optional.ofNullable(metaData);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("metaData")
    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public Events withMetaData(MetaData metaData) {
        this.metaData = metaData;
        return this;
    }

    @JsonProperty("pager")
    public Optional<Pager> getPager() {
        return Optional.ofNullable(pager);
    }

    @JsonProperty("pager")
    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public Events withPager(Pager pager) {
        this.pager = pager;
        return this;
    }

    @JsonProperty("program")
    public Optional<String> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(String program) {
        this.program = program;
    }

    public Events withProgram(String program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programInstance")
    public Optional<String> getProgramInstance() {
        return Optional.ofNullable(programInstance);
    }

    @JsonProperty("programInstance")
    public void setProgramInstance(String programInstance) {
        this.programInstance = programInstance;
    }

    public Events withProgramInstance(String programInstance) {
        this.programInstance = programInstance;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Events withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "events":
                if (value instanceof List) {
                    setEvents(((List<Event> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"events\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Event>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "metaData":
                if (value instanceof MetaData) {
                    setMetaData(((MetaData) value));
                } else {
                    throw new IllegalArgumentException(("property \"metaData\" is of type \"org.hisp.dhis.api.model.v2_37_7.MetaData\", but got "+ value.getClass().toString()));
                }
                return true;
            case "pager":
                if (value instanceof Pager) {
                    setPager(((Pager) value));
                } else {
                    throw new IllegalArgumentException(("property \"pager\" is of type \"org.hisp.dhis.api.model.v2_37_7.Pager\", but got "+ value.getClass().toString()));
                }
                return true;
            case "program":
                if (value instanceof String) {
                    setProgram(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"program\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programInstance":
                if (value instanceof String) {
                    setProgramInstance(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"programInstance\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "events":
                return getEvents();
            case "metaData":
                return getMetaData();
            case "pager":
                return getPager();
            case "program":
                return getProgram();
            case "programInstance":
                return getProgramInstance();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Events.NOT_FOUND_VALUE);
        if (Events.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Events with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Events.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("metaData");
        sb.append('=');
        sb.append(((this.metaData == null)?"<null>":this.metaData));
        sb.append(',');
        sb.append("pager");
        sb.append('=');
        sb.append(((this.pager == null)?"<null>":this.pager));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programInstance");
        sb.append('=');
        sb.append(((this.programInstance == null)?"<null>":this.programInstance));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.metaData == null)? 0 :this.metaData.hashCode()));
        result = ((result* 31)+((this.programInstance == null)? 0 :this.programInstance.hashCode()));
        result = ((result* 31)+((this.pager == null)? 0 :this.pager.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Events) == false) {
            return false;
        }
        Events rhs = ((Events) other);
        return (((((((this.metaData == rhs.metaData)||((this.metaData!= null)&&this.metaData.equals(rhs.metaData)))&&((this.programInstance == rhs.programInstance)||((this.programInstance!= null)&&this.programInstance.equals(rhs.programInstance))))&&((this.pager == rhs.pager)||((this.pager!= null)&&this.pager.equals(rhs.pager))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))));
    }

}
