
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "assignedUserMode",
    "assignedUsers",
    "completedDate",
    "dataFilters",
    "displayColumnOrder",
    "dueDate",
    "eventDate",
    "events",
    "followUp",
    "lastUpdatedDate",
    "order",
    "organisationUnit",
    "ouMode",
    "status"
})
@Generated("jsonschema2pojo")
public class EventQueryCriteria implements Serializable
{

    @JsonProperty("assignedUserMode")
    private AssignedUserSelectionMode assignedUserMode;
    @JsonProperty("assignedUsers")
    private List<String> assignedUsers = null;
    @JsonProperty("completedDate")
    private DateFilterPeriod completedDate;
    @JsonProperty("dataFilters")
    private List<EventDataFilter> dataFilters = null;
    @JsonProperty("displayColumnOrder")
    private List<String> displayColumnOrder = null;
    @JsonProperty("dueDate")
    private DateFilterPeriod dueDate;
    @JsonProperty("eventDate")
    private DateFilterPeriod eventDate;
    @JsonProperty("events")
    private List<String> events = null;
    @JsonProperty("followUp")
    private Boolean followUp;
    @JsonProperty("lastUpdatedDate")
    private DateFilterPeriod lastUpdatedDate;
    @JsonProperty("order")
    private String order;
    @JsonProperty("organisationUnit")
    private String organisationUnit;
    @JsonProperty("ouMode")
    private org.hisp.dhis.api.model.v2_37_7.MapView.OrganisationUnitSelectionMode ouMode;
    @JsonProperty("status")
    private org.hisp.dhis.api.model.v2_37_7.EventChart.EventStatus status;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7433101974631283305L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventQueryCriteria() {
    }

    /**
     * 
     * @param source
     */
    public EventQueryCriteria(EventQueryCriteria source) {
        super();
        this.assignedUserMode = source.assignedUserMode;
        this.assignedUsers = source.assignedUsers;
        this.completedDate = source.completedDate;
        this.dataFilters = source.dataFilters;
        this.displayColumnOrder = source.displayColumnOrder;
        this.dueDate = source.dueDate;
        this.eventDate = source.eventDate;
        this.events = source.events;
        this.followUp = source.followUp;
        this.lastUpdatedDate = source.lastUpdatedDate;
        this.order = source.order;
        this.organisationUnit = source.organisationUnit;
        this.ouMode = source.ouMode;
        this.status = source.status;
    }

    /**
     * 
     * @param assignedUserMode
     * @param organisationUnit
     * @param dueDate
     * @param assignedUsers
     * @param completedDate
     * @param followUp
     * @param lastUpdatedDate
     * @param dataFilters
     * @param ouMode
     * @param displayColumnOrder
     * @param events
     * @param eventDate
     * @param order
     * @param status
     */
    public EventQueryCriteria(AssignedUserSelectionMode assignedUserMode, List<String> assignedUsers, DateFilterPeriod completedDate, List<EventDataFilter> dataFilters, List<String> displayColumnOrder, DateFilterPeriod dueDate, DateFilterPeriod eventDate, List<String> events, Boolean followUp, DateFilterPeriod lastUpdatedDate, String order, String organisationUnit, org.hisp.dhis.api.model.v2_37_7.MapView.OrganisationUnitSelectionMode ouMode, org.hisp.dhis.api.model.v2_37_7.EventChart.EventStatus status) {
        super();
        this.assignedUserMode = assignedUserMode;
        this.assignedUsers = assignedUsers;
        this.completedDate = completedDate;
        this.dataFilters = dataFilters;
        this.displayColumnOrder = displayColumnOrder;
        this.dueDate = dueDate;
        this.eventDate = eventDate;
        this.events = events;
        this.followUp = followUp;
        this.lastUpdatedDate = lastUpdatedDate;
        this.order = order;
        this.organisationUnit = organisationUnit;
        this.ouMode = ouMode;
        this.status = status;
    }

    @JsonProperty("assignedUserMode")
    public Optional<AssignedUserSelectionMode> getAssignedUserMode() {
        return Optional.ofNullable(assignedUserMode);
    }

    @JsonProperty("assignedUserMode")
    public void setAssignedUserMode(AssignedUserSelectionMode assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
    }

    public EventQueryCriteria withAssignedUserMode(AssignedUserSelectionMode assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
        return this;
    }

    @JsonProperty("assignedUsers")
    public Optional<List<String>> getAssignedUsers() {
        return Optional.ofNullable(assignedUsers);
    }

    @JsonProperty("assignedUsers")
    public void setAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
    }

    public EventQueryCriteria withAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
        return this;
    }

    @JsonProperty("completedDate")
    public Optional<DateFilterPeriod> getCompletedDate() {
        return Optional.ofNullable(completedDate);
    }

    @JsonProperty("completedDate")
    public void setCompletedDate(DateFilterPeriod completedDate) {
        this.completedDate = completedDate;
    }

    public EventQueryCriteria withCompletedDate(DateFilterPeriod completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    @JsonProperty("dataFilters")
    public Optional<List<EventDataFilter>> getDataFilters() {
        return Optional.ofNullable(dataFilters);
    }

    @JsonProperty("dataFilters")
    public void setDataFilters(List<EventDataFilter> dataFilters) {
        this.dataFilters = dataFilters;
    }

    public EventQueryCriteria withDataFilters(List<EventDataFilter> dataFilters) {
        this.dataFilters = dataFilters;
        return this;
    }

    @JsonProperty("displayColumnOrder")
    public Optional<List<String>> getDisplayColumnOrder() {
        return Optional.ofNullable(displayColumnOrder);
    }

    @JsonProperty("displayColumnOrder")
    public void setDisplayColumnOrder(List<String> displayColumnOrder) {
        this.displayColumnOrder = displayColumnOrder;
    }

    public EventQueryCriteria withDisplayColumnOrder(List<String> displayColumnOrder) {
        this.displayColumnOrder = displayColumnOrder;
        return this;
    }

    @JsonProperty("dueDate")
    public Optional<DateFilterPeriod> getDueDate() {
        return Optional.ofNullable(dueDate);
    }

    @JsonProperty("dueDate")
    public void setDueDate(DateFilterPeriod dueDate) {
        this.dueDate = dueDate;
    }

    public EventQueryCriteria withDueDate(DateFilterPeriod dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @JsonProperty("eventDate")
    public Optional<DateFilterPeriod> getEventDate() {
        return Optional.ofNullable(eventDate);
    }

    @JsonProperty("eventDate")
    public void setEventDate(DateFilterPeriod eventDate) {
        this.eventDate = eventDate;
    }

    public EventQueryCriteria withEventDate(DateFilterPeriod eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @JsonProperty("events")
    public Optional<List<String>> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(List<String> events) {
        this.events = events;
    }

    public EventQueryCriteria withEvents(List<String> events) {
        this.events = events;
        return this;
    }

    @JsonProperty("followUp")
    public Optional<Boolean> getFollowUp() {
        return Optional.ofNullable(followUp);
    }

    @JsonProperty("followUp")
    public void setFollowUp(Boolean followUp) {
        this.followUp = followUp;
    }

    public EventQueryCriteria withFollowUp(Boolean followUp) {
        this.followUp = followUp;
        return this;
    }

    @JsonProperty("lastUpdatedDate")
    public Optional<DateFilterPeriod> getLastUpdatedDate() {
        return Optional.ofNullable(lastUpdatedDate);
    }

    @JsonProperty("lastUpdatedDate")
    public void setLastUpdatedDate(DateFilterPeriod lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public EventQueryCriteria withLastUpdatedDate(DateFilterPeriod lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
        return this;
    }

    @JsonProperty("order")
    public Optional<String> getOrder() {
        return Optional.ofNullable(order);
    }

    @JsonProperty("order")
    public void setOrder(String order) {
        this.order = order;
    }

    public EventQueryCriteria withOrder(String order) {
        this.order = order;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<String> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(String organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public EventQueryCriteria withOrganisationUnit(String organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("ouMode")
    public Optional<org.hisp.dhis.api.model.v2_37_7.MapView.OrganisationUnitSelectionMode> getOuMode() {
        return Optional.ofNullable(ouMode);
    }

    @JsonProperty("ouMode")
    public void setOuMode(org.hisp.dhis.api.model.v2_37_7.MapView.OrganisationUnitSelectionMode ouMode) {
        this.ouMode = ouMode;
    }

    public EventQueryCriteria withOuMode(org.hisp.dhis.api.model.v2_37_7.MapView.OrganisationUnitSelectionMode ouMode) {
        this.ouMode = ouMode;
        return this;
    }

    @JsonProperty("status")
    public Optional<org.hisp.dhis.api.model.v2_37_7.EventChart.EventStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(org.hisp.dhis.api.model.v2_37_7.EventChart.EventStatus status) {
        this.status = status;
    }

    public EventQueryCriteria withStatus(org.hisp.dhis.api.model.v2_37_7.EventChart.EventStatus status) {
        this.status = status;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EventQueryCriteria withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "assignedUserMode":
                if (value instanceof AssignedUserSelectionMode) {
                    setAssignedUserMode(((AssignedUserSelectionMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignedUserMode\" is of type \"org.hisp.dhis.api.model.v2_37_7.AssignedUserSelectionMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "assignedUsers":
                if (value instanceof List) {
                    setAssignedUsers(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignedUsers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completedDate":
                if (value instanceof DateFilterPeriod) {
                    setCompletedDate(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedDate\" is of type \"org.hisp.dhis.api.model.v2_37_7.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataFilters":
                if (value instanceof List) {
                    setDataFilters(((List<EventDataFilter> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataFilters\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.EventDataFilter>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayColumnOrder":
                if (value instanceof List) {
                    setDisplayColumnOrder(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayColumnOrder\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dueDate":
                if (value instanceof DateFilterPeriod) {
                    setDueDate(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"dueDate\" is of type \"org.hisp.dhis.api.model.v2_37_7.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventDate":
                if (value instanceof DateFilterPeriod) {
                    setEventDate(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventDate\" is of type \"org.hisp.dhis.api.model.v2_37_7.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            case "events":
                if (value instanceof List) {
                    setEvents(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"events\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "followUp":
                if (value instanceof Boolean) {
                    setFollowUp(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"followUp\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedDate":
                if (value instanceof DateFilterPeriod) {
                    setLastUpdatedDate(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedDate\" is of type \"org.hisp.dhis.api.model.v2_37_7.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            case "order":
                if (value instanceof String) {
                    setOrder(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"order\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnit":
                if (value instanceof String) {
                    setOrganisationUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ouMode":
                if (value instanceof org.hisp.dhis.api.model.v2_37_7.MapView.OrganisationUnitSelectionMode) {
                    setOuMode(((org.hisp.dhis.api.model.v2_37_7.MapView.OrganisationUnitSelectionMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"ouMode\" is of type \"org.hisp.dhis.api.model.v2_37_7.MapView.OrganisationUnitSelectionMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof org.hisp.dhis.api.model.v2_37_7.EventChart.EventStatus) {
                    setStatus(((org.hisp.dhis.api.model.v2_37_7.EventChart.EventStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_37_7.EventChart.EventStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "assignedUserMode":
                return getAssignedUserMode();
            case "assignedUsers":
                return getAssignedUsers();
            case "completedDate":
                return getCompletedDate();
            case "dataFilters":
                return getDataFilters();
            case "displayColumnOrder":
                return getDisplayColumnOrder();
            case "dueDate":
                return getDueDate();
            case "eventDate":
                return getEventDate();
            case "events":
                return getEvents();
            case "followUp":
                return getFollowUp();
            case "lastUpdatedDate":
                return getLastUpdatedDate();
            case "order":
                return getOrder();
            case "organisationUnit":
                return getOrganisationUnit();
            case "ouMode":
                return getOuMode();
            case "status":
                return getStatus();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, EventQueryCriteria.NOT_FOUND_VALUE);
        if (EventQueryCriteria.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public EventQueryCriteria with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventQueryCriteria.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assignedUserMode");
        sb.append('=');
        sb.append(((this.assignedUserMode == null)?"<null>":this.assignedUserMode));
        sb.append(',');
        sb.append("assignedUsers");
        sb.append('=');
        sb.append(((this.assignedUsers == null)?"<null>":this.assignedUsers));
        sb.append(',');
        sb.append("completedDate");
        sb.append('=');
        sb.append(((this.completedDate == null)?"<null>":this.completedDate));
        sb.append(',');
        sb.append("dataFilters");
        sb.append('=');
        sb.append(((this.dataFilters == null)?"<null>":this.dataFilters));
        sb.append(',');
        sb.append("displayColumnOrder");
        sb.append('=');
        sb.append(((this.displayColumnOrder == null)?"<null>":this.displayColumnOrder));
        sb.append(',');
        sb.append("dueDate");
        sb.append('=');
        sb.append(((this.dueDate == null)?"<null>":this.dueDate));
        sb.append(',');
        sb.append("eventDate");
        sb.append('=');
        sb.append(((this.eventDate == null)?"<null>":this.eventDate));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("followUp");
        sb.append('=');
        sb.append(((this.followUp == null)?"<null>":this.followUp));
        sb.append(',');
        sb.append("lastUpdatedDate");
        sb.append('=');
        sb.append(((this.lastUpdatedDate == null)?"<null>":this.lastUpdatedDate));
        sb.append(',');
        sb.append("order");
        sb.append('=');
        sb.append(((this.order == null)?"<null>":this.order));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("ouMode");
        sb.append('=');
        sb.append(((this.ouMode == null)?"<null>":this.ouMode));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.assignedUserMode == null)? 0 :this.assignedUserMode.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.dueDate == null)? 0 :this.dueDate.hashCode()));
        result = ((result* 31)+((this.assignedUsers == null)? 0 :this.assignedUsers.hashCode()));
        result = ((result* 31)+((this.completedDate == null)? 0 :this.completedDate.hashCode()));
        result = ((result* 31)+((this.followUp == null)? 0 :this.followUp.hashCode()));
        result = ((result* 31)+((this.lastUpdatedDate == null)? 0 :this.lastUpdatedDate.hashCode()));
        result = ((result* 31)+((this.dataFilters == null)? 0 :this.dataFilters.hashCode()));
        result = ((result* 31)+((this.ouMode == null)? 0 :this.ouMode.hashCode()));
        result = ((result* 31)+((this.displayColumnOrder == null)? 0 :this.displayColumnOrder.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.eventDate == null)? 0 :this.eventDate.hashCode()));
        result = ((result* 31)+((this.order == null)? 0 :this.order.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EventQueryCriteria) == false) {
            return false;
        }
        EventQueryCriteria rhs = ((EventQueryCriteria) other);
        return ((((((((((((((((this.assignedUserMode == rhs.assignedUserMode)||((this.assignedUserMode!= null)&&this.assignedUserMode.equals(rhs.assignedUserMode)))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.dueDate == rhs.dueDate)||((this.dueDate!= null)&&this.dueDate.equals(rhs.dueDate))))&&((this.assignedUsers == rhs.assignedUsers)||((this.assignedUsers!= null)&&this.assignedUsers.equals(rhs.assignedUsers))))&&((this.completedDate == rhs.completedDate)||((this.completedDate!= null)&&this.completedDate.equals(rhs.completedDate))))&&((this.followUp == rhs.followUp)||((this.followUp!= null)&&this.followUp.equals(rhs.followUp))))&&((this.lastUpdatedDate == rhs.lastUpdatedDate)||((this.lastUpdatedDate!= null)&&this.lastUpdatedDate.equals(rhs.lastUpdatedDate))))&&((this.dataFilters == rhs.dataFilters)||((this.dataFilters!= null)&&this.dataFilters.equals(rhs.dataFilters))))&&((this.ouMode == rhs.ouMode)||((this.ouMode!= null)&&this.ouMode.equals(rhs.ouMode))))&&((this.displayColumnOrder == rhs.displayColumnOrder)||((this.displayColumnOrder!= null)&&this.displayColumnOrder.equals(rhs.displayColumnOrder))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.eventDate == rhs.eventDate)||((this.eventDate!= null)&&this.eventDate.equals(rhs.eventDate))))&&((this.order == rhs.order)||((this.order!= null)&&this.order.equals(rhs.order))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
