
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attachment",
    "attributeValues",
    "code",
    "contentType",
    "created",
    "createdBy",
    "displayName",
    "external",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "publicAccess",
    "sharing",
    "translations",
    "url",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class Document implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attachment")
    private Boolean attachment;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("contentType")
    private String contentType;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("external")
    private Boolean external;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("url")
    private String url;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8421754999925509836L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Document() {
    }

    /**
     * 
     * @param source
     */
    public Document(Document source) {
        super();
        this.access = source.access;
        this.attachment = source.attachment;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.contentType = source.contentType;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.displayName = source.displayName;
        this.external = source.external;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.publicAccess = source.publicAccess;
        this.sharing = source.sharing;
        this.translations = source.translations;
        this.url = source.url;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param favorites
     * @param lastUpdatedBy
     * @param access
     * @param code
     * @param userGroupAccesses
     * @param created
     * @param displayName
     * @param publicAccess
     * @param attributeValues
     * @param sharing
     * @param url
     * @param externalAccess
     * @param lastUpdated
     * @param external
     * @param attachment
     * @param createdBy
     * @param translations
     * @param userAccesses
     * @param name
     * @param href
     * @param id
     * @param contentType
     * @param favorite
     * @param user
     */
    public Document(Access access, Boolean attachment, List<AttributeValue> attributeValues, String code, String contentType, Date created, User createdBy, String displayName, Boolean external, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, User lastUpdatedBy, String name, String publicAccess, Sharing sharing, List<Translation> translations, String url, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attachment = attachment;
        this.attributeValues = attributeValues;
        this.code = code;
        this.contentType = contentType;
        this.created = created;
        this.createdBy = createdBy;
        this.displayName = displayName;
        this.external = external;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.publicAccess = publicAccess;
        this.sharing = sharing;
        this.translations = translations;
        this.url = url;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Document withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attachment")
    public Optional<Boolean> getAttachment() {
        return Optional.ofNullable(attachment);
    }

    @JsonProperty("attachment")
    public void setAttachment(Boolean attachment) {
        this.attachment = attachment;
    }

    public Document withAttachment(Boolean attachment) {
        this.attachment = attachment;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Document withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Document withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("contentType")
    public Optional<String> getContentType() {
        return Optional.ofNullable(contentType);
    }

    @JsonProperty("contentType")
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Document withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Document withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Document withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Document withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("external")
    public Optional<Boolean> getExternal() {
        return Optional.ofNullable(external);
    }

    @JsonProperty("external")
    public void setExternal(Boolean external) {
        this.external = external;
    }

    public Document withExternal(Boolean external) {
        this.external = external;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Document withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Document withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Document withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Document withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Document withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Document withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Document withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Document withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Document withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public Document withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Document withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("url")
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    public Document withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public Document withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Document withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Document withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Document withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_37_7.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attachment":
                if (value instanceof Boolean) {
                    setAttachment(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"attachment\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "contentType":
                if (value instanceof String) {
                    setContentType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"contentType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "external":
                if (value instanceof Boolean) {
                    setExternal(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"external\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_37_7.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "url":
                if (value instanceof String) {
                    setUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"url\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "attachment":
                return getAttachment();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "contentType":
                return getContentType();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "displayName":
                return getDisplayName();
            case "external":
                return getExternal();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "name":
                return getName();
            case "publicAccess":
                return getPublicAccess();
            case "sharing":
                return getSharing();
            case "translations":
                return getTranslations();
            case "url":
                return getUrl();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Document.NOT_FOUND_VALUE);
        if (Document.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Document with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Document.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attachment");
        sb.append('=');
        sb.append(((this.attachment == null)?"<null>":this.attachment));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("contentType");
        sb.append('=');
        sb.append(((this.contentType == null)?"<null>":this.contentType));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("external");
        sb.append('=');
        sb.append(((this.external == null)?"<null>":this.external));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.attachment == null)? 0 :this.attachment.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.contentType == null)? 0 :this.contentType.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.external == null)? 0 :this.external.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Document) == false) {
            return false;
        }
        Document rhs = ((Document) other);
        return ((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.attachment == rhs.attachment)||((this.attachment!= null)&&this.attachment.equals(rhs.attachment))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.contentType == rhs.contentType)||((this.contentType!= null)&&this.contentType.equals(rhs.contentType))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.external == rhs.external)||((this.external!= null)&&this.external.equals(rhs.external))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
