
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "action",
    "attributeOptionCombo",
    "created",
    "creator",
    "level",
    "organisationUnit",
    "period",
    "workflow"
})
@Generated("jsonschema2pojo")
public class DataApprovalAudit implements Serializable
{

    @JsonProperty("action")
    private DataApprovalAction action;
    @JsonProperty("attributeOptionCombo")
    private CategoryOptionCombo attributeOptionCombo;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("creator")
    private User creator;
    @JsonProperty("level")
    private DataApprovalLevel level;
    @JsonProperty("organisationUnit")
    private OrganisationUnit organisationUnit;
    @JsonProperty("period")
    private Period period;
    @JsonProperty("workflow")
    private DataApprovalWorkflow workflow;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4027459312999917295L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataApprovalAudit() {
    }

    /**
     * 
     * @param source
     */
    public DataApprovalAudit(DataApprovalAudit source) {
        super();
        this.action = source.action;
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.created = source.created;
        this.creator = source.creator;
        this.level = source.level;
        this.organisationUnit = source.organisationUnit;
        this.period = source.period;
        this.workflow = source.workflow;
    }

    /**
     * 
     * @param creator
     * @param period
     * @param workflow
     * @param level
     * @param organisationUnit
     * @param created
     * @param attributeOptionCombo
     * @param action
     */
    public DataApprovalAudit(DataApprovalAction action, CategoryOptionCombo attributeOptionCombo, Date created, User creator, DataApprovalLevel level, OrganisationUnit organisationUnit, Period period, DataApprovalWorkflow workflow) {
        super();
        this.action = action;
        this.attributeOptionCombo = attributeOptionCombo;
        this.created = created;
        this.creator = creator;
        this.level = level;
        this.organisationUnit = organisationUnit;
        this.period = period;
        this.workflow = workflow;
    }

    @JsonProperty("action")
    public Optional<DataApprovalAction> getAction() {
        return Optional.ofNullable(action);
    }

    @JsonProperty("action")
    public void setAction(DataApprovalAction action) {
        this.action = action;
    }

    public DataApprovalAudit withAction(DataApprovalAction action) {
        this.action = action;
        return this;
    }

    @JsonProperty("attributeOptionCombo")
    public Optional<CategoryOptionCombo> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(CategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public DataApprovalAudit withAttributeOptionCombo(CategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DataApprovalAudit withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("creator")
    public Optional<User> getCreator() {
        return Optional.ofNullable(creator);
    }

    @JsonProperty("creator")
    public void setCreator(User creator) {
        this.creator = creator;
    }

    public DataApprovalAudit withCreator(User creator) {
        this.creator = creator;
        return this;
    }

    @JsonProperty("level")
    public Optional<DataApprovalLevel> getLevel() {
        return Optional.ofNullable(level);
    }

    @JsonProperty("level")
    public void setLevel(DataApprovalLevel level) {
        this.level = level;
    }

    public DataApprovalAudit withLevel(DataApprovalLevel level) {
        this.level = level;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public DataApprovalAudit withOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<Period> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(Period period) {
        this.period = period;
    }

    public DataApprovalAudit withPeriod(Period period) {
        this.period = period;
        return this;
    }

    @JsonProperty("workflow")
    public Optional<DataApprovalWorkflow> getWorkflow() {
        return Optional.ofNullable(workflow);
    }

    @JsonProperty("workflow")
    public void setWorkflow(DataApprovalWorkflow workflow) {
        this.workflow = workflow;
    }

    public DataApprovalAudit withWorkflow(DataApprovalWorkflow workflow) {
        this.workflow = workflow;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataApprovalAudit withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "action":
                if (value instanceof DataApprovalAction) {
                    setAction(((DataApprovalAction) value));
                } else {
                    throw new IllegalArgumentException(("property \"action\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataApprovalAction\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeOptionCombo":
                if (value instanceof CategoryOptionCombo) {
                    setAttributeOptionCombo(((CategoryOptionCombo) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"org.hisp.dhis.api.model.v2_37_7.CategoryOptionCombo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "creator":
                if (value instanceof User) {
                    setCreator(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"creator\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "level":
                if (value instanceof DataApprovalLevel) {
                    setLevel(((DataApprovalLevel) value));
                } else {
                    throw new IllegalArgumentException(("property \"level\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataApprovalLevel\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnit":
                if (value instanceof OrganisationUnit) {
                    setOrganisationUnit(((OrganisationUnit) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v2_37_7.OrganisationUnit\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof Period) {
                    setPeriod(((Period) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"org.hisp.dhis.api.model.v2_37_7.Period\", but got "+ value.getClass().toString()));
                }
                return true;
            case "workflow":
                if (value instanceof DataApprovalWorkflow) {
                    setWorkflow(((DataApprovalWorkflow) value));
                } else {
                    throw new IllegalArgumentException(("property \"workflow\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataApprovalWorkflow\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "action":
                return getAction();
            case "attributeOptionCombo":
                return getAttributeOptionCombo();
            case "created":
                return getCreated();
            case "creator":
                return getCreator();
            case "level":
                return getLevel();
            case "organisationUnit":
                return getOrganisationUnit();
            case "period":
                return getPeriod();
            case "workflow":
                return getWorkflow();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataApprovalAudit.NOT_FOUND_VALUE);
        if (DataApprovalAudit.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataApprovalAudit with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataApprovalAudit.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("action");
        sb.append('=');
        sb.append(((this.action == null)?"<null>":this.action));
        sb.append(',');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("creator");
        sb.append('=');
        sb.append(((this.creator == null)?"<null>":this.creator));
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(((this.level == null)?"<null>":this.level));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("workflow");
        sb.append('=');
        sb.append(((this.workflow == null)?"<null>":this.workflow));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.creator == null)? 0 :this.creator.hashCode()));
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.workflow == null)? 0 :this.workflow.hashCode()));
        result = ((result* 31)+((this.level == null)? 0 :this.level.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.action == null)? 0 :this.action.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataApprovalAudit) == false) {
            return false;
        }
        DataApprovalAudit rhs = ((DataApprovalAudit) other);
        return ((((((((((this.creator == rhs.creator)||((this.creator!= null)&&this.creator.equals(rhs.creator)))&&((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period))))&&((this.workflow == rhs.workflow)||((this.workflow!= null)&&this.workflow.equals(rhs.workflow))))&&((this.level == rhs.level)||((this.level!= null)&&this.level.equals(rhs.level))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.action == rhs.action)||((this.action!= null)&&this.action.equals(rhs.action))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
