
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "corsWhitelist",
    "facilityOrgUnitGroupSet",
    "facilityOrgUnitLevel",
    "feedbackRecipients",
    "infrastructuralDataElements",
    "infrastructuralIndicators",
    "infrastructuralPeriodType",
    "offlineOrganisationUnitLevel",
    "selfRegistrationOrgUnit",
    "selfRegistrationRole",
    "systemId"
})
@Generated("jsonschema2pojo")
public class Configuration implements Serializable
{

    @JsonProperty("corsWhitelist")
    private List<String> corsWhitelist = null;
    @JsonProperty("facilityOrgUnitGroupSet")
    private OrganisationUnitGroupSet facilityOrgUnitGroupSet;
    @JsonProperty("facilityOrgUnitLevel")
    private OrganisationUnitLevel facilityOrgUnitLevel;
    @JsonProperty("feedbackRecipients")
    private UserGroup feedbackRecipients;
    @JsonProperty("infrastructuralDataElements")
    private DataElementGroup infrastructuralDataElements;
    @JsonProperty("infrastructuralIndicators")
    private IndicatorGroup infrastructuralIndicators;
    /**
     * Undefined
     * 
     */
    @JsonProperty("infrastructuralPeriodType")
    private Object infrastructuralPeriodType;
    @JsonProperty("offlineOrganisationUnitLevel")
    private OrganisationUnitLevel offlineOrganisationUnitLevel;
    @JsonProperty("selfRegistrationOrgUnit")
    private OrganisationUnit selfRegistrationOrgUnit;
    @JsonProperty("selfRegistrationRole")
    private UserAuthorityGroup selfRegistrationRole;
    @JsonProperty("systemId")
    private String systemId;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5593512785730160126L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Configuration() {
    }

    /**
     * 
     * @param source
     */
    public Configuration(Configuration source) {
        super();
        this.corsWhitelist = source.corsWhitelist;
        this.facilityOrgUnitGroupSet = source.facilityOrgUnitGroupSet;
        this.facilityOrgUnitLevel = source.facilityOrgUnitLevel;
        this.feedbackRecipients = source.feedbackRecipients;
        this.infrastructuralDataElements = source.infrastructuralDataElements;
        this.infrastructuralIndicators = source.infrastructuralIndicators;
        this.infrastructuralPeriodType = source.infrastructuralPeriodType;
        this.offlineOrganisationUnitLevel = source.offlineOrganisationUnitLevel;
        this.selfRegistrationOrgUnit = source.selfRegistrationOrgUnit;
        this.selfRegistrationRole = source.selfRegistrationRole;
        this.systemId = source.systemId;
    }

    /**
     * 
     * @param infrastructuralIndicators
     * @param systemId
     * @param feedbackRecipients
     * @param infrastructuralDataElements
     * @param selfRegistrationRole
     * @param infrastructuralPeriodType
     * @param selfRegistrationOrgUnit
     * @param facilityOrgUnitLevel
     * @param corsWhitelist
     * @param facilityOrgUnitGroupSet
     * @param offlineOrganisationUnitLevel
     */
    public Configuration(List<String> corsWhitelist, OrganisationUnitGroupSet facilityOrgUnitGroupSet, OrganisationUnitLevel facilityOrgUnitLevel, UserGroup feedbackRecipients, DataElementGroup infrastructuralDataElements, IndicatorGroup infrastructuralIndicators, Object infrastructuralPeriodType, OrganisationUnitLevel offlineOrganisationUnitLevel, OrganisationUnit selfRegistrationOrgUnit, UserAuthorityGroup selfRegistrationRole, String systemId) {
        super();
        this.corsWhitelist = corsWhitelist;
        this.facilityOrgUnitGroupSet = facilityOrgUnitGroupSet;
        this.facilityOrgUnitLevel = facilityOrgUnitLevel;
        this.feedbackRecipients = feedbackRecipients;
        this.infrastructuralDataElements = infrastructuralDataElements;
        this.infrastructuralIndicators = infrastructuralIndicators;
        this.infrastructuralPeriodType = infrastructuralPeriodType;
        this.offlineOrganisationUnitLevel = offlineOrganisationUnitLevel;
        this.selfRegistrationOrgUnit = selfRegistrationOrgUnit;
        this.selfRegistrationRole = selfRegistrationRole;
        this.systemId = systemId;
    }

    @JsonProperty("corsWhitelist")
    public Optional<List<String>> getCorsWhitelist() {
        return Optional.ofNullable(corsWhitelist);
    }

    @JsonProperty("corsWhitelist")
    public void setCorsWhitelist(List<String> corsWhitelist) {
        this.corsWhitelist = corsWhitelist;
    }

    public Configuration withCorsWhitelist(List<String> corsWhitelist) {
        this.corsWhitelist = corsWhitelist;
        return this;
    }

    @JsonProperty("facilityOrgUnitGroupSet")
    public Optional<OrganisationUnitGroupSet> getFacilityOrgUnitGroupSet() {
        return Optional.ofNullable(facilityOrgUnitGroupSet);
    }

    @JsonProperty("facilityOrgUnitGroupSet")
    public void setFacilityOrgUnitGroupSet(OrganisationUnitGroupSet facilityOrgUnitGroupSet) {
        this.facilityOrgUnitGroupSet = facilityOrgUnitGroupSet;
    }

    public Configuration withFacilityOrgUnitGroupSet(OrganisationUnitGroupSet facilityOrgUnitGroupSet) {
        this.facilityOrgUnitGroupSet = facilityOrgUnitGroupSet;
        return this;
    }

    @JsonProperty("facilityOrgUnitLevel")
    public Optional<OrganisationUnitLevel> getFacilityOrgUnitLevel() {
        return Optional.ofNullable(facilityOrgUnitLevel);
    }

    @JsonProperty("facilityOrgUnitLevel")
    public void setFacilityOrgUnitLevel(OrganisationUnitLevel facilityOrgUnitLevel) {
        this.facilityOrgUnitLevel = facilityOrgUnitLevel;
    }

    public Configuration withFacilityOrgUnitLevel(OrganisationUnitLevel facilityOrgUnitLevel) {
        this.facilityOrgUnitLevel = facilityOrgUnitLevel;
        return this;
    }

    @JsonProperty("feedbackRecipients")
    public Optional<UserGroup> getFeedbackRecipients() {
        return Optional.ofNullable(feedbackRecipients);
    }

    @JsonProperty("feedbackRecipients")
    public void setFeedbackRecipients(UserGroup feedbackRecipients) {
        this.feedbackRecipients = feedbackRecipients;
    }

    public Configuration withFeedbackRecipients(UserGroup feedbackRecipients) {
        this.feedbackRecipients = feedbackRecipients;
        return this;
    }

    @JsonProperty("infrastructuralDataElements")
    public Optional<DataElementGroup> getInfrastructuralDataElements() {
        return Optional.ofNullable(infrastructuralDataElements);
    }

    @JsonProperty("infrastructuralDataElements")
    public void setInfrastructuralDataElements(DataElementGroup infrastructuralDataElements) {
        this.infrastructuralDataElements = infrastructuralDataElements;
    }

    public Configuration withInfrastructuralDataElements(DataElementGroup infrastructuralDataElements) {
        this.infrastructuralDataElements = infrastructuralDataElements;
        return this;
    }

    @JsonProperty("infrastructuralIndicators")
    public Optional<IndicatorGroup> getInfrastructuralIndicators() {
        return Optional.ofNullable(infrastructuralIndicators);
    }

    @JsonProperty("infrastructuralIndicators")
    public void setInfrastructuralIndicators(IndicatorGroup infrastructuralIndicators) {
        this.infrastructuralIndicators = infrastructuralIndicators;
    }

    public Configuration withInfrastructuralIndicators(IndicatorGroup infrastructuralIndicators) {
        this.infrastructuralIndicators = infrastructuralIndicators;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("infrastructuralPeriodType")
    public Optional<Object> getInfrastructuralPeriodType() {
        return Optional.ofNullable(infrastructuralPeriodType);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("infrastructuralPeriodType")
    public void setInfrastructuralPeriodType(Object infrastructuralPeriodType) {
        this.infrastructuralPeriodType = infrastructuralPeriodType;
    }

    public Configuration withInfrastructuralPeriodType(Object infrastructuralPeriodType) {
        this.infrastructuralPeriodType = infrastructuralPeriodType;
        return this;
    }

    @JsonProperty("offlineOrganisationUnitLevel")
    public Optional<OrganisationUnitLevel> getOfflineOrganisationUnitLevel() {
        return Optional.ofNullable(offlineOrganisationUnitLevel);
    }

    @JsonProperty("offlineOrganisationUnitLevel")
    public void setOfflineOrganisationUnitLevel(OrganisationUnitLevel offlineOrganisationUnitLevel) {
        this.offlineOrganisationUnitLevel = offlineOrganisationUnitLevel;
    }

    public Configuration withOfflineOrganisationUnitLevel(OrganisationUnitLevel offlineOrganisationUnitLevel) {
        this.offlineOrganisationUnitLevel = offlineOrganisationUnitLevel;
        return this;
    }

    @JsonProperty("selfRegistrationOrgUnit")
    public Optional<OrganisationUnit> getSelfRegistrationOrgUnit() {
        return Optional.ofNullable(selfRegistrationOrgUnit);
    }

    @JsonProperty("selfRegistrationOrgUnit")
    public void setSelfRegistrationOrgUnit(OrganisationUnit selfRegistrationOrgUnit) {
        this.selfRegistrationOrgUnit = selfRegistrationOrgUnit;
    }

    public Configuration withSelfRegistrationOrgUnit(OrganisationUnit selfRegistrationOrgUnit) {
        this.selfRegistrationOrgUnit = selfRegistrationOrgUnit;
        return this;
    }

    @JsonProperty("selfRegistrationRole")
    public Optional<UserAuthorityGroup> getSelfRegistrationRole() {
        return Optional.ofNullable(selfRegistrationRole);
    }

    @JsonProperty("selfRegistrationRole")
    public void setSelfRegistrationRole(UserAuthorityGroup selfRegistrationRole) {
        this.selfRegistrationRole = selfRegistrationRole;
    }

    public Configuration withSelfRegistrationRole(UserAuthorityGroup selfRegistrationRole) {
        this.selfRegistrationRole = selfRegistrationRole;
        return this;
    }

    @JsonProperty("systemId")
    public Optional<String> getSystemId() {
        return Optional.ofNullable(systemId);
    }

    @JsonProperty("systemId")
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Configuration withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Configuration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "corsWhitelist":
                if (value instanceof List) {
                    setCorsWhitelist(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"corsWhitelist\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "facilityOrgUnitGroupSet":
                if (value instanceof OrganisationUnitGroupSet) {
                    setFacilityOrgUnitGroupSet(((OrganisationUnitGroupSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"facilityOrgUnitGroupSet\" is of type \"org.hisp.dhis.api.model.v2_37_7.OrganisationUnitGroupSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "facilityOrgUnitLevel":
                if (value instanceof OrganisationUnitLevel) {
                    setFacilityOrgUnitLevel(((OrganisationUnitLevel) value));
                } else {
                    throw new IllegalArgumentException(("property \"facilityOrgUnitLevel\" is of type \"org.hisp.dhis.api.model.v2_37_7.OrganisationUnitLevel\", but got "+ value.getClass().toString()));
                }
                return true;
            case "feedbackRecipients":
                if (value instanceof UserGroup) {
                    setFeedbackRecipients(((UserGroup) value));
                } else {
                    throw new IllegalArgumentException(("property \"feedbackRecipients\" is of type \"org.hisp.dhis.api.model.v2_37_7.UserGroup\", but got "+ value.getClass().toString()));
                }
                return true;
            case "infrastructuralDataElements":
                if (value instanceof DataElementGroup) {
                    setInfrastructuralDataElements(((DataElementGroup) value));
                } else {
                    throw new IllegalArgumentException(("property \"infrastructuralDataElements\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataElementGroup\", but got "+ value.getClass().toString()));
                }
                return true;
            case "infrastructuralIndicators":
                if (value instanceof IndicatorGroup) {
                    setInfrastructuralIndicators(((IndicatorGroup) value));
                } else {
                    throw new IllegalArgumentException(("property \"infrastructuralIndicators\" is of type \"org.hisp.dhis.api.model.v2_37_7.IndicatorGroup\", but got "+ value.getClass().toString()));
                }
                return true;
            case "infrastructuralPeriodType":
                if (value instanceof Object) {
                    setInfrastructuralPeriodType(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"infrastructuralPeriodType\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "offlineOrganisationUnitLevel":
                if (value instanceof OrganisationUnitLevel) {
                    setOfflineOrganisationUnitLevel(((OrganisationUnitLevel) value));
                } else {
                    throw new IllegalArgumentException(("property \"offlineOrganisationUnitLevel\" is of type \"org.hisp.dhis.api.model.v2_37_7.OrganisationUnitLevel\", but got "+ value.getClass().toString()));
                }
                return true;
            case "selfRegistrationOrgUnit":
                if (value instanceof OrganisationUnit) {
                    setSelfRegistrationOrgUnit(((OrganisationUnit) value));
                } else {
                    throw new IllegalArgumentException(("property \"selfRegistrationOrgUnit\" is of type \"org.hisp.dhis.api.model.v2_37_7.OrganisationUnit\", but got "+ value.getClass().toString()));
                }
                return true;
            case "selfRegistrationRole":
                if (value instanceof UserAuthorityGroup) {
                    setSelfRegistrationRole(((UserAuthorityGroup) value));
                } else {
                    throw new IllegalArgumentException(("property \"selfRegistrationRole\" is of type \"org.hisp.dhis.api.model.v2_37_7.UserAuthorityGroup\", but got "+ value.getClass().toString()));
                }
                return true;
            case "systemId":
                if (value instanceof String) {
                    setSystemId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"systemId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "corsWhitelist":
                return getCorsWhitelist();
            case "facilityOrgUnitGroupSet":
                return getFacilityOrgUnitGroupSet();
            case "facilityOrgUnitLevel":
                return getFacilityOrgUnitLevel();
            case "feedbackRecipients":
                return getFeedbackRecipients();
            case "infrastructuralDataElements":
                return getInfrastructuralDataElements();
            case "infrastructuralIndicators":
                return getInfrastructuralIndicators();
            case "infrastructuralPeriodType":
                return getInfrastructuralPeriodType();
            case "offlineOrganisationUnitLevel":
                return getOfflineOrganisationUnitLevel();
            case "selfRegistrationOrgUnit":
                return getSelfRegistrationOrgUnit();
            case "selfRegistrationRole":
                return getSelfRegistrationRole();
            case "systemId":
                return getSystemId();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Configuration.NOT_FOUND_VALUE);
        if (Configuration.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Configuration with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Configuration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("corsWhitelist");
        sb.append('=');
        sb.append(((this.corsWhitelist == null)?"<null>":this.corsWhitelist));
        sb.append(',');
        sb.append("facilityOrgUnitGroupSet");
        sb.append('=');
        sb.append(((this.facilityOrgUnitGroupSet == null)?"<null>":this.facilityOrgUnitGroupSet));
        sb.append(',');
        sb.append("facilityOrgUnitLevel");
        sb.append('=');
        sb.append(((this.facilityOrgUnitLevel == null)?"<null>":this.facilityOrgUnitLevel));
        sb.append(',');
        sb.append("feedbackRecipients");
        sb.append('=');
        sb.append(((this.feedbackRecipients == null)?"<null>":this.feedbackRecipients));
        sb.append(',');
        sb.append("infrastructuralDataElements");
        sb.append('=');
        sb.append(((this.infrastructuralDataElements == null)?"<null>":this.infrastructuralDataElements));
        sb.append(',');
        sb.append("infrastructuralIndicators");
        sb.append('=');
        sb.append(((this.infrastructuralIndicators == null)?"<null>":this.infrastructuralIndicators));
        sb.append(',');
        sb.append("infrastructuralPeriodType");
        sb.append('=');
        sb.append(((this.infrastructuralPeriodType == null)?"<null>":this.infrastructuralPeriodType));
        sb.append(',');
        sb.append("offlineOrganisationUnitLevel");
        sb.append('=');
        sb.append(((this.offlineOrganisationUnitLevel == null)?"<null>":this.offlineOrganisationUnitLevel));
        sb.append(',');
        sb.append("selfRegistrationOrgUnit");
        sb.append('=');
        sb.append(((this.selfRegistrationOrgUnit == null)?"<null>":this.selfRegistrationOrgUnit));
        sb.append(',');
        sb.append("selfRegistrationRole");
        sb.append('=');
        sb.append(((this.selfRegistrationRole == null)?"<null>":this.selfRegistrationRole));
        sb.append(',');
        sb.append("systemId");
        sb.append('=');
        sb.append(((this.systemId == null)?"<null>":this.systemId));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.infrastructuralIndicators == null)? 0 :this.infrastructuralIndicators.hashCode()));
        result = ((result* 31)+((this.systemId == null)? 0 :this.systemId.hashCode()));
        result = ((result* 31)+((this.feedbackRecipients == null)? 0 :this.feedbackRecipients.hashCode()));
        result = ((result* 31)+((this.infrastructuralDataElements == null)? 0 :this.infrastructuralDataElements.hashCode()));
        result = ((result* 31)+((this.selfRegistrationOrgUnit == null)? 0 :this.selfRegistrationOrgUnit.hashCode()));
        result = ((result* 31)+((this.offlineOrganisationUnitLevel == null)? 0 :this.offlineOrganisationUnitLevel.hashCode()));
        result = ((result* 31)+((this.selfRegistrationRole == null)? 0 :this.selfRegistrationRole.hashCode()));
        result = ((result* 31)+((this.infrastructuralPeriodType == null)? 0 :this.infrastructuralPeriodType.hashCode()));
        result = ((result* 31)+((this.facilityOrgUnitLevel == null)? 0 :this.facilityOrgUnitLevel.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.corsWhitelist == null)? 0 :this.corsWhitelist.hashCode()));
        result = ((result* 31)+((this.facilityOrgUnitGroupSet == null)? 0 :this.facilityOrgUnitGroupSet.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Configuration) == false) {
            return false;
        }
        Configuration rhs = ((Configuration) other);
        return (((((((((((((this.infrastructuralIndicators == rhs.infrastructuralIndicators)||((this.infrastructuralIndicators!= null)&&this.infrastructuralIndicators.equals(rhs.infrastructuralIndicators)))&&((this.systemId == rhs.systemId)||((this.systemId!= null)&&this.systemId.equals(rhs.systemId))))&&((this.feedbackRecipients == rhs.feedbackRecipients)||((this.feedbackRecipients!= null)&&this.feedbackRecipients.equals(rhs.feedbackRecipients))))&&((this.infrastructuralDataElements == rhs.infrastructuralDataElements)||((this.infrastructuralDataElements!= null)&&this.infrastructuralDataElements.equals(rhs.infrastructuralDataElements))))&&((this.selfRegistrationOrgUnit == rhs.selfRegistrationOrgUnit)||((this.selfRegistrationOrgUnit!= null)&&this.selfRegistrationOrgUnit.equals(rhs.selfRegistrationOrgUnit))))&&((this.offlineOrganisationUnitLevel == rhs.offlineOrganisationUnitLevel)||((this.offlineOrganisationUnitLevel!= null)&&this.offlineOrganisationUnitLevel.equals(rhs.offlineOrganisationUnitLevel))))&&((this.selfRegistrationRole == rhs.selfRegistrationRole)||((this.selfRegistrationRole!= null)&&this.selfRegistrationRole.equals(rhs.selfRegistrationRole))))&&((this.infrastructuralPeriodType == rhs.infrastructuralPeriodType)||((this.infrastructuralPeriodType!= null)&&this.infrastructuralPeriodType.equals(rhs.infrastructuralPeriodType))))&&((this.facilityOrgUnitLevel == rhs.facilityOrgUnitLevel)||((this.facilityOrgUnitLevel!= null)&&this.facilityOrgUnitLevel.equals(rhs.facilityOrgUnitLevel))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.corsWhitelist == rhs.corsWhitelist)||((this.corsWhitelist!= null)&&this.corsWhitelist.equals(rhs.corsWhitelist))))&&((this.facilityOrgUnitGroupSet == rhs.facilityOrgUnitGroupSet)||((this.facilityOrgUnitGroupSet!= null)&&this.facilityOrgUnitGroupSet.equals(rhs.facilityOrgUnitGroupSet))));
    }

}
