
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "attributeDimensions",
    "attributeValues",
    "categoryDimensions",
    "categoryOptionGroupSetDimensions",
    "code",
    "colSubTotals",
    "colTotals",
    "columnDimensions",
    "columns",
    "completedOnly",
    "created",
    "createdBy",
    "cumulative",
    "dataDimensionItems",
    "dataElementDimensions",
    "dataElementGroupSetDimensions",
    "description",
    "digitGroupSeparator",
    "displayDensity",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "displaySubtitle",
    "displayTitle",
    "endDate",
    "externalAccess",
    "favorite",
    "favorites",
    "filterDimensions",
    "filters",
    "fontSize",
    "formName",
    "hideEmptyColumns",
    "hideEmptyRows",
    "hideSubtitle",
    "hideTitle",
    "href",
    "id",
    "interpretations",
    "itemOrganisationUnitGroups",
    "lastUpdated",
    "lastUpdatedBy",
    "legendDisplayStrategy",
    "legendDisplayStyle",
    "legendSet",
    "measureCriteria",
    "name",
    "numberType",
    "orgUnitField",
    "organisationUnitGroupSetDimensions",
    "organisationUnitLevels",
    "organisationUnits",
    "parentGraphMap",
    "periods",
    "programIndicatorDimensions",
    "publicAccess",
    "regression",
    "relativePeriods",
    "reportParams",
    "rowDimensions",
    "rowSubTotals",
    "rowTotals",
    "rows",
    "sharing",
    "shortName",
    "showDimensionLabels",
    "showHierarchy",
    "skipRounding",
    "sortOrder",
    "startDate",
    "subscribed",
    "subscribers",
    "subtitle",
    "timeField",
    "title",
    "topLimit",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "userOrgUnitType",
    "userOrganisationUnit",
    "userOrganisationUnitChildren",
    "userOrganisationUnitGrandChildren"
})
@Generated("jsonschema2pojo")
public class ReportTable implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("attributeDimensions")
    private List<TrackedEntityAttributeDimension> attributeDimensions = null;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("categoryDimensions")
    private List<CategoryDimension> categoryDimensions = null;
    @JsonProperty("categoryOptionGroupSetDimensions")
    private List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("colSubTotals")
    private Boolean colSubTotals;
    @JsonProperty("colTotals")
    private Boolean colTotals;
    @JsonProperty("columnDimensions")
    private List<String> columnDimensions = null;
    @JsonProperty("columns")
    private List<Object> columns = null;
    @JsonProperty("completedOnly")
    private Boolean completedOnly;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("cumulative")
    private Boolean cumulative;
    @JsonProperty("dataDimensionItems")
    private List<DataDimensionItem> dataDimensionItems = null;
    @JsonProperty("dataElementDimensions")
    private List<TrackedEntityDataElementDimension> dataElementDimensions = null;
    @JsonProperty("dataElementGroupSetDimensions")
    private List<DataElementGroupSetDimension> dataElementGroupSetDimensions = null;
    @JsonProperty("description")
    private String description;
    @JsonProperty("digitGroupSeparator")
    private org.hisp.dhis.api.model.v2_36_11.Chart.DigitGroupSeparator digitGroupSeparator;
    @JsonProperty("displayDensity")
    private org.hisp.dhis.api.model.v2_36_11.DataEntryForm.DisplayDensity displayDensity;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("displaySubtitle")
    private String displaySubtitle;
    @JsonProperty("displayTitle")
    private String displayTitle;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("filterDimensions")
    private List<String> filterDimensions = null;
    @JsonProperty("filters")
    private List<Object> filters = null;
    @JsonProperty("fontSize")
    private org.hisp.dhis.api.model.v2_36_11.EventReport.FontSize fontSize;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("hideEmptyColumns")
    private Boolean hideEmptyColumns;
    @JsonProperty("hideEmptyRows")
    private Boolean hideEmptyRows;
    @JsonProperty("hideSubtitle")
    private Boolean hideSubtitle;
    @JsonProperty("hideTitle")
    private Boolean hideTitle;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("interpretations")
    private List<Interpretation> interpretations = null;
    @JsonProperty("itemOrganisationUnitGroups")
    private List<OrganisationUnitGroup> itemOrganisationUnitGroups = null;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("legendDisplayStrategy")
    private org.hisp.dhis.api.model.v2_36_11.Chart.LegendDisplayStrategy legendDisplayStrategy;
    @JsonProperty("legendDisplayStyle")
    private ReportTable.LegendDisplayStyle legendDisplayStyle;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("measureCriteria")
    private String measureCriteria;
    @JsonProperty("name")
    private String name;
    @JsonProperty("numberType")
    private ReportTable.NumberType numberType;
    @JsonProperty("orgUnitField")
    private String orgUnitField;
    @JsonProperty("organisationUnitGroupSetDimensions")
    private List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions = null;
    @JsonProperty("organisationUnitLevels")
    private List<Integer> organisationUnitLevels = null;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnit> organisationUnits = null;
    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    private ParentGraphMap__4 parentGraphMap;
    @JsonProperty("periods")
    private List<Period> periods = null;
    @JsonProperty("programIndicatorDimensions")
    private List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions = null;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("regression")
    private Boolean regression;
    @JsonProperty("relativePeriods")
    private RelativePeriods relativePeriods;
    @JsonProperty("reportParams")
    private ReportParams reportParams;
    @JsonProperty("rowDimensions")
    private List<String> rowDimensions = null;
    @JsonProperty("rowSubTotals")
    private Boolean rowSubTotals;
    @JsonProperty("rowTotals")
    private Boolean rowTotals;
    @JsonProperty("rows")
    private List<Object> rows = null;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("showDimensionLabels")
    private Boolean showDimensionLabels;
    @JsonProperty("showHierarchy")
    private Boolean showHierarchy;
    @JsonProperty("skipRounding")
    private Boolean skipRounding;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonProperty("subscribed")
    private Boolean subscribed;
    @JsonProperty("subscribers")
    private List<String> subscribers = null;
    @JsonProperty("subtitle")
    private String subtitle;
    @JsonProperty("timeField")
    private String timeField;
    @JsonProperty("title")
    private String title;
    @JsonProperty("topLimit")
    private Integer topLimit;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess__1> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess__1> userGroupAccesses = null;
    @JsonProperty("userOrgUnitType")
    private org.hisp.dhis.api.model.v2_36_11.Chart.UserOrgUnitType userOrgUnitType;
    @JsonProperty("userOrganisationUnit")
    private Boolean userOrganisationUnit;
    @JsonProperty("userOrganisationUnitChildren")
    private Boolean userOrganisationUnitChildren;
    @JsonProperty("userOrganisationUnitGrandChildren")
    private Boolean userOrganisationUnitGrandChildren;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4792644311275281030L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ReportTable() {
    }

    /**
     * 
     * @param source
     */
    public ReportTable(ReportTable source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.attributeDimensions = source.attributeDimensions;
        this.attributeValues = source.attributeValues;
        this.categoryDimensions = source.categoryDimensions;
        this.categoryOptionGroupSetDimensions = source.categoryOptionGroupSetDimensions;
        this.code = source.code;
        this.colSubTotals = source.colSubTotals;
        this.colTotals = source.colTotals;
        this.columnDimensions = source.columnDimensions;
        this.columns = source.columns;
        this.completedOnly = source.completedOnly;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.cumulative = source.cumulative;
        this.dataDimensionItems = source.dataDimensionItems;
        this.dataElementDimensions = source.dataElementDimensions;
        this.dataElementGroupSetDimensions = source.dataElementGroupSetDimensions;
        this.description = source.description;
        this.digitGroupSeparator = source.digitGroupSeparator;
        this.displayDensity = source.displayDensity;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.displaySubtitle = source.displaySubtitle;
        this.displayTitle = source.displayTitle;
        this.endDate = source.endDate;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.filterDimensions = source.filterDimensions;
        this.filters = source.filters;
        this.fontSize = source.fontSize;
        this.formName = source.formName;
        this.hideEmptyColumns = source.hideEmptyColumns;
        this.hideEmptyRows = source.hideEmptyRows;
        this.hideSubtitle = source.hideSubtitle;
        this.hideTitle = source.hideTitle;
        this.href = source.href;
        this.id = source.id;
        this.interpretations = source.interpretations;
        this.itemOrganisationUnitGroups = source.itemOrganisationUnitGroups;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendDisplayStrategy = source.legendDisplayStrategy;
        this.legendDisplayStyle = source.legendDisplayStyle;
        this.legendSet = source.legendSet;
        this.measureCriteria = source.measureCriteria;
        this.name = source.name;
        this.numberType = source.numberType;
        this.orgUnitField = source.orgUnitField;
        this.organisationUnitGroupSetDimensions = source.organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = source.organisationUnitLevels;
        this.organisationUnits = source.organisationUnits;
        this.parentGraphMap = source.parentGraphMap;
        this.periods = source.periods;
        this.programIndicatorDimensions = source.programIndicatorDimensions;
        this.publicAccess = source.publicAccess;
        this.regression = source.regression;
        this.relativePeriods = source.relativePeriods;
        this.reportParams = source.reportParams;
        this.rowDimensions = source.rowDimensions;
        this.rowSubTotals = source.rowSubTotals;
        this.rowTotals = source.rowTotals;
        this.rows = source.rows;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.showDimensionLabels = source.showDimensionLabels;
        this.showHierarchy = source.showHierarchy;
        this.skipRounding = source.skipRounding;
        this.sortOrder = source.sortOrder;
        this.startDate = source.startDate;
        this.subscribed = source.subscribed;
        this.subscribers = source.subscribers;
        this.subtitle = source.subtitle;
        this.timeField = source.timeField;
        this.title = source.title;
        this.topLimit = source.topLimit;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userOrgUnitType = source.userOrgUnitType;
        this.userOrganisationUnit = source.userOrganisationUnit;
        this.userOrganisationUnitChildren = source.userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = source.userOrganisationUnitGrandChildren;
    }

    /**
     * 
     * @param dataElementGroupSetDimensions
     * @param numberType
     * @param orgUnitField
     * @param endDate
     * @param publicAccess
     * @param userOrganisationUnitChildren
     * @param displaySubtitle
     * @param legendDisplayStyle
     * @param hideEmptyColumns
     * @param measureCriteria
     * @param displayTitle
     * @param hideEmptyRows
     * @param lastUpdated
     * @param subscribed
     * @param attributeDimensions
     * @param reportParams
     * @param translations
     * @param parentGraphMap
     * @param userOrganisationUnit
     * @param filterDimensions
     * @param href
     * @param id
     * @param rowSubTotals
     * @param interpretations
     * @param itemOrganisationUnitGroups
     * @param displayDensity
     * @param displayDescription
     * @param lastUpdatedBy
     * @param programIndicatorDimensions
     * @param userGroupAccesses
     * @param created
     * @param subscribers
     * @param attributeValues
     * @param columnDimensions
     * @param completedOnly
     * @param colTotals
     * @param sharing
     * @param displayFormName
     * @param showDimensionLabels
     * @param sortOrder
     * @param subtitle
     * @param userAccesses
     * @param name
     * @param fontSize
     * @param shortName
     * @param favorite
     * @param topLimit
     * @param startDate
     * @param favorites
     * @param aggregationType
     * @param dataDimensionItems
     * @param access
     * @param categoryOptionGroupSetDimensions
     * @param code
     * @param userOrganisationUnitGrandChildren
     * @param columns
     * @param displayName
     * @param hideSubtitle
     * @param description
     * @param organisationUnitGroupSetDimensions
     * @param title
     * @param displayShortName
     * @param externalAccess
     * @param organisationUnitLevels
     * @param colSubTotals
     * @param legendDisplayStrategy
     * @param dataElementDimensions
     * @param relativePeriods
     * @param formName
     * @param periods
     * @param organisationUnits
     * @param categoryDimensions
     * @param showHierarchy
     * @param rowTotals
     * @param timeField
     * @param filters
     * @param cumulative
     * @param rows
     * @param digitGroupSeparator
     * @param hideTitle
     * @param createdBy
     * @param rowDimensions
     * @param regression
     * @param legendSet
     * @param userOrgUnitType
     * @param user
     * @param skipRounding
     */
    public ReportTable(Access access, AggregationType aggregationType, List<TrackedEntityAttributeDimension> attributeDimensions, List<AttributeValue> attributeValues, List<CategoryDimension> categoryDimensions, List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions, String code, Boolean colSubTotals, Boolean colTotals, List<String> columnDimensions, List<Object> columns, Boolean completedOnly, Date created, User createdBy, Boolean cumulative, List<DataDimensionItem> dataDimensionItems, List<TrackedEntityDataElementDimension> dataElementDimensions, List<DataElementGroupSetDimension> dataElementGroupSetDimensions, String description, org.hisp.dhis.api.model.v2_36_11.Chart.DigitGroupSeparator digitGroupSeparator, org.hisp.dhis.api.model.v2_36_11.DataEntryForm.DisplayDensity displayDensity, String displayDescription, String displayFormName, String displayName, String displayShortName, String displaySubtitle, String displayTitle, Date endDate, Boolean externalAccess, Boolean favorite, List<String> favorites, List<String> filterDimensions, List<Object> filters, org.hisp.dhis.api.model.v2_36_11.EventReport.FontSize fontSize, String formName, Boolean hideEmptyColumns, Boolean hideEmptyRows, Boolean hideSubtitle, Boolean hideTitle, String href, String id, List<Interpretation> interpretations, List<OrganisationUnitGroup> itemOrganisationUnitGroups, Date lastUpdated, User lastUpdatedBy, org.hisp.dhis.api.model.v2_36_11.Chart.LegendDisplayStrategy legendDisplayStrategy, ReportTable.LegendDisplayStyle legendDisplayStyle, LegendSet legendSet, String measureCriteria, String name, ReportTable.NumberType numberType, String orgUnitField, List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions, List<Integer> organisationUnitLevels, List<OrganisationUnit> organisationUnits, ParentGraphMap__4 parentGraphMap, List<Period> periods, List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions, String publicAccess, Boolean regression, RelativePeriods relativePeriods, ReportParams reportParams, List<String> rowDimensions, Boolean rowSubTotals, Boolean rowTotals, List<Object> rows, Sharing sharing, String shortName, Boolean showDimensionLabels, Boolean showHierarchy, Boolean skipRounding, Integer sortOrder, Date startDate, Boolean subscribed, List<String> subscribers, String subtitle, String timeField, String title, Integer topLimit, List<Translation> translations, User user, List<UserAccess__1> userAccesses, List<UserGroupAccess__1> userGroupAccesses, org.hisp.dhis.api.model.v2_36_11.Chart.UserOrgUnitType userOrgUnitType, Boolean userOrganisationUnit, Boolean userOrganisationUnitChildren, Boolean userOrganisationUnitGrandChildren) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.attributeDimensions = attributeDimensions;
        this.attributeValues = attributeValues;
        this.categoryDimensions = categoryDimensions;
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        this.code = code;
        this.colSubTotals = colSubTotals;
        this.colTotals = colTotals;
        this.columnDimensions = columnDimensions;
        this.columns = columns;
        this.completedOnly = completedOnly;
        this.created = created;
        this.createdBy = createdBy;
        this.cumulative = cumulative;
        this.dataDimensionItems = dataDimensionItems;
        this.dataElementDimensions = dataElementDimensions;
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        this.description = description;
        this.digitGroupSeparator = digitGroupSeparator;
        this.displayDensity = displayDensity;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.displaySubtitle = displaySubtitle;
        this.displayTitle = displayTitle;
        this.endDate = endDate;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.filterDimensions = filterDimensions;
        this.filters = filters;
        this.fontSize = fontSize;
        this.formName = formName;
        this.hideEmptyColumns = hideEmptyColumns;
        this.hideEmptyRows = hideEmptyRows;
        this.hideSubtitle = hideSubtitle;
        this.hideTitle = hideTitle;
        this.href = href;
        this.id = id;
        this.interpretations = interpretations;
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendDisplayStrategy = legendDisplayStrategy;
        this.legendDisplayStyle = legendDisplayStyle;
        this.legendSet = legendSet;
        this.measureCriteria = measureCriteria;
        this.name = name;
        this.numberType = numberType;
        this.orgUnitField = orgUnitField;
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = organisationUnitLevels;
        this.organisationUnits = organisationUnits;
        this.parentGraphMap = parentGraphMap;
        this.periods = periods;
        this.programIndicatorDimensions = programIndicatorDimensions;
        this.publicAccess = publicAccess;
        this.regression = regression;
        this.relativePeriods = relativePeriods;
        this.reportParams = reportParams;
        this.rowDimensions = rowDimensions;
        this.rowSubTotals = rowSubTotals;
        this.rowTotals = rowTotals;
        this.rows = rows;
        this.sharing = sharing;
        this.shortName = shortName;
        this.showDimensionLabels = showDimensionLabels;
        this.showHierarchy = showHierarchy;
        this.skipRounding = skipRounding;
        this.sortOrder = sortOrder;
        this.startDate = startDate;
        this.subscribed = subscribed;
        this.subscribers = subscribers;
        this.subtitle = subtitle;
        this.timeField = timeField;
        this.title = title;
        this.topLimit = topLimit;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.userOrgUnitType = userOrgUnitType;
        this.userOrganisationUnit = userOrganisationUnit;
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ReportTable withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public ReportTable withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeDimensions")
    public Optional<List<TrackedEntityAttributeDimension>> getAttributeDimensions() {
        return Optional.ofNullable(attributeDimensions);
    }

    @JsonProperty("attributeDimensions")
    public void setAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
    }

    public ReportTable withAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ReportTable withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("categoryDimensions")
    public Optional<List<CategoryDimension>> getCategoryDimensions() {
        return Optional.ofNullable(categoryDimensions);
    }

    @JsonProperty("categoryDimensions")
    public void setCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
    }

    public ReportTable withCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
        return this;
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public Optional<List<CategoryOptionGroupSetDimension>> getCategoryOptionGroupSetDimensions() {
        return Optional.ofNullable(categoryOptionGroupSetDimensions);
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public void setCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
    }

    public ReportTable withCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ReportTable withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("colSubTotals")
    public Optional<Boolean> getColSubTotals() {
        return Optional.ofNullable(colSubTotals);
    }

    @JsonProperty("colSubTotals")
    public void setColSubTotals(Boolean colSubTotals) {
        this.colSubTotals = colSubTotals;
    }

    public ReportTable withColSubTotals(Boolean colSubTotals) {
        this.colSubTotals = colSubTotals;
        return this;
    }

    @JsonProperty("colTotals")
    public Optional<Boolean> getColTotals() {
        return Optional.ofNullable(colTotals);
    }

    @JsonProperty("colTotals")
    public void setColTotals(Boolean colTotals) {
        this.colTotals = colTotals;
    }

    public ReportTable withColTotals(Boolean colTotals) {
        this.colTotals = colTotals;
        return this;
    }

    @JsonProperty("columnDimensions")
    public Optional<List<String>> getColumnDimensions() {
        return Optional.ofNullable(columnDimensions);
    }

    @JsonProperty("columnDimensions")
    public void setColumnDimensions(List<String> columnDimensions) {
        this.columnDimensions = columnDimensions;
    }

    public ReportTable withColumnDimensions(List<String> columnDimensions) {
        this.columnDimensions = columnDimensions;
        return this;
    }

    @JsonProperty("columns")
    public Optional<List<Object>> getColumns() {
        return Optional.ofNullable(columns);
    }

    @JsonProperty("columns")
    public void setColumns(List<Object> columns) {
        this.columns = columns;
    }

    public ReportTable withColumns(List<Object> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty("completedOnly")
    public Optional<Boolean> getCompletedOnly() {
        return Optional.ofNullable(completedOnly);
    }

    @JsonProperty("completedOnly")
    public void setCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
    }

    public ReportTable withCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ReportTable withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public ReportTable withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("cumulative")
    public Optional<Boolean> getCumulative() {
        return Optional.ofNullable(cumulative);
    }

    @JsonProperty("cumulative")
    public void setCumulative(Boolean cumulative) {
        this.cumulative = cumulative;
    }

    public ReportTable withCumulative(Boolean cumulative) {
        this.cumulative = cumulative;
        return this;
    }

    @JsonProperty("dataDimensionItems")
    public Optional<List<DataDimensionItem>> getDataDimensionItems() {
        return Optional.ofNullable(dataDimensionItems);
    }

    @JsonProperty("dataDimensionItems")
    public void setDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
    }

    public ReportTable withDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
        return this;
    }

    @JsonProperty("dataElementDimensions")
    public Optional<List<TrackedEntityDataElementDimension>> getDataElementDimensions() {
        return Optional.ofNullable(dataElementDimensions);
    }

    @JsonProperty("dataElementDimensions")
    public void setDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
    }

    public ReportTable withDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
        return this;
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public Optional<List<DataElementGroupSetDimension>> getDataElementGroupSetDimensions() {
        return Optional.ofNullable(dataElementGroupSetDimensions);
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public void setDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
    }

    public ReportTable withDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ReportTable withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("digitGroupSeparator")
    public Optional<org.hisp.dhis.api.model.v2_36_11.Chart.DigitGroupSeparator> getDigitGroupSeparator() {
        return Optional.ofNullable(digitGroupSeparator);
    }

    @JsonProperty("digitGroupSeparator")
    public void setDigitGroupSeparator(org.hisp.dhis.api.model.v2_36_11.Chart.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
    }

    public ReportTable withDigitGroupSeparator(org.hisp.dhis.api.model.v2_36_11.Chart.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
        return this;
    }

    @JsonProperty("displayDensity")
    public Optional<org.hisp.dhis.api.model.v2_36_11.DataEntryForm.DisplayDensity> getDisplayDensity() {
        return Optional.ofNullable(displayDensity);
    }

    @JsonProperty("displayDensity")
    public void setDisplayDensity(org.hisp.dhis.api.model.v2_36_11.DataEntryForm.DisplayDensity displayDensity) {
        this.displayDensity = displayDensity;
    }

    public ReportTable withDisplayDensity(org.hisp.dhis.api.model.v2_36_11.DataEntryForm.DisplayDensity displayDensity) {
        this.displayDensity = displayDensity;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public ReportTable withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public ReportTable withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ReportTable withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public ReportTable withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("displaySubtitle")
    public Optional<String> getDisplaySubtitle() {
        return Optional.ofNullable(displaySubtitle);
    }

    @JsonProperty("displaySubtitle")
    public void setDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
    }

    public ReportTable withDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
        return this;
    }

    @JsonProperty("displayTitle")
    public Optional<String> getDisplayTitle() {
        return Optional.ofNullable(displayTitle);
    }

    @JsonProperty("displayTitle")
    public void setDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
    }

    public ReportTable withDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public ReportTable withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ReportTable withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ReportTable withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ReportTable withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("filterDimensions")
    public Optional<List<String>> getFilterDimensions() {
        return Optional.ofNullable(filterDimensions);
    }

    @JsonProperty("filterDimensions")
    public void setFilterDimensions(List<String> filterDimensions) {
        this.filterDimensions = filterDimensions;
    }

    public ReportTable withFilterDimensions(List<String> filterDimensions) {
        this.filterDimensions = filterDimensions;
        return this;
    }

    @JsonProperty("filters")
    public Optional<List<Object>> getFilters() {
        return Optional.ofNullable(filters);
    }

    @JsonProperty("filters")
    public void setFilters(List<Object> filters) {
        this.filters = filters;
    }

    public ReportTable withFilters(List<Object> filters) {
        this.filters = filters;
        return this;
    }

    @JsonProperty("fontSize")
    public Optional<org.hisp.dhis.api.model.v2_36_11.EventReport.FontSize> getFontSize() {
        return Optional.ofNullable(fontSize);
    }

    @JsonProperty("fontSize")
    public void setFontSize(org.hisp.dhis.api.model.v2_36_11.EventReport.FontSize fontSize) {
        this.fontSize = fontSize;
    }

    public ReportTable withFontSize(org.hisp.dhis.api.model.v2_36_11.EventReport.FontSize fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public ReportTable withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("hideEmptyColumns")
    public Optional<Boolean> getHideEmptyColumns() {
        return Optional.ofNullable(hideEmptyColumns);
    }

    @JsonProperty("hideEmptyColumns")
    public void setHideEmptyColumns(Boolean hideEmptyColumns) {
        this.hideEmptyColumns = hideEmptyColumns;
    }

    public ReportTable withHideEmptyColumns(Boolean hideEmptyColumns) {
        this.hideEmptyColumns = hideEmptyColumns;
        return this;
    }

    @JsonProperty("hideEmptyRows")
    public Optional<Boolean> getHideEmptyRows() {
        return Optional.ofNullable(hideEmptyRows);
    }

    @JsonProperty("hideEmptyRows")
    public void setHideEmptyRows(Boolean hideEmptyRows) {
        this.hideEmptyRows = hideEmptyRows;
    }

    public ReportTable withHideEmptyRows(Boolean hideEmptyRows) {
        this.hideEmptyRows = hideEmptyRows;
        return this;
    }

    @JsonProperty("hideSubtitle")
    public Optional<Boolean> getHideSubtitle() {
        return Optional.ofNullable(hideSubtitle);
    }

    @JsonProperty("hideSubtitle")
    public void setHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
    }

    public ReportTable withHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
        return this;
    }

    @JsonProperty("hideTitle")
    public Optional<Boolean> getHideTitle() {
        return Optional.ofNullable(hideTitle);
    }

    @JsonProperty("hideTitle")
    public void setHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
    }

    public ReportTable withHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ReportTable withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ReportTable withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("interpretations")
    public Optional<List<Interpretation>> getInterpretations() {
        return Optional.ofNullable(interpretations);
    }

    @JsonProperty("interpretations")
    public void setInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
    }

    public ReportTable withInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
        return this;
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public Optional<List<OrganisationUnitGroup>> getItemOrganisationUnitGroups() {
        return Optional.ofNullable(itemOrganisationUnitGroups);
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public void setItemOrganisationUnitGroups(List<OrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
    }

    public ReportTable withItemOrganisationUnitGroups(List<OrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ReportTable withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ReportTable withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legendDisplayStrategy")
    public Optional<org.hisp.dhis.api.model.v2_36_11.Chart.LegendDisplayStrategy> getLegendDisplayStrategy() {
        return Optional.ofNullable(legendDisplayStrategy);
    }

    @JsonProperty("legendDisplayStrategy")
    public void setLegendDisplayStrategy(org.hisp.dhis.api.model.v2_36_11.Chart.LegendDisplayStrategy legendDisplayStrategy) {
        this.legendDisplayStrategy = legendDisplayStrategy;
    }

    public ReportTable withLegendDisplayStrategy(org.hisp.dhis.api.model.v2_36_11.Chart.LegendDisplayStrategy legendDisplayStrategy) {
        this.legendDisplayStrategy = legendDisplayStrategy;
        return this;
    }

    @JsonProperty("legendDisplayStyle")
    public Optional<ReportTable.LegendDisplayStyle> getLegendDisplayStyle() {
        return Optional.ofNullable(legendDisplayStyle);
    }

    @JsonProperty("legendDisplayStyle")
    public void setLegendDisplayStyle(ReportTable.LegendDisplayStyle legendDisplayStyle) {
        this.legendDisplayStyle = legendDisplayStyle;
    }

    public ReportTable withLegendDisplayStyle(ReportTable.LegendDisplayStyle legendDisplayStyle) {
        this.legendDisplayStyle = legendDisplayStyle;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public ReportTable withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("measureCriteria")
    public Optional<String> getMeasureCriteria() {
        return Optional.ofNullable(measureCriteria);
    }

    @JsonProperty("measureCriteria")
    public void setMeasureCriteria(String measureCriteria) {
        this.measureCriteria = measureCriteria;
    }

    public ReportTable withMeasureCriteria(String measureCriteria) {
        this.measureCriteria = measureCriteria;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ReportTable withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("numberType")
    public Optional<ReportTable.NumberType> getNumberType() {
        return Optional.ofNullable(numberType);
    }

    @JsonProperty("numberType")
    public void setNumberType(ReportTable.NumberType numberType) {
        this.numberType = numberType;
    }

    public ReportTable withNumberType(ReportTable.NumberType numberType) {
        this.numberType = numberType;
        return this;
    }

    @JsonProperty("orgUnitField")
    public Optional<String> getOrgUnitField() {
        return Optional.ofNullable(orgUnitField);
    }

    @JsonProperty("orgUnitField")
    public void setOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
    }

    public ReportTable withOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
        return this;
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public Optional<List<OrganisationUnitGroupSetDimension>> getOrganisationUnitGroupSetDimensions() {
        return Optional.ofNullable(organisationUnitGroupSetDimensions);
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public void setOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
    }

    public ReportTable withOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        return this;
    }

    @JsonProperty("organisationUnitLevels")
    public Optional<List<Integer>> getOrganisationUnitLevels() {
        return Optional.ofNullable(organisationUnitLevels);
    }

    @JsonProperty("organisationUnitLevels")
    public void setOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
    }

    public ReportTable withOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public ReportTable withOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    public Optional<ParentGraphMap__4> getParentGraphMap() {
        return Optional.ofNullable(parentGraphMap);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    public void setParentGraphMap(ParentGraphMap__4 parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
    }

    public ReportTable withParentGraphMap(ParentGraphMap__4 parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
        return this;
    }

    @JsonProperty("periods")
    public Optional<List<Period>> getPeriods() {
        return Optional.ofNullable(periods);
    }

    @JsonProperty("periods")
    public void setPeriods(List<Period> periods) {
        this.periods = periods;
    }

    public ReportTable withPeriods(List<Period> periods) {
        this.periods = periods;
        return this;
    }

    @JsonProperty("programIndicatorDimensions")
    public Optional<List<TrackedEntityProgramIndicatorDimension>> getProgramIndicatorDimensions() {
        return Optional.ofNullable(programIndicatorDimensions);
    }

    @JsonProperty("programIndicatorDimensions")
    public void setProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
    }

    public ReportTable withProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ReportTable withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("regression")
    public Optional<Boolean> getRegression() {
        return Optional.ofNullable(regression);
    }

    @JsonProperty("regression")
    public void setRegression(Boolean regression) {
        this.regression = regression;
    }

    public ReportTable withRegression(Boolean regression) {
        this.regression = regression;
        return this;
    }

    @JsonProperty("relativePeriods")
    public Optional<RelativePeriods> getRelativePeriods() {
        return Optional.ofNullable(relativePeriods);
    }

    @JsonProperty("relativePeriods")
    public void setRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
    }

    public ReportTable withRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
        return this;
    }

    @JsonProperty("reportParams")
    public Optional<ReportParams> getReportParams() {
        return Optional.ofNullable(reportParams);
    }

    @JsonProperty("reportParams")
    public void setReportParams(ReportParams reportParams) {
        this.reportParams = reportParams;
    }

    public ReportTable withReportParams(ReportParams reportParams) {
        this.reportParams = reportParams;
        return this;
    }

    @JsonProperty("rowDimensions")
    public Optional<List<String>> getRowDimensions() {
        return Optional.ofNullable(rowDimensions);
    }

    @JsonProperty("rowDimensions")
    public void setRowDimensions(List<String> rowDimensions) {
        this.rowDimensions = rowDimensions;
    }

    public ReportTable withRowDimensions(List<String> rowDimensions) {
        this.rowDimensions = rowDimensions;
        return this;
    }

    @JsonProperty("rowSubTotals")
    public Optional<Boolean> getRowSubTotals() {
        return Optional.ofNullable(rowSubTotals);
    }

    @JsonProperty("rowSubTotals")
    public void setRowSubTotals(Boolean rowSubTotals) {
        this.rowSubTotals = rowSubTotals;
    }

    public ReportTable withRowSubTotals(Boolean rowSubTotals) {
        this.rowSubTotals = rowSubTotals;
        return this;
    }

    @JsonProperty("rowTotals")
    public Optional<Boolean> getRowTotals() {
        return Optional.ofNullable(rowTotals);
    }

    @JsonProperty("rowTotals")
    public void setRowTotals(Boolean rowTotals) {
        this.rowTotals = rowTotals;
    }

    public ReportTable withRowTotals(Boolean rowTotals) {
        this.rowTotals = rowTotals;
        return this;
    }

    @JsonProperty("rows")
    public Optional<List<Object>> getRows() {
        return Optional.ofNullable(rows);
    }

    @JsonProperty("rows")
    public void setRows(List<Object> rows) {
        this.rows = rows;
    }

    public ReportTable withRows(List<Object> rows) {
        this.rows = rows;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ReportTable withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public ReportTable withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("showDimensionLabels")
    public Optional<Boolean> getShowDimensionLabels() {
        return Optional.ofNullable(showDimensionLabels);
    }

    @JsonProperty("showDimensionLabels")
    public void setShowDimensionLabels(Boolean showDimensionLabels) {
        this.showDimensionLabels = showDimensionLabels;
    }

    public ReportTable withShowDimensionLabels(Boolean showDimensionLabels) {
        this.showDimensionLabels = showDimensionLabels;
        return this;
    }

    @JsonProperty("showHierarchy")
    public Optional<Boolean> getShowHierarchy() {
        return Optional.ofNullable(showHierarchy);
    }

    @JsonProperty("showHierarchy")
    public void setShowHierarchy(Boolean showHierarchy) {
        this.showHierarchy = showHierarchy;
    }

    public ReportTable withShowHierarchy(Boolean showHierarchy) {
        this.showHierarchy = showHierarchy;
        return this;
    }

    @JsonProperty("skipRounding")
    public Optional<Boolean> getSkipRounding() {
        return Optional.ofNullable(skipRounding);
    }

    @JsonProperty("skipRounding")
    public void setSkipRounding(Boolean skipRounding) {
        this.skipRounding = skipRounding;
    }

    public ReportTable withSkipRounding(Boolean skipRounding) {
        this.skipRounding = skipRounding;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ReportTable withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public ReportTable withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("subscribed")
    public Optional<Boolean> getSubscribed() {
        return Optional.ofNullable(subscribed);
    }

    @JsonProperty("subscribed")
    public void setSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
    }

    public ReportTable withSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
        return this;
    }

    @JsonProperty("subscribers")
    public Optional<List<String>> getSubscribers() {
        return Optional.ofNullable(subscribers);
    }

    @JsonProperty("subscribers")
    public void setSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
    }

    public ReportTable withSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
        return this;
    }

    @JsonProperty("subtitle")
    public Optional<String> getSubtitle() {
        return Optional.ofNullable(subtitle);
    }

    @JsonProperty("subtitle")
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public ReportTable withSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @JsonProperty("timeField")
    public Optional<String> getTimeField() {
        return Optional.ofNullable(timeField);
    }

    @JsonProperty("timeField")
    public void setTimeField(String timeField) {
        this.timeField = timeField;
    }

    public ReportTable withTimeField(String timeField) {
        this.timeField = timeField;
        return this;
    }

    @JsonProperty("title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    public ReportTable withTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty("topLimit")
    public Optional<Integer> getTopLimit() {
        return Optional.ofNullable(topLimit);
    }

    @JsonProperty("topLimit")
    public void setTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
    }

    public ReportTable withTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ReportTable withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ReportTable withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess__1>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess__1> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ReportTable withUserAccesses(List<UserAccess__1> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess__1>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess__1> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ReportTable withUserGroupAccesses(List<UserGroupAccess__1> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userOrgUnitType")
    public Optional<org.hisp.dhis.api.model.v2_36_11.Chart.UserOrgUnitType> getUserOrgUnitType() {
        return Optional.ofNullable(userOrgUnitType);
    }

    @JsonProperty("userOrgUnitType")
    public void setUserOrgUnitType(org.hisp.dhis.api.model.v2_36_11.Chart.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
    }

    public ReportTable withUserOrgUnitType(org.hisp.dhis.api.model.v2_36_11.Chart.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
        return this;
    }

    @JsonProperty("userOrganisationUnit")
    public Optional<Boolean> getUserOrganisationUnit() {
        return Optional.ofNullable(userOrganisationUnit);
    }

    @JsonProperty("userOrganisationUnit")
    public void setUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
    }

    public ReportTable withUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
        return this;
    }

    @JsonProperty("userOrganisationUnitChildren")
    public Optional<Boolean> getUserOrganisationUnitChildren() {
        return Optional.ofNullable(userOrganisationUnitChildren);
    }

    @JsonProperty("userOrganisationUnitChildren")
    public void setUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
    }

    public ReportTable withUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        return this;
    }

    @JsonProperty("userOrganisationUnitGrandChildren")
    public Optional<Boolean> getUserOrganisationUnitGrandChildren() {
        return Optional.ofNullable(userOrganisationUnitGrandChildren);
    }

    @JsonProperty("userOrganisationUnitGrandChildren")
    public void setUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
    }

    public ReportTable withUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ReportTable withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_36_11.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregationType":
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_36_11.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeDimensions":
                if (value instanceof List) {
                    setAttributeDimensions(((List<TrackedEntityAttributeDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.TrackedEntityAttributeDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryDimensions":
                if (value instanceof List) {
                    setCategoryDimensions(((List<CategoryDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.CategoryDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "categoryOptionGroupSetDimensions":
                if (value instanceof List) {
                    setCategoryOptionGroupSetDimensions(((List<CategoryOptionGroupSetDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.CategoryOptionGroupSetDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "colSubTotals":
                if (value instanceof Boolean) {
                    setColSubTotals(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"colSubTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "colTotals":
                if (value instanceof Boolean) {
                    setColTotals(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"colTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "columnDimensions":
                if (value instanceof List) {
                    setColumnDimensions(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"columnDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "columns":
                if (value instanceof List) {
                    setColumns(((List<Object> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"columns\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completedOnly":
                if (value instanceof Boolean) {
                    setCompletedOnly(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof User) {
                    setCreatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_36_11.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "cumulative":
                if (value instanceof Boolean) {
                    setCumulative(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"cumulative\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataDimensionItems":
                if (value instanceof List) {
                    setDataDimensionItems(((List<DataDimensionItem> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataDimensionItems\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.DataDimensionItem>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementDimensions":
                if (value instanceof List) {
                    setDataElementDimensions(((List<TrackedEntityDataElementDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.TrackedEntityDataElementDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementGroupSetDimensions":
                if (value instanceof List) {
                    setDataElementGroupSetDimensions(((List<DataElementGroupSetDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.DataElementGroupSetDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "digitGroupSeparator":
                if (value instanceof org.hisp.dhis.api.model.v2_36_11.Chart.DigitGroupSeparator) {
                    setDigitGroupSeparator(((org.hisp.dhis.api.model.v2_36_11.Chart.DigitGroupSeparator) value));
                } else {
                    throw new IllegalArgumentException(("property \"digitGroupSeparator\" is of type \"org.hisp.dhis.api.model.v2_36_11.Chart.DigitGroupSeparator\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDensity":
                if (value instanceof org.hisp.dhis.api.model.v2_36_11.DataEntryForm.DisplayDensity) {
                    setDisplayDensity(((org.hisp.dhis.api.model.v2_36_11.DataEntryForm.DisplayDensity) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDensity\" is of type \"org.hisp.dhis.api.model.v2_36_11.DataEntryForm.DisplayDensity\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displaySubtitle":
                if (value instanceof String) {
                    setDisplaySubtitle(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displaySubtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayTitle":
                if (value instanceof String) {
                    setDisplayTitle(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayTitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "endDate":
                if (value instanceof Date) {
                    setEndDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "filterDimensions":
                if (value instanceof List) {
                    setFilterDimensions(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"filterDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "filters":
                if (value instanceof List) {
                    setFilters(((List<Object> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"filters\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "fontSize":
                if (value instanceof org.hisp.dhis.api.model.v2_36_11.EventReport.FontSize) {
                    setFontSize(((org.hisp.dhis.api.model.v2_36_11.EventReport.FontSize) value));
                } else {
                    throw new IllegalArgumentException(("property \"fontSize\" is of type \"org.hisp.dhis.api.model.v2_36_11.EventReport.FontSize\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideEmptyColumns":
                if (value instanceof Boolean) {
                    setHideEmptyColumns(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideEmptyColumns\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideEmptyRows":
                if (value instanceof Boolean) {
                    setHideEmptyRows(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideEmptyRows\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideSubtitle":
                if (value instanceof Boolean) {
                    setHideSubtitle(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideSubtitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideTitle":
                if (value instanceof Boolean) {
                    setHideTitle(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideTitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "interpretations":
                if (value instanceof List) {
                    setInterpretations(((List<Interpretation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"interpretations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Interpretation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "itemOrganisationUnitGroups":
                if (value instanceof List) {
                    setItemOrganisationUnitGroups(((List<OrganisationUnitGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"itemOrganisationUnitGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.OrganisationUnitGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_36_11.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendDisplayStrategy":
                if (value instanceof org.hisp.dhis.api.model.v2_36_11.Chart.LegendDisplayStrategy) {
                    setLegendDisplayStrategy(((org.hisp.dhis.api.model.v2_36_11.Chart.LegendDisplayStrategy) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendDisplayStrategy\" is of type \"org.hisp.dhis.api.model.v2_36_11.Chart.LegendDisplayStrategy\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendDisplayStyle":
                if (value instanceof ReportTable.LegendDisplayStyle) {
                    setLegendDisplayStyle(((ReportTable.LegendDisplayStyle) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendDisplayStyle\" is of type \"org.hisp.dhis.api.model.v2_36_11.ReportTable.LegendDisplayStyle\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof LegendSet) {
                    setLegendSet(((LegendSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_36_11.LegendSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "measureCriteria":
                if (value instanceof String) {
                    setMeasureCriteria(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"measureCriteria\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "numberType":
                if (value instanceof ReportTable.NumberType) {
                    setNumberType(((ReportTable.NumberType) value));
                } else {
                    throw new IllegalArgumentException(("property \"numberType\" is of type \"org.hisp.dhis.api.model.v2_36_11.ReportTable.NumberType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnitField":
                if (value instanceof String) {
                    setOrgUnitField(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnitField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitGroupSetDimensions":
                if (value instanceof List) {
                    setOrganisationUnitGroupSetDimensions(((List<OrganisationUnitGroupSetDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.OrganisationUnitGroupSetDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitLevels":
                if (value instanceof List) {
                    setOrganisationUnitLevels(((List<Integer> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitLevels\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnits":
                if (value instanceof List) {
                    setOrganisationUnits(((List<OrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.OrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "parentGraphMap":
                if (value instanceof ParentGraphMap__4) {
                    setParentGraphMap(((ParentGraphMap__4) value));
                } else {
                    throw new IllegalArgumentException(("property \"parentGraphMap\" is of type \"org.hisp.dhis.api.model.v2_36_11.ParentGraphMap__4\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periods":
                if (value instanceof List) {
                    setPeriods(((List<Period> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"periods\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Period>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programIndicatorDimensions":
                if (value instanceof List) {
                    setProgramIndicatorDimensions(((List<TrackedEntityProgramIndicatorDimension> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programIndicatorDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.TrackedEntityProgramIndicatorDimension>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "regression":
                if (value instanceof Boolean) {
                    setRegression(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"regression\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relativePeriods":
                if (value instanceof RelativePeriods) {
                    setRelativePeriods(((RelativePeriods) value));
                } else {
                    throw new IllegalArgumentException(("property \"relativePeriods\" is of type \"org.hisp.dhis.api.model.v2_36_11.RelativePeriods\", but got "+ value.getClass().toString()));
                }
                return true;
            case "reportParams":
                if (value instanceof ReportParams) {
                    setReportParams(((ReportParams) value));
                } else {
                    throw new IllegalArgumentException(("property \"reportParams\" is of type \"org.hisp.dhis.api.model.v2_36_11.ReportParams\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rowDimensions":
                if (value instanceof List) {
                    setRowDimensions(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"rowDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rowSubTotals":
                if (value instanceof Boolean) {
                    setRowSubTotals(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"rowSubTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rowTotals":
                if (value instanceof Boolean) {
                    setRowTotals(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"rowTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rows":
                if (value instanceof List) {
                    setRows(((List<Object> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"rows\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sharing":
                if (value instanceof Sharing) {
                    setSharing(((Sharing) value));
                } else {
                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_36_11.Sharing\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "showDimensionLabels":
                if (value instanceof Boolean) {
                    setShowDimensionLabels(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"showDimensionLabels\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "showHierarchy":
                if (value instanceof Boolean) {
                    setShowHierarchy(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"showHierarchy\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipRounding":
                if (value instanceof Boolean) {
                    setSkipRounding(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipRounding\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sortOrder":
                if (value instanceof Integer) {
                    setSortOrder(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "startDate":
                if (value instanceof Date) {
                    setStartDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subscribed":
                if (value instanceof Boolean) {
                    setSubscribed(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"subscribed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subscribers":
                if (value instanceof List) {
                    setSubscribers(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"subscribers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subtitle":
                if (value instanceof String) {
                    setSubtitle(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"subtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "timeField":
                if (value instanceof String) {
                    setTimeField(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"timeField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "title":
                if (value instanceof String) {
                    setTitle(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"title\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "topLimit":
                if (value instanceof Integer) {
                    setTopLimit(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"topLimit\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_36_11.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess__1> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.UserAccess__1>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess__1> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.UserGroupAccess__1>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userOrgUnitType":
                if (value instanceof org.hisp.dhis.api.model.v2_36_11.Chart.UserOrgUnitType) {
                    setUserOrgUnitType(((org.hisp.dhis.api.model.v2_36_11.Chart.UserOrgUnitType) value));
                } else {
                    throw new IllegalArgumentException(("property \"userOrgUnitType\" is of type \"org.hisp.dhis.api.model.v2_36_11.Chart.UserOrgUnitType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userOrganisationUnit":
                if (value instanceof Boolean) {
                    setUserOrganisationUnit(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"userOrganisationUnit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userOrganisationUnitChildren":
                if (value instanceof Boolean) {
                    setUserOrganisationUnitChildren(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"userOrganisationUnitChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userOrganisationUnitGrandChildren":
                if (value instanceof Boolean) {
                    setUserOrganisationUnitGrandChildren(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"userOrganisationUnitGrandChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "aggregationType":
                return getAggregationType();
            case "attributeDimensions":
                return getAttributeDimensions();
            case "attributeValues":
                return getAttributeValues();
            case "categoryDimensions":
                return getCategoryDimensions();
            case "categoryOptionGroupSetDimensions":
                return getCategoryOptionGroupSetDimensions();
            case "code":
                return getCode();
            case "colSubTotals":
                return getColSubTotals();
            case "colTotals":
                return getColTotals();
            case "columnDimensions":
                return getColumnDimensions();
            case "columns":
                return getColumns();
            case "completedOnly":
                return getCompletedOnly();
            case "created":
                return getCreated();
            case "createdBy":
                return getCreatedBy();
            case "cumulative":
                return getCumulative();
            case "dataDimensionItems":
                return getDataDimensionItems();
            case "dataElementDimensions":
                return getDataElementDimensions();
            case "dataElementGroupSetDimensions":
                return getDataElementGroupSetDimensions();
            case "description":
                return getDescription();
            case "digitGroupSeparator":
                return getDigitGroupSeparator();
            case "displayDensity":
                return getDisplayDensity();
            case "displayDescription":
                return getDisplayDescription();
            case "displayFormName":
                return getDisplayFormName();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "displaySubtitle":
                return getDisplaySubtitle();
            case "displayTitle":
                return getDisplayTitle();
            case "endDate":
                return getEndDate();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "filterDimensions":
                return getFilterDimensions();
            case "filters":
                return getFilters();
            case "fontSize":
                return getFontSize();
            case "formName":
                return getFormName();
            case "hideEmptyColumns":
                return getHideEmptyColumns();
            case "hideEmptyRows":
                return getHideEmptyRows();
            case "hideSubtitle":
                return getHideSubtitle();
            case "hideTitle":
                return getHideTitle();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "interpretations":
                return getInterpretations();
            case "itemOrganisationUnitGroups":
                return getItemOrganisationUnitGroups();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "legendDisplayStrategy":
                return getLegendDisplayStrategy();
            case "legendDisplayStyle":
                return getLegendDisplayStyle();
            case "legendSet":
                return getLegendSet();
            case "measureCriteria":
                return getMeasureCriteria();
            case "name":
                return getName();
            case "numberType":
                return getNumberType();
            case "orgUnitField":
                return getOrgUnitField();
            case "organisationUnitGroupSetDimensions":
                return getOrganisationUnitGroupSetDimensions();
            case "organisationUnitLevels":
                return getOrganisationUnitLevels();
            case "organisationUnits":
                return getOrganisationUnits();
            case "parentGraphMap":
                return getParentGraphMap();
            case "periods":
                return getPeriods();
            case "programIndicatorDimensions":
                return getProgramIndicatorDimensions();
            case "publicAccess":
                return getPublicAccess();
            case "regression":
                return getRegression();
            case "relativePeriods":
                return getRelativePeriods();
            case "reportParams":
                return getReportParams();
            case "rowDimensions":
                return getRowDimensions();
            case "rowSubTotals":
                return getRowSubTotals();
            case "rowTotals":
                return getRowTotals();
            case "rows":
                return getRows();
            case "sharing":
                return getSharing();
            case "shortName":
                return getShortName();
            case "showDimensionLabels":
                return getShowDimensionLabels();
            case "showHierarchy":
                return getShowHierarchy();
            case "skipRounding":
                return getSkipRounding();
            case "sortOrder":
                return getSortOrder();
            case "startDate":
                return getStartDate();
            case "subscribed":
                return getSubscribed();
            case "subscribers":
                return getSubscribers();
            case "subtitle":
                return getSubtitle();
            case "timeField":
                return getTimeField();
            case "title":
                return getTitle();
            case "topLimit":
                return getTopLimit();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "userOrgUnitType":
                return getUserOrgUnitType();
            case "userOrganisationUnit":
                return getUserOrganisationUnit();
            case "userOrganisationUnitChildren":
                return getUserOrganisationUnitChildren();
            case "userOrganisationUnitGrandChildren":
                return getUserOrganisationUnitGrandChildren();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ReportTable.NOT_FOUND_VALUE);
        if (ReportTable.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ReportTable with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ReportTable.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeDimensions");
        sb.append('=');
        sb.append(((this.attributeDimensions == null)?"<null>":this.attributeDimensions));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categoryDimensions");
        sb.append('=');
        sb.append(((this.categoryDimensions == null)?"<null>":this.categoryDimensions));
        sb.append(',');
        sb.append("categoryOptionGroupSetDimensions");
        sb.append('=');
        sb.append(((this.categoryOptionGroupSetDimensions == null)?"<null>":this.categoryOptionGroupSetDimensions));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("colSubTotals");
        sb.append('=');
        sb.append(((this.colSubTotals == null)?"<null>":this.colSubTotals));
        sb.append(',');
        sb.append("colTotals");
        sb.append('=');
        sb.append(((this.colTotals == null)?"<null>":this.colTotals));
        sb.append(',');
        sb.append("columnDimensions");
        sb.append('=');
        sb.append(((this.columnDimensions == null)?"<null>":this.columnDimensions));
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(((this.columns == null)?"<null>":this.columns));
        sb.append(',');
        sb.append("completedOnly");
        sb.append('=');
        sb.append(((this.completedOnly == null)?"<null>":this.completedOnly));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("cumulative");
        sb.append('=');
        sb.append(((this.cumulative == null)?"<null>":this.cumulative));
        sb.append(',');
        sb.append("dataDimensionItems");
        sb.append('=');
        sb.append(((this.dataDimensionItems == null)?"<null>":this.dataDimensionItems));
        sb.append(',');
        sb.append("dataElementDimensions");
        sb.append('=');
        sb.append(((this.dataElementDimensions == null)?"<null>":this.dataElementDimensions));
        sb.append(',');
        sb.append("dataElementGroupSetDimensions");
        sb.append('=');
        sb.append(((this.dataElementGroupSetDimensions == null)?"<null>":this.dataElementGroupSetDimensions));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("digitGroupSeparator");
        sb.append('=');
        sb.append(((this.digitGroupSeparator == null)?"<null>":this.digitGroupSeparator));
        sb.append(',');
        sb.append("displayDensity");
        sb.append('=');
        sb.append(((this.displayDensity == null)?"<null>":this.displayDensity));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("displaySubtitle");
        sb.append('=');
        sb.append(((this.displaySubtitle == null)?"<null>":this.displaySubtitle));
        sb.append(',');
        sb.append("displayTitle");
        sb.append('=');
        sb.append(((this.displayTitle == null)?"<null>":this.displayTitle));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("filterDimensions");
        sb.append('=');
        sb.append(((this.filterDimensions == null)?"<null>":this.filterDimensions));
        sb.append(',');
        sb.append("filters");
        sb.append('=');
        sb.append(((this.filters == null)?"<null>":this.filters));
        sb.append(',');
        sb.append("fontSize");
        sb.append('=');
        sb.append(((this.fontSize == null)?"<null>":this.fontSize));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("hideEmptyColumns");
        sb.append('=');
        sb.append(((this.hideEmptyColumns == null)?"<null>":this.hideEmptyColumns));
        sb.append(',');
        sb.append("hideEmptyRows");
        sb.append('=');
        sb.append(((this.hideEmptyRows == null)?"<null>":this.hideEmptyRows));
        sb.append(',');
        sb.append("hideSubtitle");
        sb.append('=');
        sb.append(((this.hideSubtitle == null)?"<null>":this.hideSubtitle));
        sb.append(',');
        sb.append("hideTitle");
        sb.append('=');
        sb.append(((this.hideTitle == null)?"<null>":this.hideTitle));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("interpretations");
        sb.append('=');
        sb.append(((this.interpretations == null)?"<null>":this.interpretations));
        sb.append(',');
        sb.append("itemOrganisationUnitGroups");
        sb.append('=');
        sb.append(((this.itemOrganisationUnitGroups == null)?"<null>":this.itemOrganisationUnitGroups));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendDisplayStrategy");
        sb.append('=');
        sb.append(((this.legendDisplayStrategy == null)?"<null>":this.legendDisplayStrategy));
        sb.append(',');
        sb.append("legendDisplayStyle");
        sb.append('=');
        sb.append(((this.legendDisplayStyle == null)?"<null>":this.legendDisplayStyle));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("measureCriteria");
        sb.append('=');
        sb.append(((this.measureCriteria == null)?"<null>":this.measureCriteria));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("numberType");
        sb.append('=');
        sb.append(((this.numberType == null)?"<null>":this.numberType));
        sb.append(',');
        sb.append("orgUnitField");
        sb.append('=');
        sb.append(((this.orgUnitField == null)?"<null>":this.orgUnitField));
        sb.append(',');
        sb.append("organisationUnitGroupSetDimensions");
        sb.append('=');
        sb.append(((this.organisationUnitGroupSetDimensions == null)?"<null>":this.organisationUnitGroupSetDimensions));
        sb.append(',');
        sb.append("organisationUnitLevels");
        sb.append('=');
        sb.append(((this.organisationUnitLevels == null)?"<null>":this.organisationUnitLevels));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("parentGraphMap");
        sb.append('=');
        sb.append(((this.parentGraphMap == null)?"<null>":this.parentGraphMap));
        sb.append(',');
        sb.append("periods");
        sb.append('=');
        sb.append(((this.periods == null)?"<null>":this.periods));
        sb.append(',');
        sb.append("programIndicatorDimensions");
        sb.append('=');
        sb.append(((this.programIndicatorDimensions == null)?"<null>":this.programIndicatorDimensions));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("regression");
        sb.append('=');
        sb.append(((this.regression == null)?"<null>":this.regression));
        sb.append(',');
        sb.append("relativePeriods");
        sb.append('=');
        sb.append(((this.relativePeriods == null)?"<null>":this.relativePeriods));
        sb.append(',');
        sb.append("reportParams");
        sb.append('=');
        sb.append(((this.reportParams == null)?"<null>":this.reportParams));
        sb.append(',');
        sb.append("rowDimensions");
        sb.append('=');
        sb.append(((this.rowDimensions == null)?"<null>":this.rowDimensions));
        sb.append(',');
        sb.append("rowSubTotals");
        sb.append('=');
        sb.append(((this.rowSubTotals == null)?"<null>":this.rowSubTotals));
        sb.append(',');
        sb.append("rowTotals");
        sb.append('=');
        sb.append(((this.rowTotals == null)?"<null>":this.rowTotals));
        sb.append(',');
        sb.append("rows");
        sb.append('=');
        sb.append(((this.rows == null)?"<null>":this.rows));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("showDimensionLabels");
        sb.append('=');
        sb.append(((this.showDimensionLabels == null)?"<null>":this.showDimensionLabels));
        sb.append(',');
        sb.append("showHierarchy");
        sb.append('=');
        sb.append(((this.showHierarchy == null)?"<null>":this.showHierarchy));
        sb.append(',');
        sb.append("skipRounding");
        sb.append('=');
        sb.append(((this.skipRounding == null)?"<null>":this.skipRounding));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("subscribed");
        sb.append('=');
        sb.append(((this.subscribed == null)?"<null>":this.subscribed));
        sb.append(',');
        sb.append("subscribers");
        sb.append('=');
        sb.append(((this.subscribers == null)?"<null>":this.subscribers));
        sb.append(',');
        sb.append("subtitle");
        sb.append('=');
        sb.append(((this.subtitle == null)?"<null>":this.subtitle));
        sb.append(',');
        sb.append("timeField");
        sb.append('=');
        sb.append(((this.timeField == null)?"<null>":this.timeField));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("topLimit");
        sb.append('=');
        sb.append(((this.topLimit == null)?"<null>":this.topLimit));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userOrgUnitType");
        sb.append('=');
        sb.append(((this.userOrgUnitType == null)?"<null>":this.userOrgUnitType));
        sb.append(',');
        sb.append("userOrganisationUnit");
        sb.append('=');
        sb.append(((this.userOrganisationUnit == null)?"<null>":this.userOrganisationUnit));
        sb.append(',');
        sb.append("userOrganisationUnitChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitChildren == null)?"<null>":this.userOrganisationUnitChildren));
        sb.append(',');
        sb.append("userOrganisationUnitGrandChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitGrandChildren == null)?"<null>":this.userOrganisationUnitGrandChildren));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElementGroupSetDimensions == null)? 0 :this.dataElementGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.numberType == null)? 0 :this.numberType.hashCode()));
        result = ((result* 31)+((this.orgUnitField == null)? 0 :this.orgUnitField.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitChildren == null)? 0 :this.userOrganisationUnitChildren.hashCode()));
        result = ((result* 31)+((this.displaySubtitle == null)? 0 :this.displaySubtitle.hashCode()));
        result = ((result* 31)+((this.legendDisplayStyle == null)? 0 :this.legendDisplayStyle.hashCode()));
        result = ((result* 31)+((this.hideEmptyColumns == null)? 0 :this.hideEmptyColumns.hashCode()));
        result = ((result* 31)+((this.measureCriteria == null)? 0 :this.measureCriteria.hashCode()));
        result = ((result* 31)+((this.displayTitle == null)? 0 :this.displayTitle.hashCode()));
        result = ((result* 31)+((this.hideEmptyRows == null)? 0 :this.hideEmptyRows.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.subscribed == null)? 0 :this.subscribed.hashCode()));
        result = ((result* 31)+((this.attributeDimensions == null)? 0 :this.attributeDimensions.hashCode()));
        result = ((result* 31)+((this.reportParams == null)? 0 :this.reportParams.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.parentGraphMap == null)? 0 :this.parentGraphMap.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnit == null)? 0 :this.userOrganisationUnit.hashCode()));
        result = ((result* 31)+((this.filterDimensions == null)? 0 :this.filterDimensions.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.rowSubTotals == null)? 0 :this.rowSubTotals.hashCode()));
        result = ((result* 31)+((this.interpretations == null)? 0 :this.interpretations.hashCode()));
        result = ((result* 31)+((this.itemOrganisationUnitGroups == null)? 0 :this.itemOrganisationUnitGroups.hashCode()));
        result = ((result* 31)+((this.displayDensity == null)? 0 :this.displayDensity.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programIndicatorDimensions == null)? 0 :this.programIndicatorDimensions.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.subscribers == null)? 0 :this.subscribers.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.columnDimensions == null)? 0 :this.columnDimensions.hashCode()));
        result = ((result* 31)+((this.completedOnly == null)? 0 :this.completedOnly.hashCode()));
        result = ((result* 31)+((this.colTotals == null)? 0 :this.colTotals.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.showDimensionLabels == null)? 0 :this.showDimensionLabels.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.subtitle == null)? 0 :this.subtitle.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.fontSize == null)? 0 :this.fontSize.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.topLimit == null)? 0 :this.topLimit.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.dataDimensionItems == null)? 0 :this.dataDimensionItems.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupSetDimensions == null)? 0 :this.categoryOptionGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitGrandChildren == null)? 0 :this.userOrganisationUnitGrandChildren.hashCode()));
        result = ((result* 31)+((this.columns == null)? 0 :this.columns.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.hideSubtitle == null)? 0 :this.hideSubtitle.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupSetDimensions == null)? 0 :this.organisationUnitGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.organisationUnitLevels == null)? 0 :this.organisationUnitLevels.hashCode()));
        result = ((result* 31)+((this.colSubTotals == null)? 0 :this.colSubTotals.hashCode()));
        result = ((result* 31)+((this.legendDisplayStrategy == null)? 0 :this.legendDisplayStrategy.hashCode()));
        result = ((result* 31)+((this.dataElementDimensions == null)? 0 :this.dataElementDimensions.hashCode()));
        result = ((result* 31)+((this.relativePeriods == null)? 0 :this.relativePeriods.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.periods == null)? 0 :this.periods.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.categoryDimensions == null)? 0 :this.categoryDimensions.hashCode()));
        result = ((result* 31)+((this.showHierarchy == null)? 0 :this.showHierarchy.hashCode()));
        result = ((result* 31)+((this.rowTotals == null)? 0 :this.rowTotals.hashCode()));
        result = ((result* 31)+((this.timeField == null)? 0 :this.timeField.hashCode()));
        result = ((result* 31)+((this.filters == null)? 0 :this.filters.hashCode()));
        result = ((result* 31)+((this.cumulative == null)? 0 :this.cumulative.hashCode()));
        result = ((result* 31)+((this.rows == null)? 0 :this.rows.hashCode()));
        result = ((result* 31)+((this.digitGroupSeparator == null)? 0 :this.digitGroupSeparator.hashCode()));
        result = ((result* 31)+((this.hideTitle == null)? 0 :this.hideTitle.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.rowDimensions == null)? 0 :this.rowDimensions.hashCode()));
        result = ((result* 31)+((this.regression == null)? 0 :this.regression.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.userOrgUnitType == null)? 0 :this.userOrgUnitType.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.skipRounding == null)? 0 :this.skipRounding.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ReportTable) == false) {
            return false;
        }
        ReportTable rhs = ((ReportTable) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.dataElementGroupSetDimensions == rhs.dataElementGroupSetDimensions)||((this.dataElementGroupSetDimensions!= null)&&this.dataElementGroupSetDimensions.equals(rhs.dataElementGroupSetDimensions)))&&((this.numberType == rhs.numberType)||((this.numberType!= null)&&this.numberType.equals(rhs.numberType))))&&((this.orgUnitField == rhs.orgUnitField)||((this.orgUnitField!= null)&&this.orgUnitField.equals(rhs.orgUnitField))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.userOrganisationUnitChildren == rhs.userOrganisationUnitChildren)||((this.userOrganisationUnitChildren!= null)&&this.userOrganisationUnitChildren.equals(rhs.userOrganisationUnitChildren))))&&((this.displaySubtitle == rhs.displaySubtitle)||((this.displaySubtitle!= null)&&this.displaySubtitle.equals(rhs.displaySubtitle))))&&((this.legendDisplayStyle == rhs.legendDisplayStyle)||((this.legendDisplayStyle!= null)&&this.legendDisplayStyle.equals(rhs.legendDisplayStyle))))&&((this.hideEmptyColumns == rhs.hideEmptyColumns)||((this.hideEmptyColumns!= null)&&this.hideEmptyColumns.equals(rhs.hideEmptyColumns))))&&((this.measureCriteria == rhs.measureCriteria)||((this.measureCriteria!= null)&&this.measureCriteria.equals(rhs.measureCriteria))))&&((this.displayTitle == rhs.displayTitle)||((this.displayTitle!= null)&&this.displayTitle.equals(rhs.displayTitle))))&&((this.hideEmptyRows == rhs.hideEmptyRows)||((this.hideEmptyRows!= null)&&this.hideEmptyRows.equals(rhs.hideEmptyRows))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.subscribed == rhs.subscribed)||((this.subscribed!= null)&&this.subscribed.equals(rhs.subscribed))))&&((this.attributeDimensions == rhs.attributeDimensions)||((this.attributeDimensions!= null)&&this.attributeDimensions.equals(rhs.attributeDimensions))))&&((this.reportParams == rhs.reportParams)||((this.reportParams!= null)&&this.reportParams.equals(rhs.reportParams))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.parentGraphMap == rhs.parentGraphMap)||((this.parentGraphMap!= null)&&this.parentGraphMap.equals(rhs.parentGraphMap))))&&((this.userOrganisationUnit == rhs.userOrganisationUnit)||((this.userOrganisationUnit!= null)&&this.userOrganisationUnit.equals(rhs.userOrganisationUnit))))&&((this.filterDimensions == rhs.filterDimensions)||((this.filterDimensions!= null)&&this.filterDimensions.equals(rhs.filterDimensions))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.rowSubTotals == rhs.rowSubTotals)||((this.rowSubTotals!= null)&&this.rowSubTotals.equals(rhs.rowSubTotals))))&&((this.interpretations == rhs.interpretations)||((this.interpretations!= null)&&this.interpretations.equals(rhs.interpretations))))&&((this.itemOrganisationUnitGroups == rhs.itemOrganisationUnitGroups)||((this.itemOrganisationUnitGroups!= null)&&this.itemOrganisationUnitGroups.equals(rhs.itemOrganisationUnitGroups))))&&((this.displayDensity == rhs.displayDensity)||((this.displayDensity!= null)&&this.displayDensity.equals(rhs.displayDensity))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programIndicatorDimensions == rhs.programIndicatorDimensions)||((this.programIndicatorDimensions!= null)&&this.programIndicatorDimensions.equals(rhs.programIndicatorDimensions))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.subscribers == rhs.subscribers)||((this.subscribers!= null)&&this.subscribers.equals(rhs.subscribers))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.columnDimensions == rhs.columnDimensions)||((this.columnDimensions!= null)&&this.columnDimensions.equals(rhs.columnDimensions))))&&((this.completedOnly == rhs.completedOnly)||((this.completedOnly!= null)&&this.completedOnly.equals(rhs.completedOnly))))&&((this.colTotals == rhs.colTotals)||((this.colTotals!= null)&&this.colTotals.equals(rhs.colTotals))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.showDimensionLabels == rhs.showDimensionLabels)||((this.showDimensionLabels!= null)&&this.showDimensionLabels.equals(rhs.showDimensionLabels))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.subtitle == rhs.subtitle)||((this.subtitle!= null)&&this.subtitle.equals(rhs.subtitle))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.fontSize == rhs.fontSize)||((this.fontSize!= null)&&this.fontSize.equals(rhs.fontSize))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.topLimit == rhs.topLimit)||((this.topLimit!= null)&&this.topLimit.equals(rhs.topLimit))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.dataDimensionItems == rhs.dataDimensionItems)||((this.dataDimensionItems!= null)&&this.dataDimensionItems.equals(rhs.dataDimensionItems))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.categoryOptionGroupSetDimensions == rhs.categoryOptionGroupSetDimensions)||((this.categoryOptionGroupSetDimensions!= null)&&this.categoryOptionGroupSetDimensions.equals(rhs.categoryOptionGroupSetDimensions))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.userOrganisationUnitGrandChildren == rhs.userOrganisationUnitGrandChildren)||((this.userOrganisationUnitGrandChildren!= null)&&this.userOrganisationUnitGrandChildren.equals(rhs.userOrganisationUnitGrandChildren))))&&((this.columns == rhs.columns)||((this.columns!= null)&&this.columns.equals(rhs.columns))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.hideSubtitle == rhs.hideSubtitle)||((this.hideSubtitle!= null)&&this.hideSubtitle.equals(rhs.hideSubtitle))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.organisationUnitGroupSetDimensions == rhs.organisationUnitGroupSetDimensions)||((this.organisationUnitGroupSetDimensions!= null)&&this.organisationUnitGroupSetDimensions.equals(rhs.organisationUnitGroupSetDimensions))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.organisationUnitLevels == rhs.organisationUnitLevels)||((this.organisationUnitLevels!= null)&&this.organisationUnitLevels.equals(rhs.organisationUnitLevels))))&&((this.colSubTotals == rhs.colSubTotals)||((this.colSubTotals!= null)&&this.colSubTotals.equals(rhs.colSubTotals))))&&((this.legendDisplayStrategy == rhs.legendDisplayStrategy)||((this.legendDisplayStrategy!= null)&&this.legendDisplayStrategy.equals(rhs.legendDisplayStrategy))))&&((this.dataElementDimensions == rhs.dataElementDimensions)||((this.dataElementDimensions!= null)&&this.dataElementDimensions.equals(rhs.dataElementDimensions))))&&((this.relativePeriods == rhs.relativePeriods)||((this.relativePeriods!= null)&&this.relativePeriods.equals(rhs.relativePeriods))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.periods == rhs.periods)||((this.periods!= null)&&this.periods.equals(rhs.periods))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.categoryDimensions == rhs.categoryDimensions)||((this.categoryDimensions!= null)&&this.categoryDimensions.equals(rhs.categoryDimensions))))&&((this.showHierarchy == rhs.showHierarchy)||((this.showHierarchy!= null)&&this.showHierarchy.equals(rhs.showHierarchy))))&&((this.rowTotals == rhs.rowTotals)||((this.rowTotals!= null)&&this.rowTotals.equals(rhs.rowTotals))))&&((this.timeField == rhs.timeField)||((this.timeField!= null)&&this.timeField.equals(rhs.timeField))))&&((this.filters == rhs.filters)||((this.filters!= null)&&this.filters.equals(rhs.filters))))&&((this.cumulative == rhs.cumulative)||((this.cumulative!= null)&&this.cumulative.equals(rhs.cumulative))))&&((this.rows == rhs.rows)||((this.rows!= null)&&this.rows.equals(rhs.rows))))&&((this.digitGroupSeparator == rhs.digitGroupSeparator)||((this.digitGroupSeparator!= null)&&this.digitGroupSeparator.equals(rhs.digitGroupSeparator))))&&((this.hideTitle == rhs.hideTitle)||((this.hideTitle!= null)&&this.hideTitle.equals(rhs.hideTitle))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.rowDimensions == rhs.rowDimensions)||((this.rowDimensions!= null)&&this.rowDimensions.equals(rhs.rowDimensions))))&&((this.regression == rhs.regression)||((this.regression!= null)&&this.regression.equals(rhs.regression))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.userOrgUnitType == rhs.userOrgUnitType)||((this.userOrgUnitType!= null)&&this.userOrgUnitType.equals(rhs.userOrgUnitType))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.skipRounding == rhs.skipRounding)||((this.skipRounding!= null)&&this.skipRounding.equals(rhs.skipRounding))));
    }

    @Generated("jsonschema2pojo")
    public enum LegendDisplayStyle {

        FILL("FILL"),
        TEXT("TEXT");
        private final String value;
        private final static Map<String, ReportTable.LegendDisplayStyle> CONSTANTS = new HashMap<String, ReportTable.LegendDisplayStyle>();

        static {
            for (ReportTable.LegendDisplayStyle c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        LegendDisplayStyle(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ReportTable.LegendDisplayStyle fromValue(String value) {
            ReportTable.LegendDisplayStyle constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum NumberType {

        VALUE("VALUE"),
        ROW_PERCENTAGE("ROW_PERCENTAGE"),
        COLUMN_PERCENTAGE("COLUMN_PERCENTAGE");
        private final String value;
        private final static Map<String, ReportTable.NumberType> CONSTANTS = new HashMap<String, ReportTable.NumberType>();

        static {
            for (ReportTable.NumberType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NumberType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ReportTable.NumberType fromValue(String value) {
            ReportTable.NumberType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
