
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "embedded",
    "host",
    "mode",
    "port",
    "sendAsync"
})
@Generated("jsonschema2pojo")
public class ArtemisConfigData implements Serializable
{

    @JsonProperty("embedded")
    private ArtemisEmbeddedConfig embedded;
    @JsonProperty("host")
    private String host;
    @JsonProperty("mode")
    private ArtemisConfigData.ArtemisMode mode;
    @JsonProperty("port")
    private Integer port;
    @JsonProperty("sendAsync")
    private Boolean sendAsync;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7686128537142265469L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ArtemisConfigData() {
    }

    /**
     * 
     * @param source
     */
    public ArtemisConfigData(ArtemisConfigData source) {
        super();
        this.embedded = source.embedded;
        this.host = source.host;
        this.mode = source.mode;
        this.port = source.port;
        this.sendAsync = source.sendAsync;
    }

    /**
     * 
     * @param mode
     * @param sendAsync
     * @param port
     * @param host
     * @param embedded
     */
    public ArtemisConfigData(ArtemisEmbeddedConfig embedded, String host, ArtemisConfigData.ArtemisMode mode, Integer port, Boolean sendAsync) {
        super();
        this.embedded = embedded;
        this.host = host;
        this.mode = mode;
        this.port = port;
        this.sendAsync = sendAsync;
    }

    @JsonProperty("embedded")
    public Optional<ArtemisEmbeddedConfig> getEmbedded() {
        return Optional.ofNullable(embedded);
    }

    @JsonProperty("embedded")
    public void setEmbedded(ArtemisEmbeddedConfig embedded) {
        this.embedded = embedded;
    }

    public ArtemisConfigData withEmbedded(ArtemisEmbeddedConfig embedded) {
        this.embedded = embedded;
        return this;
    }

    @JsonProperty("host")
    public Optional<String> getHost() {
        return Optional.ofNullable(host);
    }

    @JsonProperty("host")
    public void setHost(String host) {
        this.host = host;
    }

    public ArtemisConfigData withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty("mode")
    public Optional<ArtemisConfigData.ArtemisMode> getMode() {
        return Optional.ofNullable(mode);
    }

    @JsonProperty("mode")
    public void setMode(ArtemisConfigData.ArtemisMode mode) {
        this.mode = mode;
    }

    public ArtemisConfigData withMode(ArtemisConfigData.ArtemisMode mode) {
        this.mode = mode;
        return this;
    }

    @JsonProperty("port")
    public Optional<Integer> getPort() {
        return Optional.ofNullable(port);
    }

    @JsonProperty("port")
    public void setPort(Integer port) {
        this.port = port;
    }

    public ArtemisConfigData withPort(Integer port) {
        this.port = port;
        return this;
    }

    @JsonProperty("sendAsync")
    public Optional<Boolean> getSendAsync() {
        return Optional.ofNullable(sendAsync);
    }

    @JsonProperty("sendAsync")
    public void setSendAsync(Boolean sendAsync) {
        this.sendAsync = sendAsync;
    }

    public ArtemisConfigData withSendAsync(Boolean sendAsync) {
        this.sendAsync = sendAsync;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ArtemisConfigData withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "embedded":
                if (value instanceof ArtemisEmbeddedConfig) {
                    setEmbedded(((ArtemisEmbeddedConfig) value));
                } else {
                    throw new IllegalArgumentException(("property \"embedded\" is of type \"org.hisp.dhis.api.model.v2_36_11.ArtemisEmbeddedConfig\", but got "+ value.getClass().toString()));
                }
                return true;
            case "host":
                if (value instanceof String) {
                    setHost(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"host\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mode":
                if (value instanceof ArtemisConfigData.ArtemisMode) {
                    setMode(((ArtemisConfigData.ArtemisMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"mode\" is of type \"org.hisp.dhis.api.model.v2_36_11.ArtemisConfigData.ArtemisMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "port":
                if (value instanceof Integer) {
                    setPort(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"port\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sendAsync":
                if (value instanceof Boolean) {
                    setSendAsync(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"sendAsync\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "embedded":
                return getEmbedded();
            case "host":
                return getHost();
            case "mode":
                return getMode();
            case "port":
                return getPort();
            case "sendAsync":
                return getSendAsync();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ArtemisConfigData.NOT_FOUND_VALUE);
        if (ArtemisConfigData.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ArtemisConfigData with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ArtemisConfigData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("embedded");
        sb.append('=');
        sb.append(((this.embedded == null)?"<null>":this.embedded));
        sb.append(',');
        sb.append("host");
        sb.append('=');
        sb.append(((this.host == null)?"<null>":this.host));
        sb.append(',');
        sb.append("mode");
        sb.append('=');
        sb.append(((this.mode == null)?"<null>":this.mode));
        sb.append(',');
        sb.append("port");
        sb.append('=');
        sb.append(((this.port == null)?"<null>":this.port));
        sb.append(',');
        sb.append("sendAsync");
        sb.append('=');
        sb.append(((this.sendAsync == null)?"<null>":this.sendAsync));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.mode == null)? 0 :this.mode.hashCode()));
        result = ((result* 31)+((this.sendAsync == null)? 0 :this.sendAsync.hashCode()));
        result = ((result* 31)+((this.port == null)? 0 :this.port.hashCode()));
        result = ((result* 31)+((this.host == null)? 0 :this.host.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.embedded == null)? 0 :this.embedded.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ArtemisConfigData) == false) {
            return false;
        }
        ArtemisConfigData rhs = ((ArtemisConfigData) other);
        return (((((((this.mode == rhs.mode)||((this.mode!= null)&&this.mode.equals(rhs.mode)))&&((this.sendAsync == rhs.sendAsync)||((this.sendAsync!= null)&&this.sendAsync.equals(rhs.sendAsync))))&&((this.port == rhs.port)||((this.port!= null)&&this.port.equals(rhs.port))))&&((this.host == rhs.host)||((this.host!= null)&&this.host.equals(rhs.host))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.embedded == rhs.embedded)||((this.embedded!= null)&&this.embedded.equals(rhs.embedded))));
    }

    @Generated("jsonschema2pojo")
    public enum ArtemisMode {

        EMBEDDED("EMBEDDED"),
        NATIVE("NATIVE");
        private final String value;
        private final static Map<String, ArtemisConfigData.ArtemisMode> CONSTANTS = new HashMap<String, ArtemisConfigData.ArtemisMode>();

        static {
            for (ArtemisConfigData.ArtemisMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ArtemisMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ArtemisConfigData.ArtemisMode fromValue(String value) {
            ArtemisConfigData.ArtemisMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
