
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "activeUsers",
    "averageChartViews",
    "averageDashboardViews",
    "averageEventChartViews",
    "averageEventReportViews",
    "averageMapViews",
    "averagePassiveDashboardViews",
    "averagePivotTableViews",
    "averageViews",
    "averageVisualizationViews",
    "chartViews",
    "dashboardViews",
    "dataSetReportViews",
    "day",
    "eventChartViews",
    "eventReportViews",
    "mapViews",
    "month",
    "passiveDashboardViews",
    "pivotTableViews",
    "savedCharts",
    "savedDashboards",
    "savedDataValues",
    "savedEventCharts",
    "savedEventReports",
    "savedIndicators",
    "savedMaps",
    "savedPivotTables",
    "savedVisualizations",
    "totalViews",
    "users",
    "visualizationViews",
    "week",
    "year"
})
@Generated("jsonschema2pojo")
public class AggregatedStatistics implements Serializable
{

    @JsonProperty("activeUsers")
    private Integer activeUsers;
    @JsonProperty("averageChartViews")
    private Integer averageChartViews;
    @JsonProperty("averageDashboardViews")
    private Integer averageDashboardViews;
    @JsonProperty("averageEventChartViews")
    private Integer averageEventChartViews;
    @JsonProperty("averageEventReportViews")
    private Integer averageEventReportViews;
    @JsonProperty("averageMapViews")
    private Integer averageMapViews;
    @JsonProperty("averagePassiveDashboardViews")
    private Integer averagePassiveDashboardViews;
    @JsonProperty("averagePivotTableViews")
    private Integer averagePivotTableViews;
    @JsonProperty("averageViews")
    private Integer averageViews;
    @JsonProperty("averageVisualizationViews")
    private Integer averageVisualizationViews;
    @JsonProperty("chartViews")
    private Integer chartViews;
    @JsonProperty("dashboardViews")
    private Integer dashboardViews;
    @JsonProperty("dataSetReportViews")
    private Integer dataSetReportViews;
    @JsonProperty("day")
    private Integer day;
    @JsonProperty("eventChartViews")
    private Integer eventChartViews;
    @JsonProperty("eventReportViews")
    private Integer eventReportViews;
    @JsonProperty("mapViews")
    private Integer mapViews;
    @JsonProperty("month")
    private Integer month;
    @JsonProperty("passiveDashboardViews")
    private Integer passiveDashboardViews;
    @JsonProperty("pivotTableViews")
    private Integer pivotTableViews;
    @JsonProperty("savedCharts")
    private Integer savedCharts;
    @JsonProperty("savedDashboards")
    private Integer savedDashboards;
    @JsonProperty("savedDataValues")
    private Integer savedDataValues;
    @JsonProperty("savedEventCharts")
    private Integer savedEventCharts;
    @JsonProperty("savedEventReports")
    private Integer savedEventReports;
    @JsonProperty("savedIndicators")
    private Integer savedIndicators;
    @JsonProperty("savedMaps")
    private Integer savedMaps;
    @JsonProperty("savedPivotTables")
    private Integer savedPivotTables;
    @JsonProperty("savedVisualizations")
    private Integer savedVisualizations;
    @JsonProperty("totalViews")
    private Integer totalViews;
    @JsonProperty("users")
    private Integer users;
    @JsonProperty("visualizationViews")
    private Integer visualizationViews;
    @JsonProperty("week")
    private Integer week;
    @JsonProperty("year")
    private Integer year;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1017746406398930191L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AggregatedStatistics() {
    }

    /**
     * 
     * @param source
     */
    public AggregatedStatistics(AggregatedStatistics source) {
        super();
        this.activeUsers = source.activeUsers;
        this.averageChartViews = source.averageChartViews;
        this.averageDashboardViews = source.averageDashboardViews;
        this.averageEventChartViews = source.averageEventChartViews;
        this.averageEventReportViews = source.averageEventReportViews;
        this.averageMapViews = source.averageMapViews;
        this.averagePassiveDashboardViews = source.averagePassiveDashboardViews;
        this.averagePivotTableViews = source.averagePivotTableViews;
        this.averageViews = source.averageViews;
        this.averageVisualizationViews = source.averageVisualizationViews;
        this.chartViews = source.chartViews;
        this.dashboardViews = source.dashboardViews;
        this.dataSetReportViews = source.dataSetReportViews;
        this.day = source.day;
        this.eventChartViews = source.eventChartViews;
        this.eventReportViews = source.eventReportViews;
        this.mapViews = source.mapViews;
        this.month = source.month;
        this.passiveDashboardViews = source.passiveDashboardViews;
        this.pivotTableViews = source.pivotTableViews;
        this.savedCharts = source.savedCharts;
        this.savedDashboards = source.savedDashboards;
        this.savedDataValues = source.savedDataValues;
        this.savedEventCharts = source.savedEventCharts;
        this.savedEventReports = source.savedEventReports;
        this.savedIndicators = source.savedIndicators;
        this.savedMaps = source.savedMaps;
        this.savedPivotTables = source.savedPivotTables;
        this.savedVisualizations = source.savedVisualizations;
        this.totalViews = source.totalViews;
        this.users = source.users;
        this.visualizationViews = source.visualizationViews;
        this.week = source.week;
        this.year = source.year;
    }

    /**
     * 
     * @param passiveDashboardViews
     * @param savedEventCharts
     * @param dataSetReportViews
     * @param week
     * @param year
     * @param pivotTableViews
     * @param savedDashboards
     * @param dashboardViews
     * @param averagePivotTableViews
     * @param averageMapViews
     * @param savedIndicators
     * @param averageEventReportViews
     * @param eventReportViews
     * @param savedMaps
     * @param averageEventChartViews
     * @param eventChartViews
     * @param mapViews
     * @param averageVisualizationViews
     * @param chartViews
     * @param day
     * @param visualizationViews
     * @param savedCharts
     * @param averageDashboardViews
     * @param averagePassiveDashboardViews
     * @param savedVisualizations
     * @param averageChartViews
     * @param activeUsers
     * @param savedPivotTables
     * @param users
     * @param month
     * @param averageViews
     * @param savedDataValues
     * @param totalViews
     * @param savedEventReports
     */
    public AggregatedStatistics(Integer activeUsers, Integer averageChartViews, Integer averageDashboardViews, Integer averageEventChartViews, Integer averageEventReportViews, Integer averageMapViews, Integer averagePassiveDashboardViews, Integer averagePivotTableViews, Integer averageViews, Integer averageVisualizationViews, Integer chartViews, Integer dashboardViews, Integer dataSetReportViews, Integer day, Integer eventChartViews, Integer eventReportViews, Integer mapViews, Integer month, Integer passiveDashboardViews, Integer pivotTableViews, Integer savedCharts, Integer savedDashboards, Integer savedDataValues, Integer savedEventCharts, Integer savedEventReports, Integer savedIndicators, Integer savedMaps, Integer savedPivotTables, Integer savedVisualizations, Integer totalViews, Integer users, Integer visualizationViews, Integer week, Integer year) {
        super();
        this.activeUsers = activeUsers;
        this.averageChartViews = averageChartViews;
        this.averageDashboardViews = averageDashboardViews;
        this.averageEventChartViews = averageEventChartViews;
        this.averageEventReportViews = averageEventReportViews;
        this.averageMapViews = averageMapViews;
        this.averagePassiveDashboardViews = averagePassiveDashboardViews;
        this.averagePivotTableViews = averagePivotTableViews;
        this.averageViews = averageViews;
        this.averageVisualizationViews = averageVisualizationViews;
        this.chartViews = chartViews;
        this.dashboardViews = dashboardViews;
        this.dataSetReportViews = dataSetReportViews;
        this.day = day;
        this.eventChartViews = eventChartViews;
        this.eventReportViews = eventReportViews;
        this.mapViews = mapViews;
        this.month = month;
        this.passiveDashboardViews = passiveDashboardViews;
        this.pivotTableViews = pivotTableViews;
        this.savedCharts = savedCharts;
        this.savedDashboards = savedDashboards;
        this.savedDataValues = savedDataValues;
        this.savedEventCharts = savedEventCharts;
        this.savedEventReports = savedEventReports;
        this.savedIndicators = savedIndicators;
        this.savedMaps = savedMaps;
        this.savedPivotTables = savedPivotTables;
        this.savedVisualizations = savedVisualizations;
        this.totalViews = totalViews;
        this.users = users;
        this.visualizationViews = visualizationViews;
        this.week = week;
        this.year = year;
    }

    @JsonProperty("activeUsers")
    public Optional<Integer> getActiveUsers() {
        return Optional.ofNullable(activeUsers);
    }

    @JsonProperty("activeUsers")
    public void setActiveUsers(Integer activeUsers) {
        this.activeUsers = activeUsers;
    }

    public AggregatedStatistics withActiveUsers(Integer activeUsers) {
        this.activeUsers = activeUsers;
        return this;
    }

    @JsonProperty("averageChartViews")
    public Optional<Integer> getAverageChartViews() {
        return Optional.ofNullable(averageChartViews);
    }

    @JsonProperty("averageChartViews")
    public void setAverageChartViews(Integer averageChartViews) {
        this.averageChartViews = averageChartViews;
    }

    public AggregatedStatistics withAverageChartViews(Integer averageChartViews) {
        this.averageChartViews = averageChartViews;
        return this;
    }

    @JsonProperty("averageDashboardViews")
    public Optional<Integer> getAverageDashboardViews() {
        return Optional.ofNullable(averageDashboardViews);
    }

    @JsonProperty("averageDashboardViews")
    public void setAverageDashboardViews(Integer averageDashboardViews) {
        this.averageDashboardViews = averageDashboardViews;
    }

    public AggregatedStatistics withAverageDashboardViews(Integer averageDashboardViews) {
        this.averageDashboardViews = averageDashboardViews;
        return this;
    }

    @JsonProperty("averageEventChartViews")
    public Optional<Integer> getAverageEventChartViews() {
        return Optional.ofNullable(averageEventChartViews);
    }

    @JsonProperty("averageEventChartViews")
    public void setAverageEventChartViews(Integer averageEventChartViews) {
        this.averageEventChartViews = averageEventChartViews;
    }

    public AggregatedStatistics withAverageEventChartViews(Integer averageEventChartViews) {
        this.averageEventChartViews = averageEventChartViews;
        return this;
    }

    @JsonProperty("averageEventReportViews")
    public Optional<Integer> getAverageEventReportViews() {
        return Optional.ofNullable(averageEventReportViews);
    }

    @JsonProperty("averageEventReportViews")
    public void setAverageEventReportViews(Integer averageEventReportViews) {
        this.averageEventReportViews = averageEventReportViews;
    }

    public AggregatedStatistics withAverageEventReportViews(Integer averageEventReportViews) {
        this.averageEventReportViews = averageEventReportViews;
        return this;
    }

    @JsonProperty("averageMapViews")
    public Optional<Integer> getAverageMapViews() {
        return Optional.ofNullable(averageMapViews);
    }

    @JsonProperty("averageMapViews")
    public void setAverageMapViews(Integer averageMapViews) {
        this.averageMapViews = averageMapViews;
    }

    public AggregatedStatistics withAverageMapViews(Integer averageMapViews) {
        this.averageMapViews = averageMapViews;
        return this;
    }

    @JsonProperty("averagePassiveDashboardViews")
    public Optional<Integer> getAveragePassiveDashboardViews() {
        return Optional.ofNullable(averagePassiveDashboardViews);
    }

    @JsonProperty("averagePassiveDashboardViews")
    public void setAveragePassiveDashboardViews(Integer averagePassiveDashboardViews) {
        this.averagePassiveDashboardViews = averagePassiveDashboardViews;
    }

    public AggregatedStatistics withAveragePassiveDashboardViews(Integer averagePassiveDashboardViews) {
        this.averagePassiveDashboardViews = averagePassiveDashboardViews;
        return this;
    }

    @JsonProperty("averagePivotTableViews")
    public Optional<Integer> getAveragePivotTableViews() {
        return Optional.ofNullable(averagePivotTableViews);
    }

    @JsonProperty("averagePivotTableViews")
    public void setAveragePivotTableViews(Integer averagePivotTableViews) {
        this.averagePivotTableViews = averagePivotTableViews;
    }

    public AggregatedStatistics withAveragePivotTableViews(Integer averagePivotTableViews) {
        this.averagePivotTableViews = averagePivotTableViews;
        return this;
    }

    @JsonProperty("averageViews")
    public Optional<Integer> getAverageViews() {
        return Optional.ofNullable(averageViews);
    }

    @JsonProperty("averageViews")
    public void setAverageViews(Integer averageViews) {
        this.averageViews = averageViews;
    }

    public AggregatedStatistics withAverageViews(Integer averageViews) {
        this.averageViews = averageViews;
        return this;
    }

    @JsonProperty("averageVisualizationViews")
    public Optional<Integer> getAverageVisualizationViews() {
        return Optional.ofNullable(averageVisualizationViews);
    }

    @JsonProperty("averageVisualizationViews")
    public void setAverageVisualizationViews(Integer averageVisualizationViews) {
        this.averageVisualizationViews = averageVisualizationViews;
    }

    public AggregatedStatistics withAverageVisualizationViews(Integer averageVisualizationViews) {
        this.averageVisualizationViews = averageVisualizationViews;
        return this;
    }

    @JsonProperty("chartViews")
    public Optional<Integer> getChartViews() {
        return Optional.ofNullable(chartViews);
    }

    @JsonProperty("chartViews")
    public void setChartViews(Integer chartViews) {
        this.chartViews = chartViews;
    }

    public AggregatedStatistics withChartViews(Integer chartViews) {
        this.chartViews = chartViews;
        return this;
    }

    @JsonProperty("dashboardViews")
    public Optional<Integer> getDashboardViews() {
        return Optional.ofNullable(dashboardViews);
    }

    @JsonProperty("dashboardViews")
    public void setDashboardViews(Integer dashboardViews) {
        this.dashboardViews = dashboardViews;
    }

    public AggregatedStatistics withDashboardViews(Integer dashboardViews) {
        this.dashboardViews = dashboardViews;
        return this;
    }

    @JsonProperty("dataSetReportViews")
    public Optional<Integer> getDataSetReportViews() {
        return Optional.ofNullable(dataSetReportViews);
    }

    @JsonProperty("dataSetReportViews")
    public void setDataSetReportViews(Integer dataSetReportViews) {
        this.dataSetReportViews = dataSetReportViews;
    }

    public AggregatedStatistics withDataSetReportViews(Integer dataSetReportViews) {
        this.dataSetReportViews = dataSetReportViews;
        return this;
    }

    @JsonProperty("day")
    public Optional<Integer> getDay() {
        return Optional.ofNullable(day);
    }

    @JsonProperty("day")
    public void setDay(Integer day) {
        this.day = day;
    }

    public AggregatedStatistics withDay(Integer day) {
        this.day = day;
        return this;
    }

    @JsonProperty("eventChartViews")
    public Optional<Integer> getEventChartViews() {
        return Optional.ofNullable(eventChartViews);
    }

    @JsonProperty("eventChartViews")
    public void setEventChartViews(Integer eventChartViews) {
        this.eventChartViews = eventChartViews;
    }

    public AggregatedStatistics withEventChartViews(Integer eventChartViews) {
        this.eventChartViews = eventChartViews;
        return this;
    }

    @JsonProperty("eventReportViews")
    public Optional<Integer> getEventReportViews() {
        return Optional.ofNullable(eventReportViews);
    }

    @JsonProperty("eventReportViews")
    public void setEventReportViews(Integer eventReportViews) {
        this.eventReportViews = eventReportViews;
    }

    public AggregatedStatistics withEventReportViews(Integer eventReportViews) {
        this.eventReportViews = eventReportViews;
        return this;
    }

    @JsonProperty("mapViews")
    public Optional<Integer> getMapViews() {
        return Optional.ofNullable(mapViews);
    }

    @JsonProperty("mapViews")
    public void setMapViews(Integer mapViews) {
        this.mapViews = mapViews;
    }

    public AggregatedStatistics withMapViews(Integer mapViews) {
        this.mapViews = mapViews;
        return this;
    }

    @JsonProperty("month")
    public Optional<Integer> getMonth() {
        return Optional.ofNullable(month);
    }

    @JsonProperty("month")
    public void setMonth(Integer month) {
        this.month = month;
    }

    public AggregatedStatistics withMonth(Integer month) {
        this.month = month;
        return this;
    }

    @JsonProperty("passiveDashboardViews")
    public Optional<Integer> getPassiveDashboardViews() {
        return Optional.ofNullable(passiveDashboardViews);
    }

    @JsonProperty("passiveDashboardViews")
    public void setPassiveDashboardViews(Integer passiveDashboardViews) {
        this.passiveDashboardViews = passiveDashboardViews;
    }

    public AggregatedStatistics withPassiveDashboardViews(Integer passiveDashboardViews) {
        this.passiveDashboardViews = passiveDashboardViews;
        return this;
    }

    @JsonProperty("pivotTableViews")
    public Optional<Integer> getPivotTableViews() {
        return Optional.ofNullable(pivotTableViews);
    }

    @JsonProperty("pivotTableViews")
    public void setPivotTableViews(Integer pivotTableViews) {
        this.pivotTableViews = pivotTableViews;
    }

    public AggregatedStatistics withPivotTableViews(Integer pivotTableViews) {
        this.pivotTableViews = pivotTableViews;
        return this;
    }

    @JsonProperty("savedCharts")
    public Optional<Integer> getSavedCharts() {
        return Optional.ofNullable(savedCharts);
    }

    @JsonProperty("savedCharts")
    public void setSavedCharts(Integer savedCharts) {
        this.savedCharts = savedCharts;
    }

    public AggregatedStatistics withSavedCharts(Integer savedCharts) {
        this.savedCharts = savedCharts;
        return this;
    }

    @JsonProperty("savedDashboards")
    public Optional<Integer> getSavedDashboards() {
        return Optional.ofNullable(savedDashboards);
    }

    @JsonProperty("savedDashboards")
    public void setSavedDashboards(Integer savedDashboards) {
        this.savedDashboards = savedDashboards;
    }

    public AggregatedStatistics withSavedDashboards(Integer savedDashboards) {
        this.savedDashboards = savedDashboards;
        return this;
    }

    @JsonProperty("savedDataValues")
    public Optional<Integer> getSavedDataValues() {
        return Optional.ofNullable(savedDataValues);
    }

    @JsonProperty("savedDataValues")
    public void setSavedDataValues(Integer savedDataValues) {
        this.savedDataValues = savedDataValues;
    }

    public AggregatedStatistics withSavedDataValues(Integer savedDataValues) {
        this.savedDataValues = savedDataValues;
        return this;
    }

    @JsonProperty("savedEventCharts")
    public Optional<Integer> getSavedEventCharts() {
        return Optional.ofNullable(savedEventCharts);
    }

    @JsonProperty("savedEventCharts")
    public void setSavedEventCharts(Integer savedEventCharts) {
        this.savedEventCharts = savedEventCharts;
    }

    public AggregatedStatistics withSavedEventCharts(Integer savedEventCharts) {
        this.savedEventCharts = savedEventCharts;
        return this;
    }

    @JsonProperty("savedEventReports")
    public Optional<Integer> getSavedEventReports() {
        return Optional.ofNullable(savedEventReports);
    }

    @JsonProperty("savedEventReports")
    public void setSavedEventReports(Integer savedEventReports) {
        this.savedEventReports = savedEventReports;
    }

    public AggregatedStatistics withSavedEventReports(Integer savedEventReports) {
        this.savedEventReports = savedEventReports;
        return this;
    }

    @JsonProperty("savedIndicators")
    public Optional<Integer> getSavedIndicators() {
        return Optional.ofNullable(savedIndicators);
    }

    @JsonProperty("savedIndicators")
    public void setSavedIndicators(Integer savedIndicators) {
        this.savedIndicators = savedIndicators;
    }

    public AggregatedStatistics withSavedIndicators(Integer savedIndicators) {
        this.savedIndicators = savedIndicators;
        return this;
    }

    @JsonProperty("savedMaps")
    public Optional<Integer> getSavedMaps() {
        return Optional.ofNullable(savedMaps);
    }

    @JsonProperty("savedMaps")
    public void setSavedMaps(Integer savedMaps) {
        this.savedMaps = savedMaps;
    }

    public AggregatedStatistics withSavedMaps(Integer savedMaps) {
        this.savedMaps = savedMaps;
        return this;
    }

    @JsonProperty("savedPivotTables")
    public Optional<Integer> getSavedPivotTables() {
        return Optional.ofNullable(savedPivotTables);
    }

    @JsonProperty("savedPivotTables")
    public void setSavedPivotTables(Integer savedPivotTables) {
        this.savedPivotTables = savedPivotTables;
    }

    public AggregatedStatistics withSavedPivotTables(Integer savedPivotTables) {
        this.savedPivotTables = savedPivotTables;
        return this;
    }

    @JsonProperty("savedVisualizations")
    public Optional<Integer> getSavedVisualizations() {
        return Optional.ofNullable(savedVisualizations);
    }

    @JsonProperty("savedVisualizations")
    public void setSavedVisualizations(Integer savedVisualizations) {
        this.savedVisualizations = savedVisualizations;
    }

    public AggregatedStatistics withSavedVisualizations(Integer savedVisualizations) {
        this.savedVisualizations = savedVisualizations;
        return this;
    }

    @JsonProperty("totalViews")
    public Optional<Integer> getTotalViews() {
        return Optional.ofNullable(totalViews);
    }

    @JsonProperty("totalViews")
    public void setTotalViews(Integer totalViews) {
        this.totalViews = totalViews;
    }

    public AggregatedStatistics withTotalViews(Integer totalViews) {
        this.totalViews = totalViews;
        return this;
    }

    @JsonProperty("users")
    public Optional<Integer> getUsers() {
        return Optional.ofNullable(users);
    }

    @JsonProperty("users")
    public void setUsers(Integer users) {
        this.users = users;
    }

    public AggregatedStatistics withUsers(Integer users) {
        this.users = users;
        return this;
    }

    @JsonProperty("visualizationViews")
    public Optional<Integer> getVisualizationViews() {
        return Optional.ofNullable(visualizationViews);
    }

    @JsonProperty("visualizationViews")
    public void setVisualizationViews(Integer visualizationViews) {
        this.visualizationViews = visualizationViews;
    }

    public AggregatedStatistics withVisualizationViews(Integer visualizationViews) {
        this.visualizationViews = visualizationViews;
        return this;
    }

    @JsonProperty("week")
    public Optional<Integer> getWeek() {
        return Optional.ofNullable(week);
    }

    @JsonProperty("week")
    public void setWeek(Integer week) {
        this.week = week;
    }

    public AggregatedStatistics withWeek(Integer week) {
        this.week = week;
        return this;
    }

    @JsonProperty("year")
    public Optional<Integer> getYear() {
        return Optional.ofNullable(year);
    }

    @JsonProperty("year")
    public void setYear(Integer year) {
        this.year = year;
    }

    public AggregatedStatistics withYear(Integer year) {
        this.year = year;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AggregatedStatistics withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "activeUsers":
                if (value instanceof Integer) {
                    setActiveUsers(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"activeUsers\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averageChartViews":
                if (value instanceof Integer) {
                    setAverageChartViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageChartViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averageDashboardViews":
                if (value instanceof Integer) {
                    setAverageDashboardViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageDashboardViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averageEventChartViews":
                if (value instanceof Integer) {
                    setAverageEventChartViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageEventChartViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averageEventReportViews":
                if (value instanceof Integer) {
                    setAverageEventReportViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageEventReportViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averageMapViews":
                if (value instanceof Integer) {
                    setAverageMapViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageMapViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averagePassiveDashboardViews":
                if (value instanceof Integer) {
                    setAveragePassiveDashboardViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averagePassiveDashboardViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averagePivotTableViews":
                if (value instanceof Integer) {
                    setAveragePivotTableViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averagePivotTableViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averageViews":
                if (value instanceof Integer) {
                    setAverageViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "averageVisualizationViews":
                if (value instanceof Integer) {
                    setAverageVisualizationViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageVisualizationViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "chartViews":
                if (value instanceof Integer) {
                    setChartViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"chartViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dashboardViews":
                if (value instanceof Integer) {
                    setDashboardViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"dashboardViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSetReportViews":
                if (value instanceof Integer) {
                    setDataSetReportViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSetReportViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "day":
                if (value instanceof Integer) {
                    setDay(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"day\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventChartViews":
                if (value instanceof Integer) {
                    setEventChartViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventChartViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventReportViews":
                if (value instanceof Integer) {
                    setEventReportViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventReportViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mapViews":
                if (value instanceof Integer) {
                    setMapViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"mapViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "month":
                if (value instanceof Integer) {
                    setMonth(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"month\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "passiveDashboardViews":
                if (value instanceof Integer) {
                    setPassiveDashboardViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"passiveDashboardViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "pivotTableViews":
                if (value instanceof Integer) {
                    setPivotTableViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"pivotTableViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedCharts":
                if (value instanceof Integer) {
                    setSavedCharts(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedCharts\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedDashboards":
                if (value instanceof Integer) {
                    setSavedDashboards(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedDashboards\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedDataValues":
                if (value instanceof Integer) {
                    setSavedDataValues(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedDataValues\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedEventCharts":
                if (value instanceof Integer) {
                    setSavedEventCharts(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedEventCharts\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedEventReports":
                if (value instanceof Integer) {
                    setSavedEventReports(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedEventReports\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedIndicators":
                if (value instanceof Integer) {
                    setSavedIndicators(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedIndicators\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedMaps":
                if (value instanceof Integer) {
                    setSavedMaps(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedMaps\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedPivotTables":
                if (value instanceof Integer) {
                    setSavedPivotTables(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedPivotTables\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedVisualizations":
                if (value instanceof Integer) {
                    setSavedVisualizations(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedVisualizations\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "totalViews":
                if (value instanceof Integer) {
                    setTotalViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"totalViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "users":
                if (value instanceof Integer) {
                    setUsers(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"users\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "visualizationViews":
                if (value instanceof Integer) {
                    setVisualizationViews(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"visualizationViews\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "week":
                if (value instanceof Integer) {
                    setWeek(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"week\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "year":
                if (value instanceof Integer) {
                    setYear(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"year\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "activeUsers":
                return getActiveUsers();
            case "averageChartViews":
                return getAverageChartViews();
            case "averageDashboardViews":
                return getAverageDashboardViews();
            case "averageEventChartViews":
                return getAverageEventChartViews();
            case "averageEventReportViews":
                return getAverageEventReportViews();
            case "averageMapViews":
                return getAverageMapViews();
            case "averagePassiveDashboardViews":
                return getAveragePassiveDashboardViews();
            case "averagePivotTableViews":
                return getAveragePivotTableViews();
            case "averageViews":
                return getAverageViews();
            case "averageVisualizationViews":
                return getAverageVisualizationViews();
            case "chartViews":
                return getChartViews();
            case "dashboardViews":
                return getDashboardViews();
            case "dataSetReportViews":
                return getDataSetReportViews();
            case "day":
                return getDay();
            case "eventChartViews":
                return getEventChartViews();
            case "eventReportViews":
                return getEventReportViews();
            case "mapViews":
                return getMapViews();
            case "month":
                return getMonth();
            case "passiveDashboardViews":
                return getPassiveDashboardViews();
            case "pivotTableViews":
                return getPivotTableViews();
            case "savedCharts":
                return getSavedCharts();
            case "savedDashboards":
                return getSavedDashboards();
            case "savedDataValues":
                return getSavedDataValues();
            case "savedEventCharts":
                return getSavedEventCharts();
            case "savedEventReports":
                return getSavedEventReports();
            case "savedIndicators":
                return getSavedIndicators();
            case "savedMaps":
                return getSavedMaps();
            case "savedPivotTables":
                return getSavedPivotTables();
            case "savedVisualizations":
                return getSavedVisualizations();
            case "totalViews":
                return getTotalViews();
            case "users":
                return getUsers();
            case "visualizationViews":
                return getVisualizationViews();
            case "week":
                return getWeek();
            case "year":
                return getYear();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, AggregatedStatistics.NOT_FOUND_VALUE);
        if (AggregatedStatistics.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public AggregatedStatistics with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AggregatedStatistics.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("activeUsers");
        sb.append('=');
        sb.append(((this.activeUsers == null)?"<null>":this.activeUsers));
        sb.append(',');
        sb.append("averageChartViews");
        sb.append('=');
        sb.append(((this.averageChartViews == null)?"<null>":this.averageChartViews));
        sb.append(',');
        sb.append("averageDashboardViews");
        sb.append('=');
        sb.append(((this.averageDashboardViews == null)?"<null>":this.averageDashboardViews));
        sb.append(',');
        sb.append("averageEventChartViews");
        sb.append('=');
        sb.append(((this.averageEventChartViews == null)?"<null>":this.averageEventChartViews));
        sb.append(',');
        sb.append("averageEventReportViews");
        sb.append('=');
        sb.append(((this.averageEventReportViews == null)?"<null>":this.averageEventReportViews));
        sb.append(',');
        sb.append("averageMapViews");
        sb.append('=');
        sb.append(((this.averageMapViews == null)?"<null>":this.averageMapViews));
        sb.append(',');
        sb.append("averagePassiveDashboardViews");
        sb.append('=');
        sb.append(((this.averagePassiveDashboardViews == null)?"<null>":this.averagePassiveDashboardViews));
        sb.append(',');
        sb.append("averagePivotTableViews");
        sb.append('=');
        sb.append(((this.averagePivotTableViews == null)?"<null>":this.averagePivotTableViews));
        sb.append(',');
        sb.append("averageViews");
        sb.append('=');
        sb.append(((this.averageViews == null)?"<null>":this.averageViews));
        sb.append(',');
        sb.append("averageVisualizationViews");
        sb.append('=');
        sb.append(((this.averageVisualizationViews == null)?"<null>":this.averageVisualizationViews));
        sb.append(',');
        sb.append("chartViews");
        sb.append('=');
        sb.append(((this.chartViews == null)?"<null>":this.chartViews));
        sb.append(',');
        sb.append("dashboardViews");
        sb.append('=');
        sb.append(((this.dashboardViews == null)?"<null>":this.dashboardViews));
        sb.append(',');
        sb.append("dataSetReportViews");
        sb.append('=');
        sb.append(((this.dataSetReportViews == null)?"<null>":this.dataSetReportViews));
        sb.append(',');
        sb.append("day");
        sb.append('=');
        sb.append(((this.day == null)?"<null>":this.day));
        sb.append(',');
        sb.append("eventChartViews");
        sb.append('=');
        sb.append(((this.eventChartViews == null)?"<null>":this.eventChartViews));
        sb.append(',');
        sb.append("eventReportViews");
        sb.append('=');
        sb.append(((this.eventReportViews == null)?"<null>":this.eventReportViews));
        sb.append(',');
        sb.append("mapViews");
        sb.append('=');
        sb.append(((this.mapViews == null)?"<null>":this.mapViews));
        sb.append(',');
        sb.append("month");
        sb.append('=');
        sb.append(((this.month == null)?"<null>":this.month));
        sb.append(',');
        sb.append("passiveDashboardViews");
        sb.append('=');
        sb.append(((this.passiveDashboardViews == null)?"<null>":this.passiveDashboardViews));
        sb.append(',');
        sb.append("pivotTableViews");
        sb.append('=');
        sb.append(((this.pivotTableViews == null)?"<null>":this.pivotTableViews));
        sb.append(',');
        sb.append("savedCharts");
        sb.append('=');
        sb.append(((this.savedCharts == null)?"<null>":this.savedCharts));
        sb.append(',');
        sb.append("savedDashboards");
        sb.append('=');
        sb.append(((this.savedDashboards == null)?"<null>":this.savedDashboards));
        sb.append(',');
        sb.append("savedDataValues");
        sb.append('=');
        sb.append(((this.savedDataValues == null)?"<null>":this.savedDataValues));
        sb.append(',');
        sb.append("savedEventCharts");
        sb.append('=');
        sb.append(((this.savedEventCharts == null)?"<null>":this.savedEventCharts));
        sb.append(',');
        sb.append("savedEventReports");
        sb.append('=');
        sb.append(((this.savedEventReports == null)?"<null>":this.savedEventReports));
        sb.append(',');
        sb.append("savedIndicators");
        sb.append('=');
        sb.append(((this.savedIndicators == null)?"<null>":this.savedIndicators));
        sb.append(',');
        sb.append("savedMaps");
        sb.append('=');
        sb.append(((this.savedMaps == null)?"<null>":this.savedMaps));
        sb.append(',');
        sb.append("savedPivotTables");
        sb.append('=');
        sb.append(((this.savedPivotTables == null)?"<null>":this.savedPivotTables));
        sb.append(',');
        sb.append("savedVisualizations");
        sb.append('=');
        sb.append(((this.savedVisualizations == null)?"<null>":this.savedVisualizations));
        sb.append(',');
        sb.append("totalViews");
        sb.append('=');
        sb.append(((this.totalViews == null)?"<null>":this.totalViews));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("visualizationViews");
        sb.append('=');
        sb.append(((this.visualizationViews == null)?"<null>":this.visualizationViews));
        sb.append(',');
        sb.append("week");
        sb.append('=');
        sb.append(((this.week == null)?"<null>":this.week));
        sb.append(',');
        sb.append("year");
        sb.append('=');
        sb.append(((this.year == null)?"<null>":this.year));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.passiveDashboardViews == null)? 0 :this.passiveDashboardViews.hashCode()));
        result = ((result* 31)+((this.savedEventCharts == null)? 0 :this.savedEventCharts.hashCode()));
        result = ((result* 31)+((this.dataSetReportViews == null)? 0 :this.dataSetReportViews.hashCode()));
        result = ((result* 31)+((this.week == null)? 0 :this.week.hashCode()));
        result = ((result* 31)+((this.year == null)? 0 :this.year.hashCode()));
        result = ((result* 31)+((this.pivotTableViews == null)? 0 :this.pivotTableViews.hashCode()));
        result = ((result* 31)+((this.savedDashboards == null)? 0 :this.savedDashboards.hashCode()));
        result = ((result* 31)+((this.dashboardViews == null)? 0 :this.dashboardViews.hashCode()));
        result = ((result* 31)+((this.averagePivotTableViews == null)? 0 :this.averagePivotTableViews.hashCode()));
        result = ((result* 31)+((this.averageMapViews == null)? 0 :this.averageMapViews.hashCode()));
        result = ((result* 31)+((this.savedIndicators == null)? 0 :this.savedIndicators.hashCode()));
        result = ((result* 31)+((this.averageEventReportViews == null)? 0 :this.averageEventReportViews.hashCode()));
        result = ((result* 31)+((this.eventReportViews == null)? 0 :this.eventReportViews.hashCode()));
        result = ((result* 31)+((this.savedMaps == null)? 0 :this.savedMaps.hashCode()));
        result = ((result* 31)+((this.averageEventChartViews == null)? 0 :this.averageEventChartViews.hashCode()));
        result = ((result* 31)+((this.eventChartViews == null)? 0 :this.eventChartViews.hashCode()));
        result = ((result* 31)+((this.mapViews == null)? 0 :this.mapViews.hashCode()));
        result = ((result* 31)+((this.averageVisualizationViews == null)? 0 :this.averageVisualizationViews.hashCode()));
        result = ((result* 31)+((this.chartViews == null)? 0 :this.chartViews.hashCode()));
        result = ((result* 31)+((this.day == null)? 0 :this.day.hashCode()));
        result = ((result* 31)+((this.visualizationViews == null)? 0 :this.visualizationViews.hashCode()));
        result = ((result* 31)+((this.savedCharts == null)? 0 :this.savedCharts.hashCode()));
        result = ((result* 31)+((this.averageDashboardViews == null)? 0 :this.averageDashboardViews.hashCode()));
        result = ((result* 31)+((this.averagePassiveDashboardViews == null)? 0 :this.averagePassiveDashboardViews.hashCode()));
        result = ((result* 31)+((this.savedVisualizations == null)? 0 :this.savedVisualizations.hashCode()));
        result = ((result* 31)+((this.averageChartViews == null)? 0 :this.averageChartViews.hashCode()));
        result = ((result* 31)+((this.activeUsers == null)? 0 :this.activeUsers.hashCode()));
        result = ((result* 31)+((this.savedPivotTables == null)? 0 :this.savedPivotTables.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        result = ((result* 31)+((this.month == null)? 0 :this.month.hashCode()));
        result = ((result* 31)+((this.averageViews == null)? 0 :this.averageViews.hashCode()));
        result = ((result* 31)+((this.savedDataValues == null)? 0 :this.savedDataValues.hashCode()));
        result = ((result* 31)+((this.totalViews == null)? 0 :this.totalViews.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.savedEventReports == null)? 0 :this.savedEventReports.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AggregatedStatistics) == false) {
            return false;
        }
        AggregatedStatistics rhs = ((AggregatedStatistics) other);
        return ((((((((((((((((((((((((((((((((((((this.passiveDashboardViews == rhs.passiveDashboardViews)||((this.passiveDashboardViews!= null)&&this.passiveDashboardViews.equals(rhs.passiveDashboardViews)))&&((this.savedEventCharts == rhs.savedEventCharts)||((this.savedEventCharts!= null)&&this.savedEventCharts.equals(rhs.savedEventCharts))))&&((this.dataSetReportViews == rhs.dataSetReportViews)||((this.dataSetReportViews!= null)&&this.dataSetReportViews.equals(rhs.dataSetReportViews))))&&((this.week == rhs.week)||((this.week!= null)&&this.week.equals(rhs.week))))&&((this.year == rhs.year)||((this.year!= null)&&this.year.equals(rhs.year))))&&((this.pivotTableViews == rhs.pivotTableViews)||((this.pivotTableViews!= null)&&this.pivotTableViews.equals(rhs.pivotTableViews))))&&((this.savedDashboards == rhs.savedDashboards)||((this.savedDashboards!= null)&&this.savedDashboards.equals(rhs.savedDashboards))))&&((this.dashboardViews == rhs.dashboardViews)||((this.dashboardViews!= null)&&this.dashboardViews.equals(rhs.dashboardViews))))&&((this.averagePivotTableViews == rhs.averagePivotTableViews)||((this.averagePivotTableViews!= null)&&this.averagePivotTableViews.equals(rhs.averagePivotTableViews))))&&((this.averageMapViews == rhs.averageMapViews)||((this.averageMapViews!= null)&&this.averageMapViews.equals(rhs.averageMapViews))))&&((this.savedIndicators == rhs.savedIndicators)||((this.savedIndicators!= null)&&this.savedIndicators.equals(rhs.savedIndicators))))&&((this.averageEventReportViews == rhs.averageEventReportViews)||((this.averageEventReportViews!= null)&&this.averageEventReportViews.equals(rhs.averageEventReportViews))))&&((this.eventReportViews == rhs.eventReportViews)||((this.eventReportViews!= null)&&this.eventReportViews.equals(rhs.eventReportViews))))&&((this.savedMaps == rhs.savedMaps)||((this.savedMaps!= null)&&this.savedMaps.equals(rhs.savedMaps))))&&((this.averageEventChartViews == rhs.averageEventChartViews)||((this.averageEventChartViews!= null)&&this.averageEventChartViews.equals(rhs.averageEventChartViews))))&&((this.eventChartViews == rhs.eventChartViews)||((this.eventChartViews!= null)&&this.eventChartViews.equals(rhs.eventChartViews))))&&((this.mapViews == rhs.mapViews)||((this.mapViews!= null)&&this.mapViews.equals(rhs.mapViews))))&&((this.averageVisualizationViews == rhs.averageVisualizationViews)||((this.averageVisualizationViews!= null)&&this.averageVisualizationViews.equals(rhs.averageVisualizationViews))))&&((this.chartViews == rhs.chartViews)||((this.chartViews!= null)&&this.chartViews.equals(rhs.chartViews))))&&((this.day == rhs.day)||((this.day!= null)&&this.day.equals(rhs.day))))&&((this.visualizationViews == rhs.visualizationViews)||((this.visualizationViews!= null)&&this.visualizationViews.equals(rhs.visualizationViews))))&&((this.savedCharts == rhs.savedCharts)||((this.savedCharts!= null)&&this.savedCharts.equals(rhs.savedCharts))))&&((this.averageDashboardViews == rhs.averageDashboardViews)||((this.averageDashboardViews!= null)&&this.averageDashboardViews.equals(rhs.averageDashboardViews))))&&((this.averagePassiveDashboardViews == rhs.averagePassiveDashboardViews)||((this.averagePassiveDashboardViews!= null)&&this.averagePassiveDashboardViews.equals(rhs.averagePassiveDashboardViews))))&&((this.savedVisualizations == rhs.savedVisualizations)||((this.savedVisualizations!= null)&&this.savedVisualizations.equals(rhs.savedVisualizations))))&&((this.averageChartViews == rhs.averageChartViews)||((this.averageChartViews!= null)&&this.averageChartViews.equals(rhs.averageChartViews))))&&((this.activeUsers == rhs.activeUsers)||((this.activeUsers!= null)&&this.activeUsers.equals(rhs.activeUsers))))&&((this.savedPivotTables == rhs.savedPivotTables)||((this.savedPivotTables!= null)&&this.savedPivotTables.equals(rhs.savedPivotTables))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))))&&((this.month == rhs.month)||((this.month!= null)&&this.month.equals(rhs.month))))&&((this.averageViews == rhs.averageViews)||((this.averageViews!= null)&&this.averageViews.equals(rhs.averageViews))))&&((this.savedDataValues == rhs.savedDataValues)||((this.savedDataValues!= null)&&this.savedDataValues.equals(rhs.savedDataValues))))&&((this.totalViews == rhs.totalViews)||((this.totalViews!= null)&&this.totalViews.equals(rhs.totalViews))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.savedEventReports == rhs.savedEventReports)||((this.savedEventReports!= null)&&this.savedEventReports.equals(rhs.savedEventReports))));
    }

}
