
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "avatar",
    "birthday",
    "code",
    "created",
    "dataViewOrganisationUnits",
    "displayName",
    "education",
    "email",
    "employer",
    "externalAccess",
    "facebookMessenger",
    "favorite",
    "favorites",
    "firstName",
    "gender",
    "href",
    "id",
    "interests",
    "introduction",
    "jobTitle",
    "languages",
    "lastCheckedInterpretations",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "nationality",
    "organisationUnits",
    "phoneNumber",
    "publicAccess",
    "skype",
    "surname",
    "teiSearchOrganisationUnits",
    "telegram",
    "translations",
    "twitter",
    "user",
    "userAccesses",
    "userCredentials",
    "userGroupAccesses",
    "userGroups",
    "welcomeMessage",
    "whatsApp"
})
@Generated("jsonschema2pojo")
public class User implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("avatar")
    private FileResource avatar;
    @JsonProperty("birthday")
    private Date birthday;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dataViewOrganisationUnits")
    private List<OrganisationUnit> dataViewOrganisationUnits = null;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("education")
    private String education;
    @JsonProperty("email")
    private String email;
    @JsonProperty("employer")
    private String employer;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("facebookMessenger")
    private String facebookMessenger;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("firstName")
    private String firstName;
    @JsonProperty("gender")
    private String gender;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("interests")
    private String interests;
    @JsonProperty("introduction")
    private String introduction;
    @JsonProperty("jobTitle")
    private String jobTitle;
    @JsonProperty("languages")
    private String languages;
    @JsonProperty("lastCheckedInterpretations")
    private Date lastCheckedInterpretations;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("nationality")
    private String nationality;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnit> organisationUnits = null;
    @JsonProperty("phoneNumber")
    private String phoneNumber;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("skype")
    private String skype;
    @JsonProperty("surname")
    private String surname;
    @JsonProperty("teiSearchOrganisationUnits")
    private List<OrganisationUnit> teiSearchOrganisationUnits = null;
    @JsonProperty("telegram")
    private String telegram;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("twitter")
    private String twitter;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userCredentials")
    private UserCredentials userCredentials;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("userGroups")
    private List<UserGroup> userGroups = null;
    @JsonProperty("welcomeMessage")
    private String welcomeMessage;
    @JsonProperty("whatsApp")
    private String whatsApp;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 832821670255653672L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public User() {
    }

    /**
     * 
     * @param source
     */
    public User(User source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.avatar = source.avatar;
        this.birthday = source.birthday;
        this.code = source.code;
        this.created = source.created;
        this.dataViewOrganisationUnits = source.dataViewOrganisationUnits;
        this.displayName = source.displayName;
        this.education = source.education;
        this.email = source.email;
        this.employer = source.employer;
        this.externalAccess = source.externalAccess;
        this.facebookMessenger = source.facebookMessenger;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.firstName = source.firstName;
        this.gender = source.gender;
        this.href = source.href;
        this.id = source.id;
        this.interests = source.interests;
        this.introduction = source.introduction;
        this.jobTitle = source.jobTitle;
        this.languages = source.languages;
        this.lastCheckedInterpretations = source.lastCheckedInterpretations;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.nationality = source.nationality;
        this.organisationUnits = source.organisationUnits;
        this.phoneNumber = source.phoneNumber;
        this.publicAccess = source.publicAccess;
        this.skype = source.skype;
        this.surname = source.surname;
        this.teiSearchOrganisationUnits = source.teiSearchOrganisationUnits;
        this.telegram = source.telegram;
        this.translations = source.translations;
        this.twitter = source.twitter;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userCredentials = source.userCredentials;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userGroups = source.userGroups;
        this.welcomeMessage = source.welcomeMessage;
        this.whatsApp = source.whatsApp;
    }

    /**
     * 
     * @param birthday
     * @param favorites
     * @param access
     * @param code
     * @param education
     * @param gender
     * @param displayName
     * @param publicAccess
     * @param jobTitle
     * @param externalAccess
     * @param lastUpdated
     * @param skype
     * @param teiSearchOrganisationUnits
     * @param twitter
     * @param surname
     * @param translations
     * @param employer
     * @param href
     * @param id
     * @param organisationUnits
     * @param facebookMessenger
     * @param email
     * @param introduction
     * @param dataViewOrganisationUnits
     * @param lastUpdatedBy
     * @param userGroupAccesses
     * @param whatsApp
     * @param languages
     * @param created
     * @param welcomeMessage
     * @param attributeValues
     * @param userCredentials
     * @param telegram
     * @param avatar
     * @param firstName
     * @param lastCheckedInterpretations
     * @param userGroups
     * @param phoneNumber
     * @param nationality
     * @param userAccesses
     * @param name
     * @param interests
     * @param favorite
     * @param user
     */
    public User(Access access, List<AttributeValue> attributeValues, FileResource avatar, Date birthday, String code, Date created, List<OrganisationUnit> dataViewOrganisationUnits, String displayName, String education, String email, String employer, Boolean externalAccess, String facebookMessenger, Boolean favorite, List<String> favorites, String firstName, String gender, String href, String id, String interests, String introduction, String jobTitle, String languages, Date lastCheckedInterpretations, Date lastUpdated, User lastUpdatedBy, String name, String nationality, List<OrganisationUnit> organisationUnits, String phoneNumber, String publicAccess, String skype, String surname, List<OrganisationUnit> teiSearchOrganisationUnits, String telegram, List<Translation> translations, String twitter, User user, List<UserAccess> userAccesses, UserCredentials userCredentials, List<UserGroupAccess> userGroupAccesses, List<UserGroup> userGroups, String welcomeMessage, String whatsApp) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.avatar = avatar;
        this.birthday = birthday;
        this.code = code;
        this.created = created;
        this.dataViewOrganisationUnits = dataViewOrganisationUnits;
        this.displayName = displayName;
        this.education = education;
        this.email = email;
        this.employer = employer;
        this.externalAccess = externalAccess;
        this.facebookMessenger = facebookMessenger;
        this.favorite = favorite;
        this.favorites = favorites;
        this.firstName = firstName;
        this.gender = gender;
        this.href = href;
        this.id = id;
        this.interests = interests;
        this.introduction = introduction;
        this.jobTitle = jobTitle;
        this.languages = languages;
        this.lastCheckedInterpretations = lastCheckedInterpretations;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.nationality = nationality;
        this.organisationUnits = organisationUnits;
        this.phoneNumber = phoneNumber;
        this.publicAccess = publicAccess;
        this.skype = skype;
        this.surname = surname;
        this.teiSearchOrganisationUnits = teiSearchOrganisationUnits;
        this.telegram = telegram;
        this.translations = translations;
        this.twitter = twitter;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userCredentials = userCredentials;
        this.userGroupAccesses = userGroupAccesses;
        this.userGroups = userGroups;
        this.welcomeMessage = welcomeMessage;
        this.whatsApp = whatsApp;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public User withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public User withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("avatar")
    public Optional<FileResource> getAvatar() {
        return Optional.ofNullable(avatar);
    }

    @JsonProperty("avatar")
    public void setAvatar(FileResource avatar) {
        this.avatar = avatar;
    }

    public User withAvatar(FileResource avatar) {
        this.avatar = avatar;
        return this;
    }

    @JsonProperty("birthday")
    public Optional<Date> getBirthday() {
        return Optional.ofNullable(birthday);
    }

    @JsonProperty("birthday")
    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public User withBirthday(Date birthday) {
        this.birthday = birthday;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public User withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public User withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataViewOrganisationUnits")
    public Optional<List<OrganisationUnit>> getDataViewOrganisationUnits() {
        return Optional.ofNullable(dataViewOrganisationUnits);
    }

    @JsonProperty("dataViewOrganisationUnits")
    public void setDataViewOrganisationUnits(List<OrganisationUnit> dataViewOrganisationUnits) {
        this.dataViewOrganisationUnits = dataViewOrganisationUnits;
    }

    public User withDataViewOrganisationUnits(List<OrganisationUnit> dataViewOrganisationUnits) {
        this.dataViewOrganisationUnits = dataViewOrganisationUnits;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public User withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("education")
    public Optional<String> getEducation() {
        return Optional.ofNullable(education);
    }

    @JsonProperty("education")
    public void setEducation(String education) {
        this.education = education;
    }

    public User withEducation(String education) {
        this.education = education;
        return this;
    }

    @JsonProperty("email")
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    @JsonProperty("email")
    public void setEmail(String email) {
        this.email = email;
    }

    public User withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty("employer")
    public Optional<String> getEmployer() {
        return Optional.ofNullable(employer);
    }

    @JsonProperty("employer")
    public void setEmployer(String employer) {
        this.employer = employer;
    }

    public User withEmployer(String employer) {
        this.employer = employer;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public User withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("facebookMessenger")
    public Optional<String> getFacebookMessenger() {
        return Optional.ofNullable(facebookMessenger);
    }

    @JsonProperty("facebookMessenger")
    public void setFacebookMessenger(String facebookMessenger) {
        this.facebookMessenger = facebookMessenger;
    }

    public User withFacebookMessenger(String facebookMessenger) {
        this.facebookMessenger = facebookMessenger;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public User withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public User withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("firstName")
    public Optional<String> getFirstName() {
        return Optional.ofNullable(firstName);
    }

    @JsonProperty("firstName")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public User withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @JsonProperty("gender")
    public Optional<String> getGender() {
        return Optional.ofNullable(gender);
    }

    @JsonProperty("gender")
    public void setGender(String gender) {
        this.gender = gender;
    }

    public User withGender(String gender) {
        this.gender = gender;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public User withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public User withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("interests")
    public Optional<String> getInterests() {
        return Optional.ofNullable(interests);
    }

    @JsonProperty("interests")
    public void setInterests(String interests) {
        this.interests = interests;
    }

    public User withInterests(String interests) {
        this.interests = interests;
        return this;
    }

    @JsonProperty("introduction")
    public Optional<String> getIntroduction() {
        return Optional.ofNullable(introduction);
    }

    @JsonProperty("introduction")
    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public User withIntroduction(String introduction) {
        this.introduction = introduction;
        return this;
    }

    @JsonProperty("jobTitle")
    public Optional<String> getJobTitle() {
        return Optional.ofNullable(jobTitle);
    }

    @JsonProperty("jobTitle")
    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public User withJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @JsonProperty("languages")
    public Optional<String> getLanguages() {
        return Optional.ofNullable(languages);
    }

    @JsonProperty("languages")
    public void setLanguages(String languages) {
        this.languages = languages;
    }

    public User withLanguages(String languages) {
        this.languages = languages;
        return this;
    }

    @JsonProperty("lastCheckedInterpretations")
    public Optional<Date> getLastCheckedInterpretations() {
        return Optional.ofNullable(lastCheckedInterpretations);
    }

    @JsonProperty("lastCheckedInterpretations")
    public void setLastCheckedInterpretations(Date lastCheckedInterpretations) {
        this.lastCheckedInterpretations = lastCheckedInterpretations;
    }

    public User withLastCheckedInterpretations(Date lastCheckedInterpretations) {
        this.lastCheckedInterpretations = lastCheckedInterpretations;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public User withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public User withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public User withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("nationality")
    public Optional<String> getNationality() {
        return Optional.ofNullable(nationality);
    }

    @JsonProperty("nationality")
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public User withNationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public User withOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("phoneNumber")
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    @JsonProperty("phoneNumber")
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public User withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public User withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("skype")
    public Optional<String> getSkype() {
        return Optional.ofNullable(skype);
    }

    @JsonProperty("skype")
    public void setSkype(String skype) {
        this.skype = skype;
    }

    public User withSkype(String skype) {
        this.skype = skype;
        return this;
    }

    @JsonProperty("surname")
    public Optional<String> getSurname() {
        return Optional.ofNullable(surname);
    }

    @JsonProperty("surname")
    public void setSurname(String surname) {
        this.surname = surname;
    }

    public User withSurname(String surname) {
        this.surname = surname;
        return this;
    }

    @JsonProperty("teiSearchOrganisationUnits")
    public Optional<List<OrganisationUnit>> getTeiSearchOrganisationUnits() {
        return Optional.ofNullable(teiSearchOrganisationUnits);
    }

    @JsonProperty("teiSearchOrganisationUnits")
    public void setTeiSearchOrganisationUnits(List<OrganisationUnit> teiSearchOrganisationUnits) {
        this.teiSearchOrganisationUnits = teiSearchOrganisationUnits;
    }

    public User withTeiSearchOrganisationUnits(List<OrganisationUnit> teiSearchOrganisationUnits) {
        this.teiSearchOrganisationUnits = teiSearchOrganisationUnits;
        return this;
    }

    @JsonProperty("telegram")
    public Optional<String> getTelegram() {
        return Optional.ofNullable(telegram);
    }

    @JsonProperty("telegram")
    public void setTelegram(String telegram) {
        this.telegram = telegram;
    }

    public User withTelegram(String telegram) {
        this.telegram = telegram;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public User withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("twitter")
    public Optional<String> getTwitter() {
        return Optional.ofNullable(twitter);
    }

    @JsonProperty("twitter")
    public void setTwitter(String twitter) {
        this.twitter = twitter;
    }

    public User withTwitter(String twitter) {
        this.twitter = twitter;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public User withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public User withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userCredentials")
    public Optional<UserCredentials> getUserCredentials() {
        return Optional.ofNullable(userCredentials);
    }

    @JsonProperty("userCredentials")
    public void setUserCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
    }

    public User withUserCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public User withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userGroups")
    public Optional<List<UserGroup>> getUserGroups() {
        return Optional.ofNullable(userGroups);
    }

    @JsonProperty("userGroups")
    public void setUserGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    public User withUserGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
        return this;
    }

    @JsonProperty("welcomeMessage")
    public Optional<String> getWelcomeMessage() {
        return Optional.ofNullable(welcomeMessage);
    }

    @JsonProperty("welcomeMessage")
    public void setWelcomeMessage(String welcomeMessage) {
        this.welcomeMessage = welcomeMessage;
    }

    public User withWelcomeMessage(String welcomeMessage) {
        this.welcomeMessage = welcomeMessage;
        return this;
    }

    @JsonProperty("whatsApp")
    public Optional<String> getWhatsApp() {
        return Optional.ofNullable(whatsApp);
    }

    @JsonProperty("whatsApp")
    public void setWhatsApp(String whatsApp) {
        this.whatsApp = whatsApp;
    }

    public User withWhatsApp(String whatsApp) {
        this.whatsApp = whatsApp;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public User withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "avatar":
                if (value instanceof FileResource) {
                    setAvatar(((FileResource) value));
                } else {
                    throw new IllegalArgumentException(("property \"avatar\" is of type \"org.hisp.dhis.api.model.v2_35_13.FileResource\", but got "+ value.getClass().toString()));
                }
                return true;
            case "birthday":
                if (value instanceof Date) {
                    setBirthday(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"birthday\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataViewOrganisationUnits":
                if (value instanceof List) {
                    setDataViewOrganisationUnits(((List<OrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataViewOrganisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.OrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "education":
                if (value instanceof String) {
                    setEducation(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"education\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "email":
                if (value instanceof String) {
                    setEmail(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"email\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "employer":
                if (value instanceof String) {
                    setEmployer(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"employer\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "facebookMessenger":
                if (value instanceof String) {
                    setFacebookMessenger(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"facebookMessenger\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "firstName":
                if (value instanceof String) {
                    setFirstName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"firstName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "gender":
                if (value instanceof String) {
                    setGender(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"gender\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "interests":
                if (value instanceof String) {
                    setInterests(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"interests\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "introduction":
                if (value instanceof String) {
                    setIntroduction(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"introduction\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "jobTitle":
                if (value instanceof String) {
                    setJobTitle(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"jobTitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "languages":
                if (value instanceof String) {
                    setLanguages(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"languages\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastCheckedInterpretations":
                if (value instanceof Date) {
                    setLastCheckedInterpretations(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastCheckedInterpretations\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "nationality":
                if (value instanceof String) {
                    setNationality(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"nationality\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnits":
                if (value instanceof List) {
                    setOrganisationUnits(((List<OrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.OrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "phoneNumber":
                if (value instanceof String) {
                    setPhoneNumber(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"phoneNumber\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skype":
                if (value instanceof String) {
                    setSkype(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"skype\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "surname":
                if (value instanceof String) {
                    setSurname(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"surname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "teiSearchOrganisationUnits":
                if (value instanceof List) {
                    setTeiSearchOrganisationUnits(((List<OrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"teiSearchOrganisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.OrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "telegram":
                if (value instanceof String) {
                    setTelegram(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"telegram\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "twitter":
                if (value instanceof String) {
                    setTwitter(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"twitter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userCredentials":
                if (value instanceof UserCredentials) {
                    setUserCredentials(((UserCredentials) value));
                } else {
                    throw new IllegalArgumentException(("property \"userCredentials\" is of type \"org.hisp.dhis.api.model.v2_35_13.UserCredentials\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroups":
                if (value instanceof List) {
                    setUserGroups(((List<UserGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "welcomeMessage":
                if (value instanceof String) {
                    setWelcomeMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"welcomeMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "whatsApp":
                if (value instanceof String) {
                    setWhatsApp(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"whatsApp\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "attributeValues":
                return getAttributeValues();
            case "avatar":
                return getAvatar();
            case "birthday":
                return getBirthday();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "dataViewOrganisationUnits":
                return getDataViewOrganisationUnits();
            case "displayName":
                return getDisplayName();
            case "education":
                return getEducation();
            case "email":
                return getEmail();
            case "employer":
                return getEmployer();
            case "externalAccess":
                return getExternalAccess();
            case "facebookMessenger":
                return getFacebookMessenger();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "firstName":
                return getFirstName();
            case "gender":
                return getGender();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "interests":
                return getInterests();
            case "introduction":
                return getIntroduction();
            case "jobTitle":
                return getJobTitle();
            case "languages":
                return getLanguages();
            case "lastCheckedInterpretations":
                return getLastCheckedInterpretations();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "name":
                return getName();
            case "nationality":
                return getNationality();
            case "organisationUnits":
                return getOrganisationUnits();
            case "phoneNumber":
                return getPhoneNumber();
            case "publicAccess":
                return getPublicAccess();
            case "skype":
                return getSkype();
            case "surname":
                return getSurname();
            case "teiSearchOrganisationUnits":
                return getTeiSearchOrganisationUnits();
            case "telegram":
                return getTelegram();
            case "translations":
                return getTranslations();
            case "twitter":
                return getTwitter();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userCredentials":
                return getUserCredentials();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "userGroups":
                return getUserGroups();
            case "welcomeMessage":
                return getWelcomeMessage();
            case "whatsApp":
                return getWhatsApp();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, User.NOT_FOUND_VALUE);
        if (User.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public User with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(User.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("avatar");
        sb.append('=');
        sb.append(((this.avatar == null)?"<null>":this.avatar));
        sb.append(',');
        sb.append("birthday");
        sb.append('=');
        sb.append(((this.birthday == null)?"<null>":this.birthday));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataViewOrganisationUnits");
        sb.append('=');
        sb.append(((this.dataViewOrganisationUnits == null)?"<null>":this.dataViewOrganisationUnits));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("education");
        sb.append('=');
        sb.append(((this.education == null)?"<null>":this.education));
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(((this.email == null)?"<null>":this.email));
        sb.append(',');
        sb.append("employer");
        sb.append('=');
        sb.append(((this.employer == null)?"<null>":this.employer));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("facebookMessenger");
        sb.append('=');
        sb.append(((this.facebookMessenger == null)?"<null>":this.facebookMessenger));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("firstName");
        sb.append('=');
        sb.append(((this.firstName == null)?"<null>":this.firstName));
        sb.append(',');
        sb.append("gender");
        sb.append('=');
        sb.append(((this.gender == null)?"<null>":this.gender));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("interests");
        sb.append('=');
        sb.append(((this.interests == null)?"<null>":this.interests));
        sb.append(',');
        sb.append("introduction");
        sb.append('=');
        sb.append(((this.introduction == null)?"<null>":this.introduction));
        sb.append(',');
        sb.append("jobTitle");
        sb.append('=');
        sb.append(((this.jobTitle == null)?"<null>":this.jobTitle));
        sb.append(',');
        sb.append("languages");
        sb.append('=');
        sb.append(((this.languages == null)?"<null>":this.languages));
        sb.append(',');
        sb.append("lastCheckedInterpretations");
        sb.append('=');
        sb.append(((this.lastCheckedInterpretations == null)?"<null>":this.lastCheckedInterpretations));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("nationality");
        sb.append('=');
        sb.append(((this.nationality == null)?"<null>":this.nationality));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("phoneNumber");
        sb.append('=');
        sb.append(((this.phoneNumber == null)?"<null>":this.phoneNumber));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("skype");
        sb.append('=');
        sb.append(((this.skype == null)?"<null>":this.skype));
        sb.append(',');
        sb.append("surname");
        sb.append('=');
        sb.append(((this.surname == null)?"<null>":this.surname));
        sb.append(',');
        sb.append("teiSearchOrganisationUnits");
        sb.append('=');
        sb.append(((this.teiSearchOrganisationUnits == null)?"<null>":this.teiSearchOrganisationUnits));
        sb.append(',');
        sb.append("telegram");
        sb.append('=');
        sb.append(((this.telegram == null)?"<null>":this.telegram));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("twitter");
        sb.append('=');
        sb.append(((this.twitter == null)?"<null>":this.twitter));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userCredentials");
        sb.append('=');
        sb.append(((this.userCredentials == null)?"<null>":this.userCredentials));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userGroups");
        sb.append('=');
        sb.append(((this.userGroups == null)?"<null>":this.userGroups));
        sb.append(',');
        sb.append("welcomeMessage");
        sb.append('=');
        sb.append(((this.welcomeMessage == null)?"<null>":this.welcomeMessage));
        sb.append(',');
        sb.append("whatsApp");
        sb.append('=');
        sb.append(((this.whatsApp == null)?"<null>":this.whatsApp));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.birthday == null)? 0 :this.birthday.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.education == null)? 0 :this.education.hashCode()));
        result = ((result* 31)+((this.gender == null)? 0 :this.gender.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.jobTitle == null)? 0 :this.jobTitle.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.skype == null)? 0 :this.skype.hashCode()));
        result = ((result* 31)+((this.teiSearchOrganisationUnits == null)? 0 :this.teiSearchOrganisationUnits.hashCode()));
        result = ((result* 31)+((this.twitter == null)? 0 :this.twitter.hashCode()));
        result = ((result* 31)+((this.surname == null)? 0 :this.surname.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.employer == null)? 0 :this.employer.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.facebookMessenger == null)? 0 :this.facebookMessenger.hashCode()));
        result = ((result* 31)+((this.email == null)? 0 :this.email.hashCode()));
        result = ((result* 31)+((this.introduction == null)? 0 :this.introduction.hashCode()));
        result = ((result* 31)+((this.dataViewOrganisationUnits == null)? 0 :this.dataViewOrganisationUnits.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.whatsApp == null)? 0 :this.whatsApp.hashCode()));
        result = ((result* 31)+((this.languages == null)? 0 :this.languages.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.welcomeMessage == null)? 0 :this.welcomeMessage.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.userCredentials == null)? 0 :this.userCredentials.hashCode()));
        result = ((result* 31)+((this.telegram == null)? 0 :this.telegram.hashCode()));
        result = ((result* 31)+((this.avatar == null)? 0 :this.avatar.hashCode()));
        result = ((result* 31)+((this.firstName == null)? 0 :this.firstName.hashCode()));
        result = ((result* 31)+((this.lastCheckedInterpretations == null)? 0 :this.lastCheckedInterpretations.hashCode()));
        result = ((result* 31)+((this.userGroups == null)? 0 :this.userGroups.hashCode()));
        result = ((result* 31)+((this.phoneNumber == null)? 0 :this.phoneNumber.hashCode()));
        result = ((result* 31)+((this.nationality == null)? 0 :this.nationality.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.interests == null)? 0 :this.interests.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof User) == false) {
            return false;
        }
        User rhs = ((User) other);
        return ((((((((((((((((((((((((((((((((((((((((((((((this.birthday == rhs.birthday)||((this.birthday!= null)&&this.birthday.equals(rhs.birthday)))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.education == rhs.education)||((this.education!= null)&&this.education.equals(rhs.education))))&&((this.gender == rhs.gender)||((this.gender!= null)&&this.gender.equals(rhs.gender))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.jobTitle == rhs.jobTitle)||((this.jobTitle!= null)&&this.jobTitle.equals(rhs.jobTitle))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.skype == rhs.skype)||((this.skype!= null)&&this.skype.equals(rhs.skype))))&&((this.teiSearchOrganisationUnits == rhs.teiSearchOrganisationUnits)||((this.teiSearchOrganisationUnits!= null)&&this.teiSearchOrganisationUnits.equals(rhs.teiSearchOrganisationUnits))))&&((this.twitter == rhs.twitter)||((this.twitter!= null)&&this.twitter.equals(rhs.twitter))))&&((this.surname == rhs.surname)||((this.surname!= null)&&this.surname.equals(rhs.surname))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.employer == rhs.employer)||((this.employer!= null)&&this.employer.equals(rhs.employer))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.facebookMessenger == rhs.facebookMessenger)||((this.facebookMessenger!= null)&&this.facebookMessenger.equals(rhs.facebookMessenger))))&&((this.email == rhs.email)||((this.email!= null)&&this.email.equals(rhs.email))))&&((this.introduction == rhs.introduction)||((this.introduction!= null)&&this.introduction.equals(rhs.introduction))))&&((this.dataViewOrganisationUnits == rhs.dataViewOrganisationUnits)||((this.dataViewOrganisationUnits!= null)&&this.dataViewOrganisationUnits.equals(rhs.dataViewOrganisationUnits))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.whatsApp == rhs.whatsApp)||((this.whatsApp!= null)&&this.whatsApp.equals(rhs.whatsApp))))&&((this.languages == rhs.languages)||((this.languages!= null)&&this.languages.equals(rhs.languages))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.welcomeMessage == rhs.welcomeMessage)||((this.welcomeMessage!= null)&&this.welcomeMessage.equals(rhs.welcomeMessage))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.userCredentials == rhs.userCredentials)||((this.userCredentials!= null)&&this.userCredentials.equals(rhs.userCredentials))))&&((this.telegram == rhs.telegram)||((this.telegram!= null)&&this.telegram.equals(rhs.telegram))))&&((this.avatar == rhs.avatar)||((this.avatar!= null)&&this.avatar.equals(rhs.avatar))))&&((this.firstName == rhs.firstName)||((this.firstName!= null)&&this.firstName.equals(rhs.firstName))))&&((this.lastCheckedInterpretations == rhs.lastCheckedInterpretations)||((this.lastCheckedInterpretations!= null)&&this.lastCheckedInterpretations.equals(rhs.lastCheckedInterpretations))))&&((this.userGroups == rhs.userGroups)||((this.userGroups!= null)&&this.userGroups.equals(rhs.userGroups))))&&((this.phoneNumber == rhs.phoneNumber)||((this.phoneNumber!= null)&&this.phoneNumber.equals(rhs.phoneNumber))))&&((this.nationality == rhs.nationality)||((this.nationality!= null)&&this.nationality.equals(rhs.nationality))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.interests == rhs.interests)||((this.interests!= null)&&this.interests.equals(rhs.interests))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
