
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "mainId",
    "mainKlass",
    "message",
    "value",
    "warningCode",
    "warningKlass",
    "warningProperties"
})
@Generated("jsonschema2pojo")
public class TrackerWarningReport implements Serializable
{

    @JsonProperty("mainId")
    private String mainId;
    @JsonProperty("mainKlass")
    private String mainKlass;
    @JsonProperty("message")
    private String message;
    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    private Object value;
    @JsonProperty("warningCode")
    private org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport.TrackerErrorCode warningCode;
    @JsonProperty("warningKlass")
    private String warningKlass;
    @JsonProperty("warningProperties")
    private List<String> warningProperties = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2407756347654079782L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerWarningReport() {
    }

    /**
     * 
     * @param source
     */
    public TrackerWarningReport(TrackerWarningReport source) {
        super();
        this.mainId = source.mainId;
        this.mainKlass = source.mainKlass;
        this.message = source.message;
        this.value = source.value;
        this.warningCode = source.warningCode;
        this.warningKlass = source.warningKlass;
        this.warningProperties = source.warningProperties;
    }

    /**
     * 
     * @param warningKlass
     * @param warningCode
     * @param mainKlass
     * @param mainId
     * @param message
     * @param warningProperties
     * @param value
     */
    public TrackerWarningReport(String mainId, String mainKlass, String message, Object value, org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport.TrackerErrorCode warningCode, String warningKlass, List<String> warningProperties) {
        super();
        this.mainId = mainId;
        this.mainKlass = mainKlass;
        this.message = message;
        this.value = value;
        this.warningCode = warningCode;
        this.warningKlass = warningKlass;
        this.warningProperties = warningProperties;
    }

    @JsonProperty("mainId")
    public Optional<String> getMainId() {
        return Optional.ofNullable(mainId);
    }

    @JsonProperty("mainId")
    public void setMainId(String mainId) {
        this.mainId = mainId;
    }

    public TrackerWarningReport withMainId(String mainId) {
        this.mainId = mainId;
        return this;
    }

    @JsonProperty("mainKlass")
    public Optional<String> getMainKlass() {
        return Optional.ofNullable(mainKlass);
    }

    @JsonProperty("mainKlass")
    public void setMainKlass(String mainKlass) {
        this.mainKlass = mainKlass;
    }

    public TrackerWarningReport withMainKlass(String mainKlass) {
        this.mainKlass = mainKlass;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public TrackerWarningReport withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    public Optional<Object> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    public void setValue(Object value) {
        this.value = value;
    }

    public TrackerWarningReport withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonProperty("warningCode")
    public Optional<org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport.TrackerErrorCode> getWarningCode() {
        return Optional.ofNullable(warningCode);
    }

    @JsonProperty("warningCode")
    public void setWarningCode(org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport.TrackerErrorCode warningCode) {
        this.warningCode = warningCode;
    }

    public TrackerWarningReport withWarningCode(org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport.TrackerErrorCode warningCode) {
        this.warningCode = warningCode;
        return this;
    }

    @JsonProperty("warningKlass")
    public Optional<String> getWarningKlass() {
        return Optional.ofNullable(warningKlass);
    }

    @JsonProperty("warningKlass")
    public void setWarningKlass(String warningKlass) {
        this.warningKlass = warningKlass;
    }

    public TrackerWarningReport withWarningKlass(String warningKlass) {
        this.warningKlass = warningKlass;
        return this;
    }

    @JsonProperty("warningProperties")
    public Optional<List<String>> getWarningProperties() {
        return Optional.ofNullable(warningProperties);
    }

    @JsonProperty("warningProperties")
    public void setWarningProperties(List<String> warningProperties) {
        this.warningProperties = warningProperties;
    }

    public TrackerWarningReport withWarningProperties(List<String> warningProperties) {
        this.warningProperties = warningProperties;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerWarningReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "mainId":
                if (value instanceof String) {
                    setMainId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"mainId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mainKlass":
                if (value instanceof String) {
                    setMainKlass(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"mainKlass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "message":
                if (value instanceof String) {
                    setMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "value":
                if (value instanceof Object) {
                    setValue(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "warningCode":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport.TrackerErrorCode) {
                    setWarningCode(((org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport.TrackerErrorCode) value));
                } else {
                    throw new IllegalArgumentException(("property \"warningCode\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport.TrackerErrorCode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "warningKlass":
                if (value instanceof String) {
                    setWarningKlass(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"warningKlass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "warningProperties":
                if (value instanceof List) {
                    setWarningProperties(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"warningProperties\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "mainId":
                return getMainId();
            case "mainKlass":
                return getMainKlass();
            case "message":
                return getMessage();
            case "value":
                return getValue();
            case "warningCode":
                return getWarningCode();
            case "warningKlass":
                return getWarningKlass();
            case "warningProperties":
                return getWarningProperties();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerWarningReport.NOT_FOUND_VALUE);
        if (TrackerWarningReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerWarningReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerWarningReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("mainId");
        sb.append('=');
        sb.append(((this.mainId == null)?"<null>":this.mainId));
        sb.append(',');
        sb.append("mainKlass");
        sb.append('=');
        sb.append(((this.mainKlass == null)?"<null>":this.mainKlass));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("warningCode");
        sb.append('=');
        sb.append(((this.warningCode == null)?"<null>":this.warningCode));
        sb.append(',');
        sb.append("warningKlass");
        sb.append('=');
        sb.append(((this.warningKlass == null)?"<null>":this.warningKlass));
        sb.append(',');
        sb.append("warningProperties");
        sb.append('=');
        sb.append(((this.warningProperties == null)?"<null>":this.warningProperties));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.warningKlass == null)? 0 :this.warningKlass.hashCode()));
        result = ((result* 31)+((this.warningCode == null)? 0 :this.warningCode.hashCode()));
        result = ((result* 31)+((this.mainKlass == null)? 0 :this.mainKlass.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.mainId == null)? 0 :this.mainId.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.warningProperties == null)? 0 :this.warningProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerWarningReport) == false) {
            return false;
        }
        TrackerWarningReport rhs = ((TrackerWarningReport) other);
        return (((((((((this.warningKlass == rhs.warningKlass)||((this.warningKlass!= null)&&this.warningKlass.equals(rhs.warningKlass)))&&((this.warningCode == rhs.warningCode)||((this.warningCode!= null)&&this.warningCode.equals(rhs.warningCode))))&&((this.mainKlass == rhs.mainKlass)||((this.mainKlass!= null)&&this.mainKlass.equals(rhs.mainKlass))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.mainId == rhs.mainId)||((this.mainId!= null)&&this.mainId.equals(rhs.mainId))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.warningProperties == rhs.warningProperties)||((this.warningProperties!= null)&&this.warningProperties.equals(rhs.warningProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

}
