
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorReports",
    "invalidDtos",
    "performanceReport",
    "warningReports"
})
@Generated("jsonschema2pojo")
public class TrackerValidationReport implements Serializable
{

    @JsonProperty("errorReports")
    private List<TrackerErrorReport> errorReports = null;
    @JsonProperty("invalidDtos")
    private List<Object> invalidDtos = null;
    @JsonProperty("performanceReport")
    private List<TrackerValidationHookTimerReport> performanceReport = null;
    @JsonProperty("warningReports")
    private List<TrackerWarningReport> warningReports = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8955622018770035453L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerValidationReport() {
    }

    /**
     * 
     * @param source
     */
    public TrackerValidationReport(TrackerValidationReport source) {
        super();
        this.errorReports = source.errorReports;
        this.invalidDtos = source.invalidDtos;
        this.performanceReport = source.performanceReport;
        this.warningReports = source.warningReports;
    }

    /**
     * 
     * @param invalidDtos
     * @param warningReports
     * @param performanceReport
     * @param errorReports
     */
    public TrackerValidationReport(List<TrackerErrorReport> errorReports, List<Object> invalidDtos, List<TrackerValidationHookTimerReport> performanceReport, List<TrackerWarningReport> warningReports) {
        super();
        this.errorReports = errorReports;
        this.invalidDtos = invalidDtos;
        this.performanceReport = performanceReport;
        this.warningReports = warningReports;
    }

    @JsonProperty("errorReports")
    public Optional<List<TrackerErrorReport>> getErrorReports() {
        return Optional.ofNullable(errorReports);
    }

    @JsonProperty("errorReports")
    public void setErrorReports(List<TrackerErrorReport> errorReports) {
        this.errorReports = errorReports;
    }

    public TrackerValidationReport withErrorReports(List<TrackerErrorReport> errorReports) {
        this.errorReports = errorReports;
        return this;
    }

    @JsonProperty("invalidDtos")
    public Optional<List<Object>> getInvalidDtos() {
        return Optional.ofNullable(invalidDtos);
    }

    @JsonProperty("invalidDtos")
    public void setInvalidDtos(List<Object> invalidDtos) {
        this.invalidDtos = invalidDtos;
    }

    public TrackerValidationReport withInvalidDtos(List<Object> invalidDtos) {
        this.invalidDtos = invalidDtos;
        return this;
    }

    @JsonProperty("performanceReport")
    public Optional<List<TrackerValidationHookTimerReport>> getPerformanceReport() {
        return Optional.ofNullable(performanceReport);
    }

    @JsonProperty("performanceReport")
    public void setPerformanceReport(List<TrackerValidationHookTimerReport> performanceReport) {
        this.performanceReport = performanceReport;
    }

    public TrackerValidationReport withPerformanceReport(List<TrackerValidationHookTimerReport> performanceReport) {
        this.performanceReport = performanceReport;
        return this;
    }

    @JsonProperty("warningReports")
    public Optional<List<TrackerWarningReport>> getWarningReports() {
        return Optional.ofNullable(warningReports);
    }

    @JsonProperty("warningReports")
    public void setWarningReports(List<TrackerWarningReport> warningReports) {
        this.warningReports = warningReports;
    }

    public TrackerValidationReport withWarningReports(List<TrackerWarningReport> warningReports) {
        this.warningReports = warningReports;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerValidationReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "errorReports":
                if (value instanceof List) {
                    setErrorReports(((List<TrackerErrorReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"errorReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackerErrorReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "invalidDtos":
                if (value instanceof List) {
                    setInvalidDtos(((List<Object> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"invalidDtos\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "performanceReport":
                if (value instanceof List) {
                    setPerformanceReport(((List<TrackerValidationHookTimerReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"performanceReport\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackerValidationHookTimerReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "warningReports":
                if (value instanceof List) {
                    setWarningReports(((List<TrackerWarningReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"warningReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackerWarningReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "errorReports":
                return getErrorReports();
            case "invalidDtos":
                return getInvalidDtos();
            case "performanceReport":
                return getPerformanceReport();
            case "warningReports":
                return getWarningReports();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerValidationReport.NOT_FOUND_VALUE);
        if (TrackerValidationReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerValidationReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerValidationReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("errorReports");
        sb.append('=');
        sb.append(((this.errorReports == null)?"<null>":this.errorReports));
        sb.append(',');
        sb.append("invalidDtos");
        sb.append('=');
        sb.append(((this.invalidDtos == null)?"<null>":this.invalidDtos));
        sb.append(',');
        sb.append("performanceReport");
        sb.append('=');
        sb.append(((this.performanceReport == null)?"<null>":this.performanceReport));
        sb.append(',');
        sb.append("warningReports");
        sb.append('=');
        sb.append(((this.warningReports == null)?"<null>":this.warningReports));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.invalidDtos == null)? 0 :this.invalidDtos.hashCode()));
        result = ((result* 31)+((this.warningReports == null)? 0 :this.warningReports.hashCode()));
        result = ((result* 31)+((this.performanceReport == null)? 0 :this.performanceReport.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.errorReports == null)? 0 :this.errorReports.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerValidationReport) == false) {
            return false;
        }
        TrackerValidationReport rhs = ((TrackerValidationReport) other);
        return ((((((this.invalidDtos == rhs.invalidDtos)||((this.invalidDtos!= null)&&this.invalidDtos.equals(rhs.invalidDtos)))&&((this.warningReports == rhs.warningReports)||((this.warningReports!= null)&&this.warningReports.equals(rhs.warningReports))))&&((this.performanceReport == rhs.performanceReport)||((this.performanceReport!= null)&&this.performanceReport.equals(rhs.performanceReport))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.errorReports == rhs.errorReports)||((this.errorReports!= null)&&this.errorReports.equals(rhs.errorReports))));
    }

}
