
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "objectReports",
    "stats",
    "trackerType"
})
@Generated("jsonschema2pojo")
public class TrackerTypeReport implements Serializable
{

    @JsonProperty("objectReports")
    private List<TrackerObjectReport> objectReports = null;
    @JsonProperty("stats")
    private TrackerStats stats;
    @JsonProperty("trackerType")
    private TrackerObjectReport.TrackerType trackerType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1075729824601280678L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerTypeReport() {
    }

    /**
     * 
     * @param source
     */
    public TrackerTypeReport(TrackerTypeReport source) {
        super();
        this.objectReports = source.objectReports;
        this.stats = source.stats;
        this.trackerType = source.trackerType;
    }

    /**
     * 
     * @param objectReports
     * @param stats
     * @param trackerType
     */
    public TrackerTypeReport(List<TrackerObjectReport> objectReports, TrackerStats stats, TrackerObjectReport.TrackerType trackerType) {
        super();
        this.objectReports = objectReports;
        this.stats = stats;
        this.trackerType = trackerType;
    }

    @JsonProperty("objectReports")
    public Optional<List<TrackerObjectReport>> getObjectReports() {
        return Optional.ofNullable(objectReports);
    }

    @JsonProperty("objectReports")
    public void setObjectReports(List<TrackerObjectReport> objectReports) {
        this.objectReports = objectReports;
    }

    public TrackerTypeReport withObjectReports(List<TrackerObjectReport> objectReports) {
        this.objectReports = objectReports;
        return this;
    }

    @JsonProperty("stats")
    public Optional<TrackerStats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(TrackerStats stats) {
        this.stats = stats;
    }

    public TrackerTypeReport withStats(TrackerStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty("trackerType")
    public Optional<TrackerObjectReport.TrackerType> getTrackerType() {
        return Optional.ofNullable(trackerType);
    }

    @JsonProperty("trackerType")
    public void setTrackerType(TrackerObjectReport.TrackerType trackerType) {
        this.trackerType = trackerType;
    }

    public TrackerTypeReport withTrackerType(TrackerObjectReport.TrackerType trackerType) {
        this.trackerType = trackerType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerTypeReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "objectReports":
                if (value instanceof List) {
                    setObjectReports(((List<TrackerObjectReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"objectReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackerObjectReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "stats":
                if (value instanceof TrackerStats) {
                    setStats(((TrackerStats) value));
                } else {
                    throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerStats\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackerType":
                if (value instanceof TrackerObjectReport.TrackerType) {
                    setTrackerType(((TrackerObjectReport.TrackerType) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackerType\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerObjectReport.TrackerType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "objectReports":
                return getObjectReports();
            case "stats":
                return getStats();
            case "trackerType":
                return getTrackerType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerTypeReport.NOT_FOUND_VALUE);
        if (TrackerTypeReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerTypeReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerTypeReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("objectReports");
        sb.append('=');
        sb.append(((this.objectReports == null)?"<null>":this.objectReports));
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("trackerType");
        sb.append('=');
        sb.append(((this.trackerType == null)?"<null>":this.trackerType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.trackerType == null)? 0 :this.trackerType.hashCode()));
        result = ((result* 31)+((this.objectReports == null)? 0 :this.objectReports.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerTypeReport) == false) {
            return false;
        }
        TrackerTypeReport rhs = ((TrackerTypeReport) other);
        return (((((this.trackerType == rhs.trackerType)||((this.trackerType!= null)&&this.trackerType.equals(rhs.trackerType)))&&((this.objectReports == rhs.objectReports)||((this.objectReports!= null)&&this.objectReports.equals(rhs.objectReports))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))));
    }

}
