
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "commit",
    "preheat",
    "prepareRequest",
    "programrule",
    "totalImport",
    "totalRequest",
    "validation"
})
@Generated("jsonschema2pojo")
public class TrackerTimingsStats implements Serializable
{

    @JsonProperty("commit")
    private String commit;
    @JsonProperty("preheat")
    private String preheat;
    @JsonProperty("prepareRequest")
    private String prepareRequest;
    @JsonProperty("programrule")
    private String programrule;
    @JsonProperty("totalImport")
    private String totalImport;
    @JsonProperty("totalRequest")
    private String totalRequest;
    @JsonProperty("validation")
    private String validation;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4524482071052545011L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerTimingsStats() {
    }

    /**
     * 
     * @param source
     */
    public TrackerTimingsStats(TrackerTimingsStats source) {
        super();
        this.commit = source.commit;
        this.preheat = source.preheat;
        this.prepareRequest = source.prepareRequest;
        this.programrule = source.programrule;
        this.totalImport = source.totalImport;
        this.totalRequest = source.totalRequest;
        this.validation = source.validation;
    }

    /**
     * 
     * @param preheat
     * @param commit
     * @param prepareRequest
     * @param programrule
     * @param totalImport
     * @param validation
     * @param totalRequest
     */
    public TrackerTimingsStats(String commit, String preheat, String prepareRequest, String programrule, String totalImport, String totalRequest, String validation) {
        super();
        this.commit = commit;
        this.preheat = preheat;
        this.prepareRequest = prepareRequest;
        this.programrule = programrule;
        this.totalImport = totalImport;
        this.totalRequest = totalRequest;
        this.validation = validation;
    }

    @JsonProperty("commit")
    public Optional<String> getCommit() {
        return Optional.ofNullable(commit);
    }

    @JsonProperty("commit")
    public void setCommit(String commit) {
        this.commit = commit;
    }

    public TrackerTimingsStats withCommit(String commit) {
        this.commit = commit;
        return this;
    }

    @JsonProperty("preheat")
    public Optional<String> getPreheat() {
        return Optional.ofNullable(preheat);
    }

    @JsonProperty("preheat")
    public void setPreheat(String preheat) {
        this.preheat = preheat;
    }

    public TrackerTimingsStats withPreheat(String preheat) {
        this.preheat = preheat;
        return this;
    }

    @JsonProperty("prepareRequest")
    public Optional<String> getPrepareRequest() {
        return Optional.ofNullable(prepareRequest);
    }

    @JsonProperty("prepareRequest")
    public void setPrepareRequest(String prepareRequest) {
        this.prepareRequest = prepareRequest;
    }

    public TrackerTimingsStats withPrepareRequest(String prepareRequest) {
        this.prepareRequest = prepareRequest;
        return this;
    }

    @JsonProperty("programrule")
    public Optional<String> getProgramrule() {
        return Optional.ofNullable(programrule);
    }

    @JsonProperty("programrule")
    public void setProgramrule(String programrule) {
        this.programrule = programrule;
    }

    public TrackerTimingsStats withProgramrule(String programrule) {
        this.programrule = programrule;
        return this;
    }

    @JsonProperty("totalImport")
    public Optional<String> getTotalImport() {
        return Optional.ofNullable(totalImport);
    }

    @JsonProperty("totalImport")
    public void setTotalImport(String totalImport) {
        this.totalImport = totalImport;
    }

    public TrackerTimingsStats withTotalImport(String totalImport) {
        this.totalImport = totalImport;
        return this;
    }

    @JsonProperty("totalRequest")
    public Optional<String> getTotalRequest() {
        return Optional.ofNullable(totalRequest);
    }

    @JsonProperty("totalRequest")
    public void setTotalRequest(String totalRequest) {
        this.totalRequest = totalRequest;
    }

    public TrackerTimingsStats withTotalRequest(String totalRequest) {
        this.totalRequest = totalRequest;
        return this;
    }

    @JsonProperty("validation")
    public Optional<String> getValidation() {
        return Optional.ofNullable(validation);
    }

    @JsonProperty("validation")
    public void setValidation(String validation) {
        this.validation = validation;
    }

    public TrackerTimingsStats withValidation(String validation) {
        this.validation = validation;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerTimingsStats withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "commit":
                if (value instanceof String) {
                    setCommit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"commit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "preheat":
                if (value instanceof String) {
                    setPreheat(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"preheat\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "prepareRequest":
                if (value instanceof String) {
                    setPrepareRequest(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"prepareRequest\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programrule":
                if (value instanceof String) {
                    setProgramrule(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"programrule\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "totalImport":
                if (value instanceof String) {
                    setTotalImport(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"totalImport\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "totalRequest":
                if (value instanceof String) {
                    setTotalRequest(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"totalRequest\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validation":
                if (value instanceof String) {
                    setValidation(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"validation\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "commit":
                return getCommit();
            case "preheat":
                return getPreheat();
            case "prepareRequest":
                return getPrepareRequest();
            case "programrule":
                return getProgramrule();
            case "totalImport":
                return getTotalImport();
            case "totalRequest":
                return getTotalRequest();
            case "validation":
                return getValidation();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerTimingsStats.NOT_FOUND_VALUE);
        if (TrackerTimingsStats.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerTimingsStats with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerTimingsStats.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("commit");
        sb.append('=');
        sb.append(((this.commit == null)?"<null>":this.commit));
        sb.append(',');
        sb.append("preheat");
        sb.append('=');
        sb.append(((this.preheat == null)?"<null>":this.preheat));
        sb.append(',');
        sb.append("prepareRequest");
        sb.append('=');
        sb.append(((this.prepareRequest == null)?"<null>":this.prepareRequest));
        sb.append(',');
        sb.append("programrule");
        sb.append('=');
        sb.append(((this.programrule == null)?"<null>":this.programrule));
        sb.append(',');
        sb.append("totalImport");
        sb.append('=');
        sb.append(((this.totalImport == null)?"<null>":this.totalImport));
        sb.append(',');
        sb.append("totalRequest");
        sb.append('=');
        sb.append(((this.totalRequest == null)?"<null>":this.totalRequest));
        sb.append(',');
        sb.append("validation");
        sb.append('=');
        sb.append(((this.validation == null)?"<null>":this.validation));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.preheat == null)? 0 :this.preheat.hashCode()));
        result = ((result* 31)+((this.commit == null)? 0 :this.commit.hashCode()));
        result = ((result* 31)+((this.prepareRequest == null)? 0 :this.prepareRequest.hashCode()));
        result = ((result* 31)+((this.programrule == null)? 0 :this.programrule.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.totalImport == null)? 0 :this.totalImport.hashCode()));
        result = ((result* 31)+((this.validation == null)? 0 :this.validation.hashCode()));
        result = ((result* 31)+((this.totalRequest == null)? 0 :this.totalRequest.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerTimingsStats) == false) {
            return false;
        }
        TrackerTimingsStats rhs = ((TrackerTimingsStats) other);
        return (((((((((this.preheat == rhs.preheat)||((this.preheat!= null)&&this.preheat.equals(rhs.preheat)))&&((this.commit == rhs.commit)||((this.commit!= null)&&this.commit.equals(rhs.commit))))&&((this.prepareRequest == rhs.prepareRequest)||((this.prepareRequest!= null)&&this.prepareRequest.equals(rhs.prepareRequest))))&&((this.programrule == rhs.programrule)||((this.programrule!= null)&&this.programrule.equals(rhs.programrule))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.totalImport == rhs.totalImport)||((this.totalImport!= null)&&this.totalImport.equals(rhs.totalImport))))&&((this.validation == rhs.validation)||((this.validation!= null)&&this.validation.equals(rhs.validation))))&&((this.totalRequest == rhs.totalRequest)||((this.totalRequest!= null)&&this.totalRequest.equals(rhs.totalRequest))));
    }

}
