
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "enrollments",
    "events",
    "identifiers",
    "relationships",
    "trackedEntities",
    "userId",
    "username"
})
@Generated("jsonschema2pojo")
public class TrackerPreheatParams implements Serializable
{

    @JsonProperty("enrollments")
    private List<Enrollment__1> enrollments = null;
    @JsonProperty("events")
    private List<Event__1> events = null;
    @JsonProperty("identifiers")
    private TrackerIdentifierParams identifiers;
    @JsonProperty("relationships")
    private List<Relationship__1> relationships = null;
    @JsonProperty("trackedEntities")
    private List<TrackedEntity> trackedEntities = null;
    @JsonProperty("userId")
    private String userId;
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6558512159783649951L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerPreheatParams() {
    }

    /**
     * 
     * @param source
     */
    public TrackerPreheatParams(TrackerPreheatParams source) {
        super();
        this.enrollments = source.enrollments;
        this.events = source.events;
        this.identifiers = source.identifiers;
        this.relationships = source.relationships;
        this.trackedEntities = source.trackedEntities;
        this.userId = source.userId;
        this.username = source.username;
    }

    /**
     * 
     * @param relationships
     * @param identifiers
     * @param trackedEntities
     * @param userId
     * @param events
     * @param enrollments
     * @param username
     */
    public TrackerPreheatParams(List<Enrollment__1> enrollments, List<Event__1> events, TrackerIdentifierParams identifiers, List<Relationship__1> relationships, List<TrackedEntity> trackedEntities, String userId, String username) {
        super();
        this.enrollments = enrollments;
        this.events = events;
        this.identifiers = identifiers;
        this.relationships = relationships;
        this.trackedEntities = trackedEntities;
        this.userId = userId;
        this.username = username;
    }

    @JsonProperty("enrollments")
    public Optional<List<Enrollment__1>> getEnrollments() {
        return Optional.ofNullable(enrollments);
    }

    @JsonProperty("enrollments")
    public void setEnrollments(List<Enrollment__1> enrollments) {
        this.enrollments = enrollments;
    }

    public TrackerPreheatParams withEnrollments(List<Enrollment__1> enrollments) {
        this.enrollments = enrollments;
        return this;
    }

    @JsonProperty("events")
    public Optional<List<Event__1>> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(List<Event__1> events) {
        this.events = events;
    }

    public TrackerPreheatParams withEvents(List<Event__1> events) {
        this.events = events;
        return this;
    }

    @JsonProperty("identifiers")
    public Optional<TrackerIdentifierParams> getIdentifiers() {
        return Optional.ofNullable(identifiers);
    }

    @JsonProperty("identifiers")
    public void setIdentifiers(TrackerIdentifierParams identifiers) {
        this.identifiers = identifiers;
    }

    public TrackerPreheatParams withIdentifiers(TrackerIdentifierParams identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<List<Relationship__1>> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(List<Relationship__1> relationships) {
        this.relationships = relationships;
    }

    public TrackerPreheatParams withRelationships(List<Relationship__1> relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("trackedEntities")
    public Optional<List<TrackedEntity>> getTrackedEntities() {
        return Optional.ofNullable(trackedEntities);
    }

    @JsonProperty("trackedEntities")
    public void setTrackedEntities(List<TrackedEntity> trackedEntities) {
        this.trackedEntities = trackedEntities;
    }

    public TrackerPreheatParams withTrackedEntities(List<TrackedEntity> trackedEntities) {
        this.trackedEntities = trackedEntities;
        return this;
    }

    @JsonProperty("userId")
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    @JsonProperty("userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public TrackerPreheatParams withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public TrackerPreheatParams withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerPreheatParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "enrollments":
                if (value instanceof List) {
                    setEnrollments(((List<Enrollment__1> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollments\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Enrollment__1>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "events":
                if (value instanceof List) {
                    setEvents(((List<Event__1> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"events\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Event__1>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "identifiers":
                if (value instanceof TrackerIdentifierParams) {
                    setIdentifiers(((TrackerIdentifierParams) value));
                } else {
                    throw new IllegalArgumentException(("property \"identifiers\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerIdentifierParams\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relationships":
                if (value instanceof List) {
                    setRelationships(((List<Relationship__1> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"relationships\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Relationship__1>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntities":
                if (value instanceof List) {
                    setTrackedEntities(((List<TrackedEntity> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntities\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackedEntity>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userId":
                if (value instanceof String) {
                    setUserId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"userId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "username":
                if (value instanceof String) {
                    setUsername(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "enrollments":
                return getEnrollments();
            case "events":
                return getEvents();
            case "identifiers":
                return getIdentifiers();
            case "relationships":
                return getRelationships();
            case "trackedEntities":
                return getTrackedEntities();
            case "userId":
                return getUserId();
            case "username":
                return getUsername();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerPreheatParams.NOT_FOUND_VALUE);
        if (TrackerPreheatParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerPreheatParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerPreheatParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enrollments");
        sb.append('=');
        sb.append(((this.enrollments == null)?"<null>":this.enrollments));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("identifiers");
        sb.append('=');
        sb.append(((this.identifiers == null)?"<null>":this.identifiers));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("trackedEntities");
        sb.append('=');
        sb.append(((this.trackedEntities == null)?"<null>":this.trackedEntities));
        sb.append(',');
        sb.append("userId");
        sb.append('=');
        sb.append(((this.userId == null)?"<null>":this.userId));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.identifiers == null)? 0 :this.identifiers.hashCode()));
        result = ((result* 31)+((this.trackedEntities == null)? 0 :this.trackedEntities.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.userId == null)? 0 :this.userId.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.enrollments == null)? 0 :this.enrollments.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerPreheatParams) == false) {
            return false;
        }
        TrackerPreheatParams rhs = ((TrackerPreheatParams) other);
        return (((((((((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships)))&&((this.identifiers == rhs.identifiers)||((this.identifiers!= null)&&this.identifiers.equals(rhs.identifiers))))&&((this.trackedEntities == rhs.trackedEntities)||((this.trackedEntities!= null)&&this.trackedEntities.equals(rhs.trackedEntities))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.userId == rhs.userId)||((this.userId!= null)&&this.userId.equals(rhs.userId))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.enrollments == rhs.enrollments)||((this.enrollments!= null)&&this.enrollments.equals(rhs.enrollments))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

}
