
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "stats",
    "status",
    "timings",
    "trackerValidationReport"
})
@Generated("jsonschema2pojo")
public class TrackerImportReport implements Serializable
{

    @JsonProperty("stats")
    private TrackerStats stats;
    @JsonProperty("status")
    private org.hisp.dhis.api.model.v2_35_13.TrackerBundleReport.TrackerStatus status;
    @JsonProperty("timings")
    private TrackerTimingsStats timings;
    @JsonProperty("trackerValidationReport")
    private TrackerValidationReport trackerValidationReport;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6787629217896249651L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerImportReport() {
    }

    /**
     * 
     * @param source
     */
    public TrackerImportReport(TrackerImportReport source) {
        super();
        this.stats = source.stats;
        this.status = source.status;
        this.timings = source.timings;
        this.trackerValidationReport = source.trackerValidationReport;
    }

    /**
     * 
     * @param trackerValidationReport
     * @param stats
     * @param timings
     * @param status
     */
    public TrackerImportReport(TrackerStats stats, org.hisp.dhis.api.model.v2_35_13.TrackerBundleReport.TrackerStatus status, TrackerTimingsStats timings, TrackerValidationReport trackerValidationReport) {
        super();
        this.stats = stats;
        this.status = status;
        this.timings = timings;
        this.trackerValidationReport = trackerValidationReport;
    }

    @JsonProperty("stats")
    public Optional<TrackerStats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(TrackerStats stats) {
        this.stats = stats;
    }

    public TrackerImportReport withStats(TrackerStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty("status")
    public Optional<org.hisp.dhis.api.model.v2_35_13.TrackerBundleReport.TrackerStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(org.hisp.dhis.api.model.v2_35_13.TrackerBundleReport.TrackerStatus status) {
        this.status = status;
    }

    public TrackerImportReport withStatus(org.hisp.dhis.api.model.v2_35_13.TrackerBundleReport.TrackerStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty("timings")
    public Optional<TrackerTimingsStats> getTimings() {
        return Optional.ofNullable(timings);
    }

    @JsonProperty("timings")
    public void setTimings(TrackerTimingsStats timings) {
        this.timings = timings;
    }

    public TrackerImportReport withTimings(TrackerTimingsStats timings) {
        this.timings = timings;
        return this;
    }

    @JsonProperty("trackerValidationReport")
    public Optional<TrackerValidationReport> getTrackerValidationReport() {
        return Optional.ofNullable(trackerValidationReport);
    }

    @JsonProperty("trackerValidationReport")
    public void setTrackerValidationReport(TrackerValidationReport trackerValidationReport) {
        this.trackerValidationReport = trackerValidationReport;
    }

    public TrackerImportReport withTrackerValidationReport(TrackerValidationReport trackerValidationReport) {
        this.trackerValidationReport = trackerValidationReport;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerImportReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "stats":
                if (value instanceof TrackerStats) {
                    setStats(((TrackerStats) value));
                } else {
                    throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerStats\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.TrackerBundleReport.TrackerStatus) {
                    setStatus(((org.hisp.dhis.api.model.v2_35_13.TrackerBundleReport.TrackerStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerBundleReport.TrackerStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            case "timings":
                if (value instanceof TrackerTimingsStats) {
                    setTimings(((TrackerTimingsStats) value));
                } else {
                    throw new IllegalArgumentException(("property \"timings\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerTimingsStats\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackerValidationReport":
                if (value instanceof TrackerValidationReport) {
                    setTrackerValidationReport(((TrackerValidationReport) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackerValidationReport\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerValidationReport\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "stats":
                return getStats();
            case "status":
                return getStatus();
            case "timings":
                return getTimings();
            case "trackerValidationReport":
                return getTrackerValidationReport();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerImportReport.NOT_FOUND_VALUE);
        if (TrackerImportReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerImportReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerImportReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("timings");
        sb.append('=');
        sb.append(((this.timings == null)?"<null>":this.timings));
        sb.append(',');
        sb.append("trackerValidationReport");
        sb.append('=');
        sb.append(((this.trackerValidationReport == null)?"<null>":this.trackerValidationReport));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.trackerValidationReport == null)? 0 :this.trackerValidationReport.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        result = ((result* 31)+((this.timings == null)? 0 :this.timings.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerImportReport) == false) {
            return false;
        }
        TrackerImportReport rhs = ((TrackerImportReport) other);
        return ((((((this.trackerValidationReport == rhs.trackerValidationReport)||((this.trackerValidationReport!= null)&&this.trackerValidationReport.equals(rhs.trackerValidationReport)))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))))&&((this.timings == rhs.timings)||((this.timings!= null)&&this.timings.equals(rhs.timings))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
