
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "allowGenerateNextVisit",
    "attributeValues",
    "autoGenerateEvent",
    "blockEntryForm",
    "code",
    "created",
    "dataEntryForm",
    "description",
    "displayDescription",
    "displayDueDateLabel",
    "displayExecutionDateLabel",
    "displayFormName",
    "displayGenerateEventBox",
    "displayName",
    "displayShortName",
    "dueDateLabel",
    "enableUserAssignment",
    "executionDateLabel",
    "externalAccess",
    "favorite",
    "favorites",
    "featureType",
    "formName",
    "formType",
    "generatedByEnrollmentDate",
    "hideDueDate",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "minDaysFromStart",
    "name",
    "nextScheduleDate",
    "notificationTemplates",
    "openAfterEnrollment",
    "periodType",
    "preGenerateUID",
    "program",
    "programStageDataElements",
    "programStageSections",
    "publicAccess",
    "remindCompleted",
    "repeatable",
    "reportDateToUse",
    "shortName",
    "sortOrder",
    "standardInterval",
    "style",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "validationStrategy"
})
@Generated("jsonschema2pojo")
public class ProgramStage implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("allowGenerateNextVisit")
    private Boolean allowGenerateNextVisit;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("autoGenerateEvent")
    private Boolean autoGenerateEvent;
    @JsonProperty("blockEntryForm")
    private Boolean blockEntryForm;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dataEntryForm")
    private DataEntryForm dataEntryForm;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayDueDateLabel")
    private String displayDueDateLabel;
    @JsonProperty("displayExecutionDateLabel")
    private String displayExecutionDateLabel;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayGenerateEventBox")
    private Boolean displayGenerateEventBox;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("dueDateLabel")
    private String dueDateLabel;
    @JsonProperty("enableUserAssignment")
    private Boolean enableUserAssignment;
    @JsonProperty("executionDateLabel")
    private String executionDateLabel;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("featureType")
    private ProgramStage.FeatureType featureType;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("formType")
    private ProgramStage.FormType formType;
    @JsonProperty("generatedByEnrollmentDate")
    private Boolean generatedByEnrollmentDate;
    @JsonProperty("hideDueDate")
    private Boolean hideDueDate;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("minDaysFromStart")
    private Integer minDaysFromStart;
    @JsonProperty("name")
    private String name;
    @JsonProperty("nextScheduleDate")
    private DataElement nextScheduleDate;
    @JsonProperty("notificationTemplates")
    private List<ProgramNotificationTemplate> notificationTemplates = null;
    @JsonProperty("openAfterEnrollment")
    private Boolean openAfterEnrollment;
    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    private Object periodType;
    @JsonProperty("preGenerateUID")
    private Boolean preGenerateUID;
    @JsonProperty("program")
    private Program program;
    @JsonProperty("programStageDataElements")
    private List<ProgramStageDataElement> programStageDataElements = null;
    @JsonProperty("programStageSections")
    private List<ProgramStageSection> programStageSections = null;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("remindCompleted")
    private Boolean remindCompleted;
    @JsonProperty("repeatable")
    private Boolean repeatable;
    @JsonProperty("reportDateToUse")
    private String reportDateToUse;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("standardInterval")
    private Integer standardInterval;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("validationStrategy")
    private ProgramStage.ValidationStrategy validationStrategy;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 5234593502585742289L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramStage() {
    }

    /**
     * 
     * @param source
     */
    public ProgramStage(ProgramStage source) {
        super();
        this.access = source.access;
        this.allowGenerateNextVisit = source.allowGenerateNextVisit;
        this.attributeValues = source.attributeValues;
        this.autoGenerateEvent = source.autoGenerateEvent;
        this.blockEntryForm = source.blockEntryForm;
        this.code = source.code;
        this.created = source.created;
        this.dataEntryForm = source.dataEntryForm;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayDueDateLabel = source.displayDueDateLabel;
        this.displayExecutionDateLabel = source.displayExecutionDateLabel;
        this.displayFormName = source.displayFormName;
        this.displayGenerateEventBox = source.displayGenerateEventBox;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.dueDateLabel = source.dueDateLabel;
        this.enableUserAssignment = source.enableUserAssignment;
        this.executionDateLabel = source.executionDateLabel;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.featureType = source.featureType;
        this.formName = source.formName;
        this.formType = source.formType;
        this.generatedByEnrollmentDate = source.generatedByEnrollmentDate;
        this.hideDueDate = source.hideDueDate;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.minDaysFromStart = source.minDaysFromStart;
        this.name = source.name;
        this.nextScheduleDate = source.nextScheduleDate;
        this.notificationTemplates = source.notificationTemplates;
        this.openAfterEnrollment = source.openAfterEnrollment;
        this.periodType = source.periodType;
        this.preGenerateUID = source.preGenerateUID;
        this.program = source.program;
        this.programStageDataElements = source.programStageDataElements;
        this.programStageSections = source.programStageSections;
        this.publicAccess = source.publicAccess;
        this.remindCompleted = source.remindCompleted;
        this.repeatable = source.repeatable;
        this.reportDateToUse = source.reportDateToUse;
        this.shortName = source.shortName;
        this.sortOrder = source.sortOrder;
        this.standardInterval = source.standardInterval;
        this.style = source.style;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.validationStrategy = source.validationStrategy;
    }

    /**
     * 
     * @param allowGenerateNextVisit
     * @param dataEntryForm
     * @param publicAccess
     * @param reportDateToUse
     * @param program
     * @param lastUpdated
     * @param programStageDataElements
     * @param translations
     * @param href
     * @param id
     * @param displayDescription
     * @param lastUpdatedBy
     * @param formType
     * @param userGroupAccesses
     * @param generatedByEnrollmentDate
     * @param created
     * @param attributeValues
     * @param displayFormName
     * @param sortOrder
     * @param userAccesses
     * @param hideDueDate
     * @param name
     * @param enableUserAssignment
     * @param style
     * @param shortName
     * @param favorite
     * @param minDaysFromStart
     * @param standardInterval
     * @param dueDateLabel
     * @param executionDateLabel
     * @param favorites
     * @param access
     * @param code
     * @param preGenerateUID
     * @param displayName
     * @param description
     * @param displayShortName
     * @param displayExecutionDateLabel
     * @param externalAccess
     * @param notificationTemplates
     * @param openAfterEnrollment
     * @param repeatable
     * @param formName
     * @param featureType
     * @param remindCompleted
     * @param displayGenerateEventBox
     * @param nextScheduleDate
     * @param validationStrategy
     * @param autoGenerateEvent
     * @param periodType
     * @param displayDueDateLabel
     * @param blockEntryForm
     * @param user
     * @param programStageSections
     */
    public ProgramStage(Access access, Boolean allowGenerateNextVisit, List<AttributeValue> attributeValues, Boolean autoGenerateEvent, Boolean blockEntryForm, String code, Date created, DataEntryForm dataEntryForm, String description, String displayDescription, String displayDueDateLabel, String displayExecutionDateLabel, String displayFormName, Boolean displayGenerateEventBox, String displayName, String displayShortName, String dueDateLabel, Boolean enableUserAssignment, String executionDateLabel, Boolean externalAccess, Boolean favorite, List<String> favorites, ProgramStage.FeatureType featureType, String formName, ProgramStage.FormType formType, Boolean generatedByEnrollmentDate, Boolean hideDueDate, String href, String id, Date lastUpdated, User lastUpdatedBy, Integer minDaysFromStart, String name, DataElement nextScheduleDate, List<ProgramNotificationTemplate> notificationTemplates, Boolean openAfterEnrollment, Object periodType, Boolean preGenerateUID, Program program, List<ProgramStageDataElement> programStageDataElements, List<ProgramStageSection> programStageSections, String publicAccess, Boolean remindCompleted, Boolean repeatable, String reportDateToUse, String shortName, Integer sortOrder, Integer standardInterval, ObjectStyle style, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, ProgramStage.ValidationStrategy validationStrategy) {
        super();
        this.access = access;
        this.allowGenerateNextVisit = allowGenerateNextVisit;
        this.attributeValues = attributeValues;
        this.autoGenerateEvent = autoGenerateEvent;
        this.blockEntryForm = blockEntryForm;
        this.code = code;
        this.created = created;
        this.dataEntryForm = dataEntryForm;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayDueDateLabel = displayDueDateLabel;
        this.displayExecutionDateLabel = displayExecutionDateLabel;
        this.displayFormName = displayFormName;
        this.displayGenerateEventBox = displayGenerateEventBox;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.dueDateLabel = dueDateLabel;
        this.enableUserAssignment = enableUserAssignment;
        this.executionDateLabel = executionDateLabel;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.featureType = featureType;
        this.formName = formName;
        this.formType = formType;
        this.generatedByEnrollmentDate = generatedByEnrollmentDate;
        this.hideDueDate = hideDueDate;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.minDaysFromStart = minDaysFromStart;
        this.name = name;
        this.nextScheduleDate = nextScheduleDate;
        this.notificationTemplates = notificationTemplates;
        this.openAfterEnrollment = openAfterEnrollment;
        this.periodType = periodType;
        this.preGenerateUID = preGenerateUID;
        this.program = program;
        this.programStageDataElements = programStageDataElements;
        this.programStageSections = programStageSections;
        this.publicAccess = publicAccess;
        this.remindCompleted = remindCompleted;
        this.repeatable = repeatable;
        this.reportDateToUse = reportDateToUse;
        this.shortName = shortName;
        this.sortOrder = sortOrder;
        this.standardInterval = standardInterval;
        this.style = style;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.validationStrategy = validationStrategy;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramStage withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("allowGenerateNextVisit")
    public Optional<Boolean> getAllowGenerateNextVisit() {
        return Optional.ofNullable(allowGenerateNextVisit);
    }

    @JsonProperty("allowGenerateNextVisit")
    public void setAllowGenerateNextVisit(Boolean allowGenerateNextVisit) {
        this.allowGenerateNextVisit = allowGenerateNextVisit;
    }

    public ProgramStage withAllowGenerateNextVisit(Boolean allowGenerateNextVisit) {
        this.allowGenerateNextVisit = allowGenerateNextVisit;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramStage withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("autoGenerateEvent")
    public Optional<Boolean> getAutoGenerateEvent() {
        return Optional.ofNullable(autoGenerateEvent);
    }

    @JsonProperty("autoGenerateEvent")
    public void setAutoGenerateEvent(Boolean autoGenerateEvent) {
        this.autoGenerateEvent = autoGenerateEvent;
    }

    public ProgramStage withAutoGenerateEvent(Boolean autoGenerateEvent) {
        this.autoGenerateEvent = autoGenerateEvent;
        return this;
    }

    @JsonProperty("blockEntryForm")
    public Optional<Boolean> getBlockEntryForm() {
        return Optional.ofNullable(blockEntryForm);
    }

    @JsonProperty("blockEntryForm")
    public void setBlockEntryForm(Boolean blockEntryForm) {
        this.blockEntryForm = blockEntryForm;
    }

    public ProgramStage withBlockEntryForm(Boolean blockEntryForm) {
        this.blockEntryForm = blockEntryForm;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramStage withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramStage withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataEntryForm")
    public Optional<DataEntryForm> getDataEntryForm() {
        return Optional.ofNullable(dataEntryForm);
    }

    @JsonProperty("dataEntryForm")
    public void setDataEntryForm(DataEntryForm dataEntryForm) {
        this.dataEntryForm = dataEntryForm;
    }

    public ProgramStage withDataEntryForm(DataEntryForm dataEntryForm) {
        this.dataEntryForm = dataEntryForm;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ProgramStage withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public ProgramStage withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayDueDateLabel")
    public Optional<String> getDisplayDueDateLabel() {
        return Optional.ofNullable(displayDueDateLabel);
    }

    @JsonProperty("displayDueDateLabel")
    public void setDisplayDueDateLabel(String displayDueDateLabel) {
        this.displayDueDateLabel = displayDueDateLabel;
    }

    public ProgramStage withDisplayDueDateLabel(String displayDueDateLabel) {
        this.displayDueDateLabel = displayDueDateLabel;
        return this;
    }

    @JsonProperty("displayExecutionDateLabel")
    public Optional<String> getDisplayExecutionDateLabel() {
        return Optional.ofNullable(displayExecutionDateLabel);
    }

    @JsonProperty("displayExecutionDateLabel")
    public void setDisplayExecutionDateLabel(String displayExecutionDateLabel) {
        this.displayExecutionDateLabel = displayExecutionDateLabel;
    }

    public ProgramStage withDisplayExecutionDateLabel(String displayExecutionDateLabel) {
        this.displayExecutionDateLabel = displayExecutionDateLabel;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public ProgramStage withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayGenerateEventBox")
    public Optional<Boolean> getDisplayGenerateEventBox() {
        return Optional.ofNullable(displayGenerateEventBox);
    }

    @JsonProperty("displayGenerateEventBox")
    public void setDisplayGenerateEventBox(Boolean displayGenerateEventBox) {
        this.displayGenerateEventBox = displayGenerateEventBox;
    }

    public ProgramStage withDisplayGenerateEventBox(Boolean displayGenerateEventBox) {
        this.displayGenerateEventBox = displayGenerateEventBox;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramStage withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public ProgramStage withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("dueDateLabel")
    public Optional<String> getDueDateLabel() {
        return Optional.ofNullable(dueDateLabel);
    }

    @JsonProperty("dueDateLabel")
    public void setDueDateLabel(String dueDateLabel) {
        this.dueDateLabel = dueDateLabel;
    }

    public ProgramStage withDueDateLabel(String dueDateLabel) {
        this.dueDateLabel = dueDateLabel;
        return this;
    }

    @JsonProperty("enableUserAssignment")
    public Optional<Boolean> getEnableUserAssignment() {
        return Optional.ofNullable(enableUserAssignment);
    }

    @JsonProperty("enableUserAssignment")
    public void setEnableUserAssignment(Boolean enableUserAssignment) {
        this.enableUserAssignment = enableUserAssignment;
    }

    public ProgramStage withEnableUserAssignment(Boolean enableUserAssignment) {
        this.enableUserAssignment = enableUserAssignment;
        return this;
    }

    @JsonProperty("executionDateLabel")
    public Optional<String> getExecutionDateLabel() {
        return Optional.ofNullable(executionDateLabel);
    }

    @JsonProperty("executionDateLabel")
    public void setExecutionDateLabel(String executionDateLabel) {
        this.executionDateLabel = executionDateLabel;
    }

    public ProgramStage withExecutionDateLabel(String executionDateLabel) {
        this.executionDateLabel = executionDateLabel;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramStage withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramStage withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramStage withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("featureType")
    public Optional<ProgramStage.FeatureType> getFeatureType() {
        return Optional.ofNullable(featureType);
    }

    @JsonProperty("featureType")
    public void setFeatureType(ProgramStage.FeatureType featureType) {
        this.featureType = featureType;
    }

    public ProgramStage withFeatureType(ProgramStage.FeatureType featureType) {
        this.featureType = featureType;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public ProgramStage withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("formType")
    public Optional<ProgramStage.FormType> getFormType() {
        return Optional.ofNullable(formType);
    }

    @JsonProperty("formType")
    public void setFormType(ProgramStage.FormType formType) {
        this.formType = formType;
    }

    public ProgramStage withFormType(ProgramStage.FormType formType) {
        this.formType = formType;
        return this;
    }

    @JsonProperty("generatedByEnrollmentDate")
    public Optional<Boolean> getGeneratedByEnrollmentDate() {
        return Optional.ofNullable(generatedByEnrollmentDate);
    }

    @JsonProperty("generatedByEnrollmentDate")
    public void setGeneratedByEnrollmentDate(Boolean generatedByEnrollmentDate) {
        this.generatedByEnrollmentDate = generatedByEnrollmentDate;
    }

    public ProgramStage withGeneratedByEnrollmentDate(Boolean generatedByEnrollmentDate) {
        this.generatedByEnrollmentDate = generatedByEnrollmentDate;
        return this;
    }

    @JsonProperty("hideDueDate")
    public Optional<Boolean> getHideDueDate() {
        return Optional.ofNullable(hideDueDate);
    }

    @JsonProperty("hideDueDate")
    public void setHideDueDate(Boolean hideDueDate) {
        this.hideDueDate = hideDueDate;
    }

    public ProgramStage withHideDueDate(Boolean hideDueDate) {
        this.hideDueDate = hideDueDate;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramStage withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramStage withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramStage withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramStage withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("minDaysFromStart")
    public Optional<Integer> getMinDaysFromStart() {
        return Optional.ofNullable(minDaysFromStart);
    }

    @JsonProperty("minDaysFromStart")
    public void setMinDaysFromStart(Integer minDaysFromStart) {
        this.minDaysFromStart = minDaysFromStart;
    }

    public ProgramStage withMinDaysFromStart(Integer minDaysFromStart) {
        this.minDaysFromStart = minDaysFromStart;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramStage withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("nextScheduleDate")
    public Optional<DataElement> getNextScheduleDate() {
        return Optional.ofNullable(nextScheduleDate);
    }

    @JsonProperty("nextScheduleDate")
    public void setNextScheduleDate(DataElement nextScheduleDate) {
        this.nextScheduleDate = nextScheduleDate;
    }

    public ProgramStage withNextScheduleDate(DataElement nextScheduleDate) {
        this.nextScheduleDate = nextScheduleDate;
        return this;
    }

    @JsonProperty("notificationTemplates")
    public Optional<List<ProgramNotificationTemplate>> getNotificationTemplates() {
        return Optional.ofNullable(notificationTemplates);
    }

    @JsonProperty("notificationTemplates")
    public void setNotificationTemplates(List<ProgramNotificationTemplate> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
    }

    public ProgramStage withNotificationTemplates(List<ProgramNotificationTemplate> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
        return this;
    }

    @JsonProperty("openAfterEnrollment")
    public Optional<Boolean> getOpenAfterEnrollment() {
        return Optional.ofNullable(openAfterEnrollment);
    }

    @JsonProperty("openAfterEnrollment")
    public void setOpenAfterEnrollment(Boolean openAfterEnrollment) {
        this.openAfterEnrollment = openAfterEnrollment;
    }

    public ProgramStage withOpenAfterEnrollment(Boolean openAfterEnrollment) {
        this.openAfterEnrollment = openAfterEnrollment;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    public Optional<Object> getPeriodType() {
        return Optional.ofNullable(periodType);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("periodType")
    public void setPeriodType(Object periodType) {
        this.periodType = periodType;
    }

    public ProgramStage withPeriodType(Object periodType) {
        this.periodType = periodType;
        return this;
    }

    @JsonProperty("preGenerateUID")
    public Optional<Boolean> getPreGenerateUID() {
        return Optional.ofNullable(preGenerateUID);
    }

    @JsonProperty("preGenerateUID")
    public void setPreGenerateUID(Boolean preGenerateUID) {
        this.preGenerateUID = preGenerateUID;
    }

    public ProgramStage withPreGenerateUID(Boolean preGenerateUID) {
        this.preGenerateUID = preGenerateUID;
        return this;
    }

    @JsonProperty("program")
    public Optional<Program> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(Program program) {
        this.program = program;
    }

    public ProgramStage withProgram(Program program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programStageDataElements")
    public Optional<List<ProgramStageDataElement>> getProgramStageDataElements() {
        return Optional.ofNullable(programStageDataElements);
    }

    @JsonProperty("programStageDataElements")
    public void setProgramStageDataElements(List<ProgramStageDataElement> programStageDataElements) {
        this.programStageDataElements = programStageDataElements;
    }

    public ProgramStage withProgramStageDataElements(List<ProgramStageDataElement> programStageDataElements) {
        this.programStageDataElements = programStageDataElements;
        return this;
    }

    @JsonProperty("programStageSections")
    public Optional<List<ProgramStageSection>> getProgramStageSections() {
        return Optional.ofNullable(programStageSections);
    }

    @JsonProperty("programStageSections")
    public void setProgramStageSections(List<ProgramStageSection> programStageSections) {
        this.programStageSections = programStageSections;
    }

    public ProgramStage withProgramStageSections(List<ProgramStageSection> programStageSections) {
        this.programStageSections = programStageSections;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramStage withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("remindCompleted")
    public Optional<Boolean> getRemindCompleted() {
        return Optional.ofNullable(remindCompleted);
    }

    @JsonProperty("remindCompleted")
    public void setRemindCompleted(Boolean remindCompleted) {
        this.remindCompleted = remindCompleted;
    }

    public ProgramStage withRemindCompleted(Boolean remindCompleted) {
        this.remindCompleted = remindCompleted;
        return this;
    }

    @JsonProperty("repeatable")
    public Optional<Boolean> getRepeatable() {
        return Optional.ofNullable(repeatable);
    }

    @JsonProperty("repeatable")
    public void setRepeatable(Boolean repeatable) {
        this.repeatable = repeatable;
    }

    public ProgramStage withRepeatable(Boolean repeatable) {
        this.repeatable = repeatable;
        return this;
    }

    @JsonProperty("reportDateToUse")
    public Optional<String> getReportDateToUse() {
        return Optional.ofNullable(reportDateToUse);
    }

    @JsonProperty("reportDateToUse")
    public void setReportDateToUse(String reportDateToUse) {
        this.reportDateToUse = reportDateToUse;
    }

    public ProgramStage withReportDateToUse(String reportDateToUse) {
        this.reportDateToUse = reportDateToUse;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public ProgramStage withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ProgramStage withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("standardInterval")
    public Optional<Integer> getStandardInterval() {
        return Optional.ofNullable(standardInterval);
    }

    @JsonProperty("standardInterval")
    public void setStandardInterval(Integer standardInterval) {
        this.standardInterval = standardInterval;
    }

    public ProgramStage withStandardInterval(Integer standardInterval) {
        this.standardInterval = standardInterval;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public ProgramStage withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramStage withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ProgramStage withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramStage withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramStage withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("validationStrategy")
    public Optional<ProgramStage.ValidationStrategy> getValidationStrategy() {
        return Optional.ofNullable(validationStrategy);
    }

    @JsonProperty("validationStrategy")
    public void setValidationStrategy(ProgramStage.ValidationStrategy validationStrategy) {
        this.validationStrategy = validationStrategy;
    }

    public ProgramStage withValidationStrategy(ProgramStage.ValidationStrategy validationStrategy) {
        this.validationStrategy = validationStrategy;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramStage withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "allowGenerateNextVisit":
                if (value instanceof Boolean) {
                    setAllowGenerateNextVisit(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"allowGenerateNextVisit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "autoGenerateEvent":
                if (value instanceof Boolean) {
                    setAutoGenerateEvent(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"autoGenerateEvent\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "blockEntryForm":
                if (value instanceof Boolean) {
                    setBlockEntryForm(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"blockEntryForm\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataEntryForm":
                if (value instanceof DataEntryForm) {
                    setDataEntryForm(((DataEntryForm) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataEntryForm\" is of type \"org.hisp.dhis.api.model.v2_35_13.DataEntryForm\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDueDateLabel":
                if (value instanceof String) {
                    setDisplayDueDateLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDueDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayExecutionDateLabel":
                if (value instanceof String) {
                    setDisplayExecutionDateLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayExecutionDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayGenerateEventBox":
                if (value instanceof Boolean) {
                    setDisplayGenerateEventBox(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayGenerateEventBox\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dueDateLabel":
                if (value instanceof String) {
                    setDueDateLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dueDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "enableUserAssignment":
                if (value instanceof Boolean) {
                    setEnableUserAssignment(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"enableUserAssignment\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "executionDateLabel":
                if (value instanceof String) {
                    setExecutionDateLabel(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"executionDateLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "featureType":
                if (value instanceof ProgramStage.FeatureType) {
                    setFeatureType(((ProgramStage.FeatureType) value));
                } else {
                    throw new IllegalArgumentException(("property \"featureType\" is of type \"org.hisp.dhis.api.model.v2_35_13.ProgramStage.FeatureType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formType":
                if (value instanceof ProgramStage.FormType) {
                    setFormType(((ProgramStage.FormType) value));
                } else {
                    throw new IllegalArgumentException(("property \"formType\" is of type \"org.hisp.dhis.api.model.v2_35_13.ProgramStage.FormType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "generatedByEnrollmentDate":
                if (value instanceof Boolean) {
                    setGeneratedByEnrollmentDate(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"generatedByEnrollmentDate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "hideDueDate":
                if (value instanceof Boolean) {
                    setHideDueDate(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"hideDueDate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "minDaysFromStart":
                if (value instanceof Integer) {
                    setMinDaysFromStart(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"minDaysFromStart\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "nextScheduleDate":
                if (value instanceof DataElement) {
                    setNextScheduleDate(((DataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"nextScheduleDate\" is of type \"org.hisp.dhis.api.model.v2_35_13.DataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationTemplates":
                if (value instanceof List) {
                    setNotificationTemplates(((List<ProgramNotificationTemplate> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationTemplates\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.ProgramNotificationTemplate>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "openAfterEnrollment":
                if (value instanceof Boolean) {
                    setOpenAfterEnrollment(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"openAfterEnrollment\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodType":
                if (value instanceof Object) {
                    setPeriodType(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodType\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "preGenerateUID":
                if (value instanceof Boolean) {
                    setPreGenerateUID(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"preGenerateUID\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "program":
                if (value instanceof Program) {
                    setProgram(((Program) value));
                } else {
                    throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v2_35_13.Program\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStageDataElements":
                if (value instanceof List) {
                    setProgramStageDataElements(((List<ProgramStageDataElement> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageDataElements\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.ProgramStageDataElement>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programStageSections":
                if (value instanceof List) {
                    setProgramStageSections(((List<ProgramStageSection> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStageSections\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.ProgramStageSection>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "remindCompleted":
                if (value instanceof Boolean) {
                    setRemindCompleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"remindCompleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "repeatable":
                if (value instanceof Boolean) {
                    setRepeatable(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"repeatable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "reportDateToUse":
                if (value instanceof String) {
                    setReportDateToUse(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"reportDateToUse\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sortOrder":
                if (value instanceof Integer) {
                    setSortOrder(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "standardInterval":
                if (value instanceof Integer) {
                    setStandardInterval(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"standardInterval\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "style":
                if (value instanceof ObjectStyle) {
                    setStyle(((ObjectStyle) value));
                } else {
                    throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v2_35_13.ObjectStyle\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validationStrategy":
                if (value instanceof ProgramStage.ValidationStrategy) {
                    setValidationStrategy(((ProgramStage.ValidationStrategy) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationStrategy\" is of type \"org.hisp.dhis.api.model.v2_35_13.ProgramStage.ValidationStrategy\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "allowGenerateNextVisit":
                return getAllowGenerateNextVisit();
            case "attributeValues":
                return getAttributeValues();
            case "autoGenerateEvent":
                return getAutoGenerateEvent();
            case "blockEntryForm":
                return getBlockEntryForm();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "dataEntryForm":
                return getDataEntryForm();
            case "description":
                return getDescription();
            case "displayDescription":
                return getDisplayDescription();
            case "displayDueDateLabel":
                return getDisplayDueDateLabel();
            case "displayExecutionDateLabel":
                return getDisplayExecutionDateLabel();
            case "displayFormName":
                return getDisplayFormName();
            case "displayGenerateEventBox":
                return getDisplayGenerateEventBox();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "dueDateLabel":
                return getDueDateLabel();
            case "enableUserAssignment":
                return getEnableUserAssignment();
            case "executionDateLabel":
                return getExecutionDateLabel();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "featureType":
                return getFeatureType();
            case "formName":
                return getFormName();
            case "formType":
                return getFormType();
            case "generatedByEnrollmentDate":
                return getGeneratedByEnrollmentDate();
            case "hideDueDate":
                return getHideDueDate();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "minDaysFromStart":
                return getMinDaysFromStart();
            case "name":
                return getName();
            case "nextScheduleDate":
                return getNextScheduleDate();
            case "notificationTemplates":
                return getNotificationTemplates();
            case "openAfterEnrollment":
                return getOpenAfterEnrollment();
            case "periodType":
                return getPeriodType();
            case "preGenerateUID":
                return getPreGenerateUID();
            case "program":
                return getProgram();
            case "programStageDataElements":
                return getProgramStageDataElements();
            case "programStageSections":
                return getProgramStageSections();
            case "publicAccess":
                return getPublicAccess();
            case "remindCompleted":
                return getRemindCompleted();
            case "repeatable":
                return getRepeatable();
            case "reportDateToUse":
                return getReportDateToUse();
            case "shortName":
                return getShortName();
            case "sortOrder":
                return getSortOrder();
            case "standardInterval":
                return getStandardInterval();
            case "style":
                return getStyle();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "validationStrategy":
                return getValidationStrategy();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramStage.NOT_FOUND_VALUE);
        if (ProgramStage.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramStage with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramStage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("allowGenerateNextVisit");
        sb.append('=');
        sb.append(((this.allowGenerateNextVisit == null)?"<null>":this.allowGenerateNextVisit));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("autoGenerateEvent");
        sb.append('=');
        sb.append(((this.autoGenerateEvent == null)?"<null>":this.autoGenerateEvent));
        sb.append(',');
        sb.append("blockEntryForm");
        sb.append('=');
        sb.append(((this.blockEntryForm == null)?"<null>":this.blockEntryForm));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataEntryForm");
        sb.append('=');
        sb.append(((this.dataEntryForm == null)?"<null>":this.dataEntryForm));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayDueDateLabel");
        sb.append('=');
        sb.append(((this.displayDueDateLabel == null)?"<null>":this.displayDueDateLabel));
        sb.append(',');
        sb.append("displayExecutionDateLabel");
        sb.append('=');
        sb.append(((this.displayExecutionDateLabel == null)?"<null>":this.displayExecutionDateLabel));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayGenerateEventBox");
        sb.append('=');
        sb.append(((this.displayGenerateEventBox == null)?"<null>":this.displayGenerateEventBox));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("dueDateLabel");
        sb.append('=');
        sb.append(((this.dueDateLabel == null)?"<null>":this.dueDateLabel));
        sb.append(',');
        sb.append("enableUserAssignment");
        sb.append('=');
        sb.append(((this.enableUserAssignment == null)?"<null>":this.enableUserAssignment));
        sb.append(',');
        sb.append("executionDateLabel");
        sb.append('=');
        sb.append(((this.executionDateLabel == null)?"<null>":this.executionDateLabel));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("featureType");
        sb.append('=');
        sb.append(((this.featureType == null)?"<null>":this.featureType));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("formType");
        sb.append('=');
        sb.append(((this.formType == null)?"<null>":this.formType));
        sb.append(',');
        sb.append("generatedByEnrollmentDate");
        sb.append('=');
        sb.append(((this.generatedByEnrollmentDate == null)?"<null>":this.generatedByEnrollmentDate));
        sb.append(',');
        sb.append("hideDueDate");
        sb.append('=');
        sb.append(((this.hideDueDate == null)?"<null>":this.hideDueDate));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("minDaysFromStart");
        sb.append('=');
        sb.append(((this.minDaysFromStart == null)?"<null>":this.minDaysFromStart));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("nextScheduleDate");
        sb.append('=');
        sb.append(((this.nextScheduleDate == null)?"<null>":this.nextScheduleDate));
        sb.append(',');
        sb.append("notificationTemplates");
        sb.append('=');
        sb.append(((this.notificationTemplates == null)?"<null>":this.notificationTemplates));
        sb.append(',');
        sb.append("openAfterEnrollment");
        sb.append('=');
        sb.append(((this.openAfterEnrollment == null)?"<null>":this.openAfterEnrollment));
        sb.append(',');
        sb.append("periodType");
        sb.append('=');
        sb.append(((this.periodType == null)?"<null>":this.periodType));
        sb.append(',');
        sb.append("preGenerateUID");
        sb.append('=');
        sb.append(((this.preGenerateUID == null)?"<null>":this.preGenerateUID));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStageDataElements");
        sb.append('=');
        sb.append(((this.programStageDataElements == null)?"<null>":this.programStageDataElements));
        sb.append(',');
        sb.append("programStageSections");
        sb.append('=');
        sb.append(((this.programStageSections == null)?"<null>":this.programStageSections));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("remindCompleted");
        sb.append('=');
        sb.append(((this.remindCompleted == null)?"<null>":this.remindCompleted));
        sb.append(',');
        sb.append("repeatable");
        sb.append('=');
        sb.append(((this.repeatable == null)?"<null>":this.repeatable));
        sb.append(',');
        sb.append("reportDateToUse");
        sb.append('=');
        sb.append(((this.reportDateToUse == null)?"<null>":this.reportDateToUse));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("standardInterval");
        sb.append('=');
        sb.append(((this.standardInterval == null)?"<null>":this.standardInterval));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("validationStrategy");
        sb.append('=');
        sb.append(((this.validationStrategy == null)?"<null>":this.validationStrategy));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.allowGenerateNextVisit == null)? 0 :this.allowGenerateNextVisit.hashCode()));
        result = ((result* 31)+((this.dataEntryForm == null)? 0 :this.dataEntryForm.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.reportDateToUse == null)? 0 :this.reportDateToUse.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.programStageDataElements == null)? 0 :this.programStageDataElements.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.formType == null)? 0 :this.formType.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.generatedByEnrollmentDate == null)? 0 :this.generatedByEnrollmentDate.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.hideDueDate == null)? 0 :this.hideDueDate.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.enableUserAssignment == null)? 0 :this.enableUserAssignment.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.minDaysFromStart == null)? 0 :this.minDaysFromStart.hashCode()));
        result = ((result* 31)+((this.standardInterval == null)? 0 :this.standardInterval.hashCode()));
        result = ((result* 31)+((this.dueDateLabel == null)? 0 :this.dueDateLabel.hashCode()));
        result = ((result* 31)+((this.executionDateLabel == null)? 0 :this.executionDateLabel.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.preGenerateUID == null)? 0 :this.preGenerateUID.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.displayExecutionDateLabel == null)? 0 :this.displayExecutionDateLabel.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.notificationTemplates == null)? 0 :this.notificationTemplates.hashCode()));
        result = ((result* 31)+((this.openAfterEnrollment == null)? 0 :this.openAfterEnrollment.hashCode()));
        result = ((result* 31)+((this.repeatable == null)? 0 :this.repeatable.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.featureType == null)? 0 :this.featureType.hashCode()));
        result = ((result* 31)+((this.remindCompleted == null)? 0 :this.remindCompleted.hashCode()));
        result = ((result* 31)+((this.displayGenerateEventBox == null)? 0 :this.displayGenerateEventBox.hashCode()));
        result = ((result* 31)+((this.nextScheduleDate == null)? 0 :this.nextScheduleDate.hashCode()));
        result = ((result* 31)+((this.validationStrategy == null)? 0 :this.validationStrategy.hashCode()));
        result = ((result* 31)+((this.autoGenerateEvent == null)? 0 :this.autoGenerateEvent.hashCode()));
        result = ((result* 31)+((this.periodType == null)? 0 :this.periodType.hashCode()));
        result = ((result* 31)+((this.displayDueDateLabel == null)? 0 :this.displayDueDateLabel.hashCode()));
        result = ((result* 31)+((this.blockEntryForm == null)? 0 :this.blockEntryForm.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.programStageSections == null)? 0 :this.programStageSections.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramStage) == false) {
            return false;
        }
        ProgramStage rhs = ((ProgramStage) other);
        return ((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.allowGenerateNextVisit == rhs.allowGenerateNextVisit)||((this.allowGenerateNextVisit!= null)&&this.allowGenerateNextVisit.equals(rhs.allowGenerateNextVisit)))&&((this.dataEntryForm == rhs.dataEntryForm)||((this.dataEntryForm!= null)&&this.dataEntryForm.equals(rhs.dataEntryForm))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.reportDateToUse == rhs.reportDateToUse)||((this.reportDateToUse!= null)&&this.reportDateToUse.equals(rhs.reportDateToUse))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.programStageDataElements == rhs.programStageDataElements)||((this.programStageDataElements!= null)&&this.programStageDataElements.equals(rhs.programStageDataElements))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.formType == rhs.formType)||((this.formType!= null)&&this.formType.equals(rhs.formType))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.generatedByEnrollmentDate == rhs.generatedByEnrollmentDate)||((this.generatedByEnrollmentDate!= null)&&this.generatedByEnrollmentDate.equals(rhs.generatedByEnrollmentDate))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.hideDueDate == rhs.hideDueDate)||((this.hideDueDate!= null)&&this.hideDueDate.equals(rhs.hideDueDate))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.enableUserAssignment == rhs.enableUserAssignment)||((this.enableUserAssignment!= null)&&this.enableUserAssignment.equals(rhs.enableUserAssignment))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.minDaysFromStart == rhs.minDaysFromStart)||((this.minDaysFromStart!= null)&&this.minDaysFromStart.equals(rhs.minDaysFromStart))))&&((this.standardInterval == rhs.standardInterval)||((this.standardInterval!= null)&&this.standardInterval.equals(rhs.standardInterval))))&&((this.dueDateLabel == rhs.dueDateLabel)||((this.dueDateLabel!= null)&&this.dueDateLabel.equals(rhs.dueDateLabel))))&&((this.executionDateLabel == rhs.executionDateLabel)||((this.executionDateLabel!= null)&&this.executionDateLabel.equals(rhs.executionDateLabel))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.preGenerateUID == rhs.preGenerateUID)||((this.preGenerateUID!= null)&&this.preGenerateUID.equals(rhs.preGenerateUID))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.displayExecutionDateLabel == rhs.displayExecutionDateLabel)||((this.displayExecutionDateLabel!= null)&&this.displayExecutionDateLabel.equals(rhs.displayExecutionDateLabel))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.notificationTemplates == rhs.notificationTemplates)||((this.notificationTemplates!= null)&&this.notificationTemplates.equals(rhs.notificationTemplates))))&&((this.openAfterEnrollment == rhs.openAfterEnrollment)||((this.openAfterEnrollment!= null)&&this.openAfterEnrollment.equals(rhs.openAfterEnrollment))))&&((this.repeatable == rhs.repeatable)||((this.repeatable!= null)&&this.repeatable.equals(rhs.repeatable))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.featureType == rhs.featureType)||((this.featureType!= null)&&this.featureType.equals(rhs.featureType))))&&((this.remindCompleted == rhs.remindCompleted)||((this.remindCompleted!= null)&&this.remindCompleted.equals(rhs.remindCompleted))))&&((this.displayGenerateEventBox == rhs.displayGenerateEventBox)||((this.displayGenerateEventBox!= null)&&this.displayGenerateEventBox.equals(rhs.displayGenerateEventBox))))&&((this.nextScheduleDate == rhs.nextScheduleDate)||((this.nextScheduleDate!= null)&&this.nextScheduleDate.equals(rhs.nextScheduleDate))))&&((this.validationStrategy == rhs.validationStrategy)||((this.validationStrategy!= null)&&this.validationStrategy.equals(rhs.validationStrategy))))&&((this.autoGenerateEvent == rhs.autoGenerateEvent)||((this.autoGenerateEvent!= null)&&this.autoGenerateEvent.equals(rhs.autoGenerateEvent))))&&((this.periodType == rhs.periodType)||((this.periodType!= null)&&this.periodType.equals(rhs.periodType))))&&((this.displayDueDateLabel == rhs.displayDueDateLabel)||((this.displayDueDateLabel!= null)&&this.displayDueDateLabel.equals(rhs.displayDueDateLabel))))&&((this.blockEntryForm == rhs.blockEntryForm)||((this.blockEntryForm!= null)&&this.blockEntryForm.equals(rhs.blockEntryForm))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.programStageSections == rhs.programStageSections)||((this.programStageSections!= null)&&this.programStageSections.equals(rhs.programStageSections))));
    }

    @Generated("jsonschema2pojo")
    public enum FeatureType {

        NONE("NONE"),
        MULTI_POLYGON("MULTI_POLYGON"),
        POLYGON("POLYGON"),
        POINT("POINT"),
        SYMBOL("SYMBOL");
        private final String value;
        private final static Map<String, ProgramStage.FeatureType> CONSTANTS = new HashMap<String, ProgramStage.FeatureType>();

        static {
            for (ProgramStage.FeatureType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FeatureType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStage.FeatureType fromValue(String value) {
            ProgramStage.FeatureType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum FormType {

        DEFAULT("DEFAULT"),
        CUSTOM("CUSTOM"),
        SECTION("SECTION"),
        SECTION_MULTIORG("SECTION_MULTIORG");
        private final String value;
        private final static Map<String, ProgramStage.FormType> CONSTANTS = new HashMap<String, ProgramStage.FormType>();

        static {
            for (ProgramStage.FormType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FormType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStage.FormType fromValue(String value) {
            ProgramStage.FormType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ValidationStrategy {

        ON_COMPLETE("ON_COMPLETE"),
        ON_UPDATE_AND_INSERT("ON_UPDATE_AND_INSERT");
        private final String value;
        private final static Map<String, ProgramStage.ValidationStrategy> CONSTANTS = new HashMap<String, ProgramStage.ValidationStrategy>();

        static {
            for (ProgramStage.ValidationStrategy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValidationStrategy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramStage.ValidationStrategy fromValue(String value) {
            ProgramStage.ValidationStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
