
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "created",
    "deliveryChannels",
    "displayMessageTemplate",
    "displayName",
    "displaySubjectTemplate",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "messageTemplate",
    "name",
    "notificationRecipient",
    "notificationTrigger",
    "notifyParentOrganisationUnitOnly",
    "notifyUsersInHierarchyOnly",
    "publicAccess",
    "recipientDataElement",
    "recipientProgramAttribute",
    "recipientUserGroup",
    "relativeScheduledDays",
    "subjectTemplate",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ProgramNotificationTemplate implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("deliveryChannels")
    private List<DeliveryChannel> deliveryChannels = null;
    @JsonProperty("displayMessageTemplate")
    private String displayMessageTemplate;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displaySubjectTemplate")
    private String displaySubjectTemplate;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("messageTemplate")
    private String messageTemplate;
    @JsonProperty("name")
    private String name;
    @JsonProperty("notificationRecipient")
    private ProgramNotificationTemplate.ProgramNotificationRecipient notificationRecipient;
    @JsonProperty("notificationTrigger")
    private ProgramNotificationTemplate.NotificationTrigger notificationTrigger;
    @JsonProperty("notifyParentOrganisationUnitOnly")
    private Boolean notifyParentOrganisationUnitOnly;
    @JsonProperty("notifyUsersInHierarchyOnly")
    private Boolean notifyUsersInHierarchyOnly;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("recipientDataElement")
    private DataElement recipientDataElement;
    @JsonProperty("recipientProgramAttribute")
    private TrackedEntityAttribute recipientProgramAttribute;
    @JsonProperty("recipientUserGroup")
    private UserGroup recipientUserGroup;
    @JsonProperty("relativeScheduledDays")
    private Integer relativeScheduledDays;
    @JsonProperty("subjectTemplate")
    private String subjectTemplate;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1983653489764844044L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramNotificationTemplate() {
    }

    /**
     * 
     * @param source
     */
    public ProgramNotificationTemplate(ProgramNotificationTemplate source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.deliveryChannels = source.deliveryChannels;
        this.displayMessageTemplate = source.displayMessageTemplate;
        this.displayName = source.displayName;
        this.displaySubjectTemplate = source.displaySubjectTemplate;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.messageTemplate = source.messageTemplate;
        this.name = source.name;
        this.notificationRecipient = source.notificationRecipient;
        this.notificationTrigger = source.notificationTrigger;
        this.notifyParentOrganisationUnitOnly = source.notifyParentOrganisationUnitOnly;
        this.notifyUsersInHierarchyOnly = source.notifyUsersInHierarchyOnly;
        this.publicAccess = source.publicAccess;
        this.recipientDataElement = source.recipientDataElement;
        this.recipientProgramAttribute = source.recipientProgramAttribute;
        this.recipientUserGroup = source.recipientUserGroup;
        this.relativeScheduledDays = source.relativeScheduledDays;
        this.subjectTemplate = source.subjectTemplate;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param favorites
     * @param access
     * @param code
     * @param displayName
     * @param publicAccess
     * @param externalAccess
     * @param lastUpdated
     * @param notificationTrigger
     * @param translations
     * @param relativeScheduledDays
     * @param href
     * @param id
     * @param subjectTemplate
     * @param lastUpdatedBy
     * @param userGroupAccesses
     * @param created
     * @param deliveryChannels
     * @param displaySubjectTemplate
     * @param notifyUsersInHierarchyOnly
     * @param recipientDataElement
     * @param attributeValues
     * @param notificationRecipient
     * @param recipientProgramAttribute
     * @param notifyParentOrganisationUnitOnly
     * @param userAccesses
     * @param name
     * @param displayMessageTemplate
     * @param favorite
     * @param recipientUserGroup
     * @param user
     * @param messageTemplate
     */
    public ProgramNotificationTemplate(Access access, List<AttributeValue> attributeValues, String code, Date created, List<DeliveryChannel> deliveryChannels, String displayMessageTemplate, String displayName, String displaySubjectTemplate, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, User lastUpdatedBy, String messageTemplate, String name, ProgramNotificationTemplate.ProgramNotificationRecipient notificationRecipient, ProgramNotificationTemplate.NotificationTrigger notificationTrigger, Boolean notifyParentOrganisationUnitOnly, Boolean notifyUsersInHierarchyOnly, String publicAccess, DataElement recipientDataElement, TrackedEntityAttribute recipientProgramAttribute, UserGroup recipientUserGroup, Integer relativeScheduledDays, String subjectTemplate, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.deliveryChannels = deliveryChannels;
        this.displayMessageTemplate = displayMessageTemplate;
        this.displayName = displayName;
        this.displaySubjectTemplate = displaySubjectTemplate;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.messageTemplate = messageTemplate;
        this.name = name;
        this.notificationRecipient = notificationRecipient;
        this.notificationTrigger = notificationTrigger;
        this.notifyParentOrganisationUnitOnly = notifyParentOrganisationUnitOnly;
        this.notifyUsersInHierarchyOnly = notifyUsersInHierarchyOnly;
        this.publicAccess = publicAccess;
        this.recipientDataElement = recipientDataElement;
        this.recipientProgramAttribute = recipientProgramAttribute;
        this.recipientUserGroup = recipientUserGroup;
        this.relativeScheduledDays = relativeScheduledDays;
        this.subjectTemplate = subjectTemplate;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramNotificationTemplate withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramNotificationTemplate withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramNotificationTemplate withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramNotificationTemplate withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("deliveryChannels")
    public Optional<List<DeliveryChannel>> getDeliveryChannels() {
        return Optional.ofNullable(deliveryChannels);
    }

    @JsonProperty("deliveryChannels")
    public void setDeliveryChannels(List<DeliveryChannel> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
    }

    public ProgramNotificationTemplate withDeliveryChannels(List<DeliveryChannel> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
        return this;
    }

    @JsonProperty("displayMessageTemplate")
    public Optional<String> getDisplayMessageTemplate() {
        return Optional.ofNullable(displayMessageTemplate);
    }

    @JsonProperty("displayMessageTemplate")
    public void setDisplayMessageTemplate(String displayMessageTemplate) {
        this.displayMessageTemplate = displayMessageTemplate;
    }

    public ProgramNotificationTemplate withDisplayMessageTemplate(String displayMessageTemplate) {
        this.displayMessageTemplate = displayMessageTemplate;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramNotificationTemplate withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displaySubjectTemplate")
    public Optional<String> getDisplaySubjectTemplate() {
        return Optional.ofNullable(displaySubjectTemplate);
    }

    @JsonProperty("displaySubjectTemplate")
    public void setDisplaySubjectTemplate(String displaySubjectTemplate) {
        this.displaySubjectTemplate = displaySubjectTemplate;
    }

    public ProgramNotificationTemplate withDisplaySubjectTemplate(String displaySubjectTemplate) {
        this.displaySubjectTemplate = displaySubjectTemplate;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramNotificationTemplate withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramNotificationTemplate withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramNotificationTemplate withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramNotificationTemplate withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramNotificationTemplate withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramNotificationTemplate withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramNotificationTemplate withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("messageTemplate")
    public Optional<String> getMessageTemplate() {
        return Optional.ofNullable(messageTemplate);
    }

    @JsonProperty("messageTemplate")
    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public ProgramNotificationTemplate withMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramNotificationTemplate withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("notificationRecipient")
    public Optional<ProgramNotificationTemplate.ProgramNotificationRecipient> getNotificationRecipient() {
        return Optional.ofNullable(notificationRecipient);
    }

    @JsonProperty("notificationRecipient")
    public void setNotificationRecipient(ProgramNotificationTemplate.ProgramNotificationRecipient notificationRecipient) {
        this.notificationRecipient = notificationRecipient;
    }

    public ProgramNotificationTemplate withNotificationRecipient(ProgramNotificationTemplate.ProgramNotificationRecipient notificationRecipient) {
        this.notificationRecipient = notificationRecipient;
        return this;
    }

    @JsonProperty("notificationTrigger")
    public Optional<ProgramNotificationTemplate.NotificationTrigger> getNotificationTrigger() {
        return Optional.ofNullable(notificationTrigger);
    }

    @JsonProperty("notificationTrigger")
    public void setNotificationTrigger(ProgramNotificationTemplate.NotificationTrigger notificationTrigger) {
        this.notificationTrigger = notificationTrigger;
    }

    public ProgramNotificationTemplate withNotificationTrigger(ProgramNotificationTemplate.NotificationTrigger notificationTrigger) {
        this.notificationTrigger = notificationTrigger;
        return this;
    }

    @JsonProperty("notifyParentOrganisationUnitOnly")
    public Optional<Boolean> getNotifyParentOrganisationUnitOnly() {
        return Optional.ofNullable(notifyParentOrganisationUnitOnly);
    }

    @JsonProperty("notifyParentOrganisationUnitOnly")
    public void setNotifyParentOrganisationUnitOnly(Boolean notifyParentOrganisationUnitOnly) {
        this.notifyParentOrganisationUnitOnly = notifyParentOrganisationUnitOnly;
    }

    public ProgramNotificationTemplate withNotifyParentOrganisationUnitOnly(Boolean notifyParentOrganisationUnitOnly) {
        this.notifyParentOrganisationUnitOnly = notifyParentOrganisationUnitOnly;
        return this;
    }

    @JsonProperty("notifyUsersInHierarchyOnly")
    public Optional<Boolean> getNotifyUsersInHierarchyOnly() {
        return Optional.ofNullable(notifyUsersInHierarchyOnly);
    }

    @JsonProperty("notifyUsersInHierarchyOnly")
    public void setNotifyUsersInHierarchyOnly(Boolean notifyUsersInHierarchyOnly) {
        this.notifyUsersInHierarchyOnly = notifyUsersInHierarchyOnly;
    }

    public ProgramNotificationTemplate withNotifyUsersInHierarchyOnly(Boolean notifyUsersInHierarchyOnly) {
        this.notifyUsersInHierarchyOnly = notifyUsersInHierarchyOnly;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramNotificationTemplate withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("recipientDataElement")
    public Optional<DataElement> getRecipientDataElement() {
        return Optional.ofNullable(recipientDataElement);
    }

    @JsonProperty("recipientDataElement")
    public void setRecipientDataElement(DataElement recipientDataElement) {
        this.recipientDataElement = recipientDataElement;
    }

    public ProgramNotificationTemplate withRecipientDataElement(DataElement recipientDataElement) {
        this.recipientDataElement = recipientDataElement;
        return this;
    }

    @JsonProperty("recipientProgramAttribute")
    public Optional<TrackedEntityAttribute> getRecipientProgramAttribute() {
        return Optional.ofNullable(recipientProgramAttribute);
    }

    @JsonProperty("recipientProgramAttribute")
    public void setRecipientProgramAttribute(TrackedEntityAttribute recipientProgramAttribute) {
        this.recipientProgramAttribute = recipientProgramAttribute;
    }

    public ProgramNotificationTemplate withRecipientProgramAttribute(TrackedEntityAttribute recipientProgramAttribute) {
        this.recipientProgramAttribute = recipientProgramAttribute;
        return this;
    }

    @JsonProperty("recipientUserGroup")
    public Optional<UserGroup> getRecipientUserGroup() {
        return Optional.ofNullable(recipientUserGroup);
    }

    @JsonProperty("recipientUserGroup")
    public void setRecipientUserGroup(UserGroup recipientUserGroup) {
        this.recipientUserGroup = recipientUserGroup;
    }

    public ProgramNotificationTemplate withRecipientUserGroup(UserGroup recipientUserGroup) {
        this.recipientUserGroup = recipientUserGroup;
        return this;
    }

    @JsonProperty("relativeScheduledDays")
    public Optional<Integer> getRelativeScheduledDays() {
        return Optional.ofNullable(relativeScheduledDays);
    }

    @JsonProperty("relativeScheduledDays")
    public void setRelativeScheduledDays(Integer relativeScheduledDays) {
        this.relativeScheduledDays = relativeScheduledDays;
    }

    public ProgramNotificationTemplate withRelativeScheduledDays(Integer relativeScheduledDays) {
        this.relativeScheduledDays = relativeScheduledDays;
        return this;
    }

    @JsonProperty("subjectTemplate")
    public Optional<String> getSubjectTemplate() {
        return Optional.ofNullable(subjectTemplate);
    }

    @JsonProperty("subjectTemplate")
    public void setSubjectTemplate(String subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
    }

    public ProgramNotificationTemplate withSubjectTemplate(String subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramNotificationTemplate withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ProgramNotificationTemplate withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramNotificationTemplate withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramNotificationTemplate withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramNotificationTemplate withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "deliveryChannels":
                if (value instanceof List) {
                    setDeliveryChannels(((List<DeliveryChannel> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"deliveryChannels\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.DeliveryChannel>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayMessageTemplate":
                if (value instanceof String) {
                    setDisplayMessageTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayMessageTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displaySubjectTemplate":
                if (value instanceof String) {
                    setDisplaySubjectTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displaySubjectTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messageTemplate":
                if (value instanceof String) {
                    setMessageTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"messageTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationRecipient":
                if (value instanceof ProgramNotificationTemplate.ProgramNotificationRecipient) {
                    setNotificationRecipient(((ProgramNotificationTemplate.ProgramNotificationRecipient) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationRecipient\" is of type \"org.hisp.dhis.api.model.v2_35_13.ProgramNotificationTemplate.ProgramNotificationRecipient\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationTrigger":
                if (value instanceof ProgramNotificationTemplate.NotificationTrigger) {
                    setNotificationTrigger(((ProgramNotificationTemplate.NotificationTrigger) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationTrigger\" is of type \"org.hisp.dhis.api.model.v2_35_13.ProgramNotificationTemplate.NotificationTrigger\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notifyParentOrganisationUnitOnly":
                if (value instanceof Boolean) {
                    setNotifyParentOrganisationUnitOnly(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"notifyParentOrganisationUnitOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notifyUsersInHierarchyOnly":
                if (value instanceof Boolean) {
                    setNotifyUsersInHierarchyOnly(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"notifyUsersInHierarchyOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "recipientDataElement":
                if (value instanceof DataElement) {
                    setRecipientDataElement(((DataElement) value));
                } else {
                    throw new IllegalArgumentException(("property \"recipientDataElement\" is of type \"org.hisp.dhis.api.model.v2_35_13.DataElement\", but got "+ value.getClass().toString()));
                }
                return true;
            case "recipientProgramAttribute":
                if (value instanceof TrackedEntityAttribute) {
                    setRecipientProgramAttribute(((TrackedEntityAttribute) value));
                } else {
                    throw new IllegalArgumentException(("property \"recipientProgramAttribute\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackedEntityAttribute\", but got "+ value.getClass().toString()));
                }
                return true;
            case "recipientUserGroup":
                if (value instanceof UserGroup) {
                    setRecipientUserGroup(((UserGroup) value));
                } else {
                    throw new IllegalArgumentException(("property \"recipientUserGroup\" is of type \"org.hisp.dhis.api.model.v2_35_13.UserGroup\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relativeScheduledDays":
                if (value instanceof Integer) {
                    setRelativeScheduledDays(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"relativeScheduledDays\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subjectTemplate":
                if (value instanceof String) {
                    setSubjectTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"subjectTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "deliveryChannels":
                return getDeliveryChannels();
            case "displayMessageTemplate":
                return getDisplayMessageTemplate();
            case "displayName":
                return getDisplayName();
            case "displaySubjectTemplate":
                return getDisplaySubjectTemplate();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "messageTemplate":
                return getMessageTemplate();
            case "name":
                return getName();
            case "notificationRecipient":
                return getNotificationRecipient();
            case "notificationTrigger":
                return getNotificationTrigger();
            case "notifyParentOrganisationUnitOnly":
                return getNotifyParentOrganisationUnitOnly();
            case "notifyUsersInHierarchyOnly":
                return getNotifyUsersInHierarchyOnly();
            case "publicAccess":
                return getPublicAccess();
            case "recipientDataElement":
                return getRecipientDataElement();
            case "recipientProgramAttribute":
                return getRecipientProgramAttribute();
            case "recipientUserGroup":
                return getRecipientUserGroup();
            case "relativeScheduledDays":
                return getRelativeScheduledDays();
            case "subjectTemplate":
                return getSubjectTemplate();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramNotificationTemplate.NOT_FOUND_VALUE);
        if (ProgramNotificationTemplate.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramNotificationTemplate with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramNotificationTemplate.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("deliveryChannels");
        sb.append('=');
        sb.append(((this.deliveryChannels == null)?"<null>":this.deliveryChannels));
        sb.append(',');
        sb.append("displayMessageTemplate");
        sb.append('=');
        sb.append(((this.displayMessageTemplate == null)?"<null>":this.displayMessageTemplate));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displaySubjectTemplate");
        sb.append('=');
        sb.append(((this.displaySubjectTemplate == null)?"<null>":this.displaySubjectTemplate));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("messageTemplate");
        sb.append('=');
        sb.append(((this.messageTemplate == null)?"<null>":this.messageTemplate));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("notificationRecipient");
        sb.append('=');
        sb.append(((this.notificationRecipient == null)?"<null>":this.notificationRecipient));
        sb.append(',');
        sb.append("notificationTrigger");
        sb.append('=');
        sb.append(((this.notificationTrigger == null)?"<null>":this.notificationTrigger));
        sb.append(',');
        sb.append("notifyParentOrganisationUnitOnly");
        sb.append('=');
        sb.append(((this.notifyParentOrganisationUnitOnly == null)?"<null>":this.notifyParentOrganisationUnitOnly));
        sb.append(',');
        sb.append("notifyUsersInHierarchyOnly");
        sb.append('=');
        sb.append(((this.notifyUsersInHierarchyOnly == null)?"<null>":this.notifyUsersInHierarchyOnly));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("recipientDataElement");
        sb.append('=');
        sb.append(((this.recipientDataElement == null)?"<null>":this.recipientDataElement));
        sb.append(',');
        sb.append("recipientProgramAttribute");
        sb.append('=');
        sb.append(((this.recipientProgramAttribute == null)?"<null>":this.recipientProgramAttribute));
        sb.append(',');
        sb.append("recipientUserGroup");
        sb.append('=');
        sb.append(((this.recipientUserGroup == null)?"<null>":this.recipientUserGroup));
        sb.append(',');
        sb.append("relativeScheduledDays");
        sb.append('=');
        sb.append(((this.relativeScheduledDays == null)?"<null>":this.relativeScheduledDays));
        sb.append(',');
        sb.append("subjectTemplate");
        sb.append('=');
        sb.append(((this.subjectTemplate == null)?"<null>":this.subjectTemplate));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.notificationTrigger == null)? 0 :this.notificationTrigger.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.relativeScheduledDays == null)? 0 :this.relativeScheduledDays.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.subjectTemplate == null)? 0 :this.subjectTemplate.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.deliveryChannels == null)? 0 :this.deliveryChannels.hashCode()));
        result = ((result* 31)+((this.displaySubjectTemplate == null)? 0 :this.displaySubjectTemplate.hashCode()));
        result = ((result* 31)+((this.notifyUsersInHierarchyOnly == null)? 0 :this.notifyUsersInHierarchyOnly.hashCode()));
        result = ((result* 31)+((this.recipientDataElement == null)? 0 :this.recipientDataElement.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.notificationRecipient == null)? 0 :this.notificationRecipient.hashCode()));
        result = ((result* 31)+((this.recipientProgramAttribute == null)? 0 :this.recipientProgramAttribute.hashCode()));
        result = ((result* 31)+((this.notifyParentOrganisationUnitOnly == null)? 0 :this.notifyParentOrganisationUnitOnly.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.displayMessageTemplate == null)? 0 :this.displayMessageTemplate.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.recipientUserGroup == null)? 0 :this.recipientUserGroup.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.messageTemplate == null)? 0 :this.messageTemplate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramNotificationTemplate) == false) {
            return false;
        }
        ProgramNotificationTemplate rhs = ((ProgramNotificationTemplate) other);
        return (((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.notificationTrigger == rhs.notificationTrigger)||((this.notificationTrigger!= null)&&this.notificationTrigger.equals(rhs.notificationTrigger))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.relativeScheduledDays == rhs.relativeScheduledDays)||((this.relativeScheduledDays!= null)&&this.relativeScheduledDays.equals(rhs.relativeScheduledDays))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.subjectTemplate == rhs.subjectTemplate)||((this.subjectTemplate!= null)&&this.subjectTemplate.equals(rhs.subjectTemplate))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.deliveryChannels == rhs.deliveryChannels)||((this.deliveryChannels!= null)&&this.deliveryChannels.equals(rhs.deliveryChannels))))&&((this.displaySubjectTemplate == rhs.displaySubjectTemplate)||((this.displaySubjectTemplate!= null)&&this.displaySubjectTemplate.equals(rhs.displaySubjectTemplate))))&&((this.notifyUsersInHierarchyOnly == rhs.notifyUsersInHierarchyOnly)||((this.notifyUsersInHierarchyOnly!= null)&&this.notifyUsersInHierarchyOnly.equals(rhs.notifyUsersInHierarchyOnly))))&&((this.recipientDataElement == rhs.recipientDataElement)||((this.recipientDataElement!= null)&&this.recipientDataElement.equals(rhs.recipientDataElement))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.notificationRecipient == rhs.notificationRecipient)||((this.notificationRecipient!= null)&&this.notificationRecipient.equals(rhs.notificationRecipient))))&&((this.recipientProgramAttribute == rhs.recipientProgramAttribute)||((this.recipientProgramAttribute!= null)&&this.recipientProgramAttribute.equals(rhs.recipientProgramAttribute))))&&((this.notifyParentOrganisationUnitOnly == rhs.notifyParentOrganisationUnitOnly)||((this.notifyParentOrganisationUnitOnly!= null)&&this.notifyParentOrganisationUnitOnly.equals(rhs.notifyParentOrganisationUnitOnly))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.displayMessageTemplate == rhs.displayMessageTemplate)||((this.displayMessageTemplate!= null)&&this.displayMessageTemplate.equals(rhs.displayMessageTemplate))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.recipientUserGroup == rhs.recipientUserGroup)||((this.recipientUserGroup!= null)&&this.recipientUserGroup.equals(rhs.recipientUserGroup))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.messageTemplate == rhs.messageTemplate)||((this.messageTemplate!= null)&&this.messageTemplate.equals(rhs.messageTemplate))));
    }

    @Generated("jsonschema2pojo")
    public enum NotificationTrigger {

        ENROLLMENT("ENROLLMENT"),
        COMPLETION("COMPLETION"),
        PROGRAM_RULE("PROGRAM_RULE"),
        SCHEDULED_DAYS_DUE_DATE("SCHEDULED_DAYS_DUE_DATE"),
        SCHEDULED_DAYS_INCIDENT_DATE("SCHEDULED_DAYS_INCIDENT_DATE"),
        SCHEDULED_DAYS_ENROLLMENT_DATE("SCHEDULED_DAYS_ENROLLMENT_DATE");
        private final String value;
        private final static Map<String, ProgramNotificationTemplate.NotificationTrigger> CONSTANTS = new HashMap<String, ProgramNotificationTemplate.NotificationTrigger>();

        static {
            for (ProgramNotificationTemplate.NotificationTrigger c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NotificationTrigger(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramNotificationTemplate.NotificationTrigger fromValue(String value) {
            ProgramNotificationTemplate.NotificationTrigger constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ProgramNotificationRecipient {

        TRACKED_ENTITY_INSTANCE("TRACKED_ENTITY_INSTANCE"),
        ORGANISATION_UNIT_CONTACT("ORGANISATION_UNIT_CONTACT"),
        USERS_AT_ORGANISATION_UNIT("USERS_AT_ORGANISATION_UNIT"),
        USER_GROUP("USER_GROUP"),
        PROGRAM_ATTRIBUTE("PROGRAM_ATTRIBUTE"),
        DATA_ELEMENT("DATA_ELEMENT");
        private final String value;
        private final static Map<String, ProgramNotificationTemplate.ProgramNotificationRecipient> CONSTANTS = new HashMap<String, ProgramNotificationTemplate.ProgramNotificationRecipient>();

        static {
            for (ProgramNotificationTemplate.ProgramNotificationRecipient c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ProgramNotificationRecipient(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramNotificationTemplate.ProgramNotificationRecipient fromValue(String value) {
            ProgramNotificationTemplate.ProgramNotificationRecipient constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
