
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "operation",
    "path",
    "value"
})
@Generated("jsonschema2pojo")
public class Mutation implements Serializable
{

    @JsonProperty("operation")
    private Mutation.Operation operation;
    @JsonProperty("path")
    private String path;
    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    private Object value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4925490497646256773L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Mutation() {
    }

    /**
     * 
     * @param source
     */
    public Mutation(Mutation source) {
        super();
        this.operation = source.operation;
        this.path = source.path;
        this.value = source.value;
    }

    /**
     * 
     * @param path
     * @param operation
     * @param value
     */
    public Mutation(Mutation.Operation operation, String path, Object value) {
        super();
        this.operation = operation;
        this.path = path;
        this.value = value;
    }

    @JsonProperty("operation")
    public Optional<Mutation.Operation> getOperation() {
        return Optional.ofNullable(operation);
    }

    @JsonProperty("operation")
    public void setOperation(Mutation.Operation operation) {
        this.operation = operation;
    }

    public Mutation withOperation(Mutation.Operation operation) {
        this.operation = operation;
        return this;
    }

    @JsonProperty("path")
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    @JsonProperty("path")
    public void setPath(String path) {
        this.path = path;
    }

    public Mutation withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    public Optional<Object> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    public void setValue(Object value) {
        this.value = value;
    }

    public Mutation withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Mutation withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "operation":
                if (value instanceof Mutation.Operation) {
                    setOperation(((Mutation.Operation) value));
                } else {
                    throw new IllegalArgumentException(("property \"operation\" is of type \"org.hisp.dhis.api.model.v2_35_13.Mutation.Operation\", but got "+ value.getClass().toString()));
                }
                return true;
            case "path":
                if (value instanceof String) {
                    setPath(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"path\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "value":
                if (value instanceof Object) {
                    setValue(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "operation":
                return getOperation();
            case "path":
                return getPath();
            case "value":
                return getValue();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Mutation.NOT_FOUND_VALUE);
        if (Mutation.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Mutation with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Mutation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("operation");
        sb.append('=');
        sb.append(((this.operation == null)?"<null>":this.operation));
        sb.append(',');
        sb.append("path");
        sb.append('=');
        sb.append(((this.path == null)?"<null>":this.path));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.path == null)? 0 :this.path.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.operation == null)? 0 :this.operation.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Mutation) == false) {
            return false;
        }
        Mutation rhs = ((Mutation) other);
        return (((((this.path == rhs.path)||((this.path!= null)&&this.path.equals(rhs.path)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.operation == rhs.operation)||((this.operation!= null)&&this.operation.equals(rhs.operation))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

    @Generated("jsonschema2pojo")
    public enum Operation {

        ADDITION("ADDITION"),
        DELETION("DELETION");
        private final String value;
        private final static Map<String, Mutation.Operation> CONSTANTS = new HashMap<String, Mutation.Operation>();

        static {
            for (Mutation.Operation c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Operation(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Mutation.Operation fromValue(String value) {
            Mutation.Operation constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
