
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "aggregationType",
    "code",
    "description",
    "dimensionItemType",
    "dimensionType",
    "endDate",
    "legendSet",
    "name",
    "startDate",
    "totalAggregationType",
    "uid",
    "valueType"
})
@Generated("jsonschema2pojo")
public class MetadataItem implements Serializable
{

    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("code")
    private String code;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimensionItemType")
    private org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType;
    @JsonProperty("dimensionType")
    private org.hisp.dhis.api.model.v2_35_13.CategoryOptionGroupSet.DimensionType dimensionType;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("legendSet")
    private String legendSet;
    @JsonProperty("name")
    private String name;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonProperty("totalAggregationType")
    private MetadataItem.TotalAggregationType totalAggregationType;
    @JsonProperty("uid")
    private String uid;
    @JsonProperty("valueType")
    private org.hisp.dhis.api.model.v2_35_13.OptionSet.ValueType valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7321359082914922591L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetadataItem() {
    }

    /**
     * 
     * @param source
     */
    public MetadataItem(MetadataItem source) {
        super();
        this.aggregationType = source.aggregationType;
        this.code = source.code;
        this.description = source.description;
        this.dimensionItemType = source.dimensionItemType;
        this.dimensionType = source.dimensionType;
        this.endDate = source.endDate;
        this.legendSet = source.legendSet;
        this.name = source.name;
        this.startDate = source.startDate;
        this.totalAggregationType = source.totalAggregationType;
        this.uid = source.uid;
        this.valueType = source.valueType;
    }

    /**
     * 
     * @param uid
     * @param aggregationType
     * @param dimensionType
     * @param code
     * @param endDate
     * @param valueType
     * @param legendSet
     * @param name
     * @param description
     * @param startDate
     * @param dimensionItemType
     * @param totalAggregationType
     */
    public MetadataItem(AggregationType aggregationType, String code, String description, org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType, org.hisp.dhis.api.model.v2_35_13.CategoryOptionGroupSet.DimensionType dimensionType, Date endDate, String legendSet, String name, Date startDate, MetadataItem.TotalAggregationType totalAggregationType, String uid, org.hisp.dhis.api.model.v2_35_13.OptionSet.ValueType valueType) {
        super();
        this.aggregationType = aggregationType;
        this.code = code;
        this.description = description;
        this.dimensionItemType = dimensionItemType;
        this.dimensionType = dimensionType;
        this.endDate = endDate;
        this.legendSet = legendSet;
        this.name = name;
        this.startDate = startDate;
        this.totalAggregationType = totalAggregationType;
        this.uid = uid;
        this.valueType = valueType;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public MetadataItem withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public MetadataItem withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public MetadataItem withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimensionItemType")
    public Optional<org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType> getDimensionItemType() {
        return Optional.ofNullable(dimensionItemType);
    }

    @JsonProperty("dimensionItemType")
    public void setDimensionItemType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
    }

    public MetadataItem withDimensionItemType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
        return this;
    }

    @JsonProperty("dimensionType")
    public Optional<org.hisp.dhis.api.model.v2_35_13.CategoryOptionGroupSet.DimensionType> getDimensionType() {
        return Optional.ofNullable(dimensionType);
    }

    @JsonProperty("dimensionType")
    public void setDimensionType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionGroupSet.DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public MetadataItem withDimensionType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionGroupSet.DimensionType dimensionType) {
        this.dimensionType = dimensionType;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public MetadataItem withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<String> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(String legendSet) {
        this.legendSet = legendSet;
    }

    public MetadataItem withLegendSet(String legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public MetadataItem withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public MetadataItem withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("totalAggregationType")
    public Optional<MetadataItem.TotalAggregationType> getTotalAggregationType() {
        return Optional.ofNullable(totalAggregationType);
    }

    @JsonProperty("totalAggregationType")
    public void setTotalAggregationType(MetadataItem.TotalAggregationType totalAggregationType) {
        this.totalAggregationType = totalAggregationType;
    }

    public MetadataItem withTotalAggregationType(MetadataItem.TotalAggregationType totalAggregationType) {
        this.totalAggregationType = totalAggregationType;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public MetadataItem withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonProperty("valueType")
    public Optional<org.hisp.dhis.api.model.v2_35_13.OptionSet.ValueType> getValueType() {
        return Optional.ofNullable(valueType);
    }

    @JsonProperty("valueType")
    public void setValueType(org.hisp.dhis.api.model.v2_35_13.OptionSet.ValueType valueType) {
        this.valueType = valueType;
    }

    public MetadataItem withValueType(org.hisp.dhis.api.model.v2_35_13.OptionSet.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MetadataItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "aggregationType":
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_35_13.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItemType":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType) {
                    setDimensionItemType(((org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItemType\" is of type \"org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionType":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.CategoryOptionGroupSet.DimensionType) {
                    setDimensionType(((org.hisp.dhis.api.model.v2_35_13.CategoryOptionGroupSet.DimensionType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionType\" is of type \"org.hisp.dhis.api.model.v2_35_13.CategoryOptionGroupSet.DimensionType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "endDate":
                if (value instanceof Date) {
                    setEndDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof String) {
                    setLegendSet(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "startDate":
                if (value instanceof Date) {
                    setStartDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "totalAggregationType":
                if (value instanceof MetadataItem.TotalAggregationType) {
                    setTotalAggregationType(((MetadataItem.TotalAggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"totalAggregationType\" is of type \"org.hisp.dhis.api.model.v2_35_13.MetadataItem.TotalAggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "uid":
                if (value instanceof String) {
                    setUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "valueType":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.OptionSet.ValueType) {
                    setValueType(((org.hisp.dhis.api.model.v2_35_13.OptionSet.ValueType) value));
                } else {
                    throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v2_35_13.OptionSet.ValueType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "aggregationType":
                return getAggregationType();
            case "code":
                return getCode();
            case "description":
                return getDescription();
            case "dimensionItemType":
                return getDimensionItemType();
            case "dimensionType":
                return getDimensionType();
            case "endDate":
                return getEndDate();
            case "legendSet":
                return getLegendSet();
            case "name":
                return getName();
            case "startDate":
                return getStartDate();
            case "totalAggregationType":
                return getTotalAggregationType();
            case "uid":
                return getUid();
            case "valueType":
                return getValueType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MetadataItem.NOT_FOUND_VALUE);
        if (MetadataItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MetadataItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItemType");
        sb.append('=');
        sb.append(((this.dimensionItemType == null)?"<null>":this.dimensionItemType));
        sb.append(',');
        sb.append("dimensionType");
        sb.append('=');
        sb.append(((this.dimensionType == null)?"<null>":this.dimensionType));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("totalAggregationType");
        sb.append('=');
        sb.append(((this.totalAggregationType == null)?"<null>":this.totalAggregationType));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.dimensionType == null)? 0 :this.dimensionType.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.dimensionItemType == null)? 0 :this.dimensionItemType.hashCode()));
        result = ((result* 31)+((this.totalAggregationType == null)? 0 :this.totalAggregationType.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MetadataItem) == false) {
            return false;
        }
        MetadataItem rhs = ((MetadataItem) other);
        return ((((((((((((((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType)))&&((this.dimensionType == rhs.dimensionType)||((this.dimensionType!= null)&&this.dimensionType.equals(rhs.dimensionType))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.dimensionItemType == rhs.dimensionItemType)||((this.dimensionItemType!= null)&&this.dimensionItemType.equals(rhs.dimensionItemType))))&&((this.totalAggregationType == rhs.totalAggregationType)||((this.totalAggregationType!= null)&&this.totalAggregationType.equals(rhs.totalAggregationType))));
    }

    @Generated("jsonschema2pojo")
    public enum TotalAggregationType {

        SUM("SUM"),
        AVERAGE("AVERAGE");
        private final String value;
        private final static Map<String, MetadataItem.TotalAggregationType> CONSTANTS = new HashMap<String, MetadataItem.TotalAggregationType>();

        static {
            for (MetadataItem.TotalAggregationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TotalAggregationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataItem.TotalAggregationType fromValue(String value) {
            MetadataItem.TotalAggregationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
