
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "atomicMode",
    "csvImportClass",
    "filename",
    "firstRowIsHeader",
    "flushMode",
    "identifier",
    "importMode",
    "importStrategy",
    "mergeMode",
    "metadataSyncImport",
    "preheatMode",
    "skipSharing",
    "skipTranslation",
    "skipValidation",
    "userOverrideMode",
    "username"
})
@Generated("jsonschema2pojo")
public class MetadataImportParams implements Serializable
{

    @JsonProperty("atomicMode")
    private AtomicMode atomicMode;
    @JsonProperty("csvImportClass")
    private CsvImportClass csvImportClass;
    @JsonProperty("filename")
    private String filename;
    @JsonProperty("firstRowIsHeader")
    private Boolean firstRowIsHeader;
    @JsonProperty("flushMode")
    private FlushMode flushMode;
    @JsonProperty("identifier")
    private MetadataImportParams.PreheatIdentifier identifier;
    @JsonProperty("importMode")
    private MetadataImportParams.ObjectBundleMode importMode;
    @JsonProperty("importStrategy")
    private org.hisp.dhis.api.model.v2_35_13.ImportOptions.ImportStrategy importStrategy;
    @JsonProperty("mergeMode")
    private org.hisp.dhis.api.model.v2_35_13.ImportOptions.MergeMode mergeMode;
    @JsonProperty("metadataSyncImport")
    private Boolean metadataSyncImport;
    @JsonProperty("preheatMode")
    private MetadataImportParams.PreheatMode preheatMode;
    @JsonProperty("skipSharing")
    private Boolean skipSharing;
    @JsonProperty("skipTranslation")
    private Boolean skipTranslation;
    @JsonProperty("skipValidation")
    private Boolean skipValidation;
    @JsonProperty("userOverrideMode")
    private MetadataImportParams.UserOverrideMode userOverrideMode;
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3156397011013006058L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetadataImportParams() {
    }

    /**
     * 
     * @param source
     */
    public MetadataImportParams(MetadataImportParams source) {
        super();
        this.atomicMode = source.atomicMode;
        this.csvImportClass = source.csvImportClass;
        this.filename = source.filename;
        this.firstRowIsHeader = source.firstRowIsHeader;
        this.flushMode = source.flushMode;
        this.identifier = source.identifier;
        this.importMode = source.importMode;
        this.importStrategy = source.importStrategy;
        this.mergeMode = source.mergeMode;
        this.metadataSyncImport = source.metadataSyncImport;
        this.preheatMode = source.preheatMode;
        this.skipSharing = source.skipSharing;
        this.skipTranslation = source.skipTranslation;
        this.skipValidation = source.skipValidation;
        this.userOverrideMode = source.userOverrideMode;
        this.username = source.username;
    }

    /**
     * 
     * @param csvImportClass
     * @param firstRowIsHeader
     * @param identifier
     * @param importMode
     * @param preheatMode
     * @param atomicMode
     * @param metadataSyncImport
     * @param userOverrideMode
     * @param mergeMode
     * @param flushMode
     * @param skipSharing
     * @param skipValidation
     * @param filename
     * @param importStrategy
     * @param skipTranslation
     * @param username
     */
    public MetadataImportParams(AtomicMode atomicMode, CsvImportClass csvImportClass, String filename, Boolean firstRowIsHeader, FlushMode flushMode, MetadataImportParams.PreheatIdentifier identifier, MetadataImportParams.ObjectBundleMode importMode, org.hisp.dhis.api.model.v2_35_13.ImportOptions.ImportStrategy importStrategy, org.hisp.dhis.api.model.v2_35_13.ImportOptions.MergeMode mergeMode, Boolean metadataSyncImport, MetadataImportParams.PreheatMode preheatMode, Boolean skipSharing, Boolean skipTranslation, Boolean skipValidation, MetadataImportParams.UserOverrideMode userOverrideMode, String username) {
        super();
        this.atomicMode = atomicMode;
        this.csvImportClass = csvImportClass;
        this.filename = filename;
        this.firstRowIsHeader = firstRowIsHeader;
        this.flushMode = flushMode;
        this.identifier = identifier;
        this.importMode = importMode;
        this.importStrategy = importStrategy;
        this.mergeMode = mergeMode;
        this.metadataSyncImport = metadataSyncImport;
        this.preheatMode = preheatMode;
        this.skipSharing = skipSharing;
        this.skipTranslation = skipTranslation;
        this.skipValidation = skipValidation;
        this.userOverrideMode = userOverrideMode;
        this.username = username;
    }

    @JsonProperty("atomicMode")
    public Optional<AtomicMode> getAtomicMode() {
        return Optional.ofNullable(atomicMode);
    }

    @JsonProperty("atomicMode")
    public void setAtomicMode(AtomicMode atomicMode) {
        this.atomicMode = atomicMode;
    }

    public MetadataImportParams withAtomicMode(AtomicMode atomicMode) {
        this.atomicMode = atomicMode;
        return this;
    }

    @JsonProperty("csvImportClass")
    public Optional<CsvImportClass> getCsvImportClass() {
        return Optional.ofNullable(csvImportClass);
    }

    @JsonProperty("csvImportClass")
    public void setCsvImportClass(CsvImportClass csvImportClass) {
        this.csvImportClass = csvImportClass;
    }

    public MetadataImportParams withCsvImportClass(CsvImportClass csvImportClass) {
        this.csvImportClass = csvImportClass;
        return this;
    }

    @JsonProperty("filename")
    public Optional<String> getFilename() {
        return Optional.ofNullable(filename);
    }

    @JsonProperty("filename")
    public void setFilename(String filename) {
        this.filename = filename;
    }

    public MetadataImportParams withFilename(String filename) {
        this.filename = filename;
        return this;
    }

    @JsonProperty("firstRowIsHeader")
    public Optional<Boolean> getFirstRowIsHeader() {
        return Optional.ofNullable(firstRowIsHeader);
    }

    @JsonProperty("firstRowIsHeader")
    public void setFirstRowIsHeader(Boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
    }

    public MetadataImportParams withFirstRowIsHeader(Boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
        return this;
    }

    @JsonProperty("flushMode")
    public Optional<FlushMode> getFlushMode() {
        return Optional.ofNullable(flushMode);
    }

    @JsonProperty("flushMode")
    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public MetadataImportParams withFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    @JsonProperty("identifier")
    public Optional<MetadataImportParams.PreheatIdentifier> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    @JsonProperty("identifier")
    public void setIdentifier(MetadataImportParams.PreheatIdentifier identifier) {
        this.identifier = identifier;
    }

    public MetadataImportParams withIdentifier(MetadataImportParams.PreheatIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    @JsonProperty("importMode")
    public Optional<MetadataImportParams.ObjectBundleMode> getImportMode() {
        return Optional.ofNullable(importMode);
    }

    @JsonProperty("importMode")
    public void setImportMode(MetadataImportParams.ObjectBundleMode importMode) {
        this.importMode = importMode;
    }

    public MetadataImportParams withImportMode(MetadataImportParams.ObjectBundleMode importMode) {
        this.importMode = importMode;
        return this;
    }

    @JsonProperty("importStrategy")
    public Optional<org.hisp.dhis.api.model.v2_35_13.ImportOptions.ImportStrategy> getImportStrategy() {
        return Optional.ofNullable(importStrategy);
    }

    @JsonProperty("importStrategy")
    public void setImportStrategy(org.hisp.dhis.api.model.v2_35_13.ImportOptions.ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
    }

    public MetadataImportParams withImportStrategy(org.hisp.dhis.api.model.v2_35_13.ImportOptions.ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
        return this;
    }

    @JsonProperty("mergeMode")
    public Optional<org.hisp.dhis.api.model.v2_35_13.ImportOptions.MergeMode> getMergeMode() {
        return Optional.ofNullable(mergeMode);
    }

    @JsonProperty("mergeMode")
    public void setMergeMode(org.hisp.dhis.api.model.v2_35_13.ImportOptions.MergeMode mergeMode) {
        this.mergeMode = mergeMode;
    }

    public MetadataImportParams withMergeMode(org.hisp.dhis.api.model.v2_35_13.ImportOptions.MergeMode mergeMode) {
        this.mergeMode = mergeMode;
        return this;
    }

    @JsonProperty("metadataSyncImport")
    public Optional<Boolean> getMetadataSyncImport() {
        return Optional.ofNullable(metadataSyncImport);
    }

    @JsonProperty("metadataSyncImport")
    public void setMetadataSyncImport(Boolean metadataSyncImport) {
        this.metadataSyncImport = metadataSyncImport;
    }

    public MetadataImportParams withMetadataSyncImport(Boolean metadataSyncImport) {
        this.metadataSyncImport = metadataSyncImport;
        return this;
    }

    @JsonProperty("preheatMode")
    public Optional<MetadataImportParams.PreheatMode> getPreheatMode() {
        return Optional.ofNullable(preheatMode);
    }

    @JsonProperty("preheatMode")
    public void setPreheatMode(MetadataImportParams.PreheatMode preheatMode) {
        this.preheatMode = preheatMode;
    }

    public MetadataImportParams withPreheatMode(MetadataImportParams.PreheatMode preheatMode) {
        this.preheatMode = preheatMode;
        return this;
    }

    @JsonProperty("skipSharing")
    public Optional<Boolean> getSkipSharing() {
        return Optional.ofNullable(skipSharing);
    }

    @JsonProperty("skipSharing")
    public void setSkipSharing(Boolean skipSharing) {
        this.skipSharing = skipSharing;
    }

    public MetadataImportParams withSkipSharing(Boolean skipSharing) {
        this.skipSharing = skipSharing;
        return this;
    }

    @JsonProperty("skipTranslation")
    public Optional<Boolean> getSkipTranslation() {
        return Optional.ofNullable(skipTranslation);
    }

    @JsonProperty("skipTranslation")
    public void setSkipTranslation(Boolean skipTranslation) {
        this.skipTranslation = skipTranslation;
    }

    public MetadataImportParams withSkipTranslation(Boolean skipTranslation) {
        this.skipTranslation = skipTranslation;
        return this;
    }

    @JsonProperty("skipValidation")
    public Optional<Boolean> getSkipValidation() {
        return Optional.ofNullable(skipValidation);
    }

    @JsonProperty("skipValidation")
    public void setSkipValidation(Boolean skipValidation) {
        this.skipValidation = skipValidation;
    }

    public MetadataImportParams withSkipValidation(Boolean skipValidation) {
        this.skipValidation = skipValidation;
        return this;
    }

    @JsonProperty("userOverrideMode")
    public Optional<MetadataImportParams.UserOverrideMode> getUserOverrideMode() {
        return Optional.ofNullable(userOverrideMode);
    }

    @JsonProperty("userOverrideMode")
    public void setUserOverrideMode(MetadataImportParams.UserOverrideMode userOverrideMode) {
        this.userOverrideMode = userOverrideMode;
    }

    public MetadataImportParams withUserOverrideMode(MetadataImportParams.UserOverrideMode userOverrideMode) {
        this.userOverrideMode = userOverrideMode;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public MetadataImportParams withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MetadataImportParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "atomicMode":
                if (value instanceof AtomicMode) {
                    setAtomicMode(((AtomicMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"atomicMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.AtomicMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "csvImportClass":
                if (value instanceof CsvImportClass) {
                    setCsvImportClass(((CsvImportClass) value));
                } else {
                    throw new IllegalArgumentException(("property \"csvImportClass\" is of type \"org.hisp.dhis.api.model.v2_35_13.CsvImportClass\", but got "+ value.getClass().toString()));
                }
                return true;
            case "filename":
                if (value instanceof String) {
                    setFilename(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"filename\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "firstRowIsHeader":
                if (value instanceof Boolean) {
                    setFirstRowIsHeader(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"firstRowIsHeader\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "flushMode":
                if (value instanceof FlushMode) {
                    setFlushMode(((FlushMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"flushMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.FlushMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "identifier":
                if (value instanceof MetadataImportParams.PreheatIdentifier) {
                    setIdentifier(((MetadataImportParams.PreheatIdentifier) value));
                } else {
                    throw new IllegalArgumentException(("property \"identifier\" is of type \"org.hisp.dhis.api.model.v2_35_13.MetadataImportParams.PreheatIdentifier\", but got "+ value.getClass().toString()));
                }
                return true;
            case "importMode":
                if (value instanceof MetadataImportParams.ObjectBundleMode) {
                    setImportMode(((MetadataImportParams.ObjectBundleMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"importMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.MetadataImportParams.ObjectBundleMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "importStrategy":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.ImportOptions.ImportStrategy) {
                    setImportStrategy(((org.hisp.dhis.api.model.v2_35_13.ImportOptions.ImportStrategy) value));
                } else {
                    throw new IllegalArgumentException(("property \"importStrategy\" is of type \"org.hisp.dhis.api.model.v2_35_13.ImportOptions.ImportStrategy\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mergeMode":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.ImportOptions.MergeMode) {
                    setMergeMode(((org.hisp.dhis.api.model.v2_35_13.ImportOptions.MergeMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"mergeMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.ImportOptions.MergeMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "metadataSyncImport":
                if (value instanceof Boolean) {
                    setMetadataSyncImport(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"metadataSyncImport\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "preheatMode":
                if (value instanceof MetadataImportParams.PreheatMode) {
                    setPreheatMode(((MetadataImportParams.PreheatMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"preheatMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.MetadataImportParams.PreheatMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipSharing":
                if (value instanceof Boolean) {
                    setSkipSharing(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipSharing\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipTranslation":
                if (value instanceof Boolean) {
                    setSkipTranslation(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipTranslation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "skipValidation":
                if (value instanceof Boolean) {
                    setSkipValidation(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipValidation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userOverrideMode":
                if (value instanceof MetadataImportParams.UserOverrideMode) {
                    setUserOverrideMode(((MetadataImportParams.UserOverrideMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"userOverrideMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.MetadataImportParams.UserOverrideMode\", but got "+ value.getClass().toString()));
                }
                return true;
            case "username":
                if (value instanceof String) {
                    setUsername(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "atomicMode":
                return getAtomicMode();
            case "csvImportClass":
                return getCsvImportClass();
            case "filename":
                return getFilename();
            case "firstRowIsHeader":
                return getFirstRowIsHeader();
            case "flushMode":
                return getFlushMode();
            case "identifier":
                return getIdentifier();
            case "importMode":
                return getImportMode();
            case "importStrategy":
                return getImportStrategy();
            case "mergeMode":
                return getMergeMode();
            case "metadataSyncImport":
                return getMetadataSyncImport();
            case "preheatMode":
                return getPreheatMode();
            case "skipSharing":
                return getSkipSharing();
            case "skipTranslation":
                return getSkipTranslation();
            case "skipValidation":
                return getSkipValidation();
            case "userOverrideMode":
                return getUserOverrideMode();
            case "username":
                return getUsername();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MetadataImportParams.NOT_FOUND_VALUE);
        if (MetadataImportParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MetadataImportParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataImportParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("atomicMode");
        sb.append('=');
        sb.append(((this.atomicMode == null)?"<null>":this.atomicMode));
        sb.append(',');
        sb.append("csvImportClass");
        sb.append('=');
        sb.append(((this.csvImportClass == null)?"<null>":this.csvImportClass));
        sb.append(',');
        sb.append("filename");
        sb.append('=');
        sb.append(((this.filename == null)?"<null>":this.filename));
        sb.append(',');
        sb.append("firstRowIsHeader");
        sb.append('=');
        sb.append(((this.firstRowIsHeader == null)?"<null>":this.firstRowIsHeader));
        sb.append(',');
        sb.append("flushMode");
        sb.append('=');
        sb.append(((this.flushMode == null)?"<null>":this.flushMode));
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(((this.identifier == null)?"<null>":this.identifier));
        sb.append(',');
        sb.append("importMode");
        sb.append('=');
        sb.append(((this.importMode == null)?"<null>":this.importMode));
        sb.append(',');
        sb.append("importStrategy");
        sb.append('=');
        sb.append(((this.importStrategy == null)?"<null>":this.importStrategy));
        sb.append(',');
        sb.append("mergeMode");
        sb.append('=');
        sb.append(((this.mergeMode == null)?"<null>":this.mergeMode));
        sb.append(',');
        sb.append("metadataSyncImport");
        sb.append('=');
        sb.append(((this.metadataSyncImport == null)?"<null>":this.metadataSyncImport));
        sb.append(',');
        sb.append("preheatMode");
        sb.append('=');
        sb.append(((this.preheatMode == null)?"<null>":this.preheatMode));
        sb.append(',');
        sb.append("skipSharing");
        sb.append('=');
        sb.append(((this.skipSharing == null)?"<null>":this.skipSharing));
        sb.append(',');
        sb.append("skipTranslation");
        sb.append('=');
        sb.append(((this.skipTranslation == null)?"<null>":this.skipTranslation));
        sb.append(',');
        sb.append("skipValidation");
        sb.append('=');
        sb.append(((this.skipValidation == null)?"<null>":this.skipValidation));
        sb.append(',');
        sb.append("userOverrideMode");
        sb.append('=');
        sb.append(((this.userOverrideMode == null)?"<null>":this.userOverrideMode));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.csvImportClass == null)? 0 :this.csvImportClass.hashCode()));
        result = ((result* 31)+((this.firstRowIsHeader == null)? 0 :this.firstRowIsHeader.hashCode()));
        result = ((result* 31)+((this.identifier == null)? 0 :this.identifier.hashCode()));
        result = ((result* 31)+((this.importMode == null)? 0 :this.importMode.hashCode()));
        result = ((result* 31)+((this.preheatMode == null)? 0 :this.preheatMode.hashCode()));
        result = ((result* 31)+((this.atomicMode == null)? 0 :this.atomicMode.hashCode()));
        result = ((result* 31)+((this.metadataSyncImport == null)? 0 :this.metadataSyncImport.hashCode()));
        result = ((result* 31)+((this.userOverrideMode == null)? 0 :this.userOverrideMode.hashCode()));
        result = ((result* 31)+((this.mergeMode == null)? 0 :this.mergeMode.hashCode()));
        result = ((result* 31)+((this.flushMode == null)? 0 :this.flushMode.hashCode()));
        result = ((result* 31)+((this.skipSharing == null)? 0 :this.skipSharing.hashCode()));
        result = ((result* 31)+((this.skipValidation == null)? 0 :this.skipValidation.hashCode()));
        result = ((result* 31)+((this.filename == null)? 0 :this.filename.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importStrategy == null)? 0 :this.importStrategy.hashCode()));
        result = ((result* 31)+((this.skipTranslation == null)? 0 :this.skipTranslation.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MetadataImportParams) == false) {
            return false;
        }
        MetadataImportParams rhs = ((MetadataImportParams) other);
        return ((((((((((((((((((this.csvImportClass == rhs.csvImportClass)||((this.csvImportClass!= null)&&this.csvImportClass.equals(rhs.csvImportClass)))&&((this.firstRowIsHeader == rhs.firstRowIsHeader)||((this.firstRowIsHeader!= null)&&this.firstRowIsHeader.equals(rhs.firstRowIsHeader))))&&((this.identifier == rhs.identifier)||((this.identifier!= null)&&this.identifier.equals(rhs.identifier))))&&((this.importMode == rhs.importMode)||((this.importMode!= null)&&this.importMode.equals(rhs.importMode))))&&((this.preheatMode == rhs.preheatMode)||((this.preheatMode!= null)&&this.preheatMode.equals(rhs.preheatMode))))&&((this.atomicMode == rhs.atomicMode)||((this.atomicMode!= null)&&this.atomicMode.equals(rhs.atomicMode))))&&((this.metadataSyncImport == rhs.metadataSyncImport)||((this.metadataSyncImport!= null)&&this.metadataSyncImport.equals(rhs.metadataSyncImport))))&&((this.userOverrideMode == rhs.userOverrideMode)||((this.userOverrideMode!= null)&&this.userOverrideMode.equals(rhs.userOverrideMode))))&&((this.mergeMode == rhs.mergeMode)||((this.mergeMode!= null)&&this.mergeMode.equals(rhs.mergeMode))))&&((this.flushMode == rhs.flushMode)||((this.flushMode!= null)&&this.flushMode.equals(rhs.flushMode))))&&((this.skipSharing == rhs.skipSharing)||((this.skipSharing!= null)&&this.skipSharing.equals(rhs.skipSharing))))&&((this.skipValidation == rhs.skipValidation)||((this.skipValidation!= null)&&this.skipValidation.equals(rhs.skipValidation))))&&((this.filename == rhs.filename)||((this.filename!= null)&&this.filename.equals(rhs.filename))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importStrategy == rhs.importStrategy)||((this.importStrategy!= null)&&this.importStrategy.equals(rhs.importStrategy))))&&((this.skipTranslation == rhs.skipTranslation)||((this.skipTranslation!= null)&&this.skipTranslation.equals(rhs.skipTranslation))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

    @Generated("jsonschema2pojo")
    public enum ObjectBundleMode {

        COMMIT("COMMIT"),
        VALIDATE("VALIDATE");
        private final String value;
        private final static Map<String, MetadataImportParams.ObjectBundleMode> CONSTANTS = new HashMap<String, MetadataImportParams.ObjectBundleMode>();

        static {
            for (MetadataImportParams.ObjectBundleMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ObjectBundleMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.ObjectBundleMode fromValue(String value) {
            MetadataImportParams.ObjectBundleMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum PreheatIdentifier {

        UID("UID"),
        CODE("CODE"),
        AUTO("AUTO");
        private final String value;
        private final static Map<String, MetadataImportParams.PreheatIdentifier> CONSTANTS = new HashMap<String, MetadataImportParams.PreheatIdentifier>();

        static {
            for (MetadataImportParams.PreheatIdentifier c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PreheatIdentifier(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.PreheatIdentifier fromValue(String value) {
            MetadataImportParams.PreheatIdentifier constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum PreheatMode {

        REFERENCE("REFERENCE"),
        ALL("ALL"),
        NONE("NONE");
        private final String value;
        private final static Map<String, MetadataImportParams.PreheatMode> CONSTANTS = new HashMap<String, MetadataImportParams.PreheatMode>();

        static {
            for (MetadataImportParams.PreheatMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PreheatMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.PreheatMode fromValue(String value) {
            MetadataImportParams.PreheatMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum UserOverrideMode {

        NONE("NONE"),
        CURRENT("CURRENT"),
        SELECTED("SELECTED");
        private final String value;
        private final static Map<String, MetadataImportParams.UserOverrideMode> CONSTANTS = new HashMap<String, MetadataImportParams.UserOverrideMode>();

        static {
            for (MetadataImportParams.UserOverrideMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        UserOverrideMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.UserOverrideMode fromValue(String value) {
            MetadataImportParams.UserOverrideMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
