
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "activeUsers",
    "attributeValues",
    "chartViews",
    "code",
    "created",
    "dashboardViews",
    "dataSetReportViews",
    "displayName",
    "eventChartViews",
    "eventReportViews",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "mapViews",
    "name",
    "publicAccess",
    "reportTableViews",
    "savedCharts",
    "savedDashboards",
    "savedDataValues",
    "savedEventCharts",
    "savedEventReports",
    "savedIndicators",
    "savedMaps",
    "savedReportTables",
    "savedVisualizations",
    "totalViews",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "users",
    "visualizationViews"
})
@Generated("jsonschema2pojo")
public class DataStatistics implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("activeUsers")
    private Integer activeUsers;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("chartViews")
    private Double chartViews;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dashboardViews")
    private Double dashboardViews;
    @JsonProperty("dataSetReportViews")
    private Double dataSetReportViews;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("eventChartViews")
    private Double eventChartViews;
    @JsonProperty("eventReportViews")
    private Double eventReportViews;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("mapViews")
    private Double mapViews;
    @JsonProperty("name")
    private String name;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("reportTableViews")
    private Double reportTableViews;
    @JsonProperty("savedCharts")
    private Double savedCharts;
    @JsonProperty("savedDashboards")
    private Double savedDashboards;
    @JsonProperty("savedDataValues")
    private Double savedDataValues;
    @JsonProperty("savedEventCharts")
    private Double savedEventCharts;
    @JsonProperty("savedEventReports")
    private Double savedEventReports;
    @JsonProperty("savedIndicators")
    private Double savedIndicators;
    @JsonProperty("savedMaps")
    private Double savedMaps;
    @JsonProperty("savedReportTables")
    private Double savedReportTables;
    @JsonProperty("savedVisualizations")
    private Double savedVisualizations;
    @JsonProperty("totalViews")
    private Double totalViews;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("users")
    private Integer users;
    @JsonProperty("visualizationViews")
    private Double visualizationViews;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4022865904324043708L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataStatistics() {
    }

    /**
     * 
     * @param source
     */
    public DataStatistics(DataStatistics source) {
        super();
        this.access = source.access;
        this.activeUsers = source.activeUsers;
        this.attributeValues = source.attributeValues;
        this.chartViews = source.chartViews;
        this.code = source.code;
        this.created = source.created;
        this.dashboardViews = source.dashboardViews;
        this.dataSetReportViews = source.dataSetReportViews;
        this.displayName = source.displayName;
        this.eventChartViews = source.eventChartViews;
        this.eventReportViews = source.eventReportViews;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.mapViews = source.mapViews;
        this.name = source.name;
        this.publicAccess = source.publicAccess;
        this.reportTableViews = source.reportTableViews;
        this.savedCharts = source.savedCharts;
        this.savedDashboards = source.savedDashboards;
        this.savedDataValues = source.savedDataValues;
        this.savedEventCharts = source.savedEventCharts;
        this.savedEventReports = source.savedEventReports;
        this.savedIndicators = source.savedIndicators;
        this.savedMaps = source.savedMaps;
        this.savedReportTables = source.savedReportTables;
        this.savedVisualizations = source.savedVisualizations;
        this.totalViews = source.totalViews;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.users = source.users;
        this.visualizationViews = source.visualizationViews;
    }

    /**
     * 
     * @param favorites
     * @param savedEventCharts
     * @param access
     * @param code
     * @param dataSetReportViews
     * @param displayName
     * @param publicAccess
     * @param savedDashboards
     * @param dashboardViews
     * @param savedIndicators
     * @param eventReportViews
     * @param externalAccess
     * @param savedMaps
     * @param lastUpdated
     * @param translations
     * @param eventChartViews
     * @param mapViews
     * @param chartViews
     * @param href
     * @param id
     * @param visualizationViews
     * @param lastUpdatedBy
     * @param savedCharts
     * @param userGroupAccesses
     * @param created
     * @param savedVisualizations
     * @param attributeValues
     * @param reportTableViews
     * @param savedReportTables
     * @param activeUsers
     * @param users
     * @param userAccesses
     * @param name
     * @param savedDataValues
     * @param totalViews
     * @param favorite
     * @param user
     * @param savedEventReports
     */
    public DataStatistics(Access access, Integer activeUsers, List<AttributeValue> attributeValues, Double chartViews, String code, Date created, Double dashboardViews, Double dataSetReportViews, String displayName, Double eventChartViews, Double eventReportViews, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, User lastUpdatedBy, Double mapViews, String name, String publicAccess, Double reportTableViews, Double savedCharts, Double savedDashboards, Double savedDataValues, Double savedEventCharts, Double savedEventReports, Double savedIndicators, Double savedMaps, Double savedReportTables, Double savedVisualizations, Double totalViews, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, Integer users, Double visualizationViews) {
        super();
        this.access = access;
        this.activeUsers = activeUsers;
        this.attributeValues = attributeValues;
        this.chartViews = chartViews;
        this.code = code;
        this.created = created;
        this.dashboardViews = dashboardViews;
        this.dataSetReportViews = dataSetReportViews;
        this.displayName = displayName;
        this.eventChartViews = eventChartViews;
        this.eventReportViews = eventReportViews;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.mapViews = mapViews;
        this.name = name;
        this.publicAccess = publicAccess;
        this.reportTableViews = reportTableViews;
        this.savedCharts = savedCharts;
        this.savedDashboards = savedDashboards;
        this.savedDataValues = savedDataValues;
        this.savedEventCharts = savedEventCharts;
        this.savedEventReports = savedEventReports;
        this.savedIndicators = savedIndicators;
        this.savedMaps = savedMaps;
        this.savedReportTables = savedReportTables;
        this.savedVisualizations = savedVisualizations;
        this.totalViews = totalViews;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.users = users;
        this.visualizationViews = visualizationViews;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public DataStatistics withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("activeUsers")
    public Optional<Integer> getActiveUsers() {
        return Optional.ofNullable(activeUsers);
    }

    @JsonProperty("activeUsers")
    public void setActiveUsers(Integer activeUsers) {
        this.activeUsers = activeUsers;
    }

    public DataStatistics withActiveUsers(Integer activeUsers) {
        this.activeUsers = activeUsers;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public DataStatistics withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("chartViews")
    public Optional<Double> getChartViews() {
        return Optional.ofNullable(chartViews);
    }

    @JsonProperty("chartViews")
    public void setChartViews(Double chartViews) {
        this.chartViews = chartViews;
    }

    public DataStatistics withChartViews(Double chartViews) {
        this.chartViews = chartViews;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DataStatistics withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DataStatistics withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dashboardViews")
    public Optional<Double> getDashboardViews() {
        return Optional.ofNullable(dashboardViews);
    }

    @JsonProperty("dashboardViews")
    public void setDashboardViews(Double dashboardViews) {
        this.dashboardViews = dashboardViews;
    }

    public DataStatistics withDashboardViews(Double dashboardViews) {
        this.dashboardViews = dashboardViews;
        return this;
    }

    @JsonProperty("dataSetReportViews")
    public Optional<Double> getDataSetReportViews() {
        return Optional.ofNullable(dataSetReportViews);
    }

    @JsonProperty("dataSetReportViews")
    public void setDataSetReportViews(Double dataSetReportViews) {
        this.dataSetReportViews = dataSetReportViews;
    }

    public DataStatistics withDataSetReportViews(Double dataSetReportViews) {
        this.dataSetReportViews = dataSetReportViews;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DataStatistics withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("eventChartViews")
    public Optional<Double> getEventChartViews() {
        return Optional.ofNullable(eventChartViews);
    }

    @JsonProperty("eventChartViews")
    public void setEventChartViews(Double eventChartViews) {
        this.eventChartViews = eventChartViews;
    }

    public DataStatistics withEventChartViews(Double eventChartViews) {
        this.eventChartViews = eventChartViews;
        return this;
    }

    @JsonProperty("eventReportViews")
    public Optional<Double> getEventReportViews() {
        return Optional.ofNullable(eventReportViews);
    }

    @JsonProperty("eventReportViews")
    public void setEventReportViews(Double eventReportViews) {
        this.eventReportViews = eventReportViews;
    }

    public DataStatistics withEventReportViews(Double eventReportViews) {
        this.eventReportViews = eventReportViews;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public DataStatistics withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public DataStatistics withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public DataStatistics withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public DataStatistics withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public DataStatistics withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DataStatistics withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public DataStatistics withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("mapViews")
    public Optional<Double> getMapViews() {
        return Optional.ofNullable(mapViews);
    }

    @JsonProperty("mapViews")
    public void setMapViews(Double mapViews) {
        this.mapViews = mapViews;
    }

    public DataStatistics withMapViews(Double mapViews) {
        this.mapViews = mapViews;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DataStatistics withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public DataStatistics withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("reportTableViews")
    public Optional<Double> getReportTableViews() {
        return Optional.ofNullable(reportTableViews);
    }

    @JsonProperty("reportTableViews")
    public void setReportTableViews(Double reportTableViews) {
        this.reportTableViews = reportTableViews;
    }

    public DataStatistics withReportTableViews(Double reportTableViews) {
        this.reportTableViews = reportTableViews;
        return this;
    }

    @JsonProperty("savedCharts")
    public Optional<Double> getSavedCharts() {
        return Optional.ofNullable(savedCharts);
    }

    @JsonProperty("savedCharts")
    public void setSavedCharts(Double savedCharts) {
        this.savedCharts = savedCharts;
    }

    public DataStatistics withSavedCharts(Double savedCharts) {
        this.savedCharts = savedCharts;
        return this;
    }

    @JsonProperty("savedDashboards")
    public Optional<Double> getSavedDashboards() {
        return Optional.ofNullable(savedDashboards);
    }

    @JsonProperty("savedDashboards")
    public void setSavedDashboards(Double savedDashboards) {
        this.savedDashboards = savedDashboards;
    }

    public DataStatistics withSavedDashboards(Double savedDashboards) {
        this.savedDashboards = savedDashboards;
        return this;
    }

    @JsonProperty("savedDataValues")
    public Optional<Double> getSavedDataValues() {
        return Optional.ofNullable(savedDataValues);
    }

    @JsonProperty("savedDataValues")
    public void setSavedDataValues(Double savedDataValues) {
        this.savedDataValues = savedDataValues;
    }

    public DataStatistics withSavedDataValues(Double savedDataValues) {
        this.savedDataValues = savedDataValues;
        return this;
    }

    @JsonProperty("savedEventCharts")
    public Optional<Double> getSavedEventCharts() {
        return Optional.ofNullable(savedEventCharts);
    }

    @JsonProperty("savedEventCharts")
    public void setSavedEventCharts(Double savedEventCharts) {
        this.savedEventCharts = savedEventCharts;
    }

    public DataStatistics withSavedEventCharts(Double savedEventCharts) {
        this.savedEventCharts = savedEventCharts;
        return this;
    }

    @JsonProperty("savedEventReports")
    public Optional<Double> getSavedEventReports() {
        return Optional.ofNullable(savedEventReports);
    }

    @JsonProperty("savedEventReports")
    public void setSavedEventReports(Double savedEventReports) {
        this.savedEventReports = savedEventReports;
    }

    public DataStatistics withSavedEventReports(Double savedEventReports) {
        this.savedEventReports = savedEventReports;
        return this;
    }

    @JsonProperty("savedIndicators")
    public Optional<Double> getSavedIndicators() {
        return Optional.ofNullable(savedIndicators);
    }

    @JsonProperty("savedIndicators")
    public void setSavedIndicators(Double savedIndicators) {
        this.savedIndicators = savedIndicators;
    }

    public DataStatistics withSavedIndicators(Double savedIndicators) {
        this.savedIndicators = savedIndicators;
        return this;
    }

    @JsonProperty("savedMaps")
    public Optional<Double> getSavedMaps() {
        return Optional.ofNullable(savedMaps);
    }

    @JsonProperty("savedMaps")
    public void setSavedMaps(Double savedMaps) {
        this.savedMaps = savedMaps;
    }

    public DataStatistics withSavedMaps(Double savedMaps) {
        this.savedMaps = savedMaps;
        return this;
    }

    @JsonProperty("savedReportTables")
    public Optional<Double> getSavedReportTables() {
        return Optional.ofNullable(savedReportTables);
    }

    @JsonProperty("savedReportTables")
    public void setSavedReportTables(Double savedReportTables) {
        this.savedReportTables = savedReportTables;
    }

    public DataStatistics withSavedReportTables(Double savedReportTables) {
        this.savedReportTables = savedReportTables;
        return this;
    }

    @JsonProperty("savedVisualizations")
    public Optional<Double> getSavedVisualizations() {
        return Optional.ofNullable(savedVisualizations);
    }

    @JsonProperty("savedVisualizations")
    public void setSavedVisualizations(Double savedVisualizations) {
        this.savedVisualizations = savedVisualizations;
    }

    public DataStatistics withSavedVisualizations(Double savedVisualizations) {
        this.savedVisualizations = savedVisualizations;
        return this;
    }

    @JsonProperty("totalViews")
    public Optional<Double> getTotalViews() {
        return Optional.ofNullable(totalViews);
    }

    @JsonProperty("totalViews")
    public void setTotalViews(Double totalViews) {
        this.totalViews = totalViews;
    }

    public DataStatistics withTotalViews(Double totalViews) {
        this.totalViews = totalViews;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public DataStatistics withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public DataStatistics withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public DataStatistics withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public DataStatistics withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("users")
    public Optional<Integer> getUsers() {
        return Optional.ofNullable(users);
    }

    @JsonProperty("users")
    public void setUsers(Integer users) {
        this.users = users;
    }

    public DataStatistics withUsers(Integer users) {
        this.users = users;
        return this;
    }

    @JsonProperty("visualizationViews")
    public Optional<Double> getVisualizationViews() {
        return Optional.ofNullable(visualizationViews);
    }

    @JsonProperty("visualizationViews")
    public void setVisualizationViews(Double visualizationViews) {
        this.visualizationViews = visualizationViews;
    }

    public DataStatistics withVisualizationViews(Double visualizationViews) {
        this.visualizationViews = visualizationViews;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataStatistics withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "activeUsers":
                if (value instanceof Integer) {
                    setActiveUsers(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"activeUsers\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "chartViews":
                if (value instanceof Double) {
                    setChartViews(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"chartViews\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dashboardViews":
                if (value instanceof Double) {
                    setDashboardViews(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"dashboardViews\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSetReportViews":
                if (value instanceof Double) {
                    setDataSetReportViews(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSetReportViews\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventChartViews":
                if (value instanceof Double) {
                    setEventChartViews(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventChartViews\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "eventReportViews":
                if (value instanceof Double) {
                    setEventReportViews(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"eventReportViews\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "mapViews":
                if (value instanceof Double) {
                    setMapViews(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"mapViews\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "reportTableViews":
                if (value instanceof Double) {
                    setReportTableViews(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"reportTableViews\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedCharts":
                if (value instanceof Double) {
                    setSavedCharts(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedCharts\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedDashboards":
                if (value instanceof Double) {
                    setSavedDashboards(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedDashboards\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedDataValues":
                if (value instanceof Double) {
                    setSavedDataValues(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedDataValues\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedEventCharts":
                if (value instanceof Double) {
                    setSavedEventCharts(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedEventCharts\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedEventReports":
                if (value instanceof Double) {
                    setSavedEventReports(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedEventReports\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedIndicators":
                if (value instanceof Double) {
                    setSavedIndicators(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedIndicators\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedMaps":
                if (value instanceof Double) {
                    setSavedMaps(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedMaps\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedReportTables":
                if (value instanceof Double) {
                    setSavedReportTables(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedReportTables\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "savedVisualizations":
                if (value instanceof Double) {
                    setSavedVisualizations(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"savedVisualizations\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "totalViews":
                if (value instanceof Double) {
                    setTotalViews(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"totalViews\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "users":
                if (value instanceof Integer) {
                    setUsers(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"users\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "visualizationViews":
                if (value instanceof Double) {
                    setVisualizationViews(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"visualizationViews\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "activeUsers":
                return getActiveUsers();
            case "attributeValues":
                return getAttributeValues();
            case "chartViews":
                return getChartViews();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "dashboardViews":
                return getDashboardViews();
            case "dataSetReportViews":
                return getDataSetReportViews();
            case "displayName":
                return getDisplayName();
            case "eventChartViews":
                return getEventChartViews();
            case "eventReportViews":
                return getEventReportViews();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "mapViews":
                return getMapViews();
            case "name":
                return getName();
            case "publicAccess":
                return getPublicAccess();
            case "reportTableViews":
                return getReportTableViews();
            case "savedCharts":
                return getSavedCharts();
            case "savedDashboards":
                return getSavedDashboards();
            case "savedDataValues":
                return getSavedDataValues();
            case "savedEventCharts":
                return getSavedEventCharts();
            case "savedEventReports":
                return getSavedEventReports();
            case "savedIndicators":
                return getSavedIndicators();
            case "savedMaps":
                return getSavedMaps();
            case "savedReportTables":
                return getSavedReportTables();
            case "savedVisualizations":
                return getSavedVisualizations();
            case "totalViews":
                return getTotalViews();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "users":
                return getUsers();
            case "visualizationViews":
                return getVisualizationViews();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataStatistics.NOT_FOUND_VALUE);
        if (DataStatistics.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataStatistics with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataStatistics.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("activeUsers");
        sb.append('=');
        sb.append(((this.activeUsers == null)?"<null>":this.activeUsers));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("chartViews");
        sb.append('=');
        sb.append(((this.chartViews == null)?"<null>":this.chartViews));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dashboardViews");
        sb.append('=');
        sb.append(((this.dashboardViews == null)?"<null>":this.dashboardViews));
        sb.append(',');
        sb.append("dataSetReportViews");
        sb.append('=');
        sb.append(((this.dataSetReportViews == null)?"<null>":this.dataSetReportViews));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("eventChartViews");
        sb.append('=');
        sb.append(((this.eventChartViews == null)?"<null>":this.eventChartViews));
        sb.append(',');
        sb.append("eventReportViews");
        sb.append('=');
        sb.append(((this.eventReportViews == null)?"<null>":this.eventReportViews));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("mapViews");
        sb.append('=');
        sb.append(((this.mapViews == null)?"<null>":this.mapViews));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("reportTableViews");
        sb.append('=');
        sb.append(((this.reportTableViews == null)?"<null>":this.reportTableViews));
        sb.append(',');
        sb.append("savedCharts");
        sb.append('=');
        sb.append(((this.savedCharts == null)?"<null>":this.savedCharts));
        sb.append(',');
        sb.append("savedDashboards");
        sb.append('=');
        sb.append(((this.savedDashboards == null)?"<null>":this.savedDashboards));
        sb.append(',');
        sb.append("savedDataValues");
        sb.append('=');
        sb.append(((this.savedDataValues == null)?"<null>":this.savedDataValues));
        sb.append(',');
        sb.append("savedEventCharts");
        sb.append('=');
        sb.append(((this.savedEventCharts == null)?"<null>":this.savedEventCharts));
        sb.append(',');
        sb.append("savedEventReports");
        sb.append('=');
        sb.append(((this.savedEventReports == null)?"<null>":this.savedEventReports));
        sb.append(',');
        sb.append("savedIndicators");
        sb.append('=');
        sb.append(((this.savedIndicators == null)?"<null>":this.savedIndicators));
        sb.append(',');
        sb.append("savedMaps");
        sb.append('=');
        sb.append(((this.savedMaps == null)?"<null>":this.savedMaps));
        sb.append(',');
        sb.append("savedReportTables");
        sb.append('=');
        sb.append(((this.savedReportTables == null)?"<null>":this.savedReportTables));
        sb.append(',');
        sb.append("savedVisualizations");
        sb.append('=');
        sb.append(((this.savedVisualizations == null)?"<null>":this.savedVisualizations));
        sb.append(',');
        sb.append("totalViews");
        sb.append('=');
        sb.append(((this.totalViews == null)?"<null>":this.totalViews));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("visualizationViews");
        sb.append('=');
        sb.append(((this.visualizationViews == null)?"<null>":this.visualizationViews));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.savedEventCharts == null)? 0 :this.savedEventCharts.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.dataSetReportViews == null)? 0 :this.dataSetReportViews.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.savedDashboards == null)? 0 :this.savedDashboards.hashCode()));
        result = ((result* 31)+((this.dashboardViews == null)? 0 :this.dashboardViews.hashCode()));
        result = ((result* 31)+((this.savedIndicators == null)? 0 :this.savedIndicators.hashCode()));
        result = ((result* 31)+((this.eventReportViews == null)? 0 :this.eventReportViews.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.savedMaps == null)? 0 :this.savedMaps.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.eventChartViews == null)? 0 :this.eventChartViews.hashCode()));
        result = ((result* 31)+((this.mapViews == null)? 0 :this.mapViews.hashCode()));
        result = ((result* 31)+((this.chartViews == null)? 0 :this.chartViews.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.visualizationViews == null)? 0 :this.visualizationViews.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.savedCharts == null)? 0 :this.savedCharts.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.savedVisualizations == null)? 0 :this.savedVisualizations.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.reportTableViews == null)? 0 :this.reportTableViews.hashCode()));
        result = ((result* 31)+((this.savedReportTables == null)? 0 :this.savedReportTables.hashCode()));
        result = ((result* 31)+((this.activeUsers == null)? 0 :this.activeUsers.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.savedDataValues == null)? 0 :this.savedDataValues.hashCode()));
        result = ((result* 31)+((this.totalViews == null)? 0 :this.totalViews.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.savedEventReports == null)? 0 :this.savedEventReports.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataStatistics) == false) {
            return false;
        }
        DataStatistics rhs = ((DataStatistics) other);
        return ((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.savedEventCharts == rhs.savedEventCharts)||((this.savedEventCharts!= null)&&this.savedEventCharts.equals(rhs.savedEventCharts))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.dataSetReportViews == rhs.dataSetReportViews)||((this.dataSetReportViews!= null)&&this.dataSetReportViews.equals(rhs.dataSetReportViews))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.savedDashboards == rhs.savedDashboards)||((this.savedDashboards!= null)&&this.savedDashboards.equals(rhs.savedDashboards))))&&((this.dashboardViews == rhs.dashboardViews)||((this.dashboardViews!= null)&&this.dashboardViews.equals(rhs.dashboardViews))))&&((this.savedIndicators == rhs.savedIndicators)||((this.savedIndicators!= null)&&this.savedIndicators.equals(rhs.savedIndicators))))&&((this.eventReportViews == rhs.eventReportViews)||((this.eventReportViews!= null)&&this.eventReportViews.equals(rhs.eventReportViews))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.savedMaps == rhs.savedMaps)||((this.savedMaps!= null)&&this.savedMaps.equals(rhs.savedMaps))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.eventChartViews == rhs.eventChartViews)||((this.eventChartViews!= null)&&this.eventChartViews.equals(rhs.eventChartViews))))&&((this.mapViews == rhs.mapViews)||((this.mapViews!= null)&&this.mapViews.equals(rhs.mapViews))))&&((this.chartViews == rhs.chartViews)||((this.chartViews!= null)&&this.chartViews.equals(rhs.chartViews))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.visualizationViews == rhs.visualizationViews)||((this.visualizationViews!= null)&&this.visualizationViews.equals(rhs.visualizationViews))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.savedCharts == rhs.savedCharts)||((this.savedCharts!= null)&&this.savedCharts.equals(rhs.savedCharts))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.savedVisualizations == rhs.savedVisualizations)||((this.savedVisualizations!= null)&&this.savedVisualizations.equals(rhs.savedVisualizations))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.reportTableViews == rhs.reportTableViews)||((this.reportTableViews!= null)&&this.reportTableViews.equals(rhs.reportTableViews))))&&((this.savedReportTables == rhs.savedReportTables)||((this.savedReportTables!= null)&&this.savedReportTables.equals(rhs.savedReportTables))))&&((this.activeUsers == rhs.activeUsers)||((this.activeUsers!= null)&&this.activeUsers.equals(rhs.activeUsers))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.savedDataValues == rhs.savedDataValues)||((this.savedDataValues!= null)&&this.savedDataValues.equals(rhs.savedDataValues))))&&((this.totalViews == rhs.totalViews)||((this.totalViews!= null)&&this.totalViews.equals(rhs.totalViews))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.savedEventReports == rhs.savedEventReports)||((this.savedEventReports!= null)&&this.savedEventReports.equals(rhs.savedEventReports))));
    }

}
