/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk;

import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;
import org.hisp.dhis.integration.sdk.api.converter.ConverterFactory;
import org.hisp.dhis.integration.sdk.api.operation.DeleteOperation;
import org.hisp.dhis.integration.sdk.api.operation.GetOperation;
import org.hisp.dhis.integration.sdk.api.operation.PatchOperation;
import org.hisp.dhis.integration.sdk.api.operation.PostOperation;
import org.hisp.dhis.integration.sdk.api.operation.PutOperation;
import org.hisp.dhis.integration.sdk.api.security.SecurityContext;
import org.hisp.dhis.integration.sdk.internal.operation.DefaultDeleteOperation;
import org.hisp.dhis.integration.sdk.internal.operation.DefaultGetOperation;
import org.hisp.dhis.integration.sdk.internal.operation.DefaultPostOperation;
import org.hisp.dhis.integration.sdk.internal.operation.DefaultPutOperation;

public class DefaultDhis2Client
implements Dhis2Client {
    private final OkHttpClient httpClient;
    private final String apiUrl;
    private final ConverterFactory converterFactory;

    DefaultDhis2Client(String apiUrl, SecurityContext securityContext, ConverterFactory converterFactory, int maxIdleConnections, long keepAliveDuration, long callTimeout, long readTimeout, long writeTimeout, long connectTimeout) {
        this.apiUrl = apiUrl;
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(maxIdleConnections, keepAliveDuration, TimeUnit.MILLISECONDS)).callTimeout(callTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS).connectTimeout(connectTimeout, TimeUnit.MILLISECONDS);
        this.httpClient = httpClientBuilder.addInterceptor(chain -> chain.proceed(securityContext.apply(chain.request()))).build();
        this.converterFactory = converterFactory;
    }

    @Override
    public PostOperation post(String path, String ... pathParams) {
        return new DefaultPostOperation(this.apiUrl, path, this.httpClient, this.converterFactory, pathParams);
    }

    @Override
    public PutOperation put(String path, String ... pathParams) {
        return new DefaultPutOperation(this.apiUrl, path, this.httpClient, this.converterFactory, pathParams);
    }

    @Override
    public GetOperation get(String path, String ... pathParams) {
        return new DefaultGetOperation(this.apiUrl, path, this.httpClient, this.converterFactory, pathParams);
    }

    @Override
    public PatchOperation patch(String path, String ... pathParams) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DeleteOperation delete(String path, String ... pathParams) {
        return new DefaultDeleteOperation(this.apiUrl, path, this.httpClient, this.converterFactory, pathParams);
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Override
    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }
}

