/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.internal.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.hisp.dhis.integration.sdk.api.Dhis2ClientException;
import org.hisp.dhis.integration.sdk.api.converter.Converter;

public class JacksonConverter
implements Converter {
    private final ObjectMapper objectMapper;

    public JacksonConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String convert(Object from) {
        try {
            return this.objectMapper.writeValueAsString(from);
        }
        catch (JsonProcessingException e) {
            throw new Dhis2ClientException(e);
        }
    }

    @Override
    public <T> T convert(Object from, Class<T> toType) {
        return (T)this.objectMapper.convertValue(from, toType);
    }

    @Override
    public <T> T convert(Reader source, Class<T> toType) {
        try {
            return (T)this.objectMapper.readValue(source, toType);
        }
        catch (IOException e) {
            throw new Dhis2ClientException(e);
        }
    }

    @Override
    public <T> T convert(List<?> from, Class<T> toCollectionType, Class<?> toElementType) {
        return (T)this.objectMapper.convertValue(from, (JavaType)this.objectMapper.getTypeFactory().constructCollectionLikeType(toCollectionType, toElementType));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

