/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.support.period.type;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractPeriod {
    private static final int WEEK_DAYS = 7;
    private final Calendar initialCalendar;
    protected Calendar calendar;
    final SimpleDateFormat idFormatter;

    AbstractPeriod(Calendar calendar, String dateFormatStr) {
        this.initialCalendar = (Calendar)calendar.clone();
        this.calendar = (Calendar)calendar.clone();
        this.idFormatter = new SimpleDateFormat(dateFormatStr, Locale.US);
    }

    public final synchronized String createPeriod(Date date, int periodOffset) {
        this.calendar = (Calendar)this.initialCalendar.clone();
        this.moveToStartOfThePeriodOfADayWithOffset(date, periodOffset);
        String periodId = this.formatTime();
        this.movePeriods(1);
        this.calendar.add(14, -1);
        this.moveToStartOfThePeriodOfADayWithOffset(date, periodOffset);
        return periodId;
    }

    private void moveToStartOfThePeriodOfADayWithOffset(Date date, int periodOffset) {
        this.calendar.setTime(date);
        AbstractPeriod.setCalendarToStartTimeOfADay(this.calendar);
        this.moveToStartOfCurrentPeriod();
        this.movePeriods(periodOffset);
    }

    static void setCalendarToStartTimeOfADay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    protected abstract void moveToStartOfCurrentPeriod();

    protected abstract void movePeriods(int var1);

    protected String formatTime() {
        return this.idFormatter.format(this.calendar.getTime());
    }

    protected abstract void moveToStartOfCurrentYear();

    protected void setDayOfWeek(Calendar calendar, int targetDayOfWeek) {
        int firstDayOfWeek = calendar.getFirstDayOfWeek();
        int currentDay = calendar.get(7);
        int diff = (targetDayOfWeek - firstDayOfWeek + 7) % 7 - (currentDay - firstDayOfWeek + 7) % 7;
        calendar.add(5, diff);
    }
}

