/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.internal.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.hisp.dhis.integration.sdk.api.Dhis2ClientException;
import org.hisp.dhis.integration.sdk.api.RemoteDhis2ClientException;
import org.hisp.dhis.integration.sdk.api.converter.ConverterFactory;
import org.hisp.dhis.integration.sdk.api.operation.ParameterizedOperation;

public abstract class AbstractOperation<T>
implements ParameterizedOperation<T> {
    protected final String url;
    protected final OkHttpClient httpClient;
    protected final ConverterFactory converterFactory;
    protected final Map<String, List<String>> queryParams = new HashMap<String, List<String>>();
    protected final String baseApiUrl;
    protected final String[] pathParams;
    protected final String path;

    public AbstractOperation(String baseApiUrl, String path, OkHttpClient httpClient, ConverterFactory converterFactory, String ... pathParams) {
        this.baseApiUrl = baseApiUrl;
        this.path = path;
        this.url = (baseApiUrl.endsWith("/") ? baseApiUrl : baseApiUrl + "/") + (path != null && path.startsWith("/") ? path.substring(1) : path);
        this.httpClient = httpClient;
        this.converterFactory = converterFactory;
        this.pathParams = pathParams;
    }

    @Override
    public T transfer() {
        HttpUrl httpUrl = HttpUrl.parse((String)this.url);
        HttpUrl.Builder httpUrlBuilder = httpUrl.newBuilder();
        int pathParamIndex = 0;
        for (int i = 0; i < httpUrl.pathSegments().size(); ++i) {
            String pathSegment = (String)httpUrl.pathSegments().get(i);
            if (!pathSegment.startsWith("{") || !pathSegment.endsWith("}")) continue;
            httpUrlBuilder.setPathSegment(i, this.pathParams[pathParamIndex]);
            ++pathParamIndex;
        }
        for (Map.Entry<String, List<String>> queryParam : this.queryParams.entrySet()) {
            for (String queryValue : queryParam.getValue()) {
                httpUrlBuilder.addQueryParameter(queryParam.getKey(), queryValue);
            }
        }
        return this.doTransfer(httpUrlBuilder.build());
    }

    protected T doTransfer(HttpUrl httpUrl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParameterizedOperation<T> withParameters(Map<String, String> parameters) {
        return this;
    }

    @Override
    public ParameterizedOperation<T> withParameter(String name, String value) {
        List<String> values = this.queryParams.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.queryParams.put(name, values);
        }
        values.add(value);
        return this;
    }

    protected Response onHttpResponse(Callable<Response> callable) {
        Response response;
        try {
            response = callable.call();
        }
        catch (Exception e) {
            throw new Dhis2ClientException(e);
        }
        if (!response.isSuccessful()) {
            response.close();
            throw new RemoteDhis2ClientException(response.toString(), response.code());
        }
        return response;
    }
}

