/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk;

import org.hisp.dhis.integration.sdk.DefaultDhis2Client;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;
import org.hisp.dhis.integration.sdk.api.converter.ConverterFactory;
import org.hisp.dhis.integration.sdk.api.security.SecurityContext;
import org.hisp.dhis.integration.sdk.internal.converter.JacksonConverterFactory;
import org.hisp.dhis.integration.sdk.internal.security.BasicCredentialsSecurityContext;
import org.hisp.dhis.integration.sdk.internal.security.PersonalAccessTokenSecurityContext;

public class Dhis2ClientBuilder {
    private final SecurityContext securityContext;
    private final String baseApiUrl;
    private final int maxIdleConnections;
    private final long keepAliveDurationMs;
    private final long callTimeoutMs;
    private final long readTimeoutMs;
    private final long writeTimeoutMs;
    private final long connectTimeoutMs;
    private ConverterFactory converterFactory = new JacksonConverterFactory();

    public static Dhis2ClientBuilder newClient(String baseApiUrl, String username, String password) {
        return Dhis2ClientBuilder.newClient(baseApiUrl, username, password, 5, 300000L);
    }

    public static Dhis2ClientBuilder newClient(String baseApiUrl, String personalAccessToken) {
        return Dhis2ClientBuilder.newClient(baseApiUrl, personalAccessToken, 5, 300000L, 0L, 10000L, 10000L, 10000L);
    }

    public static Dhis2ClientBuilder newClient(String baseApiUrl, String username, String password, int maxIdleConnections, long keepAliveDurationMs) {
        return new Dhis2ClientBuilder(baseApiUrl, new BasicCredentialsSecurityContext(username, password), maxIdleConnections, keepAliveDurationMs, 0L, 10000L, 10000L, 10000L);
    }

    public static Dhis2ClientBuilder newClient(String baseApiUrl, String personalAccessToken, int maxIdleConnections, long keepAliveDurationMs, long callTimeoutMs, long readTimeoutMs, long writeTimeoutMs, long connectTimeoutMs) {
        return new Dhis2ClientBuilder(baseApiUrl, new PersonalAccessTokenSecurityContext(personalAccessToken), maxIdleConnections, keepAliveDurationMs, callTimeoutMs, readTimeoutMs, writeTimeoutMs, connectTimeoutMs);
    }

    public static Dhis2ClientBuilder newClient(String baseApiUrl, SecurityContext securityContext, int maxIdleConnections, long keepAliveDurationMs, long callTimeoutMs, long readTimeoutMs, long writeTimeoutMs, long connectTimeoutMs) {
        return new Dhis2ClientBuilder(baseApiUrl, securityContext, maxIdleConnections, keepAliveDurationMs, callTimeoutMs, readTimeoutMs, writeTimeoutMs, connectTimeoutMs);
    }

    private Dhis2ClientBuilder(String baseApiUrl, SecurityContext securityContext, int maxIdleConnections, long keepAliveDurationMs, long callTimeoutMs, long readTimeoutMs, long writeTimeoutMs, long connectTimeout) {
        this.baseApiUrl = baseApiUrl.trim();
        this.securityContext = securityContext;
        this.maxIdleConnections = maxIdleConnections;
        this.keepAliveDurationMs = keepAliveDurationMs;
        this.callTimeoutMs = callTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.writeTimeoutMs = writeTimeoutMs;
        this.connectTimeoutMs = connectTimeout;
    }

    public Dhis2ClientBuilder withConverterFactory(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
        return this;
    }

    public Dhis2Client build() {
        StringBuilder apiPathStringBuilder = new StringBuilder();
        apiPathStringBuilder.append(this.baseApiUrl);
        if (!this.baseApiUrl.endsWith("/")) {
            apiPathStringBuilder.append("/");
        }
        return new DefaultDhis2Client(apiPathStringBuilder.toString(), this.securityContext, this.converterFactory, this.maxIdleConnections, this.keepAliveDurationMs, this.callTimeoutMs, this.readTimeoutMs, this.writeTimeoutMs, this.connectTimeoutMs);
    }
}

