/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.vector;

import java.io.Serializable;
import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.descriptive.StorelessMultivariateStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.util.MathUtils;

public class VectorialStorelessStatistic
implements StorelessMultivariateStatistic,
Serializable {
    private static final long serialVersionUID = 20160413L;
    private final StorelessUnivariateStatistic[] stats;

    public VectorialStorelessStatistic(int dimension, StorelessUnivariateStatistic univariateStatistic) {
        if (dimension < 1) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, new Object[]{dimension, 1});
        }
        this.stats = new StorelessUnivariateStatistic[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.stats[i] = univariateStatistic.copy();
        }
    }

    @Override
    public void increment(double[] d) {
        MathUtils.checkDimension((int)d.length, (int)this.stats.length);
        for (int i = 0; i < this.stats.length; ++i) {
            this.stats[i].increment(d[i]);
        }
    }

    @Override
    public double[] getResult() {
        double[] result = new double[this.stats.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.stats[i].getResult();
        }
        return result;
    }

    @Override
    public long getN() {
        return this.stats[0].getN();
    }

    @Override
    public void clear() {
        for (StorelessUnivariateStatistic stat : this.stats) {
            stat.clear();
        }
    }

    @Override
    public int getDimension() {
        return this.stats.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.stats);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VectorialStorelessStatistic)) {
            return false;
        }
        VectorialStorelessStatistic other = (VectorialStorelessStatistic)obj;
        return Arrays.equals(this.stats, other.stats);
    }
}

