/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.MathUtils;

public class Frequency<T extends Comparable<T>>
implements Serializable {
    private static final long serialVersionUID = 20160322L;
    private final NavigableMap<T, Long> freqTable;

    public Frequency() {
        this.freqTable = new TreeMap<T, Long>();
    }

    public Frequency(Comparator<? super T> comparator) {
        this.freqTable = new TreeMap<T, Long>(comparator);
    }

    public void addValue(T v) {
        this.incrementValue(v, 1L);
    }

    public void incrementValue(T v, long increment) {
        Long count = this.freqTable.getOrDefault(v, 0L);
        this.freqTable.put(v, count + increment);
    }

    public void clear() {
        this.freqTable.clear();
    }

    public Iterator<T> valuesIterator() {
        return this.freqTable.keySet().iterator();
    }

    public Iterator<Map.Entry<T, Long>> entrySetIterator() {
        return this.freqTable.entrySet().iterator();
    }

    public long getSumFreq() {
        return this.freqTable.values().stream().mapToLong(Long::longValue).sum();
    }

    public long getCount(T v) {
        return this.freqTable.getOrDefault(v, 0L);
    }

    public int getUniqueCount() {
        return this.freqTable.keySet().size();
    }

    public double getPct(T v) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCount(v) / (double)sumFreq;
    }

    public long getCumFreq(T v) {
        if (this.getSumFreq() == 0L) {
            return 0L;
        }
        NavigableMap<T, Long> headMap = this.freqTable.headMap(v, true);
        if (headMap.isEmpty()) {
            return 0L;
        }
        if (headMap.size() == this.freqTable.size()) {
            return this.getSumFreq();
        }
        return headMap.values().stream().mapToLong(Long::longValue).sum();
    }

    public double getCumPct(T v) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCumFreq(v) / (double)sumFreq;
    }

    public List<T> getMode() {
        long mostPopular = this.freqTable.values().stream().mapToLong(Long::longValue).max().orElse(0L);
        return this.freqTable.entrySet().stream().filter(entry -> (Long)entry.getValue() == mostPopular).map(entry -> (Comparable)entry.getKey()).collect(Collectors.toList());
    }

    public void merge(Frequency<? extends T> other) throws NullArgumentException {
        MathUtils.checkNotNull(other);
        Iterator<Map.Entry<T, Long>> iter = other.entrySetIterator();
        while (iter.hasNext()) {
            Map.Entry<T, Long> entry = iter.next();
            this.incrementValue((Comparable)entry.getKey(), entry.getValue());
        }
    }

    public void merge(Collection<? extends Frequency<? extends T>> others) throws NullArgumentException {
        MathUtils.checkNotNull(others);
        for (Frequency<T> frequency : others) {
            this.merge(frequency);
        }
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        StringBuilder outBuffer = new StringBuilder(200);
        outBuffer.append("Value \tFreq. \tPct. \tCum Pct. \n");
        for (Comparable value : this.freqTable.keySet()) {
            outBuffer.append(value).append('\t').append(this.getCount(value)).append('\t').append(nf.format(this.getPct(value))).append('\t').append(nf.format(this.getCumPct(value))).append('\n');
        }
        return outBuffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.freqTable == null ? 0 : this.freqTable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency other = (Frequency)obj;
        return Objects.equals(this.freqTable, other.freqTable);
    }
}

