/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import java.util.Arrays;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.sampling.AbstractFieldODEStateInterpolator;
import org.hipparchus.util.MathArrays;

class AdamsFieldStateInterpolator<T extends RealFieldElement<T>>
extends AbstractFieldODEStateInterpolator<T> {
    private T scalingH;
    private final FieldODEStateAndDerivative<T> reference;
    private final T[] scaled;
    private final Array2DRowFieldMatrix<T> nordsieck;

    AdamsFieldStateInterpolator(T stepSize, FieldODEStateAndDerivative<T> reference, T[] scaled, Array2DRowFieldMatrix<T> nordsieck, boolean isForward, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> equationsMapper) {
        this((RealFieldElement)stepSize, reference, (RealFieldElement[])scaled, (Array2DRowFieldMatrix)nordsieck, isForward, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, equationsMapper);
    }

    private AdamsFieldStateInterpolator(T stepSize, FieldODEStateAndDerivative<T> reference, T[] scaled, Array2DRowFieldMatrix<T> nordsieck, boolean isForward, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> equationsMapper) {
        super(isForward, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, equationsMapper);
        this.scalingH = stepSize;
        this.reference = reference;
        this.scaled = (RealFieldElement[])scaled.clone();
        this.nordsieck = new Array2DRowFieldMatrix(nordsieck.getData(), false);
    }

    @Override
    protected AdamsFieldStateInterpolator<T> create(boolean newForward, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new AdamsFieldStateInterpolator(this.scalingH, this.reference, this.scaled, this.nordsieck, newForward, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> equationsMapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        return AdamsFieldStateInterpolator.taylor(equationsMapper, this.reference, time, this.scalingH, this.scaled, this.nordsieck);
    }

    public static <S extends RealFieldElement<S>> FieldODEStateAndDerivative<S> taylor(FieldEquationsMapper<S> equationsMapper, FieldODEStateAndDerivative<S> reference, S time, S stepSize, S[] scaled, Array2DRowFieldMatrix<S> nordsieck) {
        RealFieldElement x = (RealFieldElement)time.subtract(reference.getTime());
        RealFieldElement normalizedAbscissa = (RealFieldElement)x.divide(stepSize);
        Object[] stateVariation = (RealFieldElement[])MathArrays.buildArray((Field)time.getField(), (int)scaled.length);
        Arrays.fill(stateVariation, time.getField().getZero());
        Object[] estimatedDerivatives = (RealFieldElement[])MathArrays.buildArray((Field)time.getField(), (int)scaled.length);
        Arrays.fill(estimatedDerivatives, time.getField().getZero());
        RealFieldElement[][] nData = (RealFieldElement[][])nordsieck.getDataRef();
        for (int i = nData.length - 1; i >= 0; --i) {
            int order = i + 2;
            RealFieldElement[] nDataI = nData[i];
            RealFieldElement power = (RealFieldElement)normalizedAbscissa.pow(order);
            for (int j = 0; j < nDataI.length; ++j) {
                RealFieldElement d = (RealFieldElement)nDataI[j].multiply((Object)power);
                stateVariation[j] = (RealFieldElement)stateVariation[j].add((Object)d);
                estimatedDerivatives[j] = (RealFieldElement)estimatedDerivatives[j].add(d.multiply(order));
            }
        }
        RealFieldElement[] estimatedState = reference.getCompleteState();
        for (int j = 0; j < stateVariation.length; ++j) {
            stateVariation[j] = (RealFieldElement)stateVariation[j].add(scaled[j].multiply((Object)normalizedAbscissa));
            estimatedState[j] = (RealFieldElement)estimatedState[j].add(stateVariation[j]);
            estimatedDerivatives[j] = (RealFieldElement)((RealFieldElement)estimatedDerivatives[j].add(scaled[j].multiply((Object)normalizedAbscissa))).divide((Object)x);
        }
        return equationsMapper.mapStateAndDerivative(time, estimatedState, (RealFieldElement[])estimatedDerivatives);
    }
}

