/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import java.util.Arrays;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FilterType;
import org.hipparchus.ode.events.ODEEventHandler;
import org.hipparchus.ode.events.Transformer;

public class EventFilter
implements ODEEventHandler {
    private static final int HISTORY_SIZE = 100;
    private final ODEEventHandler rawHandler;
    private final FilterType filter;
    private final Transformer[] transformers;
    private final double[] updates;
    private boolean forward;
    private double extremeT;

    public EventFilter(ODEEventHandler rawHandler, FilterType filter) {
        this.rawHandler = rawHandler;
        this.filter = filter;
        this.transformers = new Transformer[100];
        this.updates = new double[100];
    }

    @Override
    public void init(ODEStateAndDerivative initialState, double finalTime) {
        this.rawHandler.init(initialState, finalTime);
        this.forward = finalTime >= initialState.getTime();
        this.extremeT = this.forward ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        Arrays.fill((Object[])this.transformers, (Object)Transformer.UNINITIALIZED);
        Arrays.fill(this.updates, this.extremeT);
    }

    @Override
    public double g(ODEStateAndDerivative state) {
        double rawG = this.rawHandler.g(state);
        if (this.forward) {
            int last = this.transformers.length - 1;
            if (this.extremeT < state.getTime()) {
                Transformer previous = this.transformers[last];
                Transformer next = this.filter.selectTransformer(previous, rawG, this.forward);
                if (next != previous) {
                    System.arraycopy(this.updates, 1, this.updates, 0, last);
                    System.arraycopy(this.transformers, 1, this.transformers, 0, last);
                    this.updates[last] = this.extremeT;
                    this.transformers[last] = next;
                }
                this.extremeT = state.getTime();
                return next.transformed(rawG);
            }
            for (int i = last; i > 0; --i) {
                if (!(this.updates[i] <= state.getTime())) continue;
                return this.transformers[i].transformed(rawG);
            }
            return this.transformers[0].transformed(rawG);
        }
        if (state.getTime() < this.extremeT) {
            Transformer previous = this.transformers[0];
            Transformer next = this.filter.selectTransformer(previous, rawG, this.forward);
            if (next != previous) {
                System.arraycopy(this.updates, 0, this.updates, 1, this.updates.length - 1);
                System.arraycopy(this.transformers, 0, this.transformers, 1, this.transformers.length - 1);
                this.updates[0] = this.extremeT;
                this.transformers[0] = next;
            }
            this.extremeT = state.getTime();
            return next.transformed(rawG);
        }
        for (int i = 0; i < this.updates.length - 1; ++i) {
            if (!(state.getTime() <= this.updates[i])) continue;
            return this.transformers[i].transformed(rawG);
        }
        return this.transformers[this.updates.length - 1].transformed(rawG);
    }

    @Override
    public Action eventOccurred(ODEStateAndDerivative state, boolean increasing) {
        return this.rawHandler.eventOccurred(state, this.filter.isTriggeredOnIncreasing());
    }

    @Override
    public ODEState resetState(ODEStateAndDerivative state) {
        return this.rawHandler.resetState(state);
    }
}

