/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.execution.jco;

import org.hibersap.HibersapException;
import org.hibersap.bapi.BapiTransactionCommit;
import org.hibersap.bapi.BapiTransactionRollback;
import org.hibersap.mapping.AnnotationBapiMapper;
import org.hibersap.mapping.model.BapiMapping;
import org.hibersap.session.AbstractTransaction;
import org.hibersap.session.SessionImplementor;

public class JCoTransaction
extends AbstractTransaction {
    private final SessionImplementor session;
    private BapiMapping bapiCommit;
    private BapiMapping bapiRollback;
    private boolean inTransaction = false;

    public JCoTransaction(SessionImplementor session) {
        this.session = session;
        this.initTransactionBapis();
    }

    public void begin() {
        if (this.inTransaction) {
            throw new HibersapException("Transaction was already started");
        }
        this.inTransaction = true;
    }

    public void commit() {
        this.errorIfNotInTransaction();
        this.notifySynchronizationsBeforeCompletion();
        try {
            this.executeBapi(new BapiTransactionCommit(), this.bapiCommit);
            this.notifySynchronizationsAfterCompletion(true);
        }
        catch (RuntimeException e) {
            this.notifySynchronizationsAfterCompletion(false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        this.errorIfNotInTransaction();
        try {
            this.executeBapi(new BapiTransactionRollback(), this.bapiRollback);
        }
        finally {
            this.notifySynchronizationsAfterCompletion(false);
        }
    }

    private void errorIfNotInTransaction() {
        if (!this.inTransaction) {
            throw new HibersapException("Not in transaction");
        }
    }

    private void executeBapi(Object bapi, BapiMapping mapping) {
        this.session.execute(bapi, mapping);
    }

    private void initTransactionBapis() {
        AnnotationBapiMapper mapper = new AnnotationBapiMapper();
        this.bapiCommit = mapper.mapBapi(BapiTransactionCommit.class);
        this.bapiRollback = mapper.mapBapi(BapiTransactionRollback.class);
    }
}

