/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.lucene.LuceneBackend;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.impl.V5MigrationOrmSearchIntegratorAdapter;
import org.hibernate.search.mapper.orm.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class SearchFactoryImpl
implements SearchFactory {
    public static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private final V5MigrationOrmSearchIntegratorAdapter searchIntegrator;

    public SearchFactoryImpl(V5MigrationOrmSearchIntegratorAdapter searchIntegrator) {
        this.searchIntegrator = searchIntegrator;
    }

    @Override
    public void optimize() {
        this.optimize(Object.class);
    }

    @Override
    public void optimize(Class<?> clazz) {
        this.searchIntegrator.toSearchMapping().scope(clazz).workspace().mergeSegments();
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return (Analyzer)((LuceneBackend)this.searchIntegrator.toSearchMapping().backend().unwrap(LuceneBackend.class)).analyzer(name).orElseThrow(() -> log.unknownAnalyzer(name));
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        return ((LuceneIndexManager)this.searchIntegrator.toSearchMapping().indexedEntity(clazz).indexManager().unwrap(LuceneIndexManager.class)).indexingAnalyzer();
    }

    @Override
    public QueryContextBuilder buildQueryBuilder() {
        return this.searchIntegrator.buildQueryBuilder();
    }

    @Override
    public Set<Class<?>> getIndexedTypes() {
        return this.searchIntegrator.toSearchMapping().allIndexedEntities().stream().map(SearchIndexedEntity::javaClass).collect(Collectors.toSet());
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (SearchIntegrator.class.isAssignableFrom(cls)) {
            return (T)this.searchIntegrator;
        }
        if (SearchMapping.class.isAssignableFrom(cls)) {
            return (T)this.searchIntegrator.toSearchMapping();
        }
        throw log.cannotUnwrapSearchFactory(cls);
    }
}

