/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class FacetBuildingContext<T> {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final List<String> allowedRangeTypes = Arrays.asList(String.class.getName(), Integer.class.getName(), Long.class.getName(), Double.class.getName(), Float.class.getName(), Date.class.getName());
    private final QueryBuildingContext context;
    private String name;
    private String fieldName;
    private FacetSortOrder sort = FacetSortOrder.COUNT_DESC;
    private boolean includeZeroCount = false;
    private boolean isRangeQuery = false;
    private List<FacetRange<T>> rangeList = new ArrayList<FacetRange<T>>();
    private T rangeStart;
    private boolean includeRangeStart = true;
    private T rangeEnd;
    private boolean includeRangeEnd = true;
    private int maxFacetCount = -1;

    public FacetBuildingContext(QueryBuildingContext context) {
        this.context = context;
    }

    void setName(String name) {
        this.name = name;
    }

    void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    void setSort(FacetSortOrder sort) {
        this.sort = sort;
    }

    void setIncludeZeroCount(boolean includeZeroCount) {
        this.includeZeroCount = includeZeroCount;
    }

    public void setRangeQuery(boolean rangeQuery) {
        this.isRangeQuery = rangeQuery;
    }

    public void setRangeStart(T rangeStart) {
        this.rangeStart = rangeStart;
    }

    public void setIncludeRangeStart(boolean includeRangeStart) {
        this.includeRangeStart = includeRangeStart;
    }

    public void setRangeEnd(T rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    public void setIncludeRangeEnd(boolean includeRangeEnd) {
        this.includeRangeEnd = includeRangeEnd;
    }

    public void setMaxFacetCount(int maxFacetCount) {
        this.maxFacetCount = maxFacetCount;
    }

    public void makeRange() {
        Class<?> type = this.getRangeType();
        this.assertValidRangeType(type);
        FacetRange facetRange = new FacetRange(type, Range.between(this.rangeStart, (RangeBoundInclusion)(this.includeRangeStart ? RangeBoundInclusion.INCLUDED : RangeBoundInclusion.EXCLUDED), this.rangeEnd, (RangeBoundInclusion)(this.includeRangeEnd ? RangeBoundInclusion.INCLUDED : RangeBoundInclusion.EXCLUDED)), this.fieldName);
        this.rangeList.add(facetRange);
        this.rangeStart = null;
        this.rangeEnd = null;
        this.includeRangeStart = true;
        this.includeRangeEnd = true;
    }

    private void assertValidRangeType(Class<?> clazz) {
        if (!allowedRangeTypes.contains(clazz.getName())) {
            throw log.unsupportedParameterTypeForRangeFaceting(clazz.getName(), StringHelper.join(allowedRangeTypes, ","));
        }
    }

    private Class<?> getRangeType() {
        if (this.rangeStart == null && this.rangeEnd == null) {
            throw log.noStartOrEndSpecifiedForRangeQuery(this.name);
        }
        T tmp = this.rangeStart;
        if (tmp == null) {
            tmp = this.rangeEnd;
        }
        return tmp.getClass();
    }

    FacetingRequest getFacetingRequest() {
        FacetingRequestImpl request;
        if (this.isRangeQuery) {
            request = new RangeFacetRequest<T>(this.name, this.fieldName, this.rangeList);
        } else {
            if (FacetSortOrder.RANGE_DEFINITION_ORDER.equals((Object)this.sort)) {
                throw log.rangeDefinitionOrderRequestedForDiscreteFacetRequest();
            }
            request = new DiscreteFacetRequest(this.name, this.fieldName);
        }
        request.setSort(this.sort);
        request.setIncludeZeroCounts(this.includeZeroCount);
        request.setMaxNumberOfFacets(this.maxFacetCount);
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FacetBuildingContext");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append(", sort=").append((Object)this.sort);
        sb.append(", includeZeroCount=").append(this.includeZeroCount);
        sb.append(", isRangeQuery=").append(this.isRangeQuery);
        sb.append(", rangeList=").append(this.rangeList);
        sb.append(", rangeStart=").append(this.rangeStart);
        sb.append(", includeRangeStart=").append(this.includeRangeStart);
        sb.append(", rangeEnd=").append(this.rangeEnd);
        sb.append(", includeRangeEnd=").append(this.includeRangeEnd);
        sb.append('}');
        return sb.toString();
    }
}

