/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.query.dsl.PhraseMatchingContext;
import org.hibernate.search.query.dsl.PhraseTermination;
import org.hibernate.search.query.dsl.impl.ConnectedMultiFieldsPhraseQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.PhraseQueryContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

public class ConnectedPhraseMatchingContext
implements PhraseMatchingContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final PhraseQueryContext phraseContext;
    private final FieldsContext fieldsContext;

    public ConnectedPhraseMatchingContext(String fieldName, PhraseQueryContext phraseContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.phraseContext = phraseContext;
        this.fieldsContext = new FieldsContext(new String[]{fieldName}, queryContext);
    }

    @Override
    public PhraseMatchingContext andField(String field) {
        this.fieldsContext.add(field);
        return this;
    }

    @Override
    public PhraseTermination sentence(String sentence) {
        this.phraseContext.setSentence(sentence);
        return new ConnectedMultiFieldsPhraseQueryBuilder(this.queryContext, this.queryCustomizer, this.fieldsContext, this.phraseContext);
    }

    @Override
    public PhraseMatchingContext boostedTo(float boost) {
        this.fieldsContext.boostedTo(boost);
        return this;
    }

    @Override
    public PhraseMatchingContext ignoreAnalyzer() {
        this.fieldsContext.ignoreAnalyzer();
        return this;
    }

    @Override
    public PhraseMatchingContext ignoreFieldBridge() {
        this.fieldsContext.ignoreFieldBridge();
        return this;
    }
}

