/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.query.dsl.SimpleQueryStringDefinitionTermination;
import org.hibernate.search.query.dsl.SimpleQueryStringMatchingContext;
import org.hibernate.search.query.dsl.SimpleQueryStringTermination;
import org.hibernate.search.query.dsl.impl.ConnectedMultiFieldsSimpleQueryStringQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

public class ConnectedSimpleQueryStringMatchingContext
implements SimpleQueryStringMatchingContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final FieldsContext fieldsContext;
    private boolean withAndAsDefaultOperator = false;

    public ConnectedSimpleQueryStringMatchingContext(String field, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldsContext = new FieldsContext(new String[]{field}, queryContext);
    }

    public ConnectedSimpleQueryStringMatchingContext(String[] fields, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldsContext = new FieldsContext(fields, queryContext);
    }

    @Override
    public SimpleQueryStringMatchingContext andField(String field) {
        this.fieldsContext.add(field);
        return this;
    }

    @Override
    public SimpleQueryStringMatchingContext andFields(String ... fields) {
        this.fieldsContext.addAll(fields);
        return this;
    }

    @Override
    public SimpleQueryStringMatchingContext boostedTo(float boost) {
        this.fieldsContext.boostedTo(boost);
        return this;
    }

    @Override
    public SimpleQueryStringTermination matching(String simpleQueryString) {
        return new ConnectedMultiFieldsSimpleQueryStringQueryBuilder(this.queryContext, this.queryCustomizer, this.fieldsContext, simpleQueryString, this.withAndAsDefaultOperator);
    }

    @Override
    public SimpleQueryStringDefinitionTermination withAndAsDefaultOperator() {
        this.withAndAsDefaultOperator = true;
        return this;
    }
}

