/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class TermQueryContext {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Approximation approximation;
    private int maxEditDistance = 2;
    private int prefixLength = 0;

    public TermQueryContext(Approximation approximation) {
        this.approximation = approximation;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public Approximation getApproximation() {
        return this.approximation;
    }

    public int getMaxEditDistance() {
        return this.maxEditDistance;
    }

    public void setMaxEditDistance(int maxEditDistance) {
        if (maxEditDistance < 1 || maxEditDistance > 2) {
            throw log.incorrectEditDistance();
        }
        this.maxEditDistance = maxEditDistance;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public static enum Approximation {
        EXACT,
        WILDCARD,
        FUZZY;

    }
}

