/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.logging.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.logging.impl.TypeFormatter;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@CategorizedLogger(category="org.hibernate.search", description="The root category for any Hibernate Search logs.\nIt may also include logs that do not fit any other, more specific, logging category.\n")
@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=900000, max=909999)})
public interface CommonMiscLog {
    public static final String CATEGORY_NAME = "org.hibernate.search";
    public static final CommonMiscLog INSTANCE = LoggerFactory.make(CommonMiscLog.class, "org.hibernate.search", MethodHandles.lookup());
    public static final int ID_OFFSET = 900000;

    @Message(id=900000, value="'%1$s' must not be null.")
    public IllegalArgumentException mustNotBeNull(String var1);

    @Message(id=900001, value="'%1$s' must not be null or empty.")
    public IllegalArgumentException collectionMustNotBeNullNorEmpty(String var1);

    @Message(id=900002, value="'%1$s' must be positive or zero.")
    public IllegalArgumentException mustBePositiveOrZero(String var1);

    @Message(id=900003, value="'%1$s' must not be null or empty.")
    public IllegalArgumentException stringMustNotBeNullNorEmpty(String var1);

    @Message(id=900004, value="'%1$s' must not be null or empty.")
    public IllegalArgumentException arrayMustNotBeNullNorEmpty(String var1);

    @Message(id=900005, value="Exception while invoking '%1$s' on '%2$s': %3$s.")
    public SearchException errorInvokingMember(Member var1, String var2, @Cause Throwable var3, String var4);

    @Message(id=900006, value="Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s doesn't declare any type parameter.")
    public IllegalArgumentException cannotRequestTypeParameterOfUnparameterizedType(@FormatWith(value=TypeFormatter.class) Type var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, int var3);

    @Message(id=900007, value="Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s only declares %4$s type parameter(s).")
    public IllegalArgumentException typeParameterIndexOutOfBound(@FormatWith(value=TypeFormatter.class) Type var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, int var3, int var4);

    @Message(id=900008, value="Requested type argument index %3$s to type %2$s in implementing type %1$s should be 0 or greater.")
    public IllegalArgumentException invalidTypeParameterIndex(@FormatWith(value=TypeFormatter.class) Type var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=900009, value="Unable to access the value of containing annotation '%1$s'. Ignoring annotation.")
    public void cannotAccessRepeateableContainingAnnotationValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Throwable var2);

    @Message(id=900010, value="'%1$s' must be strictly positive.")
    public IllegalArgumentException mustBeStrictlyPositive(String var1);

    @Message(id=900011, value="'%1$s' must not contain any null element.")
    public IllegalArgumentException collectionMustNotContainNullElement(String var1);

    @Message(id=900012, value="Exception while invoking '%1$s' with arguments %2$s: %3$s")
    public SearchException errorInvokingStaticMember(Member var1, String var2, @Cause Throwable var3, String var4);

    @Message(id=900013, value="Exception while accessing Jandex index for '%1$s': %2$s")
    public SearchException errorAccessingJandexIndex(URL var1, String var2, @Cause Throwable var3);

    @Message(id=900014, value="Exception while building Jandex index for '%1$s': %2$s")
    public SearchException errorBuildingJandexIndex(URL var1, String var2, @Cause Throwable var3);

    @Message(id=900016, value="Cannot open filesystem for code source at '%1$s': %2$s")
    public IOException cannotOpenCodeSourceFileSystem(URL var1, String var2, @Cause Throwable var3);

    @Message(id=900017, value="Cannot interpret '%1$s' as a local directory or JAR.")
    public IOException cannotInterpretCodeSourceUrl(URL var1);

    @Message(id=900018, value="Cannot open a ZIP filesystem for code source at '%1$s', because the URI points to content inside a nested JAR. Run your application on JDK13+ to get nested JAR support, or disable JAR scanning by setting a mapping configurer that calls .discoverAnnotatedTypesFromRootMappingAnnotations(false). See the reference documentation for information about mapping configurers.")
    public SearchException cannotOpenNestedJar(URI var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=900019, value="Unexpected structure for META-INF/versions entry: %s")
    public void metaInfVersionBadStructure(Path var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=900020, value="Failed to parse META-INF/versions entry: %s")
    public void metaInfVersionParsingFailed(Path var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=900021, value="Cancelling CompletableFuture %s (mayInterruptIfRunning = %s)")
    public void cancellingCompletableFuture(CompletableFuture<?> var1, boolean var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=900022, value="Cancelling Future %s (mayInterruptIfRunning = %s)")
    public void cancellingFuture(Future<?> var1, boolean var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=900023, value="Could not cancel Future %s (mayInterruptIfRunning = %s)")
    public void cancellingFutureFailed(Future<?> var1, boolean var2);
}

