/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.hibernate.search.util.common.AssertionFailure;

public final class StreamHelper {
    private StreamHelper() {
    }

    public static <T, E extends RuntimeException> Collector<T, ?, T> singleElement(Supplier<E> missingValueExceptionSupplier, Supplier<E> multipleValuesExceptionSupplier) {
        return Collector.of(() -> new Optional[1], (holder, value) -> {
            if (holder[0] != null) {
                throw (RuntimeException)multipleValuesExceptionSupplier.get();
            }
            holder[0] = Optional.ofNullable(value);
        }, (holder1, holder2) -> {
            if (holder1[0] == null) {
                return holder2;
            }
            if (holder2[0] != null) {
                throw (RuntimeException)multipleValuesExceptionSupplier.get();
            }
            return holder1;
        }, holder -> {
            if (holder[0] == null) {
                throw (RuntimeException)missingValueExceptionSupplier.get();
            }
            return holder[0].orElse(null);
        }, new Collector.Characteristics[0]);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<M> mapSupplier) {
        return Collectors.toMap(keyMapper, valueMapper, StreamHelper.throwingMerger(), mapSupplier);
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new AssertionFailure("Unexpected duplicate key: " + String.valueOf(u));
        };
    }
}

