/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter;
import org.hibernate.search.mapper.pojo.common.annotation.impl.SearchProcessingWithContextException;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.indexing.mapper")
@MessageLogger(projectCode="HSEARCH")
public interface IndexingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.indexing.mapper";
    public static final IndexingLog INSTANCE = (IndexingLog)LoggerFactory.make(IndexingLog.class, (String)"org.hibernate.search.indexing.mapper", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(value="%1$s")
    public SearchProcessingWithContextException searchProcessingFailure(@Cause Throwable var1, String var2, @Param EventContext var3);

    @Message(id=700038, value="The entity identifier must not be null.")
    public SearchException nullProvidedIdentifier();

    @Message(id=700060, value="Unable to trigger entity processing while already processing entities. Make sure you do not change entities within an entity getter or a custom bridge used for indexing, and avoid any event that could trigger entity processing. Hibernate ORM flushes, in particular, must be avoided in entity getters and bridges.")
    public SearchException recursiveIndexingPlanProcess();

    @Message(id=700083, value="Exception while building document for entity '%1$s': %2$s")
    public SearchException errorBuildingDocument(EntityReference var1, String var2, @Cause Exception var3);

    @Message(id=700084, value="Exception while resolving other entities to reindex as a result of changes on entity '%1$s': %2$s")
    public SearchException errorResolvingEntitiesToReindex(EntityReference var1, String var2, @Cause Exception var3);

    @Message(id=700087, value="Invalid indexing request: if the entity is null, the identifier must be provided explicitly.")
    public SearchException nullProvidedIdentifierAndEntity();

    @Message(id=700088, value="Invalid indexing request: the add and update operations require a non-null entity.")
    public SearchException nullEntityForIndexerAddOrUpdate();

    @Message(id=700124, value="Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.")
    public SearchException indexingFailure(String var1, List<?> var2, @Cause Throwable var3);

    @Message(id=700128, value="Indexing plan for '%1$s' cannot be created as this type is excluded by the indexing plan filter.")
    public SearchException attemptToCreateIndexingPlanForExcludedType(PojoRawTypeIdentifier<?> var1);

    @Message(id=700129, value="'%1$s' cannot be included and excluded at the same time within one filter. Already included types: '%2$s'. Already excluded types: '%3$s'.")
    public SearchException indexingPlanFilterCannotIncludeExcludeSameType(PojoRawTypeIdentifier<?> var1, Set<PojoRawTypeIdentifier<?>> var2, Set<PojoRawTypeIdentifier<?>> var3);

    @Message(id=700155, value="Cannot load entities of type '%s': no selection loading strategy registered for this type.")
    public SearchException noSelectionLoadingStrategy(String var1);

    @Message(id=700156, value="Cannot load entities of type '%s': no mass loading strategy registered for this type.")
    public SearchException noMassLoadingStrategy(String var1);

    @Message(id=700157, value="Type mismatch when applying loading binder to type '%1$s': the binder expects the entity type to extend '%2$s', but entity type '%1$s' does not.")
    public SearchException loadingConfigurationTypeMismatch(@FormatWith(value=MappableTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);
}

