/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.formatting.mapper", description="Logs related to parsing/formatting.")
@MessageLogger(projectCode="HSEARCH")
public interface FormattingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.formatting.mapper";
    public static final FormattingLog INSTANCE = (FormattingLog)LoggerFactory.make(FormattingLog.class, (String)"org.hibernate.search.formatting.mapper", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=295, value="Invalid value for type '$2%s': '$1%s'. %3$s")
    public SearchException parseException(String var1, @FormatWith(value=SimpleNameClassFormatter.class) Class<?> var2, String var3, @Cause Exception var4);

    @Message(id=297, value="Unable to convert '%2$s' into type '%1$s': value is too large.")
    public SearchException valueTooLargeForConversionException(@FormatWith(value=SimpleNameClassFormatter.class) Class<?> var1, Object var2, @Cause Exception var3);

    @Message(id=700043, value="Exception creating URL from String '%1$s'.")
    public SearchException malformedURL(String var1, @Cause Exception var2);

    @Message(id=700044, value="Exception creating URI from String '%1$s'.")
    public SearchException badURISyntax(String var1, @Cause URISyntaxException var2);

    @Message(id=700158, value="A non-string tenant ID '%1$s' cannot be used with a default TenantIdentifierConverter. Provide your custom implementation of TenantIdentifierConverter to use non-string tenant identifiers.")
    public SearchException nonStringTenantId(Object var1);
}

