/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.identity.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.identity.impl.BoundIdentifierMapping;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.identity.impl.IdentityMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.identity.impl.IdentityMappingMode;
import org.hibernate.search.mapper.pojo.identity.impl.PojoIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.identity.impl.PropertyIdentifierMapping;
import org.hibernate.search.mapper.pojo.identity.impl.ProvidedIdentifierMapping;
import org.hibernate.search.mapper.pojo.identity.impl.UnconfiguredIdentifierMapping;
import org.hibernate.search.mapper.pojo.identity.impl.UnmappedPropertyIdentifierMapping;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.impl.Closer;

public final class PojoRootIdentityMappingCollector<E>
implements PojoIdentityMappingCollector {
    private final PojoRawTypeModel<E> typeModel;
    private final PojoMappingHelper mappingHelper;
    private final Optional<IndexedEntityBindingContext> bindingContext;
    private final BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge;
    private BoundIdentifierMapping<?, E> identifierMapping;

    public PojoRootIdentityMappingCollector(PojoRawTypeModel<E> typeModel, PojoMappingHelper mappingHelper, Optional<IndexedEntityBindingContext> bindingContext, BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge) {
        this.typeModel = typeModel;
        this.mappingHelper = mappingHelper;
        this.bindingContext = bindingContext;
        this.providedIdentifierBridge = providedIdentifierBridge;
    }

    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(IdentifierMappingImplementor::close, this.identifierMapping, BoundIdentifierMapping::mapping);
        }
    }

    public PojoIndexMappingCollectorTypeNode toMappingCollectorRootNode() {
        return new IdentityMappingCollectorTypeNode<E>(BoundPojoModelPath.root(this.typeModel), this.mappingHelper, this);
    }

    @Override
    public <T> void identifierBridge(BoundPojoModelPathPropertyNode<?, T> modelPath, IdentifierBinder binder, Map<String, Object> params) {
        BoundIdentifierBridge<T> boundIdentifierBridge = this.mappingHelper.indexModelBinder().bindIdentifier(this.bindingContext, modelPath, binder, params);
        PojoPropertyModel<T> propertyModel = modelPath.getPropertyModel();
        this.identifierMapping = new BoundIdentifierMapping(new PropertyIdentifierMapping(propertyModel.typeModel().rawType().caster(), propertyModel.handle(), boundIdentifierBridge.getBridgeHolder()), propertyModel.typeModel(), Optional.of(propertyModel));
    }

    public BoundIdentifierMapping<?, E> build(IdentityMappingMode mode) {
        this.applyDefaults(mode);
        return this.identifierMapping;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyDefaults(IdentityMappingMode mode) {
        if (this.identifierMapping != null) {
            return;
        }
        if (this.providedIdentifierBridge != null) {
            PojoRawTypeModel<Object> identifierType = this.mappingHelper.introspector().typeModel(Object.class);
            BoundIdentifierBridge<Object> boundIdentifierBridge = this.mappingHelper.indexModelBinder().bindIdentifier(this.bindingContext, identifierType, (IdentifierBinder)new BeanBinder(this.providedIdentifierBridge), Collections.emptyMap());
            this.identifierMapping = new BoundIdentifierMapping(ProvidedIdentifierMapping.get(boundIdentifierBridge.getBridgeHolder()), identifierType, Optional.empty());
            return;
        }
        Optional<BoundPojoModelPathPropertyNode<E, ?>> entityIdPropertyPath = this.mappingHelper.indexModelBinder().createEntityIdPropertyPath(this.typeModel);
        if (IdentityMappingMode.REQUIRED.equals((Object)mode)) {
            if (!entityIdPropertyPath.isPresent()) throw MappingLog.INSTANCE.missingIdentifierMapping(this.typeModel);
            this.identifierBridge(entityIdPropertyPath.get(), null, Collections.emptyMap());
            return;
        } else if (entityIdPropertyPath.isPresent()) {
            this.identifierMapping = this.unmappedIdentifier(entityIdPropertyPath.get());
            return;
        } else {
            PojoRawTypeModel<Object> identifierType = this.mappingHelper.introspector().typeModel(Object.class);
            this.identifierMapping = new BoundIdentifierMapping(new UnconfiguredIdentifierMapping<E>(this.typeModel.typeIdentifier()), identifierType, Optional.empty());
        }
    }

    private <T> BoundIdentifierMapping<T, E> unmappedIdentifier(BoundPojoModelPathPropertyNode<?, T> modelPath) {
        PojoPropertyModel<T> propertyModel = modelPath.getPropertyModel();
        return new BoundIdentifierMapping<T, E>(new UnmappedPropertyIdentifierMapping<T, E>(this.typeModel.typeIdentifier(), propertyModel.typeModel().rawType().caster(), propertyModel.handle()), propertyModel.typeModel(), Optional.of(propertyModel));
    }
}

