/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.engine.common.tree.spi.TreeContributionListener;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.AbstractBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.FieldModelContributorContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PojoTreeContributionListener;
import org.hibernate.search.mapper.pojo.bridge.binding.spi.FieldModelContributor;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.PojoValueBridgeDocumentValueConverter;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.PojoValueBridgeStringConverter;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelValueElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;

public class ValueBindingContextImpl<V>
extends AbstractBindingContext
implements ValueBindingContext<V> {
    private final PojoBootstrapIntrospector introspector;
    private final PojoTypeModel<V> valueTypeModel;
    private final boolean multiValued;
    private final PojoModelValue<V> bridgedElement;
    private final IndexFieldTypeFactory indexFieldTypeFactory;
    private final PojoTreeContributionListener listener;
    private final IndexSchemaElement schemaElement;
    private final String relativeFieldName;
    private final FieldModelContributor contributor;
    private PartialBinding<V, ?> partialBinding;

    public ValueBindingContextImpl(BeanResolver beanResolver, PojoBootstrapIntrospector introspector, PojoTypeModel<V> valueTypeModel, boolean multiValued, IndexBindingContext indexBindingContext, IndexFieldTypeDefaultsProvider defaultsProvider, String relativeFieldName, FieldModelContributor contributor, Map<String, Object> params) {
        super(beanResolver, params);
        this.introspector = introspector;
        this.valueTypeModel = valueTypeModel;
        this.multiValued = multiValued;
        this.bridgedElement = new PojoModelValueElement<V>(introspector, valueTypeModel);
        this.indexFieldTypeFactory = indexBindingContext.createTypeFactory(defaultsProvider);
        this.listener = new PojoTreeContributionListener();
        this.schemaElement = indexBindingContext.schemaElement((TreeContributionListener)this.listener);
        this.relativeFieldName = relativeFieldName;
        this.contributor = contributor;
    }

    @Override
    public <V2, F> void bridge(Class<V2> expectedValueType, ValueBridge<V2, F> bridge) {
        this.bridge(expectedValueType, bridge, null);
    }

    @Override
    public <V2, F> void bridge(Class<V2> expectedValueType, ValueBridge<V2, F> bridge, IndexFieldTypeOptionsStep<?, F> fieldTypeOptionsStep) {
        this.bridge(expectedValueType, BeanHolder.of(bridge), fieldTypeOptionsStep);
    }

    @Override
    public <V2, F> void bridge(Class<V2> expectedValueType, BeanHolder<? extends ValueBridge<V2, F>> bridgeHolder, IndexFieldTypeOptionsStep<?, F> fieldTypeOptionsStep) {
        try {
            PojoRawTypeModel<V2> expectedValueTypeModel = this.introspector.typeModel(expectedValueType);
            if (!this.valueTypeModel.rawType().isSubTypeOf(expectedValueTypeModel)) {
                throw MappingLog.INSTANCE.invalidInputTypeForBridge(bridgeHolder.get(), this.valueTypeModel, expectedValueTypeModel);
            }
            IndexFieldReference<F> indexFieldReference = this.createFieldReference(expectedValueType, (ValueBridge)bridgeHolder.get(), fieldTypeOptionsStep);
            BeanHolder<? extends ValueBridge<V2, F>> castedBridgeHolder = bridgeHolder;
            this.partialBinding = new PartialBinding(castedBridgeHolder, indexFieldReference);
        }
        catch (RuntimeException e) {
            ValueBindingContextImpl.abortBridge(new SuppressingCloser((Throwable)e), bridgeHolder);
            throw e;
        }
    }

    @Override
    public PojoModelValue<V> bridgedElement() {
        return this.bridgedElement;
    }

    @Override
    public IndexFieldTypeFactory typeFactory() {
        return this.indexFieldTypeFactory;
    }

    public Optional<BoundValueBridge<V, ?>> applyBinder(ValueBinder binder) {
        try {
            binder.bind(this);
            if (this.partialBinding == null) {
                throw MappingLog.INSTANCE.missingBridgeForBinder(binder);
            }
            if (!this.listener.isAnySchemaContributed()) {
                try (Object closer = new Closer();){
                    this.partialBinding.abort((AbstractCloser<?, ?>)closer);
                }
                closer = Optional.empty();
                return closer;
            }
            Optional<BoundValueBridge<V, ?>> closer = Optional.of(this.partialBinding.complete());
            return closer;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
        }
    }

    private <V2, F> IndexFieldReference<F> createFieldReference(Class<V2> expectedValueType, ValueBridge<V2, F> bridge, IndexFieldTypeOptionsStep<?, F> fieldTypeOptionsStep) {
        if (fieldTypeOptionsStep == null) {
            fieldTypeOptionsStep = this.inferFieldType(bridge);
        }
        PojoValueBridgeDocumentValueConverter<V2, F> converter = new PojoValueBridgeDocumentValueConverter<V2, F>(bridge);
        PojoValueBridgeStringConverter<F> stringConverter = new PojoValueBridgeStringConverter<F>(bridge);
        fieldTypeOptionsStep.dslConverter(expectedValueType, converter);
        fieldTypeOptionsStep.projectionConverter(expectedValueType, converter);
        fieldTypeOptionsStep.parser(stringConverter);
        fieldTypeOptionsStep.formatter(stringConverter);
        this.contributor.contribute(new FieldModelContributorContextImpl<F>(bridge, fieldTypeOptionsStep));
        IndexSchemaFieldOptionsStep fieldContext = this.schemaElement.field(this.relativeFieldName, fieldTypeOptionsStep);
        if (this.multiValued) {
            fieldContext.multiValued();
        }
        return (IndexFieldReference)fieldContext.toReference();
    }

    private <F> IndexFieldTypeOptionsStep<?, F> inferFieldType(ValueBridge<?, F> bridge) {
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(bridge.getClass());
        Type typeArgument = (Type)bridgeTypeContext.resolveTypeArgument(ValueBridge.class, 1).orElseThrow(() -> new AssertionFailure("Could not auto-detect the return type for value bridge '" + String.valueOf(bridge) + "'."));
        if (typeArgument instanceof Class) {
            return this.contributor.inferDefaultFieldType(this.indexFieldTypeFactory, (Class)typeArgument);
        }
        throw MappingLog.INSTANCE.invalidGenericParameterToInferFieldType(bridge, typeArgument);
    }

    private static void abortBridge(AbstractCloser<?, ?> closer, BeanHolder<? extends ValueBridge<?, ?>> bridgeHolder) {
        closer.push(ValueBridge::close, bridgeHolder, BeanHolder::get);
        closer.push(BeanHolder::close, bridgeHolder);
    }

    private static class PartialBinding<V, F> {
        private final BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder;
        private final IndexFieldReference<F> indexFieldReference;

        private PartialBinding(BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder, IndexFieldReference<F> indexFieldReference) {
            this.bridgeHolder = bridgeHolder;
            this.indexFieldReference = indexFieldReference;
        }

        void abort(AbstractCloser<?, ?> closer) {
            ValueBindingContextImpl.abortBridge(closer, this.bridgeHolder);
        }

        BoundValueBridge<V, F> complete() {
            return new BoundValueBridge(this.bridgeHolder, this.indexFieldReference);
        }
    }
}

