/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.loading.impl;

import java.util.Map;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.common.spi.PojoEntityReferenceFactoryDelegate;
import org.hibernate.search.mapper.pojo.loading.impl.PojoLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.search.loading.impl.PojoProjectionHitMapper;
import org.hibernate.search.mapper.pojo.search.loading.impl.PojoSearchLoadingIndexedTypeContext;

public class PojoSearchLoadingContext<E>
implements SearchLoadingContext<E> {
    private final Map<String, PojoSearchLoadingIndexedTypeContext<? extends E>> targetTypesByEntityName;
    private final PojoEntityReferenceFactoryDelegate entityReferenceFactoryDelegate;
    private final BridgeSessionContext sessionContext;
    private final PojoSelectionLoadingContext delegate;

    public PojoSearchLoadingContext(Map<String, PojoSearchLoadingIndexedTypeContext<? extends E>> targetTypesByEntityName, PojoEntityReferenceFactoryDelegate entityReferenceFactoryDelegate, BridgeSessionContext sessionContext, PojoSelectionLoadingContext delegate) {
        this.targetTypesByEntityName = targetTypesByEntityName;
        this.entityReferenceFactoryDelegate = entityReferenceFactoryDelegate;
        this.sessionContext = sessionContext;
        this.delegate = delegate;
    }

    public PojoSelectionLoadingContext unwrap() {
        return this.delegate;
    }

    public ProjectionHitMapper<E> createProjectionHitMapper() {
        PojoLoadingPlan<? extends E> loadingPlan = PojoLoadingPlan.create(this.delegate, this.targetTypesByEntityName.values());
        return new PojoProjectionHitMapper<E>(this.targetTypesByEntityName, this.entityReferenceFactoryDelegate, this.sessionContext, loadingPlan);
    }
}

