/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.IdentifierBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBindingContext;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.AbstractStringBasedDefaultBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;

public final class DefaultEnumBridge<T extends Enum<T>>
extends AbstractStringBasedDefaultBridge<T> {
    private final Class<T> enumType;

    public DefaultEnumBridge(Class<T> enumType) {
        this.enumType = enumType;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.enumType.getName() + "]";
    }

    @Override
    public boolean isCompatibleWith(IdentifierBridge<?> other) {
        return this.isCompatibleWith((Object)other);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.isCompatibleWith((Object)other);
    }

    private boolean isCompatibleWith(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        DefaultEnumBridge castedOther = (DefaultEnumBridge)other;
        return this.enumType.equals(castedOther.enumType);
    }

    @Override
    protected String toString(T value) {
        return ((Enum)value).name();
    }

    @Override
    protected T fromString(String value) {
        return (T)ParseUtils.parseEnum(this.enumType, (String)value);
    }

    public static class Binder
    implements IdentifierBinder,
    ValueBinder {
        public static final Binder INSTANCE = new Binder();

        private Binder() {
        }

        @Override
        public void bind(IdentifierBindingContext<?> context) {
            this.doBind(context, context.bridgedElement().rawType());
        }

        private <V extends Enum<V>> void doBind(IdentifierBindingContext<?> context, Class<V> enumType) {
            context.bridge(enumType, new DefaultEnumBridge<V>(enumType));
        }

        @Override
        public void bind(ValueBindingContext<?> context) {
            this.doBind(context, context.bridgedElement().rawType());
        }

        private <V extends Enum<V>> void doBind(ValueBindingContext<?> context, Class<V> enumType) {
            context.bridge(enumType, new DefaultEnumBridge<V>(enumType));
        }
    }
}

