/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoEntityTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoIndexedTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;

public class PojoTypeAdditionalMetadata {
    private final Optional<PojoEntityTypeAdditionalMetadata> entityTypeMetadata;
    private final Optional<PojoIndexedTypeAdditionalMetadata> indexedTypeMetadata;
    private final Map<String, Supplier<PojoPropertyAdditionalMetadata>> propertiesAdditionalMetadataSuppliers;
    private final Map<String, PojoPropertyAdditionalMetadata> propertiesAdditionalMetadata = new LinkedHashMap<String, PojoPropertyAdditionalMetadata>();

    public PojoTypeAdditionalMetadata(Optional<PojoEntityTypeAdditionalMetadata> entityTypeMetadata, Optional<PojoIndexedTypeAdditionalMetadata> indexedTypeMetadata, Map<String, Supplier<PojoPropertyAdditionalMetadata>> propertiesAdditionalMetadataSuppliers) {
        this.entityTypeMetadata = entityTypeMetadata;
        this.indexedTypeMetadata = indexedTypeMetadata;
        this.propertiesAdditionalMetadataSuppliers = propertiesAdditionalMetadataSuppliers;
    }

    public boolean isEntity() {
        return this.entityTypeMetadata.isPresent();
    }

    public Optional<PojoEntityTypeAdditionalMetadata> getEntityTypeMetadata() {
        return this.entityTypeMetadata;
    }

    public Optional<PojoIndexedTypeAdditionalMetadata> getIndexedTypeMetadata() {
        return this.indexedTypeMetadata;
    }

    public Set<String> getNamesOfPropertiesWithAdditionalMetadata() {
        return this.propertiesAdditionalMetadataSuppliers.keySet();
    }

    public PojoPropertyAdditionalMetadata getPropertyAdditionalMetadata(String name) {
        return this.propertiesAdditionalMetadata.computeIfAbsent(name, theName -> {
            Supplier<PojoPropertyAdditionalMetadata> supplier = this.propertiesAdditionalMetadataSuppliers.get(theName);
            if (supplier == null) {
                return PojoPropertyAdditionalMetadata.EMPTY;
            }
            return supplier.get();
        });
    }
}

