/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingConstructorNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingMethodParameterNode;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ConstructorMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.MethodParameterMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.InitialMethodParameterMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeMappingStepImpl;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;

class InitialConstructorMappingStep
implements ConstructorMappingStep,
PojoSearchMappingConstructorNode {
    private final TypeMappingStepImpl parent;
    private final PojoConstructorModel<?> constructorModel;
    private boolean projectionConstructor = false;
    private Map<Integer, InitialMethodParameterMappingStep> parameters;

    InitialConstructorMappingStep(TypeMappingStepImpl parent, PojoConstructorModel<?> constructorModel) {
        this.parent = parent;
        this.constructorModel = constructorModel;
    }

    @Override
    public TypeMappingStep hostingType() {
        return this.parent;
    }

    @Override
    public Class<?>[] parametersJavaTypes() {
        return this.constructorModel.parametersJavaTypes();
    }

    @Override
    public ConstructorMappingStep projectionConstructor() {
        this.projectionConstructor = true;
        return this;
    }

    @Override
    public boolean isProjectionConstructor() {
        return this.projectionConstructor;
    }

    @Override
    public MethodParameterMappingStep parameter(int index) {
        InitialMethodParameterMappingStep parameter;
        if (this.parameters == null) {
            this.parameters = new HashMap<Integer, InitialMethodParameterMappingStep>();
        }
        if ((parameter = this.parameters.get(index)) == null) {
            PojoMethodParameterModel<?> parameterModel = this.constructorModel.parameter(index);
            parameter = new InitialMethodParameterMappingStep(this, parameterModel);
            this.parameters.put(index, parameter);
        }
        return parameter;
    }

    @Override
    public Optional<PojoSearchMappingMethodParameterNode> parameterNode(int index) {
        return Optional.ofNullable(this.parameters == null ? null : (PojoSearchMappingMethodParameterNode)this.parameters.get(index));
    }
}

