/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.util.common.impl.Closer;

public class PojoIndexedTypeManagerContainer
implements PojoWorkIndexedTypeContextProvider,
PojoScopeIndexedTypeContextProvider {
    private final Map<PojoRawTypeIdentifier<?>, PojoIndexedTypeManager<?, ?>> byExactType;
    private final Map<PojoRawTypeIdentifier<?>, Set<? extends PojoIndexedTypeManager<?, ?>>> bySuperType;
    private final Map<String, PojoIndexedTypeManager<?, ?>> byEntityName;
    private final Set<PojoIndexedTypeManager<?, ?>> all;

    public static Builder builder() {
        return new Builder();
    }

    private PojoIndexedTypeManagerContainer(Builder builder) {
        this.byExactType = new LinkedHashMap(builder.byExactType);
        this.bySuperType = new LinkedHashMap(builder.bySuperType);
        this.bySuperType.replaceAll((k, v) -> Collections.unmodifiableSet(v));
        this.byEntityName = new LinkedHashMap(builder.byExactType.size());
        for (PojoIndexedTypeManager typeManager : builder.byExactType.values()) {
            this.byEntityName.put(typeManager.entityName(), typeManager);
        }
        this.all = Collections.unmodifiableSet(new LinkedHashSet(this.byExactType.values()));
    }

    public <E> Optional<? extends PojoIndexedTypeManager<?, E>> forExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return Optional.ofNullable(this.byExactType.get(typeIdentifier));
    }

    @Override
    public <E> Optional<? extends Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>>> allForSuperType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return Optional.ofNullable(this.bySuperType.get(typeIdentifier));
    }

    @Override
    public Optional<? extends PojoWorkIndexedTypeContext<?, ?>> forEntityName(String entityName) {
        return Optional.ofNullable(this.byEntityName.get(entityName));
    }

    Set<PojoIndexedTypeManager<?, ?>> all() {
        return this.all;
    }

    public static class Builder {
        private final Map<PojoRawTypeIdentifier<?>, PojoIndexedTypeManager<?, ?>> byExactType = new LinkedHashMap();
        private final Map<PojoRawTypeIdentifier<?>, Set<PojoIndexedTypeManager<?, ?>>> bySuperType = new LinkedHashMap();

        private Builder() {
        }

        public <E> void add(PojoRawTypeModel<E> typeModel, PojoIndexedTypeManager<?, E> typeManager) {
            this.byExactType.put(typeModel.typeIdentifier(), typeManager);
            typeModel.ascendingSuperTypes().map(PojoRawTypeModel::typeIdentifier).forEach(clazz -> this.bySuperType.computeIfAbsent((PojoRawTypeIdentifier<?>)clazz, ignored -> new LinkedHashSet()).add(typeManager));
        }

        public void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.pushAll(PojoIndexedTypeManager::close, this.byExactType.values());
            }
        }

        public PojoIndexedTypeManagerContainer build() {
            return new PojoIndexedTypeManagerContainer(this);
        }
    }
}

