/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeFromDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;

public final class DefaultLocalDateTimeIdentifierBridge
implements IdentifierBridge<LocalDateTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    @Override
    public String toDocumentIdentifier(LocalDateTime propertyValue, IdentifierBridgeToDocumentIdentifierContext context) {
        return FORMATTER.format(propertyValue);
    }

    @Override
    public LocalDateTime fromDocumentIdentifier(String documentIdentifier, IdentifierBridgeFromDocumentIdentifierContext context) {
        return ParseUtils.parseLocalDateTime((String)documentIdentifier);
    }

    @Override
    public boolean isCompatibleWith(IdentifierBridge<?> other) {
        return this.getClass().equals(other.getClass());
    }
}

