/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.impl;

import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoImplicitReindexingResolverCastedTypeNode<T, S, U>
extends PojoImplicitReindexingResolverNode<T, S> {
    private final PojoCaster<U> caster;
    private final PojoImplicitReindexingResolverNode<? super U, S> nested;

    public PojoImplicitReindexingResolverCastedTypeNode(PojoCaster<U> caster, PojoImplicitReindexingResolverNode<? super U, S> nested) {
        this.caster = caster;
        this.nested = nested;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(PojoImplicitReindexingResolverNode::close, this.nested);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"process type (with cast, ignore if it fails)");
        builder.attribute("caster", this.caster);
        builder.attribute("nested", this.nested);
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, T dirty, PojoImplicitReindexingResolverRootContext<S> context) {
        U castedDirty = this.caster.castOrNull(context.sessionContext().runtimeIntrospector().unproxy(dirty));
        if (castedDirty != null) {
            this.nested.resolveEntitiesToReindex(collector, castedDirty, context);
        }
    }
}

