/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverContainerElementNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.util.common.impl.Closer;

class PojoImplicitReindexingResolverContainerElementNodeBuilder<C, V>
extends AbstractPojoImplicitReindexingResolverNodeBuilder<C> {
    private final BoundPojoModelPathValueNode<?, ? extends C, V> modelPath;
    private final ContainerExtractorHolder<C, V> extractorHolder;
    private final PojoImplicitReindexingResolverValueNodeBuilderDelegate<V> valueBuilderDelegate;

    PojoImplicitReindexingResolverContainerElementNodeBuilder(BoundPojoModelPathValueNode<?, ? extends C, V> modelPath, ContainerExtractorHolder<C, V> extractorHolder, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.modelPath = modelPath;
        this.extractorHolder = extractorHolder;
        this.valueBuilderDelegate = new PojoImplicitReindexingResolverValueNodeBuilderDelegate<V>(modelPath, buildingHelper);
    }

    @Override
    BoundPojoModelPathValueNode<?, ? extends C, V> getModelPath() {
        return this.modelPath;
    }

    @Override
    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(ContainerExtractorHolder::close, this.extractorHolder);
            closer.push(PojoImplicitReindexingResolverValueNodeBuilderDelegate::closeOnFailure, this.valueBuilderDelegate);
        }
    }

    PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> value() {
        return this.valueBuilderDelegate;
    }

    @Override
    void onFreeze(Set<PojoModelPathValueNode> dirtyPathsTriggeringReindexingCollector) {
        this.valueBuilderDelegate.freeze(dirtyPathsTriggeringReindexingCollector);
    }

    @Override
    <S> Optional<PojoImplicitReindexingResolverNode<C, S>> doBuild(PojoPathFilterFactory<S> pathFilterFactory, Set<PojoModelPathValueNode> allPotentialDirtyPaths) {
        this.checkFrozen();
        Collection<PojoImplicitReindexingResolverNode<V, S>> valueTypeNodes = this.valueBuilderDelegate.buildTypeNodes(pathFilterFactory, allPotentialDirtyPaths);
        if (valueTypeNodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PojoImplicitReindexingResolverContainerElementNode<C, S, V>(this.extractorHolder, this.createNested(valueTypeNodes)));
    }
}

